/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/Application.h"
#include "asf/core/ComponentContainer.h"
#include "asf/core/ComponentDescription.h"
#include "asf/core/ContextData.h"
#include "asf/core/Logger.h"
#include "asf/core/RequiredPort.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusImportedPort.h"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "com/bosch/cm/asf/lang/dbus/ConnectorsJson.h"
#include "org/bosch/cm/lcm/genericrecoveryclient/GenericRecoveryClient.h"
#include "org/bosch/cm/lcm/genericrecoveryclient/GenericRecoveryClientComponent.h"
#include <cstdio>
#include <string>

/**
 * Application GenericRecoveryClient
 */

namespace org {
namespace bosch {
namespace cm {
namespace lcm {
namespace genericrecoveryclient {

DEFINE_LOGGER_AND_LEVEL (_logger, "/org/bosch/cm/lcm/genericrecoveryclient/GenericRecoveryClient", Info);

/* static */ const char* GenericRecoveryClient::genericRecoveryApp = "genericRecoveryApp";

static const char* helpMessage =
    "--logconfig <file>     Read the logging configuration from <file>\n"
    "                       see the ASF User Guide, section 6.3. Logging API\n"
    "--help                 Print this help message\n";

bool GenericRecoveryClient_enabledASFSignalHandler = false;

void importGenericRecoveryClient() {
    ::asf::core::Application* app = ::asf::core::Application::getApplication();
    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't attach GenericRecoveryClient, because no Application is instantiated");

    // Expression

    ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector dbusSystemConnector;
    {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector __expression0;
        {
            __expression0.setBusType(::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector::BusType__System);
        }
        dbusSystemConnector = __expression0;
    }
    {
        std::string jsonPayload;
        serializeJson (dbusSystemConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "dbusSystemConnector", "DBusConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::dbus::DBusConnector > dbusSystemConnector_(new ::asf::dbus::DBusConnector(*app, dbusSystemConnector));
    app->addStarter(dbusSystemConnector_);

    // Thread 'GenericRecoveryClient'

    ::asf::core::ComponentContainerSharedPtr GenericRecoveryClient(new ::asf::core::ComponentContainer("GenericRecoveryClient", ::asf::core::ThreadConfiguration(1)));
    app->addContainer (GenericRecoveryClient);

        // Component 'GenericRecoveryClientComponent genericRecoveryApp'

        ::boost::shared_ptr< ::asf::core::ComponentFactory< ::org::bosch::cm::lcm::genericrecoveryclient::GenericRecoveryClientComponent > > genericRecoveryAppFactory(new ::asf::core::ComponentFactory< ::org::bosch::cm::lcm::genericrecoveryclient::GenericRecoveryClientComponent >);
        ::asf::core::ComponentDescriptionSharedPtr genericRecoveryAppDescription(new ::asf::core::ComponentDescription(1, "genericRecoveryApp", /* immediate = */ true, /* threadBridge = */ false, genericRecoveryAppFactory));
        GenericRecoveryClient->addComponentDescription(genericRecoveryAppDescription);

            // Port 'DBusManagerClientPort'

            ::asf::core::RequiredPort& genericRecoveryApp_DBusManagerClientPort = genericRecoveryAppDescription->addRequiredPort (::asf::core::RequiredPort ("org.freedesktop.systemd1.Manager", "DBusManagerClientPort"));
            (void)genericRecoveryApp_DBusManagerClientPort; // prevent unused variable warning

            // Port 'RecoveryClientPort'

            ::asf::core::RequiredPort& genericRecoveryApp_RecoveryClientPort = genericRecoveryAppDescription->addRequiredPort (::asf::core::RequiredPort ("org.bosch.cm.lcm.Generic_RecoveryClient", "RecoveryClientPort"));
            (void)genericRecoveryApp_RecoveryClientPort; // prevent unused variable warning

            // Port 'DBusUnitClientPort'

            ::asf::core::RequiredPort& genericRecoveryApp_DBusUnitClientPort = genericRecoveryAppDescription->addRequiredPort (::asf::core::RequiredPort ("org.freedesktop.systemd1.Unit", "DBusUnitClientPort", /* wired at runtime */ true));
            (void)genericRecoveryApp_DBusUnitClientPort; // prevent unused variable warning

            // Port 'DBusServiceClientPort'

            ::asf::core::RequiredPort& genericRecoveryApp_DBusServiceClientPort = genericRecoveryAppDescription->addRequiredPort (::asf::core::RequiredPort ("org.freedesktop.systemd1.Service", "DBusServiceClientPort", /* wired at runtime */ true));
            (void)genericRecoveryApp_DBusServiceClientPort; // prevent unused variable warning

    // Expression

    ::asf::dbus::DBusImportedPort& Generic_RecoveryClient = dbusSystemConnector_->importByName (::std::string("org.genivi.NodeStateManager"), ::std::string("/org/bosch/cm/lcm/GenericRecoveryClient"));
    Generic_RecoveryClient.setServiceName("org.bosch.cm.lcm.Generic_RecoveryClient");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (genericRecoveryApp_RecoveryClientPort, Generic_RecoveryClient);

    // Expression

    ::asf::dbus::DBusImportedPort& DBusManagerClient = dbusSystemConnector_->importByName (::std::string("org.freedesktop.systemd1"), ::std::string("/org/freedesktop/systemd1"));
    DBusManagerClient.setServiceName("org.freedesktop.systemd1.Manager");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (genericRecoveryApp_DBusManagerClientPort, DBusManagerClient);


    LOG_INFO_STATIC("Starting application 'GenericRecoveryClient' version 1.0.0");

    app->start();
}

int executeGenericRecoveryClient(int argc, char* argv[]) {
    ::asf::core::ContextData context;

    const char* logConfigFile = 0;
    std::vector<std::string> arguments;

    for (int i=1; i<argc; i++) {
        if (std::string(argv[i]) == "--logconfig" && i+1 < argc) {
            // ignore lint warning e850: modification of i inside loop is safe
            logConfigFile = argv[++i];
        } else {
            if (std::string(argv[i]) == "--help") {
                printf ("%s", helpMessage);
                exit (0);
            } else {
                arguments.push_back (argv[i]);
            }
        }
    }

    if (logConfigFile == 0) {
        ::asf::core::Logger::setupLogging ("org.bosch.cm.lcm.genericrecoveryclient", "GenericRecoveryClient");
    } else {
        ::asf::core::Logger::setupLogging ("org.bosch.cm.lcm.genericrecoveryclient", "GenericRecoveryClient", logConfigFile);
    }

    LOG_INFO_STATIC("%s ASF signal handler", GenericRecoveryClient_enabledASFSignalHandler ? "Enabled" : "Disabled" );

    ::asf::core::Application* app = ::asf::core::Application::createApplication("org.bosch.cm.lcm.genericrecoveryclient", "GenericRecoveryClient", ::asf::core::Version(1, 0, 0, ""), arguments);

    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't create GenericRecoveryClient");

    app->enableExceptionHandler(false);

    importGenericRecoveryClient();

    int exitCode = app->waitForCompletion();
    ::asf::core::Application::deleteApplication();

    return exitCode;
}

} // namespace genericrecoveryclient
} // namespace lcm
} // namespace cm
} // namespace bosch
} // namespace org

int main(int argc, char* argv[]) {
    ::boost::shared_ptr< ::asf::threading::Thread > mainThread = ::asf::threading::Thread::attach();
    return ::org::bosch::cm::lcm::genericrecoveryclient::executeGenericRecoveryClient(argc, argv);
}

