/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/cca/CcaConnector.h"
#include "asf/cca/CcaImportedPort.h"
#include "asf/cms/CmsProvidedPortListener.h"
#include "asf/core/Application.h"
#include "asf/core/ComponentContainer.h"
#include "asf/core/ComponentDescription.h"
#include "asf/core/ContextData.h"
#include "asf/core/Logger.h"
#include "asf/core/ProvidedPort.h"
#include "asf/core/RequiredPort.h"
#include "asf/core/SignalHandler.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusExportedPort.h"
#include "asf/dbus/DBusImportedPort.h"
#include "com/bosch/cm/asf/lang/cca/Connectors.h"
#include "com/bosch/cm/asf/lang/cca/ConnectorsJson.h"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "com/bosch/cm/asf/lang/dbus/ConnectorsJson.h"
#include "fcswupdate/FcSwUpdateApp.h"
#include "fcswupdate/FcSwUpdateComponent.h"
#include <cstdio>
#include <string>

/**
 * If the meaning of "FcSwUpdateApp" isn't clear, then there should be a description here.
 */

namespace fcswupdate {

DEFINE_LOGGER_AND_LEVEL (_logger, "/fcswupdate/FcSwUpdateApp", Info);

/* static */ const char* FcSwUpdateApp::fcSwUpdateComponent = "fcSwUpdateComponent";

static const char* helpMessage =
    "--logconfig <file>     Read the logging configuration from <file>\n"
    "                       see the ASF User Guide, section 6.3. Logging API\n"
    "--help                 Print this help message\n";

bool FcSwUpdateApp_enabledASFSignalHandler = false;

void importFcSwUpdateApp() {
    ::asf::core::Application* app = ::asf::core::Application::getApplication();
    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't attach FcSwUpdateApp, because no Application is instantiated");

    // Expression

    ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector dbusConnector;
    {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector __expression0;
        {
            __expression0.setBusType(::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector::BusType__Session);
        }
        dbusConnector = __expression0;
    }
    {
        std::string jsonPayload;
        serializeJson (dbusConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "dbusConnector", "DBusConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::dbus::DBusConnector > dbusConnector_(new ::asf::dbus::DBusConnector(*app, dbusConnector));
    app->addStarter(dbusConnector_);

    // Expression

    ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector dbusSysConnector;
    {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector __expression1;
        {
            __expression1.setBusType(::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector::BusType__System);
        }
        dbusSysConnector = __expression1;
    }
    {
        std::string jsonPayload;
        serializeJson (dbusSysConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "dbusSysConnector", "DBusConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::dbus::DBusConnector > dbusSysConnector_(new ::asf::dbus::DBusConnector(*app, dbusSysConnector));
    app->addStarter(dbusSysConnector_);

    // Thread 'T1'

    ::asf::core::ComponentContainerSharedPtr T1(new ::asf::core::ComponentContainer("T1", ::asf::core::ThreadConfiguration(1)));
    app->addContainer (T1);

        // Component 'FcSwUpdateComponent fcSwUpdateComponent'

        ::boost::shared_ptr< ::asf::core::ComponentFactory< ::fcswupdate::FcSwUpdateComponent > > fcSwUpdateComponentFactory(new ::asf::core::ComponentFactory< ::fcswupdate::FcSwUpdateComponent >);
        ::asf::core::ComponentDescriptionSharedPtr fcSwUpdateComponentDescription(new ::asf::core::ComponentDescription(1, "fcSwUpdateComponent", /* immediate = */ true, /* threadBridge = */ false, fcSwUpdateComponentFactory));
        T1->addComponentDescription(fcSwUpdateComponentDescription);

            // Port 'spmFiPort'

            ::asf::core::RequiredPort& fcSwUpdateComponent_spmFiPort = fcSwUpdateComponentDescription->addRequiredPort (::asf::core::RequiredPort ("SPM_CORE_FI", "spmFiPort"));
            (void)fcSwUpdateComponent_spmFiPort; // prevent unused variable warning

            // Port 'vehicleMainFiPort'

            ::asf::core::RequiredPort& fcSwUpdateComponent_vehicleMainFiPort = fcSwUpdateComponentDescription->addRequiredPort (::asf::core::RequiredPort ("VEHICLE_MAIN_FI", "vehicleMainFiPort"));
            (void)fcSwUpdateComponent_vehicleMainFiPort; // prevent unused variable warning

            // Port 'diagLogFiPort'

            ::asf::core::RequiredPort& fcSwUpdateComponent_diagLogFiPort = fcSwUpdateComponentDescription->addRequiredPort (::asf::core::RequiredPort ("Midw_DiagLog_FI", "diagLogFiPort"));
            (void)fcSwUpdateComponent_diagLogFiPort; // prevent unused variable warning

            // Port 'SWUCoreServicePort'

            ::asf::core::RequiredPort& fcSwUpdateComponent_SWUCoreServicePort = fcSwUpdateComponentDescription->addRequiredPort (::asf::core::RequiredPort ("ai_sw_update.common.core.imp.SWUCoreService", "SWUCoreServicePort"));
            (void)fcSwUpdateComponent_SWUCoreServicePort; // prevent unused variable warning

            // Port 'fcSwUpdatePort'

            ::asf::core::ProvidedPort& fcSwUpdateComponent_fcSwUpdatePort = fcSwUpdateComponentDescription->addProvidedPort (::asf::core::ProvidedPort ("fcswupdatesrv.FcSwUpdateSrv", "fcSwUpdatePort", false, false));
            (void)fcSwUpdateComponent_fcSwUpdatePort; // prevent unused variable warning

            // Port 'loopbackSrvIn'

            ::asf::core::RequiredPort& fcSwUpdateComponent_loopbackSrvIn = fcSwUpdateComponentDescription->addRequiredPort (::asf::core::RequiredPort ("fcswupdateloopbacksrv.FcSwUpdateLoopBackSrv", "loopbackSrvIn"));
            (void)fcSwUpdateComponent_loopbackSrvIn; // prevent unused variable warning

            // Port 'loopbackSrvOut'

            ::asf::core::ProvidedPort& fcSwUpdateComponent_loopbackSrvOut = fcSwUpdateComponentDescription->addProvidedPort (::asf::core::ProvidedPort ("fcswupdateloopbacksrv.FcSwUpdateLoopBackSrv", "loopbackSrvOut", ::boost::shared_ptr< ::asf::core::ProvidedPortListener >(new ::asf::cms::CmsProvidedPortListener())));
            (void)fcSwUpdateComponent_loopbackSrvOut; // prevent unused variable warning

            // Port 'fcSwUpdateSystemSettingPort'

            ::asf::core::ProvidedPort& fcSwUpdateComponent_fcSwUpdateSystemSettingPort = fcSwUpdateComponentDescription->addProvidedPort (::asf::core::ProvidedPort ("org.bosch.cm.diagnosis.dbus.Diagnosis1.SystemSettings1", "fcSwUpdateSystemSettingPort", false, false));
            (void)fcSwUpdateComponent_fcSwUpdateSystemSettingPort; // prevent unused variable warning

    // Expression

    ::com::bosch::cm::asf::lang::cca::Connectors::CcaConnector ccaConnector;
    {
        ::com::bosch::cm::asf::lang::cca::Connectors::CcaConnector __expression2;
        {
            __expression2.setApplicationId(188);
        }
        ccaConnector = __expression2;
    }
    {
        std::string jsonPayload;
        serializeJson (ccaConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "ccaConnector", "CcaConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::cca::CcaConnector > ccaConnector_(new ::asf::cca::CcaConnector(*app, ccaConnector));
    app->addStarter(ccaConnector_);

    // Expression

    ::asf::dbus::DBusImportedPort& swUpdateService = dbusConnector_->importByName (::std::string("ai_sw_update.common.core.imp.SWUCoreApplication"), ::std::string("/org/bosch/cm/ai_sw_update/SWUCoreService"));
    swUpdateService.setServiceName("ai_sw_update.common.core.imp.SWUCoreService");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (fcSwUpdateComponent_SWUCoreServicePort, swUpdateService);

    // Expression

    dbusConnector_->exportByName (fcSwUpdateComponent_fcSwUpdatePort, ::std::string("/org/bosch/cm/ai_sw_update/fcSwUpdateService"));

    // Expression

    ::asf::dbus::DBusExportedPort& fcSwUpdateComponent = dbusConnector_->exportByName (fcSwUpdateComponent_fcSwUpdateSystemSettingPort, ::std::string("/org/bosch/cm/diagnosis/dbus/Diagnosis1/SystemSettings1"));
    fcSwUpdateComponent.setServiceName("org.bosch.cm.diagnosis.dbus.Diagnosis1.SystemSettings1");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (fcSwUpdateComponent_loopbackSrvIn, fcSwUpdateComponent_loopbackSrvOut);

    // Expression

    ::asf::cca::CcaImportedPort& spmFiImport = ccaConnector_->importByName (0, 1, 0, 2);
    spmFiImport.setServiceName("SPM_CORE_FI");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (fcSwUpdateComponent_spmFiPort, spmFiImport);

    // Expression

    ::asf::cca::CcaImportedPort& vehicleMainFiImport = ccaConnector_->importByName (47, 1, 0, 2);
    vehicleMainFiImport.setServiceName("VEHICLE_MAIN_FI");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (fcSwUpdateComponent_vehicleMainFiPort, vehicleMainFiImport);

    // Expression

    ::asf::cca::CcaImportedPort& diagLogFiImport = ccaConnector_->importByName (256, 1, 3, 2);
    diagLogFiImport.setServiceName("Midw_DiagLog_FI");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (fcSwUpdateComponent_diagLogFiPort, diagLogFiImport);


    LOG_INFO_STATIC("Starting application 'FcSwUpdateApp' version 1.0.0");

    app->start();
}

int executeFcSwUpdateApp(int argc, char* argv[]) {
    ::asf::core::ContextData context;

    const char* logConfigFile = 0;
    std::vector<std::string> arguments;

    for (int i=1; i<argc; i++) {
        if (std::string(argv[i]) == "--logconfig" && i+1 < argc) {
            // ignore lint warning e850: modification of i inside loop is safe
            logConfigFile = argv[++i];
        } else {
            if (std::string(argv[i]) == "--help") {
                printf ("%s", helpMessage);
                exit (0);
            } else {
                arguments.push_back (argv[i]);
            }
        }
    }

    if (logConfigFile == 0) {
        ::asf::core::Logger::setupLogging ("fcswupdate", "FcSwUpdateApp");
    } else {
        ::asf::core::Logger::setupLogging ("fcswupdate", "FcSwUpdateApp", logConfigFile);
    }

    LOG_INFO_STATIC("%s ASF signal handler", FcSwUpdateApp_enabledASFSignalHandler ? "Enabled" : "Disabled" );

    ::asf::core::Application* app = ::asf::core::Application::createApplication("fcswupdate", "FcSwUpdateApp", ::asf::core::Version(1, 0, 0, ""), arguments);

    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't create FcSwUpdateApp");

    app->enableExceptionHandler(true);

    importFcSwUpdateApp();

    int exitCode = app->waitForCompletion();
    ::asf::core::Application::deleteApplication();

    return exitCode;
}

} // namespace fcswupdate

int main(int argc, char* argv[]) {
    ::fcswupdate::FcSwUpdateApp_enabledASFSignalHandler = true;
    ::asf::core::SignalHandler asfSignalHandler;
    ::boost::shared_ptr< ::asf::threading::Thread > mainThread = ::asf::threading::Thread::attach();
    return ::fcswupdate::executeFcSwUpdateApp(argc, argv);
}

