/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef BOSCH_CM_DI_HMIEMPLISTINTERFACESTUB_H
#define BOSCH_CM_DI_HMIEMPLISTINTERFACESTUB_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "bosch/cm/di/HmiEmpListInterface.h"
#include "bosch/cm/di/HmiEmpListInterfaceConst.h"
#include <string>
#include <vector>

namespace bosch {
namespace cm {
namespace di {
namespace HmiEmpListInterface {

class HmiEmpListInterfaceStubDelegate;

class HmiEmpListInterfaceStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the HmiEmpListInterfaceStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    HmiEmpListInterfaceStub (const std::string& portName);

    /**
     * Create an instance of the HmiEmpListInterfaceStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    HmiEmpListInterfaceStub (const std::string& portName, const std::string& objectPath);

    virtual ~HmiEmpListInterfaceStub();

    // signal 'sig_DBState'

    /**
     * Raise the signal 'sig_DBState' and send an update message to registered
     * clients.
     *
     * <b>Documentation of 'sig_DBState'</b>:
     *
     * sig_DBState =  DB download state
     *
     * @param DownloadState If the meaning of "DownloadState" isn't clear, then there should be a description here.
     *
     * @param SourceType If the meaning of "SourceType" isn't clear, then there should be a description here.
     */
    void sendSig_DBStateSignal(entDownloadState downloadState, entSourceType sourceType);

    // signal 'sig_AlbumArtState'

    /**
     * Raise the signal 'sig_AlbumArtState' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'sig_AlbumArtState'</b>:
     *
     * sig_AlbumArtState =  AlbumArt download state
     *
     * @param DownloadState If the meaning of "DownloadState" isn't clear, then there should be a description here.
     *
     * @param SongId If the meaning of "SongId" isn't clear, then there should be a description here.
     */
    void sendSig_AlbumArtStateSignal(entDownloadState downloadState, uint16 songId);

    // signal 'sig_PlayableFlag'

    /**
     * Raise the signal 'sig_PlayableFlag' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'sig_PlayableFlag'</b>:
     *
     * sig_PlayableFlag =  playable content in USB
     *
     * @param isPlayableAudio If the meaning of "isPlayableAudio" isn't clear, then there should be a description here.
     *
     * @param isPlayableVideo If the meaning of "isPlayableVideo" isn't clear, then there should be a description here.
     *
     * @param SourceType If the meaning of "SourceType" isn't clear, then there should be a description here.
     */
    void sendSig_PlayableFlagSignal(bool isPlayableAudio, bool isPlayableVideo, entSourceType sourceType);

    // signal 'sig_CurrentTrackInfo'

    /**
     * Raise the signal 'sig_CurrentTrackInfo' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'sig_CurrentTrackInfo'</b>:
     *
     * If the meaning of "sig_CurrentTrackInfo" isn't clear, then there should be a description here.
     *
     * @param SourceType If the meaning of "SourceType" isn't clear, then there should be a description here.
     *
     * @param ListType If the meaning of "ListType" isn't clear, then there should be a description here.
     *
     * @param Region If the meaning of "Region" isn't clear, then there should be a description here.
     *
     * @param SongId If the meaning of "SongId" isn't clear, then there should be a description here.
     *
     * @param FolderPath If the meaning of "FolderPath" isn't clear, then there should be a description here.
     */
    void sendSig_CurrentTrackInfoSignal(entSourceType sourceType, entListType listType, uint8 region, uint16 songId, const ::std::string& folderPath);

    // property 'listSize'

    /**
     * The method onListSizeGet() is called by ASF when a client invokes the
     * read method for the property 'listSize'. The onListSizeGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'listSize'</b>:
     *
     * Attribute to get List size
     */
    virtual void onListSizeGet(const ::boost::shared_ptr< ListSizeGet >& payload);

    /**
     * Sends back the update to a previous onListSizeGet().
     *
     * <b>Documentation of 'listSize'</b>:
     *
     * Attribute to get List size
     *
     * @param act Identifies a previous invocation of onListSizeGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendListSizeGetUpdate(const ListSizeStruct& listSize, act_t act = 0);

    /**
     * Set the value of the property 'listSize' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'listSize'</b>:
     *
     * Attribute to get List size
     */
    void setListSize(const ListSizeStruct& listSize);

    /**
     * Returns the current value of the property 'listSize'.
     *
     * <b>Documentation of 'listSize'</b>:
     *
     * Attribute to get List size
     */
    const ListSizeStruct& getListSize() const;

    /**
     * Returns the current value of the property 'listSize' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendListSizeUpdate() method.
     *
     * <b>Documentation of 'listSize'</b>:
     *
     * Attribute to get List size
     */
    ListSizeStruct& getListSizeMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendListSizeUpdate().
     *
     * <b>Documentation of 'listSize'</b>:
     *
     * Attribute to get List size
     */
    void sendListSizeUpdate();

    // method 'ReqCreateMediaPlayerList'

    /**
     * The method onReqCreateMediaPlayerList() is called by ASF when a client
     * invokes the method 'ReqCreateMediaPlayerList'. A subclass has to
     * implement this method and send back a response to the client either
     * with the sendReqCreateMediaPlayerList() or
     * sendReqCreateMediaPlayerListError() method. Do not invoke this method
     * on your own.
     *
     * <b>Documentation of 'ReqCreateMediaPlayerList'</b>:
     *
     * ReqCreateMediaPlayerList = Method to Request External MediaPlayer List
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onReqCreateMediaPlayerListRequest (const ::boost::shared_ptr< ReqCreateMediaPlayerListRequest >& request) = 0;

    /**
     * The method sendReqCreateMediaPlayerListResponse() sends a response of a
     * previous method invocation of 'ReqCreateMediaPlayerList' back to the
     * client.
     *
     * <b>Documentation of 'ReqCreateMediaPlayerList'</b>:
     *
     * ReqCreateMediaPlayerList = Method to Request External MediaPlayer List
     *
     * @param response If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onReqCreateMediaPlayerList(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendReqCreateMediaPlayerListResponse (bool response, act_t act = 0);

    /**
     * The method sendReqCreateMediaPlayerListError() sends an error response
     * of a previous method invocation of 'ReqCreateMediaPlayerList' back to
     * the client.
     *
     * <b>Documentation of 'ReqCreateMediaPlayerList'</b>:
     *
     * ReqCreateMediaPlayerList = Method to Request External MediaPlayer List
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onReqCreateMediaPlayerList(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendReqCreateMediaPlayerListError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'ReqMediaPlayerListSlice'

    /**
     * The method onReqMediaPlayerListSlice() is called by ASF when a client
     * invokes the method 'ReqMediaPlayerListSlice'. A subclass has to
     * implement this method and send back a response to the client either
     * with the sendReqMediaPlayerListSlice() or
     * sendReqMediaPlayerListSliceError() method. Do not invoke this method on
     * your own.
     *
     * <b>Documentation of 'ReqMediaPlayerListSlice'</b>:
     *
     * ReqMediaPlayerListSlice = Method to Request MediaPlayer ListSlice
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onReqMediaPlayerListSliceRequest (const ::boost::shared_ptr< ReqMediaPlayerListSliceRequest >& request) = 0;

    /**
     * The method sendReqMediaPlayerListSliceResponse() sends a response of a
     * previous method invocation of 'ReqMediaPlayerListSlice' back to the
     * client.
     *
     * <b>Documentation of 'ReqMediaPlayerListSlice'</b>:
     *
     * ReqMediaPlayerListSlice = Method to Request MediaPlayer ListSlice
     *
     * @param mArrayListContainer If the meaning of "mArrayListContainer" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onReqMediaPlayerListSlice(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendReqMediaPlayerListSliceResponse (const ::std::vector< ListContainerStruct >& mArrayListContainer, act_t act = 0);

    /**
     * The method sendReqMediaPlayerListSliceError() sends an error response
     * of a previous method invocation of 'ReqMediaPlayerListSlice' back to
     * the client.
     *
     * <b>Documentation of 'ReqMediaPlayerListSlice'</b>:
     *
     * ReqMediaPlayerListSlice = Method to Request MediaPlayer ListSlice
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onReqMediaPlayerListSlice(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendReqMediaPlayerListSliceError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'ReqDBDownload'

    /**
     * The method onReqDBDownload() is called by ASF when a client invokes the
     * method 'ReqDBDownload'. A subclass has to implement this method and
     * send back a response to the client either with the sendReqDBDownload()
     * or sendReqDBDownloadError() method. Do not invoke this method on your
     * own.
     *
     * <b>Documentation of 'ReqDBDownload'</b>:
     *
     * ReqDBDownload = Method to Request DB Download
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onReqDBDownloadRequest (const ::boost::shared_ptr< ReqDBDownloadRequest >& request) = 0;

    /**
     * The method sendReqDBDownloadResponse() sends a response of a previous
     * method invocation of 'ReqDBDownload' back to the client.
     *
     * <b>Documentation of 'ReqDBDownload'</b>:
     *
     * ReqDBDownload = Method to Request DB Download
     *
     * @param response If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onReqDBDownload(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendReqDBDownloadResponse (bool response, act_t act = 0);

    /**
     * The method sendReqDBDownloadError() sends an error response of a
     * previous method invocation of 'ReqDBDownload' back to the client.
     *
     * <b>Documentation of 'ReqDBDownload'</b>:
     *
     * ReqDBDownload = Method to Request DB Download
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onReqDBDownload(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendReqDBDownloadError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'ReqCreateMediaPlayerFolderList'

    /**
     * The method onReqCreateMediaPlayerFolderList() is called by ASF when a
     * client invokes the method 'ReqCreateMediaPlayerFolderList'. A subclass
     * has to implement this method and send back a response to the client
     * either with the sendReqCreateMediaPlayerFolderList() or
     * sendReqCreateMediaPlayerFolderListError() method. Do not invoke this
     * method on your own.
     *
     * <b>Documentation of 'ReqCreateMediaPlayerFolderList'</b>:
     *
     * If the meaning of "ReqCreateMediaPlayerFolderList" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onReqCreateMediaPlayerFolderListRequest (const ::boost::shared_ptr< ReqCreateMediaPlayerFolderListRequest >& request) = 0;

    /**
     * The method sendReqCreateMediaPlayerFolderListResponse() sends a
     * response of a previous method invocation of
     * 'ReqCreateMediaPlayerFolderList' back to the client.
     *
     * <b>Documentation of 'ReqCreateMediaPlayerFolderList'</b>:
     *
     * If the meaning of "ReqCreateMediaPlayerFolderList" isn't clear, then there should be a description here.
     *
     * @param ListCount If the meaning of "ListCount" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onReqCreateMediaPlayerFolderList(). If the act is not specified, i.e.
     * the most recent invocation will be answered. In case multiple replies
     * are pending an act must be specified. An assertion will be thrown if no
     * or multiple method invocation could be found.
     */
    void sendReqCreateMediaPlayerFolderListResponse (uint16 listCount, act_t act = 0);

    /**
     * The method sendReqCreateMediaPlayerFolderListError() sends an error
     * response of a previous method invocation of
     * 'ReqCreateMediaPlayerFolderList' back to the client.
     *
     * <b>Documentation of 'ReqCreateMediaPlayerFolderList'</b>:
     *
     * If the meaning of "ReqCreateMediaPlayerFolderList" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onReqCreateMediaPlayerFolderList(). If the act is not specified, i.e.
     * the most recent invocation will be answered. In case multiple replies
     * are pending an act must be specified. An assertion will be thrown if no
     * or multiple method invocation could be found.
     */
    void sendReqCreateMediaPlayerFolderListError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'ReqMediaPlayerFolderListSlice'

    /**
     * The method onReqMediaPlayerFolderListSlice() is called by ASF when a
     * client invokes the method 'ReqMediaPlayerFolderListSlice'. A subclass
     * has to implement this method and send back a response to the client
     * either with the sendReqMediaPlayerFolderListSlice() or
     * sendReqMediaPlayerFolderListSliceError() method. Do not invoke this
     * method on your own.
     *
     * <b>Documentation of 'ReqMediaPlayerFolderListSlice'</b>:
     *
     * If the meaning of "ReqMediaPlayerFolderListSlice" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onReqMediaPlayerFolderListSliceRequest (const ::boost::shared_ptr< ReqMediaPlayerFolderListSliceRequest >& request) = 0;

    /**
     * The method sendReqMediaPlayerFolderListSliceResponse() sends a response
     * of a previous method invocation of 'ReqMediaPlayerFolderListSlice' back
     * to the client.
     *
     * <b>Documentation of 'ReqMediaPlayerFolderListSlice'</b>:
     *
     * If the meaning of "ReqMediaPlayerFolderListSlice" isn't clear, then there should be a description here.
     *
     * @param mArrayListContainer If the meaning of "mArrayListContainer" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onReqMediaPlayerFolderListSlice(). If the act is not specified, i.e.
     * the most recent invocation will be answered. In case multiple replies
     * are pending an act must be specified. An assertion will be thrown if no
     * or multiple method invocation could be found.
     */
    void sendReqMediaPlayerFolderListSliceResponse (const ::std::vector< ListContainerStruct >& mArrayListContainer, act_t act = 0);

    /**
     * The method sendReqMediaPlayerFolderListSliceError() sends an error
     * response of a previous method invocation of
     * 'ReqMediaPlayerFolderListSlice' back to the client.
     *
     * <b>Documentation of 'ReqMediaPlayerFolderListSlice'</b>:
     *
     * If the meaning of "ReqMediaPlayerFolderListSlice" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onReqMediaPlayerFolderListSlice(). If the act is not specified, i.e.
     * the most recent invocation will be answered. In case multiple replies
     * are pending an act must be specified. An assertion will be thrown if no
     * or multiple method invocation could be found.
     */
    void sendReqMediaPlayerFolderListSliceError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'SetMediaVideoLanguagesList'

    /**
     * The method onSetMediaVideoLanguagesList() is called by ASF when a
     * client invokes the method 'SetMediaVideoLanguagesList'. A subclass has
     * to implement this method and send back a response to the client either
     * with the sendSetMediaVideoLanguagesList() or
     * sendSetMediaVideoLanguagesListError() method. Do not invoke this method
     * on your own.
     *
     * <b>Documentation of 'SetMediaVideoLanguagesList'</b>:
     *
     * SetMediaVideoLanguagesList = Method to update list of selected languages
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSetMediaVideoLanguagesListRequest (const ::boost::shared_ptr< SetMediaVideoLanguagesListRequest >& request) = 0;

    /**
     * The method sendSetMediaVideoLanguagesListResponse() sends a response of
     * a previous method invocation of 'SetMediaVideoLanguagesList' back to
     * the client.
     *
     * <b>Documentation of 'SetMediaVideoLanguagesList'</b>:
     *
     * SetMediaVideoLanguagesList = Method to update list of selected languages
     *
     * @param response If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onSetMediaVideoLanguagesList(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSetMediaVideoLanguagesListResponse (bool response, act_t act = 0);

    /**
     * The method sendSetMediaVideoLanguagesListError() sends an error
     * response of a previous method invocation of
     * 'SetMediaVideoLanguagesList' back to the client.
     *
     * <b>Documentation of 'SetMediaVideoLanguagesList'</b>:
     *
     * SetMediaVideoLanguagesList = Method to update list of selected languages
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onSetMediaVideoLanguagesList(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSetMediaVideoLanguagesListError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    ListSizeUpdate _listSizeProperty;

    friend class HmiEmpListInterfaceStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace HmiEmpListInterface
} // namespace di
} // namespace cm
} // namespace bosch

#endif // BOSCH_CM_DI_HMIEMPLISTINTERFACESTUB_H
