/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "bosch/cm/di/HmiEmpListInterface.h"
#include "bosch/cm/di/HmiEmpListInterfaceConst.h"
#include "bosch/cm/di/HmiEmpListInterfaceDBus.h"
#include "bosch/cm/di/HmiEmpListInterfaceJson.h"
#include "bosch/cm/di/HmiEmpListInterfaceStub.h"
#include <string>
#include <vector>

#include "asf/dbus/DBusMessage.h"

namespace bosch {
namespace cm {
namespace di {
namespace HmiEmpListInterface {

DEFINE_CLASS_LOGGER("/bosch/cm/di/bosch/cm/di/HmiEmpListInterface", HmiEmpListInterfaceStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 13, "ReqDBDownload", 2 },
    { 23, "ReqMediaPlayerListSlice", 1 },
    { 24, "ReqCreateMediaPlayerList", 0 },
    { 26, "SetMediaVideoLanguagesList", 5 },
    { 29, "ReqMediaPlayerFolderListSlice", 4 },
    { 30, "ReqCreateMediaPlayerFolderList", 3 },
};

static ::asf::dbus::DBusUtils::stringEntry propertiesTable[] = {
    { 8, "listSize", 0 },
};

class HmiEmpListInterfaceStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    HmiEmpListInterfaceStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    HmiEmpListInterfaceStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    HmiEmpListInterfaceStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "bosch.cm.di.HmiEmpListInterface"),
          _logger(logger) {}

    virtual ~HmiEmpListInterfaceStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void HmiEmpListInterfaceStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 6, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'ReqCreateMediaPlayerList'

            LOG_DEBUG_STUB("process method '%s'", "ReqCreateMediaPlayerList");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReqCreateMediaPlayerListRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ReqCreateMediaPlayerList", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ReqCreateMediaPlayerListRequest > payload = ::boost::static_pointer_cast<ReqCreateMediaPlayerListRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<HmiEmpListInterfaceStub*>(getStub())->onReqCreateMediaPlayerListRequest(payload);
            return;
        }
        case 1: {

            // method 'ReqMediaPlayerListSlice'

            LOG_DEBUG_STUB("process method '%s'", "ReqMediaPlayerListSlice");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReqMediaPlayerListSliceRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ReqMediaPlayerListSlice", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ReqMediaPlayerListSliceRequest > payload = ::boost::static_pointer_cast<ReqMediaPlayerListSliceRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<HmiEmpListInterfaceStub*>(getStub())->onReqMediaPlayerListSliceRequest(payload);
            return;
        }
        case 2: {

            // method 'ReqDBDownload'

            LOG_DEBUG_STUB("process method '%s'", "ReqDBDownload");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReqDBDownloadRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ReqDBDownload", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ReqDBDownloadRequest > payload = ::boost::static_pointer_cast<ReqDBDownloadRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<HmiEmpListInterfaceStub*>(getStub())->onReqDBDownloadRequest(payload);
            return;
        }
        case 3: {

            // method 'ReqCreateMediaPlayerFolderList'

            LOG_DEBUG_STUB("process method '%s'", "ReqCreateMediaPlayerFolderList");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReqCreateMediaPlayerFolderListRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ReqCreateMediaPlayerFolderList", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ReqCreateMediaPlayerFolderListRequest > payload = ::boost::static_pointer_cast<ReqCreateMediaPlayerFolderListRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<HmiEmpListInterfaceStub*>(getStub())->onReqCreateMediaPlayerFolderListRequest(payload);
            return;
        }
        case 4: {

            // method 'ReqMediaPlayerFolderListSlice'

            LOG_DEBUG_STUB("process method '%s'", "ReqMediaPlayerFolderListSlice");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReqMediaPlayerFolderListSliceRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ReqMediaPlayerFolderListSlice", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ReqMediaPlayerFolderListSliceRequest > payload = ::boost::static_pointer_cast<ReqMediaPlayerFolderListSliceRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<HmiEmpListInterfaceStub*>(getStub())->onReqMediaPlayerFolderListSliceRequest(payload);
            return;
        }
        case 5: {

            // method 'SetMediaVideoLanguagesList'

            LOG_DEBUG_STUB("process method '%s'", "SetMediaVideoLanguagesList");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetMediaVideoLanguagesListRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SetMediaVideoLanguagesList", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SetMediaVideoLanguagesListRequest > payload = ::boost::static_pointer_cast<SetMediaVideoLanguagesListRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<HmiEmpListInterfaceStub*>(getStub())->onSetMediaVideoLanguagesListRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* HmiEmpListInterfaceStubDelegate::introspect() const {
    return     "<interface name=\"bosch.cm.di.HmiEmpListInterface\">\n"
            "    <property access=\"read\" name=\"listSize\" type=\"(uuuy)\"/>\n"
            "    <method name=\"ReqCreateMediaPlayerList\">\n"
            "      <doc>\n"
            "        <line>ReqCreateMediaPlayerList = ReqCreateMediaPlayerList = Method to Request External MediaPlayer List</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"ListType\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>ListType = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"SourceType\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>SourceType = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"Region\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>Region = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"AbsoluteIndex\" type=\"q\">\n"
            "        <doc>\n"
            "          <line>AbsoluteIndex = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"response\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>response = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"ReqMediaPlayerListSlice\">\n"
            "      <doc>\n"
            "        <line>ReqMediaPlayerListSlice = ReqMediaPlayerListSlice = Method to Request MediaPlayer ListSlice</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"ListType\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>ListType = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"SourceType\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>SourceType = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"Region\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>Region = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"StartingIndex\" type=\"q\">\n"
            "        <doc>\n"
            "          <line>StartingIndex = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"WindowSize\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>WindowSize = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"mArrayListContainer\" type=\"a(ssqbu)\">\n"
            "        <doc>\n"
            "          <line>mArrayListContainer = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"ReqDBDownload\">\n"
            "      <doc>\n"
            "        <line>ReqDBDownload = ReqDBDownload = Method to Request DB Download</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"SourceType\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>SourceType = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"response\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>response = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"ReqCreateMediaPlayerFolderList\">\n"
            "      <arg direction=\"in\" name=\"SourceType\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>SourceType = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"Region\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>Region = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"FolderPath\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>FolderPath = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"ListCount\" type=\"q\">\n"
            "        <doc>\n"
            "          <line>ListCount = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"ReqMediaPlayerFolderListSlice\">\n"
            "      <arg direction=\"in\" name=\"SourceType\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>SourceType = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"Region\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>Region = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"StartingIndex\" type=\"q\">\n"
            "        <doc>\n"
            "          <line>StartingIndex = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"WindowSize\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>WindowSize = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"FolderPath\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>FolderPath = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"mArrayListContainer\" type=\"a(ssqbu)\">\n"
            "        <doc>\n"
            "          <line>mArrayListContainer = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"SetMediaVideoLanguagesList\">\n"
            "      <doc>\n"
            "        <line>SetMediaVideoLanguagesList = SetMediaVideoLanguagesList = Method to update list of selected languages</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"SourceType\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>SourceType = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"Region\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>Region = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"VideoLanguageIds\" type=\"aq\">\n"
            "        <doc>\n"
            "          <line>VideoLanguageIds = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"response\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>response = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <signal name=\"sig_DBState\">\n"
            "      <doc>\n"
            "        <line>sig_DBState = sig_DBState =  DB download state</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"DownloadState\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>DownloadState = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"SourceType\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>SourceType = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"sig_AlbumArtState\">\n"
            "      <doc>\n"
            "        <line>sig_AlbumArtState = sig_AlbumArtState =  AlbumArt download state</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"DownloadState\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>DownloadState = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"SongId\" type=\"q\">\n"
            "        <doc>\n"
            "          <line>SongId = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"sig_PlayableFlag\">\n"
            "      <doc>\n"
            "        <line>sig_PlayableFlag = sig_PlayableFlag =  playable content in USB</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"isPlayableAudio\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>isPlayableAudio = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"isPlayableVideo\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>isPlayableVideo = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"SourceType\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>SourceType = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"sig_CurrentTrackInfo\">\n"
            "      <arg direction=\"out\" name=\"SourceType\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>SourceType = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"ListType\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>ListType = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"Region\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>Region = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"SongId\" type=\"q\">\n"
            "        <doc>\n"
            "          <line>SongId = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"FolderPath\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>FolderPath = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "</interface>\n";
}

void HmiEmpListInterfaceStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<HmiEmpListInterfaceStub*>(getStub()))->onGetAll (properties);
}

void HmiEmpListInterfaceStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 1, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "listSize");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void HmiEmpListInterfaceStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 1, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "listSize");
            ::boost::shared_ptr< ListSizeGet > payload(new ListSizeGet());
            payload->setAct(act);
            static_cast<HmiEmpListInterfaceStub*>(getStub())->onListSizeGet (payload);
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

HmiEmpListInterfaceStub::HmiEmpListInterfaceStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new HmiEmpListInterfaceStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

HmiEmpListInterfaceStub::HmiEmpListInterfaceStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new HmiEmpListInterfaceStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

HmiEmpListInterfaceStub::~HmiEmpListInterfaceStub() {
    delete _stubDelegate;
}

void HmiEmpListInterfaceStub::sendSig_DBStateSignal(entDownloadState downloadState, entSourceType sourceType) {
    if (_stubDelegate->isConnected()) {
        Sig_DBStateSignal* payload = new Sig_DBStateSignal(downloadState, sourceType);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "sig_DBState", Sig_DBStateSignal, payload)
        LOG_INFO ("-> send%sSignal", "Sig_DBState");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "Sig_DBState");
    }
}

void HmiEmpListInterfaceStub::sendSig_AlbumArtStateSignal(entDownloadState downloadState, uint16 songId) {
    if (_stubDelegate->isConnected()) {
        Sig_AlbumArtStateSignal* payload = new Sig_AlbumArtStateSignal(downloadState, songId);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "sig_AlbumArtState", Sig_AlbumArtStateSignal, payload)
        LOG_INFO ("-> send%sSignal", "Sig_AlbumArtState");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "Sig_AlbumArtState");
    }
}

void HmiEmpListInterfaceStub::sendSig_PlayableFlagSignal(bool isPlayableAudio, bool isPlayableVideo, entSourceType sourceType) {
    if (_stubDelegate->isConnected()) {
        Sig_PlayableFlagSignal* payload = new Sig_PlayableFlagSignal(isPlayableAudio, isPlayableVideo, sourceType);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "sig_PlayableFlag", Sig_PlayableFlagSignal, payload)
        LOG_INFO ("-> send%sSignal", "Sig_PlayableFlag");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "Sig_PlayableFlag");
    }
}

void HmiEmpListInterfaceStub::sendSig_CurrentTrackInfoSignal(entSourceType sourceType, entListType listType, uint8 region, uint16 songId, const ::std::string& folderPath) {
    if (_stubDelegate->isConnected()) {
        Sig_CurrentTrackInfoSignal* payload = new Sig_CurrentTrackInfoSignal(sourceType, listType, region, songId, folderPath);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "sig_CurrentTrackInfo", Sig_CurrentTrackInfoSignal, payload)
        LOG_INFO ("-> send%sSignal", "Sig_CurrentTrackInfo");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "Sig_CurrentTrackInfo");
    }
}

void HmiEmpListInterfaceStub::sendListSizeUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ListSizeUpdate payload(_listSizeProperty);

        LOG_INFO ("-> send%s", "ListSizeUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("listSize", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("bosch.cm.di.HmiEmpListInterface", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ListSizeUpdate");
    }
}

void HmiEmpListInterfaceStub::onListSizeGet(const ::boost::shared_ptr< ListSizeGet >& listSize) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ListSizeGet", listSize->getAct());
    sendListSizeGetUpdate(_listSizeProperty.getListSize(), listSize->getAct());
}

void HmiEmpListInterfaceStub::sendListSizeGetUpdate(const ListSizeStruct& listSize, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ListSizeGet payload(listSize);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ListSizeGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void HmiEmpListInterfaceStub::setListSize(const ListSizeStruct& listSize) {
    if(listSize!=_listSizeProperty.getListSize()) {
        _listSizeProperty.setListSize(listSize);
        sendListSizeUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ListSizeStruct& HmiEmpListInterfaceStub::getListSize() const {
    return _listSizeProperty.getListSize();
}

ListSizeStruct& HmiEmpListInterfaceStub::getListSizeMutable() {
    return _listSizeProperty.getListSizeMutable();
}

void  HmiEmpListInterfaceStub::sendReqCreateMediaPlayerListResponse (bool response, act_t act) {
    ReqCreateMediaPlayerListResponse* payload = new ReqCreateMediaPlayerListResponse(response);
    DBUS_MESSAGE_REPLY(dbusMessage, "ReqCreateMediaPlayerList", ReqCreateMediaPlayerListResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ReqCreateMediaPlayerList", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  HmiEmpListInterfaceStub::sendReqCreateMediaPlayerListError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ReqCreateMediaPlayerListError* payload = new ReqCreateMediaPlayerListError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ReqCreateMediaPlayerList", ReqCreateMediaPlayerListError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ReqCreateMediaPlayerList", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  HmiEmpListInterfaceStub::sendReqMediaPlayerListSliceResponse (const ::std::vector< ListContainerStruct >& mArrayListContainer, act_t act) {
    ReqMediaPlayerListSliceResponse* payload = new ReqMediaPlayerListSliceResponse(mArrayListContainer);
    DBUS_MESSAGE_REPLY(dbusMessage, "ReqMediaPlayerListSlice", ReqMediaPlayerListSliceResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ReqMediaPlayerListSlice", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  HmiEmpListInterfaceStub::sendReqMediaPlayerListSliceError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ReqMediaPlayerListSliceError* payload = new ReqMediaPlayerListSliceError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ReqMediaPlayerListSlice", ReqMediaPlayerListSliceError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ReqMediaPlayerListSlice", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  HmiEmpListInterfaceStub::sendReqDBDownloadResponse (bool response, act_t act) {
    ReqDBDownloadResponse* payload = new ReqDBDownloadResponse(response);
    DBUS_MESSAGE_REPLY(dbusMessage, "ReqDBDownload", ReqDBDownloadResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ReqDBDownload", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  HmiEmpListInterfaceStub::sendReqDBDownloadError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ReqDBDownloadError* payload = new ReqDBDownloadError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ReqDBDownload", ReqDBDownloadError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ReqDBDownload", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  HmiEmpListInterfaceStub::sendReqCreateMediaPlayerFolderListResponse (uint16 listCount, act_t act) {
    ReqCreateMediaPlayerFolderListResponse* payload = new ReqCreateMediaPlayerFolderListResponse(listCount);
    DBUS_MESSAGE_REPLY(dbusMessage, "ReqCreateMediaPlayerFolderList", ReqCreateMediaPlayerFolderListResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ReqCreateMediaPlayerFolderList", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  HmiEmpListInterfaceStub::sendReqCreateMediaPlayerFolderListError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ReqCreateMediaPlayerFolderListError* payload = new ReqCreateMediaPlayerFolderListError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ReqCreateMediaPlayerFolderList", ReqCreateMediaPlayerFolderListError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ReqCreateMediaPlayerFolderList", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  HmiEmpListInterfaceStub::sendReqMediaPlayerFolderListSliceResponse (const ::std::vector< ListContainerStruct >& mArrayListContainer, act_t act) {
    ReqMediaPlayerFolderListSliceResponse* payload = new ReqMediaPlayerFolderListSliceResponse(mArrayListContainer);
    DBUS_MESSAGE_REPLY(dbusMessage, "ReqMediaPlayerFolderListSlice", ReqMediaPlayerFolderListSliceResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ReqMediaPlayerFolderListSlice", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  HmiEmpListInterfaceStub::sendReqMediaPlayerFolderListSliceError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ReqMediaPlayerFolderListSliceError* payload = new ReqMediaPlayerFolderListSliceError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ReqMediaPlayerFolderListSlice", ReqMediaPlayerFolderListSliceError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ReqMediaPlayerFolderListSlice", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  HmiEmpListInterfaceStub::sendSetMediaVideoLanguagesListResponse (bool response, act_t act) {
    SetMediaVideoLanguagesListResponse* payload = new SetMediaVideoLanguagesListResponse(response);
    DBUS_MESSAGE_REPLY(dbusMessage, "SetMediaVideoLanguagesList", SetMediaVideoLanguagesListResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SetMediaVideoLanguagesList", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  HmiEmpListInterfaceStub::sendSetMediaVideoLanguagesListError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SetMediaVideoLanguagesListError* payload = new SetMediaVideoLanguagesListError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "SetMediaVideoLanguagesList", SetMediaVideoLanguagesListError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SetMediaVideoLanguagesList", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void HmiEmpListInterfaceStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {

    //property 'listSize'
    {
        ::asf::dbus::DBusVariant variant;
        ListSizeGet payload(_listSizeProperty.getListSize());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("listSize", variant));
    }
}

} // namespace HmiEmpListInterface
} // namespace di
} // namespace cm
} // namespace bosch
