/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "EMP_ListHandler/DbusComponent/EMPServer/EmpListDbusApplication.h"
#include "EMP_ListHandler/DbusComponent/EMPServer/EmpListDbusService.h"
#include "asf/core/Application.h"
#include "asf/core/ComponentContainer.h"
#include "asf/core/ComponentDescription.h"
#include "asf/core/ContextData.h"
#include "asf/core/Logger.h"
#include "asf/core/ProvidedPort.h"
#include "asf/core/RequiredPort.h"
#include "asf/core/SignalHandler.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusImportedPort.h"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "com/bosch/cm/asf/lang/dbus/ConnectorsJson.h"
#include <cstdio>
#include <string>

/**
 * If the meaning of "EmpListDbusApplication" isn't clear, then there should be a description here.
 */

namespace EMP_ListHandler {
namespace DbusComponent {
namespace EMPServer {

DEFINE_LOGGER_AND_LEVEL (_logger, "/EMP_ListHandler/DbusComponent/EMPServer/EmpListDbusApplication", Info);

/* static */ const char* EmpListDbusApplication::empList = "empList";

static const char* helpMessage =
    "--logconfig <file>     Read the logging configuration from <file>\n"
    "                       see the ASF User Guide, section 6.3. Logging API\n"
    "--help                 Print this help message\n";

bool EmpListDbusApplication_enabledASFSignalHandler = false;

void importEmpListDbusApplication() {
    ::asf::core::Application* app = ::asf::core::Application::getApplication();
    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't attach EmpListDbusApplication, because no Application is instantiated");

    // Expression

    ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector dbusSessionConnector;
    {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector __expression0;
        {
            __expression0.setBusType(::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector::BusType__Session);
        }
        dbusSessionConnector = __expression0;
    }
    {
        std::string jsonPayload;
        serializeJson (dbusSessionConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "dbusSessionConnector", "DBusConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::dbus::DBusConnector > dbusSessionConnector_(new ::asf::dbus::DBusConnector(*app, dbusSessionConnector));
    app->addStarter(dbusSessionConnector_);

    // Thread 'EmpListDbusthread'

    ::asf::core::ComponentContainerSharedPtr EmpListDbusthread(new ::asf::core::ComponentContainer("EmpListDbusthread", ::asf::core::ThreadConfiguration(1)));
    app->addContainer (EmpListDbusthread);

        // Component 'EmpListDbusService empList'

        ::boost::shared_ptr< ::asf::core::ComponentFactory< ::EMP_ListHandler::DbusComponent::EMPServer::EmpListDbusService > > empListFactory(new ::asf::core::ComponentFactory< ::EMP_ListHandler::DbusComponent::EMPServer::EmpListDbusService >);
        ::asf::core::ComponentDescriptionSharedPtr empListDescription(new ::asf::core::ComponentDescription(1, "empList", /* immediate = */ true, /* threadBridge = */ false, empListFactory));
        EmpListDbusthread->addComponentDescription(empListDescription);

            // Port 'EmpListHmiPort'

            ::asf::core::ProvidedPort& empList_EmpListHmiPort = empListDescription->addProvidedPort (::asf::core::ProvidedPort ("bosch.cm.di.HmiEmpListInterface", "EmpListHmiPort", false, false));
            (void)empList_EmpListHmiPort; // prevent unused variable warning

            // Port 'PluginDbusServerPort'

            ::asf::core::RequiredPort& empList_PluginDbusServerPort = empListDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.ai.PluginDbusInterface", "PluginDbusServerPort"));
            (void)empList_PluginDbusServerPort; // prevent unused variable warning

    // Expression

    dbusSessionConnector_->exportByName (empList_EmpListHmiPort, ::std::string("/bosch/cm/di/HmiEmpListInterface"));

    // Expression

    ::asf::dbus::DBusImportedPort& PluginDbusPort = dbusSessionConnector_->importByName (::std::string("PluginServer.PluginServer"), ::std::string("/bosch/cm/ai/PluginDbusInterface"));
    PluginDbusPort.setServiceName("bosch.cm.ai.PluginDbusInterface");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (empList_PluginDbusServerPort, PluginDbusPort);


    LOG_INFO_STATIC("Starting application 'EmpListDbusApplication' version 1.0.0");

    app->start();
}

int executeEmpListDbusApplication(int argc, char* argv[]) {
    ::asf::core::ContextData context;

    const char* logConfigFile = 0;
    std::vector<std::string> arguments;

    for (int i=1; i<argc; i++) {
        if (std::string(argv[i]) == "--logconfig" && i+1 < argc) {
            // ignore lint warning e850: modification of i inside loop is safe
            logConfigFile = argv[++i];
        } else {
            if (std::string(argv[i]) == "--help") {
                printf ("%s", helpMessage);
                exit (0);
            } else {
                arguments.push_back (argv[i]);
            }
        }
    }

    if (logConfigFile == 0) {
        ::asf::core::Logger::setupLogging ("EMP_ListHandler.DbusComponent.EMPServer", "EmpListDbusApplication");
    } else {
        ::asf::core::Logger::setupLogging ("EMP_ListHandler.DbusComponent.EMPServer", "EmpListDbusApplication", logConfigFile);
    }

    LOG_INFO_STATIC("%s ASF signal handler", EmpListDbusApplication_enabledASFSignalHandler ? "Enabled" : "Disabled" );

    ::asf::core::Application* app = ::asf::core::Application::createApplication("EMP_ListHandler.DbusComponent.EMPServer", "EmpListDbusApplication", ::asf::core::Version(1, 0, 0, ""), arguments);

    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't create EmpListDbusApplication");

    app->enableExceptionHandler(true);

    importEmpListDbusApplication();

    int exitCode = app->waitForCompletion();
    ::asf::core::Application::deleteApplication();

    return exitCode;
}

} // namespace EMPServer
} // namespace DbusComponent
} // namespace EMP_ListHandler

int main(int argc, char* argv[]) {
    ::EMP_ListHandler::DbusComponent::EMPServer::EmpListDbusApplication_enabledASFSignalHandler = true;
    ::asf::core::SignalHandler asfSignalHandler;
    ::boost::shared_ptr< ::asf::threading::Thread > mainThread = ::asf::threading::Thread::attach();
    return ::EMP_ListHandler::DbusComponent::EMPServer::executeEmpListDbusApplication(argc, argv);
}

