/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef COURIERTUNNELSERVICE_COURIERMESSAGERECEIVERSTUB_H
#define COURIERTUNNELSERVICE_COURIERMESSAGERECEIVERSTUB_H

#include "CourierTunnelService/CourierMessageReceiver.h"
#include "asf/cms/CmsStubDelegate.h"
#include "asf/core/Logger.h"
#include "boost/shared_ptr.hpp"

namespace CourierTunnelService {
namespace CourierMessageReceiver {

/**
 * The CourierMessageReceiver service is a bridge between
 * the courier message framework and ASF.
 */

class CourierMessageReceiverStubConnector;

/**
 * The CourierMessageReceiverStub is the hook to implement the
 * CourierMessageReceiver. It is necessary to derive from this class and
 * implement the pure virtual functions. That's the way to add the
 * functionality to the service.
 */
class CourierMessageReceiverStub : public ::asf::core::Stub
{
public:
    /**
     * The derived class has to pass the port name to the
     * CourierMessageReceiverStub. The port name is defined in the "Car
     * Multimedia Component" model.
     */
    CourierMessageReceiverStub (const std::string& portName);

    virtual ~CourierMessageReceiverStub();

    // request receiveCourierMessage

    /**
     * This function will be called if the component receives the client
     * request "receiveCourierMessageRequest". The service implementation has
     * to process the request and send the response with
     * sendReceiveCourierMessageResponse().
     *
     * <b>Documentation of 'receiveCourierMessage'</b>:
     *
     * Sends a courier message from the client to the service provider
     */
    virtual void onReceiveCourierMessageRequest (const ::boost::shared_ptr< ReceiveCourierMessageRequest >& receiveCourierMessage) = 0;


private:
    CourierMessageReceiverStub(const CourierMessageReceiverStub&);

    CourierMessageReceiverStub& operator=(const CourierMessageReceiverStub&);


    CourierMessageReceiverStubConnector* _stubConnector;

    ::asf::cms::CmsStubDelegate* _cmsStubDelegate;

    DECLARE_CLASS_LOGGER();

    friend class CourierMessageReceiverStubConnector;
};

} // namespace CourierMessageReceiver
} // namespace CourierTunnelService

#endif // COURIERTUNNELSERVICE_COURIERMESSAGERECEIVERSTUB_H
