/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "CourierTunnelService/CourierMessageReceiver.h"
#include "CourierTunnelService/CourierMessageReceiverProxy.h"
#include "asf/cms/CmsProxyRegistry.h"
#include "boost/shared_ptr.hpp"

namespace CourierTunnelService {
namespace CourierMessageReceiver {

DEFINE_CLASS_LOGGER("/CourierTunnelService/CourierMessageReceiver", CourierMessageReceiverProxy);
DEFINE_CLASS_LOGGER("/CourierTunnelService/CourierMessageReceiver", CourierMessageReceiverClientBase);


// static
::boost::shared_ptr< CourierMessageReceiverProxy > CourierMessageReceiverProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::cms::CmsProxyRegistry::getInstance().getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<CourierMessageReceiverProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    // create new proxy object
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< CourierMessageReceiverProxy >  proxyNew(new CourierMessageReceiverProxy(portName,serviceAvailable));
    ::asf::cms::CmsProxyRegistry::getInstance().registerProxy(proxyNew);
    return proxyNew;
}

// static
::boost::shared_ptr< CourierMessageReceiverProxy > CourierMessageReceiverProxy::createProxy(const std::string& portName, const std::string& uriAddress, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    // create new proxy object
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< CourierMessageReceiverProxy >  proxyNew(new CourierMessageReceiverProxy(portName,serviceAvailable));
    ::asf::cms::CmsProxyRegistry::getInstance().registerProxy(proxyNew, uriAddress);
    return proxyNew;
}

CourierMessageReceiverProxy::CourierMessageReceiverProxy (const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    CmsProxy(portName,serviceAvailable, "CourierTunnelService.CourierMessageReceiver", _logger) {
    LOG_INFO ("Create proxy=%p, compId=%d, portName='%s'", this, _cmsProxyDelegate.getClientComponentId(), getPortName().c_str());
}

CourierMessageReceiverProxy::~CourierMessageReceiverProxy () {
    ::asf::cms::CmsProxyRegistry::getInstance().deregisterProxy(_cmsProxyDelegate.getProxyId());
}

act_t CourierMessageReceiverProxy::sendReceiveCourierMessageRequest() {
    ::boost::shared_ptr< ReceiveCourierMessageRequest > para(new ReceiveCourierMessageRequest());
    ::asf::cms::CmsMessage msg(::asf::cms::CmsTypes::CmsMessageHeader::CmsMessageType__OnewayRequest,_cmsProxyDelegate.getServiceId(),"receiveCourierMessage",::asf::cms::CmsMessage::getUniqueCct(),_cmsProxyDelegate.getProxyId());
    msg.setPayload(para);

    ::asf::cms::CmsMessage::returnCct(msg.getCct());
    act_t regId = (act_t)0;
    if(_cmsProxyDelegate.request(msg)) {
        LOG_INFO ("-> send%sRequest(), returning act=%" PRIuPTR, "ReceiveCourierMessage", regId);
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(*para,jsonPayload);
            LOG_INFO("payload: %s", jsonPayload.c_str());
        }
    }
    return regId;
}

::asf::cms::CmsServiceStreamer* CourierMessageReceiverProxy::getStreamer() {
    ::asf::cms::CmsServiceStreamer* streamer=0;
    switch(_cmsProxyDelegate.getEncoding()) {
        case ::com::bosch::cm::asf::lang::cms::Connectors::Encoding__Json:
            streamer=&_streamerJson;
            break;
        case ::com::bosch::cm::asf::lang::cms::Connectors::Encoding__FastBin:
            streamer=&_streamerCmsBin;
            break;
        default:
            streamer=0;
            break;
    }
    return streamer;
}

} // namespace CourierMessageReceiver
} // namespace CourierTunnelService
