/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef NET_CONNMAN_SESSIONPROXY_H
#define NET_CONNMAN_SESSIONPROXY_H

#include "asf/core/Logger.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DBusVariant.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "net/connman/Session.h"
#include <dbus/dbus.h>
#include <string>

namespace net {
namespace connman {
namespace Session {

class SessionProxy;

class ChangeCallbackIF {
public:
    virtual ~ChangeCallbackIF() {}

    virtual void onChangeError(const ::boost::shared_ptr< SessionProxy >& proxy, const ::boost::shared_ptr< ChangeError >& error) = 0;

    virtual void onChangeResponse(const ::boost::shared_ptr< SessionProxy >& proxy, const ::boost::shared_ptr< ChangeResponse >& response) = 0;
};

class ConnectCallbackIF {
public:
    virtual ~ConnectCallbackIF() {}

    virtual void onConnectError(const ::boost::shared_ptr< SessionProxy >& proxy, const ::boost::shared_ptr< ConnectError >& error) = 0;

    virtual void onConnectResponse(const ::boost::shared_ptr< SessionProxy >& proxy, const ::boost::shared_ptr< ConnectResponse >& response) = 0;
};

class DestroyCallbackIF {
public:
    virtual ~DestroyCallbackIF() {}

    virtual void onDestroyError(const ::boost::shared_ptr< SessionProxy >& proxy, const ::boost::shared_ptr< DestroyError >& error) = 0;

    virtual void onDestroyResponse(const ::boost::shared_ptr< SessionProxy >& proxy, const ::boost::shared_ptr< DestroyResponse >& response) = 0;
};

class DisconnectCallbackIF {
public:
    virtual ~DisconnectCallbackIF() {}

    virtual void onDisconnectError(const ::boost::shared_ptr< SessionProxy >& proxy, const ::boost::shared_ptr< DisconnectError >& error) = 0;

    virtual void onDisconnectResponse(const ::boost::shared_ptr< SessionProxy >& proxy, const ::boost::shared_ptr< DisconnectResponse >& response) = 0;
};


/**
 * SessionProxy is the client side representation of the D-Bus service
 * interface 'net.connman.Session' (specified in file
 * dbus-net.connman.session.manager.xml).
 *
 * If the meaning of "net.connman.Session" isn't clear, then there should be a description here.
 */
class SessionProxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of SessionProxy.
     */
    static ::boost::shared_ptr< SessionProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of SessionProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< SessionProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of SessionProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< SessionProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< SessionProxy > proxyNew(new SessionProxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(false);
        return proxyNew;
    }

    virtual ~SessionProxy ();




    // Method 'Destroy'

    /**
     * Call the method 'Destroy'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'Destroy'</b>:
     *
     * If the meaning of "Destroy" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDestroyRequest(DestroyCallbackIF& cb) const;

    // Method 'Connect'

    /**
     * Call the method 'Connect'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'Connect'</b>:
     *
     * If the meaning of "Connect" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendConnectRequest(ConnectCallbackIF& cb) const;

    // Method 'Disconnect'

    /**
     * Call the method 'Disconnect'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'Disconnect'</b>:
     *
     * If the meaning of "Disconnect" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDisconnectRequest(DisconnectCallbackIF& cb) const;

    // Method 'Change'

    /**
     * Call the method 'Change'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'Change'</b>:
     *
     * If the meaning of "Change" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param name If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param value If the meaning of "value" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendChangeRequest(ChangeCallbackIF& cb, const ::std::string& name, const ::asf::dbus::DBusVariant& value) const;


private:

    SessionProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;


    DECLARE_CLASS_LOGGER();

    friend class SessionProxyCallback;
};

} // namespace Session
} // namespace connman
} // namespace net

#endif // NET_CONNMAN_SESSIONPROXY_H
