/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "net/connman/Manager.h"
#include "net/connman/ManagerDBus.h"
#include "net/connman/ManagerJson.h"
#include "net/connman/ManagerStub.h"
#include <string>
#include <vector>

#include "asf/dbus/DBusMessage.h"

namespace net {
namespace connman {
namespace Manager {

DEFINE_CLASS_LOGGER("/net/connman/Manager", ManagerStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 13, "CreateSession", 0 },
    { 14, "DestroySession", 1 },
};


class ManagerStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    ManagerStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    ManagerStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    ManagerStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "net.connman.Manager"),
          _logger(logger) {}

    virtual ~ManagerStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void ManagerStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 2, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'CreateSession'

            LOG_DEBUG_STUB("process method '%s'", "CreateSession");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CreateSessionRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "CreateSession", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< CreateSessionRequest > payload = ::boost::static_pointer_cast<CreateSessionRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ManagerStub*>(getStub())->onCreateSessionRequest(payload);
            return;
        }
        case 1: {

            // method 'DestroySession'

            LOG_DEBUG_STUB("process method '%s'", "DestroySession");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DestroySessionRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "DestroySession", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< DestroySessionRequest > payload = ::boost::static_pointer_cast<DestroySessionRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ManagerStub*>(getStub())->onDestroySessionRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* ManagerStubDelegate::introspect() const {
    return     "<interface name=\"net.connman.Manager\">\n"
            "      <method name=\"CreateSession\">\n"
            "        <arg direction=\"in\" name=\"settings\" type=\"a{sv}\"/>\n"
            "        <arg direction=\"in\" name=\"notifier\" type=\"o\"/>\n"
            "        <arg direction=\"out\" name=\"session\" type=\"o\"/>\n"
            "      </method>\n"
            "      <method name=\"DestroySession\">\n"
            "        <arg direction=\"in\" name=\"session\" type=\"o\"/>\n"
            "      </method>\n"
            "      <signal name=\"ServicesChanged\">\n"
            "        <arg name=\"changed\" type=\"a(oa{sv})\"/>\n"
            "        <arg name=\"removed\" type=\"ao\"/>\n"
            "      </signal>\n"
            "</interface>\n";
}

void ManagerStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<ManagerStub*>(getStub()))->onGetAll (properties);
}

void ManagerStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    ((void)value);  // to get rid of unused variable warning
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void ManagerStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

ManagerStub::ManagerStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new ManagerStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

ManagerStub::ManagerStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new ManagerStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

ManagerStub::~ManagerStub() {
    delete _stubDelegate;
}

void ManagerStub::sendServicesChangedSignal(const ::std::vector< ServicesChangedSignalChangedStruct >& changed, const ::std::vector< ::std::string >& removed) {
    if (_stubDelegate->isConnected()) {
        ServicesChangedSignal* payload = new ServicesChangedSignal(changed, removed);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "ServicesChanged", ServicesChangedSignal, payload)
        LOG_INFO ("-> send%sSignal", "ServicesChanged");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "ServicesChanged");
    }
}

void  ManagerStub::sendCreateSessionResponse (const ::std::string& session, act_t act) {
    CreateSessionResponse* payload = new CreateSessionResponse(session);
    DBUS_MESSAGE_REPLY(dbusMessage, "CreateSession", CreateSessionResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "CreateSession", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendCreateSessionError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    CreateSessionError* payload = new CreateSessionError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "CreateSession", CreateSessionError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "CreateSession", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendDestroySessionResponse (act_t act) {
    DestroySessionResponse* payload = new DestroySessionResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "DestroySession", DestroySessionResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "DestroySession", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendDestroySessionError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    DestroySessionError* payload = new DestroySessionError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "DestroySession", DestroySessionError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "DestroySession", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void ManagerStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {
    ((void)properties);  // to get rid of unused variable warning
}

} // namespace Manager
} // namespace connman
} // namespace net
