/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef NET_CONNMAN_MANAGERPROXY_H
#define NET_CONNMAN_MANAGERPROXY_H

#include "asf/core/Logger.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DBusVariant.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "net/connman/Manager.h"
#include <dbus/dbus.h>
#include <map>
#include <string>

namespace net {
namespace connman {
namespace Manager {

class ManagerProxy;

class CreateSessionCallbackIF {
public:
    virtual ~CreateSessionCallbackIF() {}

    virtual void onCreateSessionError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< CreateSessionError >& error) = 0;

    virtual void onCreateSessionResponse(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< CreateSessionResponse >& response) = 0;
};

class DestroySessionCallbackIF {
public:
    virtual ~DestroySessionCallbackIF() {}

    virtual void onDestroySessionError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< DestroySessionError >& error) = 0;

    virtual void onDestroySessionResponse(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< DestroySessionResponse >& response) = 0;
};

class ServicesChangedCallbackIF {
public:
    virtual ~ServicesChangedCallbackIF() {}

    virtual void onServicesChangedError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< ServicesChangedError >& error) = 0;

    virtual void onServicesChangedSignal(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< ServicesChangedSignal >& signal) = 0;
};


/**
 * ManagerProxy is the client side representation of the D-Bus service
 * interface 'net.connman.Manager' (specified in file
 * dbus-net.connman.session.manager.xml).
 *
 * If the meaning of "net.connman.Manager" isn't clear, then there should be a description here.
 */
class ManagerProxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of ManagerProxy.
     */
    static ::boost::shared_ptr< ManagerProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of ManagerProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< ManagerProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of ManagerProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< ManagerProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< ManagerProxy > proxyNew(new ManagerProxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(false);
        return proxyNew;
    }

    virtual ~ManagerProxy ();


    // Signal 'ServicesChanged'

    /**
     * Notify on the signal 'ServicesChanged'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'ServicesChanged'</b>:
     *
     * If the meaning of "ServicesChanged" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendServicesChangedRegister(ServicesChangedCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'ServicesChanged'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'ServicesChanged'</b>:
     *
     * If the meaning of "ServicesChanged" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendServicesChangedRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendServicesChangedDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'ServicesChanged'.
     */
    void sendServicesChangedDeregisterAll () const;



    // Method 'CreateSession'

    /**
     * Call the method 'CreateSession'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'CreateSession'</b>:
     *
     * If the meaning of "CreateSession" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param settings If the meaning of "settings" isn't clear, then there should be a description here.
     *
     * @param notifier If the meaning of "notifier" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCreateSessionRequest(CreateSessionCallbackIF& cb, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& settings, const ::std::string& notifier) const;

    // Method 'DestroySession'

    /**
     * Call the method 'DestroySession'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'DestroySession'</b>:
     *
     * If the meaning of "DestroySession" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param session If the meaning of "session" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDestroySessionRequest(DestroySessionCallbackIF& cb, const ::std::string& session) const;

    /**
     * Release all property and signal notifications.
     */
    void sendDeregisterAll () const;

private:

    ManagerProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;


    DECLARE_CLASS_LOGGER();

    friend class ManagerProxyCallback;
};

} // namespace Manager
} // namespace connman
} // namespace net

#endif // NET_CONNMAN_MANAGERPROXY_H
