#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef NET_CONNMAN_MANAGER_H
#define NET_CONNMAN_MANAGER_H

#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include "asf/dbus/DBusVariant.h"
#include <cstddef>
#include <cstring>
#include <map>
#include <string>
#include <vector>

/**
 * If the meaning of "Manager" isn't clear, then there should be a description here.
 */

namespace net {
namespace connman {
namespace Manager {

// method IDs
static const uint16 ID_CreateSession = 0;
static const uint16 ID_DestroySession = 1;

// signal IDs
static const uint16 ID_ServicesChanged = 2;

// property IDs

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class CreateSessionRequest;

class CreateSessionResponse;

class DestroySessionRequest;

class ServicesChangedSignalChangedStruct;

class ServicesChangedSignal;

// type definitions
/**
 * If the meaning of "CreateSessionError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError CreateSessionError;

/**
 * If the meaning of "DestroySessionResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage DestroySessionResponse;

/**
 * If the meaning of "DestroySessionError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DestroySessionError;

/**
 * If the meaning of "ServicesChangedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ServicesChangedError;


/**
 * If the meaning of "CreateSessionRequest" isn't clear, then there should be a description here.
 */
class CreateSessionRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CreateSessionRequest ();

    /**
     * Copy constructor
     */
    inline  CreateSessionRequest (const CreateSessionRequest &rhs);

    /**
     * All fields constructor
     */
    inline  CreateSessionRequest (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& settings_, const ::std::string& notifier_);

    /**
     * Destructor
     */
    inline virtual  ~CreateSessionRequest();

    /**
     * Assignment operator
     */
    inline CreateSessionRequest& operator = (const CreateSessionRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CreateSessionRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CreateSessionRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CreateSessionRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CreateSessionRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "settings"

    static const int kSettings = 0;

    /**
     * Clears the field "settings".
     *
     * The field will be set to its default value. The hasSettings()
     * method will return false.
     */
    inline void clearSettings();

    /**
     * Checks whether the field "settings" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSettings()). Otherwise it will return false.
     */
    inline bool hasSettings () const;

    /**
     * Returns the value of the member "settings".
     *
     * If the meaning of "settings" isn't clear, then there should be a description here.
     *
     * @return The value of the field "settings"
     */
    inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getSettings () const;

    /**
     * Retrieves the value of the field "settings" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "settings".
     */
    inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getSettingsMutable ();

    /**
     * Sets the value of the member "settings".
     *
     * If the meaning of "settings" isn't clear, then there should be a description here.
     *
     * @param settings The value which will be set
     */
    inline void setSettings (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& settings_);

    // API of field "notifier"

    static const int kNotifier = 1;

    /**
     * Clears the field "notifier".
     *
     * The field will be set to its default value. The hasNotifier()
     * method will return false.
     */
    inline void clearNotifier();

    /**
     * Checks whether the field "notifier" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNotifier()). Otherwise it will return false.
     */
    inline bool hasNotifier () const;

    /**
     * Returns the value of the member "notifier".
     *
     * If the meaning of "notifier" isn't clear, then there should be a description here.
     *
     * @return The value of the field "notifier"
     */
    inline const ::std::string& getNotifier () const;

    /**
     * Retrieves the value of the field "notifier" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "notifier".
     */
    inline ::std::string& getNotifierMutable ();

    /**
     * Sets the value of the member "notifier".
     *
     * If the meaning of "notifier" isn't clear, then there should be a description here.
     *
     * @param notifier The value which will be set
     */
    inline void setNotifier (const ::std::string& notifier_);

    /**
     * Sets the value of the member "notifier".
     *
     * If the meaning of "notifier" isn't clear, then there should be a description here.
     *
     * @param notifier The value which will be set
     */
    inline void setNotifier (const char* notifier_);

    /**
     * Sets the value of the member "notifier".
     *
     * If the meaning of "notifier" isn't clear, then there should be a description here.
     *
     * @param notifier The value which will be set
     */
    inline void setNotifier (const char* value, size_t size);

    static const CreateSessionRequest &getDefaultInstance();

private:

    static const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getStringTo__asf__dbus__DBusVariantMap_DefaultInstance ();

    inline void set_has_settings ();

    inline void clear_has_settings ();

    inline void set_has_notifier ();

    inline void clear_has_notifier ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::map< ::std::string, ::asf::dbus::DBusVariant > _settings;

    ::std::string _notifier;

};

/**
 * If the meaning of "CreateSessionResponse" isn't clear, then there should be a description here.
 */
class CreateSessionResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CreateSessionResponse ();

    /**
     * Copy constructor
     */
    inline  CreateSessionResponse (const CreateSessionResponse &rhs);

    /**
     * All fields constructor
     */
    inline  CreateSessionResponse (const ::std::string& session_);

    /**
     * Destructor
     */
    inline virtual  ~CreateSessionResponse();

    /**
     * Assignment operator
     */
    inline CreateSessionResponse& operator = (const CreateSessionResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CreateSessionResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CreateSessionResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CreateSessionResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CreateSessionResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "session"

    static const int kSession = 0;

    /**
     * Clears the field "session".
     *
     * The field will be set to its default value. The hasSession()
     * method will return false.
     */
    inline void clearSession();

    /**
     * Checks whether the field "session" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSession()). Otherwise it will return false.
     */
    inline bool hasSession () const;

    /**
     * Returns the value of the member "session".
     *
     * If the meaning of "session" isn't clear, then there should be a description here.
     *
     * @return The value of the field "session"
     */
    inline const ::std::string& getSession () const;

    /**
     * Retrieves the value of the field "session" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "session".
     */
    inline ::std::string& getSessionMutable ();

    /**
     * Sets the value of the member "session".
     *
     * If the meaning of "session" isn't clear, then there should be a description here.
     *
     * @param session The value which will be set
     */
    inline void setSession (const ::std::string& session_);

    /**
     * Sets the value of the member "session".
     *
     * If the meaning of "session" isn't clear, then there should be a description here.
     *
     * @param session The value which will be set
     */
    inline void setSession (const char* session_);

    /**
     * Sets the value of the member "session".
     *
     * If the meaning of "session" isn't clear, then there should be a description here.
     *
     * @param session The value which will be set
     */
    inline void setSession (const char* value, size_t size);

    static const CreateSessionResponse &getDefaultInstance();

private:

    inline void set_has_session ();

    inline void clear_has_session ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _session;

};

/**
 * If the meaning of "DestroySessionRequest" isn't clear, then there should be a description here.
 */
class DestroySessionRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DestroySessionRequest ();

    /**
     * Copy constructor
     */
    inline  DestroySessionRequest (const DestroySessionRequest &rhs);

    /**
     * All fields constructor
     */
    inline  DestroySessionRequest (const ::std::string& session_);

    /**
     * Destructor
     */
    inline virtual  ~DestroySessionRequest();

    /**
     * Assignment operator
     */
    inline DestroySessionRequest& operator = (const DestroySessionRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DestroySessionRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DestroySessionRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DestroySessionRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DestroySessionRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "session"

    static const int kSession = 0;

    /**
     * Clears the field "session".
     *
     * The field will be set to its default value. The hasSession()
     * method will return false.
     */
    inline void clearSession();

    /**
     * Checks whether the field "session" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSession()). Otherwise it will return false.
     */
    inline bool hasSession () const;

    /**
     * Returns the value of the member "session".
     *
     * If the meaning of "session" isn't clear, then there should be a description here.
     *
     * @return The value of the field "session"
     */
    inline const ::std::string& getSession () const;

    /**
     * Retrieves the value of the field "session" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "session".
     */
    inline ::std::string& getSessionMutable ();

    /**
     * Sets the value of the member "session".
     *
     * If the meaning of "session" isn't clear, then there should be a description here.
     *
     * @param session The value which will be set
     */
    inline void setSession (const ::std::string& session_);

    /**
     * Sets the value of the member "session".
     *
     * If the meaning of "session" isn't clear, then there should be a description here.
     *
     * @param session The value which will be set
     */
    inline void setSession (const char* session_);

    /**
     * Sets the value of the member "session".
     *
     * If the meaning of "session" isn't clear, then there should be a description here.
     *
     * @param session The value which will be set
     */
    inline void setSession (const char* value, size_t size);

    static const DestroySessionRequest &getDefaultInstance();

private:

    inline void set_has_session ();

    inline void clear_has_session ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _session;

};

/**
 * If the meaning of "ServicesChangedSignalChangedStruct" isn't clear, then there should be a description here.
 */
class ServicesChangedSignalChangedStruct {
public:

    /**
     * Default constructor
     */
    inline  ServicesChangedSignalChangedStruct ();

    /**
     * Copy constructor
     */
    inline  ServicesChangedSignalChangedStruct (const ServicesChangedSignalChangedStruct &rhs);

    /**
     * All fields constructor
     */
    inline  ServicesChangedSignalChangedStruct (const ::std::string& elem1_, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& elem2_);

    /**
     * Destructor
     */
    inline  ~ServicesChangedSignalChangedStruct();

    /**
     * Assignment operator
     */
    inline ServicesChangedSignalChangedStruct& operator = (const ServicesChangedSignalChangedStruct& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ServicesChangedSignalChangedStruct& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ServicesChangedSignalChangedStruct& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ServicesChangedSignalChangedStruct& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ServicesChangedSignalChangedStruct& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "elem1"

    static const int kElem1 = 0;

    /**
     * Clears the field "elem1".
     *
     * The field will be set to its default value. The hasElem1()
     * method will return false.
     */
    inline void clearElem1();

    /**
     * Checks whether the field "elem1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem1()). Otherwise it will return false.
     */
    inline bool hasElem1 () const;

    /**
     * Returns the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem1"
     */
    inline const ::std::string& getElem1 () const;

    /**
     * Retrieves the value of the field "elem1" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "elem1".
     */
    inline ::std::string& getElem1Mutable ();

    /**
     * Sets the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @param elem1 The value which will be set
     */
    inline void setElem1 (const ::std::string& elem1_);

    /**
     * Sets the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @param elem1 The value which will be set
     */
    inline void setElem1 (const char* elem1_);

    /**
     * Sets the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @param elem1 The value which will be set
     */
    inline void setElem1 (const char* value, size_t size);

    // API of field "elem2"

    static const int kElem2 = 1;

    /**
     * Clears the field "elem2".
     *
     * The field will be set to its default value. The hasElem2()
     * method will return false.
     */
    inline void clearElem2();

    /**
     * Checks whether the field "elem2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem2()). Otherwise it will return false.
     */
    inline bool hasElem2 () const;

    /**
     * Returns the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem2"
     */
    inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getElem2 () const;

    /**
     * Retrieves the value of the field "elem2" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "elem2".
     */
    inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getElem2Mutable ();

    /**
     * Sets the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @param elem2 The value which will be set
     */
    inline void setElem2 (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& elem2_);

    static const ServicesChangedSignalChangedStruct &getDefaultInstance();

private:

    static const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getStringTo__asf__dbus__DBusVariantMap_DefaultInstance ();

    inline void set_has_elem1 ();

    inline void clear_has_elem1 ();

    inline void set_has_elem2 ();

    inline void clear_has_elem2 ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _elem1;

    ::std::map< ::std::string, ::asf::dbus::DBusVariant > _elem2;

};

/**
 * If the meaning of "ServicesChangedSignal" isn't clear, then there should be a description here.
 */
class ServicesChangedSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ServicesChangedSignal ();

    /**
     * Copy constructor
     */
    inline  ServicesChangedSignal (const ServicesChangedSignal &rhs);

    /**
     * All fields constructor
     */
    inline  ServicesChangedSignal (const ::std::vector< ServicesChangedSignalChangedStruct >& changed_, const ::std::vector< ::std::string >& removed_);

    /**
     * Destructor
     */
    inline virtual  ~ServicesChangedSignal();

    /**
     * Assignment operator
     */
    inline ServicesChangedSignal& operator = (const ServicesChangedSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ServicesChangedSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ServicesChangedSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ServicesChangedSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ServicesChangedSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "changed"

    static const int kChanged = 0;

    /**
     * Clears the field "changed".
     *
     * The field will be set to its default value. The hasChanged()
     * method will return false.
     */
    inline void clearChanged();

    /**
     * Checks whether the field "changed" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChanged()). Otherwise it will return false.
     */
    inline bool hasChanged () const;

    /**
     * Returns the value of the member "changed".
     *
     * If the meaning of "changed" isn't clear, then there should be a description here.
     *
     * @return The value of the field "changed"
     */
    inline const ::std::vector< ServicesChangedSignalChangedStruct >& getChanged () const;

    /**
     * Retrieves the value of the field "changed" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "changed".
     */
    inline ::std::vector< ServicesChangedSignalChangedStruct >& getChangedMutable ();

    /**
     * Sets the value of the member "changed".
     *
     * If the meaning of "changed" isn't clear, then there should be a description here.
     *
     * @param changed The value which will be set
     */
    inline void setChanged (const ::std::vector< ServicesChangedSignalChangedStruct >& changed_);

    // API of field "removed"

    static const int kRemoved = 1;

    /**
     * Clears the field "removed".
     *
     * The field will be set to its default value. The hasRemoved()
     * method will return false.
     */
    inline void clearRemoved();

    /**
     * Checks whether the field "removed" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRemoved()). Otherwise it will return false.
     */
    inline bool hasRemoved () const;

    /**
     * Returns the value of the member "removed".
     *
     * If the meaning of "removed" isn't clear, then there should be a description here.
     *
     * @return The value of the field "removed"
     */
    inline const ::std::vector< ::std::string >& getRemoved () const;

    /**
     * Retrieves the value of the field "removed" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "removed".
     */
    inline ::std::vector< ::std::string >& getRemovedMutable ();

    /**
     * Sets the value of the member "removed".
     *
     * If the meaning of "removed" isn't clear, then there should be a description here.
     *
     * @param removed The value which will be set
     */
    inline void setRemoved (const ::std::vector< ::std::string >& removed_);

    static const ServicesChangedSignal &getDefaultInstance();

private:

    static const ::std::vector< ServicesChangedSignalChangedStruct >& getServicesChangedSignalChangedStructList_DefaultInstance ();

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    inline void set_has_changed ();

    inline void clear_has_changed ();

    inline void set_has_removed ();

    inline void clear_has_removed ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::vector< ServicesChangedSignalChangedStruct > _changed;

    ::std::vector< ::std::string > _removed;

};

inline  CreateSessionRequest::CreateSessionRequest ()  :
    _settings (),
    _notifier ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CreateSessionRequest::CreateSessionRequest (const CreateSessionRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _settings (),
    _notifier ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CreateSessionRequest::CreateSessionRequest (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& settings_, const ::std::string& notifier_)  :
    _settings (settings_),
    _notifier (notifier_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (notifier_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  CreateSessionRequest::~CreateSessionRequest() {
}

inline CreateSessionRequest& CreateSessionRequest::operator = (const CreateSessionRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSettings()) {
            setSettings(rhs.getSettings());
        } else {
            clearSettings();
        }
        if (rhs.hasNotifier()) {
            setNotifier(rhs.getNotifier());
        } else {
            clearNotifier();
        }
    }
    return *this;
}

inline bool CreateSessionRequest::operator == (const CreateSessionRequest& rhs) const {
    return (((!hasSettings() && !rhs.hasSettings()) || getSettings() == rhs.getSettings()) &&
        ((!hasNotifier() && !rhs.hasNotifier()) || getNotifier() == rhs.getNotifier()));
}

inline bool CreateSessionRequest::operator != (const CreateSessionRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool CreateSessionRequest::operator < (const CreateSessionRequest& rhs) const {
    if (hasSettings() || rhs.hasSettings()) {
        if (getSettings() < rhs.getSettings()) return true;
        if (getSettings() > rhs.getSettings()) return false;
    }
    if (hasNotifier() || rhs.hasNotifier()) {
        if (getNotifier() < rhs.getNotifier()) return true;
        if (getNotifier() > rhs.getNotifier()) return false;
    }
    return false;
}

inline ::asf::core::Payload* CreateSessionRequest::clone() {
    return new CreateSessionRequest(*this);
}

inline bool CreateSessionRequest::operator > (const CreateSessionRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CreateSessionRequest::clear() {
    clearSettings();
    clearNotifier();
}

inline void CreateSessionRequest::clearSettings() {
    if (hasSettings()) {
         clear_has_settings();
        _settings.clear();
     }
}

inline bool CreateSessionRequest::hasSettings () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& CreateSessionRequest::getSettings () const {
    return _settings;
}

inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& CreateSessionRequest::getSettingsMutable () {
    set_has_settings();
    return _settings;
}

inline void CreateSessionRequest::setSettings (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& settings_) {
    set_has_settings();
    this->_settings = settings_;
}

inline void CreateSessionRequest::clearNotifier() {
    if (hasNotifier()) {
         clear_has_notifier();
        _notifier.clear();
     }
}

inline bool CreateSessionRequest::hasNotifier () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& CreateSessionRequest::getNotifier () const {
    return _notifier;
}

inline ::std::string& CreateSessionRequest::getNotifierMutable () {
    set_has_notifier();
    return _notifier;
}

inline void CreateSessionRequest::setNotifier (const ::std::string& notifier_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (notifier_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_notifier();
    this->_notifier = notifier_;
}

inline void CreateSessionRequest::setNotifier (const char* notifier_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (notifier_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_notifier();
    this->_notifier.assign(notifier_);
}

inline void CreateSessionRequest::setNotifier (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_notifier();
    this->_notifier.assign(value, size);
}

inline void CreateSessionRequest::set_has_settings () {
    _has_bits_[0] |= 1u << 0;
}

inline void CreateSessionRequest::clear_has_settings () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void CreateSessionRequest::set_has_notifier () {
    _has_bits_[0] |= 1u << 1;
}

inline void CreateSessionRequest::clear_has_notifier () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  CreateSessionResponse::CreateSessionResponse ()  :
    _session ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CreateSessionResponse::CreateSessionResponse (const CreateSessionResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _session ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CreateSessionResponse::CreateSessionResponse (const ::std::string& session_)  :
    _session (session_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (session_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  CreateSessionResponse::~CreateSessionResponse() {
}

inline CreateSessionResponse& CreateSessionResponse::operator = (const CreateSessionResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSession()) {
            setSession(rhs.getSession());
        } else {
            clearSession();
        }
    }
    return *this;
}

inline bool CreateSessionResponse::operator == (const CreateSessionResponse& rhs) const {
    return (((!hasSession() && !rhs.hasSession()) || getSession() == rhs.getSession()));
}

inline bool CreateSessionResponse::operator != (const CreateSessionResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool CreateSessionResponse::operator < (const CreateSessionResponse& rhs) const {
    if (hasSession() || rhs.hasSession()) {
        if (getSession() < rhs.getSession()) return true;
        if (getSession() > rhs.getSession()) return false;
    }
    return false;
}

inline ::asf::core::Payload* CreateSessionResponse::clone() {
    return new CreateSessionResponse(*this);
}

inline bool CreateSessionResponse::operator > (const CreateSessionResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CreateSessionResponse::clear() {
    clearSession();
}

inline void CreateSessionResponse::clearSession() {
    if (hasSession()) {
         clear_has_session();
        _session.clear();
     }
}

inline bool CreateSessionResponse::hasSession () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& CreateSessionResponse::getSession () const {
    return _session;
}

inline ::std::string& CreateSessionResponse::getSessionMutable () {
    set_has_session();
    return _session;
}

inline void CreateSessionResponse::setSession (const ::std::string& session_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (session_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_session();
    this->_session = session_;
}

inline void CreateSessionResponse::setSession (const char* session_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (session_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_session();
    this->_session.assign(session_);
}

inline void CreateSessionResponse::setSession (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_session();
    this->_session.assign(value, size);
}

inline void CreateSessionResponse::set_has_session () {
    _has_bits_[0] |= 1u << 0;
}

inline void CreateSessionResponse::clear_has_session () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DestroySessionRequest::DestroySessionRequest ()  :
    _session ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DestroySessionRequest::DestroySessionRequest (const DestroySessionRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _session ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DestroySessionRequest::DestroySessionRequest (const ::std::string& session_)  :
    _session (session_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (session_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DestroySessionRequest::~DestroySessionRequest() {
}

inline DestroySessionRequest& DestroySessionRequest::operator = (const DestroySessionRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSession()) {
            setSession(rhs.getSession());
        } else {
            clearSession();
        }
    }
    return *this;
}

inline bool DestroySessionRequest::operator == (const DestroySessionRequest& rhs) const {
    return (((!hasSession() && !rhs.hasSession()) || getSession() == rhs.getSession()));
}

inline bool DestroySessionRequest::operator != (const DestroySessionRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool DestroySessionRequest::operator < (const DestroySessionRequest& rhs) const {
    if (hasSession() || rhs.hasSession()) {
        if (getSession() < rhs.getSession()) return true;
        if (getSession() > rhs.getSession()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DestroySessionRequest::clone() {
    return new DestroySessionRequest(*this);
}

inline bool DestroySessionRequest::operator > (const DestroySessionRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DestroySessionRequest::clear() {
    clearSession();
}

inline void DestroySessionRequest::clearSession() {
    if (hasSession()) {
         clear_has_session();
        _session.clear();
     }
}

inline bool DestroySessionRequest::hasSession () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& DestroySessionRequest::getSession () const {
    return _session;
}

inline ::std::string& DestroySessionRequest::getSessionMutable () {
    set_has_session();
    return _session;
}

inline void DestroySessionRequest::setSession (const ::std::string& session_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (session_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_session();
    this->_session = session_;
}

inline void DestroySessionRequest::setSession (const char* session_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (session_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_session();
    this->_session.assign(session_);
}

inline void DestroySessionRequest::setSession (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_session();
    this->_session.assign(value, size);
}

inline void DestroySessionRequest::set_has_session () {
    _has_bits_[0] |= 1u << 0;
}

inline void DestroySessionRequest::clear_has_session () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ServicesChangedSignalChangedStruct::ServicesChangedSignalChangedStruct ()  :
    _elem1 (),
    _elem2 ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ServicesChangedSignalChangedStruct::ServicesChangedSignalChangedStruct (const ServicesChangedSignalChangedStruct &rhs)  :
    _elem1 (),
    _elem2 ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ServicesChangedSignalChangedStruct::ServicesChangedSignalChangedStruct (const ::std::string& elem1_, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& elem2_)  :
    _elem1 (elem1_),
    _elem2 (elem2_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (elem1_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ServicesChangedSignalChangedStruct::~ServicesChangedSignalChangedStruct() {
}

inline ServicesChangedSignalChangedStruct& ServicesChangedSignalChangedStruct::operator = (const ServicesChangedSignalChangedStruct& rhs) {
    if( this != &rhs ) {
        if (rhs.hasElem1()) {
            setElem1(rhs.getElem1());
        } else {
            clearElem1();
        }
        if (rhs.hasElem2()) {
            setElem2(rhs.getElem2());
        } else {
            clearElem2();
        }
    }
    return *this;
}

inline bool ServicesChangedSignalChangedStruct::operator == (const ServicesChangedSignalChangedStruct& rhs) const {
    return (((!hasElem1() && !rhs.hasElem1()) || getElem1() == rhs.getElem1()) &&
        ((!hasElem2() && !rhs.hasElem2()) || getElem2() == rhs.getElem2()));
}

inline bool ServicesChangedSignalChangedStruct::operator != (const ServicesChangedSignalChangedStruct& rhs) const {
    return ! (*this == rhs);
}

inline bool ServicesChangedSignalChangedStruct::operator < (const ServicesChangedSignalChangedStruct& rhs) const {
    if (hasElem1() || rhs.hasElem1()) {
        if (getElem1() < rhs.getElem1()) return true;
        if (getElem1() > rhs.getElem1()) return false;
    }
    if (hasElem2() || rhs.hasElem2()) {
        if (getElem2() < rhs.getElem2()) return true;
        if (getElem2() > rhs.getElem2()) return false;
    }
    return false;
}

inline bool ServicesChangedSignalChangedStruct::operator > (const ServicesChangedSignalChangedStruct& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ServicesChangedSignalChangedStruct::clear() {
    clearElem1();
    clearElem2();
}

inline void ServicesChangedSignalChangedStruct::clearElem1() {
    if (hasElem1()) {
         clear_has_elem1();
        _elem1.clear();
     }
}

inline bool ServicesChangedSignalChangedStruct::hasElem1 () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& ServicesChangedSignalChangedStruct::getElem1 () const {
    return _elem1;
}

inline ::std::string& ServicesChangedSignalChangedStruct::getElem1Mutable () {
    set_has_elem1();
    return _elem1;
}

inline void ServicesChangedSignalChangedStruct::setElem1 (const ::std::string& elem1_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (elem1_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_elem1();
    this->_elem1 = elem1_;
}

inline void ServicesChangedSignalChangedStruct::setElem1 (const char* elem1_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (elem1_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_elem1();
    this->_elem1.assign(elem1_);
}

inline void ServicesChangedSignalChangedStruct::setElem1 (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_elem1();
    this->_elem1.assign(value, size);
}

inline void ServicesChangedSignalChangedStruct::clearElem2() {
    if (hasElem2()) {
         clear_has_elem2();
        _elem2.clear();
     }
}

inline bool ServicesChangedSignalChangedStruct::hasElem2 () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& ServicesChangedSignalChangedStruct::getElem2 () const {
    return _elem2;
}

inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& ServicesChangedSignalChangedStruct::getElem2Mutable () {
    set_has_elem2();
    return _elem2;
}

inline void ServicesChangedSignalChangedStruct::setElem2 (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& elem2_) {
    set_has_elem2();
    this->_elem2 = elem2_;
}

inline void ServicesChangedSignalChangedStruct::set_has_elem1 () {
    _has_bits_[0] |= 1u << 0;
}

inline void ServicesChangedSignalChangedStruct::clear_has_elem1 () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ServicesChangedSignalChangedStruct::set_has_elem2 () {
    _has_bits_[0] |= 1u << 1;
}

inline void ServicesChangedSignalChangedStruct::clear_has_elem2 () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  ServicesChangedSignal::ServicesChangedSignal ()  :
    _changed (),
    _removed ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ServicesChangedSignal::ServicesChangedSignal (const ServicesChangedSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _changed (),
    _removed ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ServicesChangedSignal::ServicesChangedSignal (const ::std::vector< ServicesChangedSignalChangedStruct >& changed_, const ::std::vector< ::std::string >& removed_)  :
    _changed (changed_),
    _removed (removed_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ServicesChangedSignal::~ServicesChangedSignal() {
}

inline ServicesChangedSignal& ServicesChangedSignal::operator = (const ServicesChangedSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasChanged()) {
            setChanged(rhs.getChanged());
        } else {
            clearChanged();
        }
        if (rhs.hasRemoved()) {
            setRemoved(rhs.getRemoved());
        } else {
            clearRemoved();
        }
    }
    return *this;
}

inline bool ServicesChangedSignal::operator == (const ServicesChangedSignal& rhs) const {
    return (((!hasChanged() && !rhs.hasChanged()) || getChanged() == rhs.getChanged()) &&
        ((!hasRemoved() && !rhs.hasRemoved()) || getRemoved() == rhs.getRemoved()));
}

inline bool ServicesChangedSignal::operator != (const ServicesChangedSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool ServicesChangedSignal::operator < (const ServicesChangedSignal& rhs) const {
    if (hasChanged() || rhs.hasChanged()) {
        if (getChanged() < rhs.getChanged()) return true;
        if (getChanged() > rhs.getChanged()) return false;
    }
    if (hasRemoved() || rhs.hasRemoved()) {
        if (getRemoved() < rhs.getRemoved()) return true;
        if (getRemoved() > rhs.getRemoved()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ServicesChangedSignal::clone() {
    return new ServicesChangedSignal(*this);
}

inline bool ServicesChangedSignal::operator > (const ServicesChangedSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ServicesChangedSignal::clear() {
    clearChanged();
    clearRemoved();
}

inline void ServicesChangedSignal::clearChanged() {
    if (hasChanged()) {
         clear_has_changed();
        _changed.clear();
     }
}

inline bool ServicesChangedSignal::hasChanged () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ServicesChangedSignalChangedStruct >& ServicesChangedSignal::getChanged () const {
    return _changed;
}

inline ::std::vector< ServicesChangedSignalChangedStruct >& ServicesChangedSignal::getChangedMutable () {
    set_has_changed();
    return _changed;
}

inline void ServicesChangedSignal::setChanged (const ::std::vector< ServicesChangedSignalChangedStruct >& changed_) {
    set_has_changed();
    this->_changed = changed_;
}

inline void ServicesChangedSignal::clearRemoved() {
    if (hasRemoved()) {
         clear_has_removed();
        _removed.clear();
     }
}

inline bool ServicesChangedSignal::hasRemoved () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< ::std::string >& ServicesChangedSignal::getRemoved () const {
    return _removed;
}

inline ::std::vector< ::std::string >& ServicesChangedSignal::getRemovedMutable () {
    set_has_removed();
    return _removed;
}

inline void ServicesChangedSignal::setRemoved (const ::std::vector< ::std::string >& removed_) {
    set_has_removed();
    this->_removed = removed_;
}

inline void ServicesChangedSignal::set_has_changed () {
    _has_bits_[0] |= 1u << 0;
}

inline void ServicesChangedSignal::clear_has_changed () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ServicesChangedSignal::set_has_removed () {
    _has_bits_[0] |= 1u << 1;
}

inline void ServicesChangedSignal::clear_has_removed () {
    _has_bits_[0] &= ~ (1u << 1);
}

} // namespace Manager
} // namespace connman
} // namespace net

#endif // NET_CONNMAN_MANAGER_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
