/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/Application.h"
#include "asf/core/ComponentContainer.h"
#include "asf/core/ComponentDescription.h"
#include "asf/core/ContextData.h"
#include "asf/core/Logger.h"
#include "asf/core/RequiredPort.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusImportedPort.h"
#include "cc/proxies/only/CcDbusIfAppLibrary.h"
#include "cc/proxies/only/CcDbusIfComponent.h"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "com/bosch/cm/asf/lang/dbus/ConnectorsJson.h"
#include <cstdio>
#include <string>

/**
 * If the meaning of "CcDbusIfAppLibrary" isn't clear, then there should be a description here.
 */

namespace cc {
namespace proxies {
namespace only {

DEFINE_LOGGER_AND_LEVEL (_logger, "/cc/proxies/only/CcDbusIfAppLibrary", Info);

/* static */ const char* CcDbusIfAppLibrary::ccDbusIf = "ccDbusIf";

static const char* helpMessage =
    "--logconfig <file>     Read the logging configuration from <file>\n"
    "                       see the ASF User Guide, section 6.3. Logging API\n"
    "--help                 Print this help message\n";

bool CcDbusIfAppLibrary_enabledASFSignalHandler = false;

void importCcDbusIfAppLibrary() {
    ::asf::core::Application* app = ::asf::core::Application::getApplication();
    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't attach CcDbusIfAppLibrary, because no Application is instantiated");

    // Expression

    ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector dbusSystemConnector;
    {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector __expression0;
        {
            __expression0.setBusType(::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector::BusType__System);
        }
        dbusSystemConnector = __expression0;
    }
    {
        std::string jsonPayload;
        serializeJson (dbusSystemConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "dbusSystemConnector", "DBusConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::dbus::DBusConnector > dbusSystemConnector_(new ::asf::dbus::DBusConnector(*app, dbusSystemConnector));
    app->addStarter(dbusSystemConnector_);

    // Expression

    ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector dbusSessionConnector;
    {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector __expression1;
        {
            __expression1.setBusType(::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector::BusType__Session);
        }
        dbusSessionConnector = __expression1;
    }
    {
        std::string jsonPayload;
        serializeJson (dbusSessionConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "dbusSessionConnector", "DBusConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::dbus::DBusConnector > dbusSessionConnector_(new ::asf::dbus::DBusConnector(*app, dbusSessionConnector));
    app->addStarter(dbusSessionConnector_);

    // Thread 'ccDbusIfThread'

    ::asf::core::ComponentContainerSharedPtr CcDbusIfThread(new ::asf::core::ComponentContainer("ccDbusIfThread", ::asf::core::ThreadConfiguration(1)));
    app->addContainer (CcDbusIfThread);

        // Component 'CcDbusIfComponent ccDbusIf'

        ::boost::shared_ptr< ::asf::core::ComponentFactory< ::cc::proxies::only::CcDbusIfComponent > > ccDbusIfFactory(new ::asf::core::ComponentFactory< ::cc::proxies::only::CcDbusIfComponent >);
        ::asf::core::ComponentDescriptionSharedPtr ccDbusIfDescription(new ::asf::core::ComponentDescription(1, "ccDbusIf", /* immediate = */ true, /* threadBridge = */ false, ccDbusIfFactory));
        CcDbusIfThread->addComponentDescription(ccDbusIfDescription);

            // Port 'allObjectManagerPort'

            ::asf::core::RequiredPort& ccDbusIf_allObjectManagerPort = ccDbusIfDescription->addRequiredPort (::asf::core::RequiredPort ("org.freedesktop.DBus.ObjectManager", "allObjectManagerPort", /* wired at runtime */ true));
            (void)ccDbusIf_allObjectManagerPort; // prevent unused variable warning

            // Port 'allPropertiesGetAllPort'

            ::asf::core::RequiredPort& ccDbusIf_allPropertiesGetAllPort = ccDbusIfDescription->addRequiredPort (::asf::core::RequiredPort ("org.freedesktop.DBus.Properties", "allPropertiesGetAllPort", /* wired at runtime */ true));
            (void)ccDbusIf_allPropertiesGetAllPort; // prevent unused variable warning

            // Port 'allIntrospectablePort'

            ::asf::core::RequiredPort& ccDbusIf_allIntrospectablePort = ccDbusIfDescription->addRequiredPort (::asf::core::RequiredPort ("org.freedesktop.DBus.Introspectable", "allIntrospectablePort", /* wired at runtime */ true));
            (void)ccDbusIf_allIntrospectablePort; // prevent unused variable warning

            // Port 'evoAdapterPort'

            ::asf::core::RequiredPort& ccDbusIf_evoAdapterPort = ccDbusIfDescription->addRequiredPort (::asf::core::RequiredPort ("org.bluez.Adapter1", "evoAdapterPort", /* wired at runtime */ true));
            (void)ccDbusIf_evoAdapterPort; // prevent unused variable warning

            // Port 'evoAgentManagerPort'

            ::asf::core::RequiredPort& ccDbusIf_evoAgentManagerPort = ccDbusIfDescription->addRequiredPort (::asf::core::RequiredPort ("org.bluez.AgentManager", "evoAgentManagerPort"));
            (void)ccDbusIf_evoAgentManagerPort; // prevent unused variable warning

            // Port 'evoDevicePort'

            ::asf::core::RequiredPort& ccDbusIf_evoDevicePort = ccDbusIfDescription->addRequiredPort (::asf::core::RequiredPort ("org.bluez.Device1", "evoDevicePort", /* wired at runtime */ true));
            (void)ccDbusIf_evoDevicePort; // prevent unused variable warning

            // Port 'evoServicePort'

            ::asf::core::RequiredPort& ccDbusIf_evoServicePort = ccDbusIfDescription->addRequiredPort (::asf::core::RequiredPort ("org.bluez.Service", "evoServicePort", /* wired at runtime */ true));
            (void)ccDbusIf_evoServicePort; // prevent unused variable warning

            // Port 'evoTracePort'

            ::asf::core::RequiredPort& ccDbusIf_evoTracePort = ccDbusIfDescription->addRequiredPort (::asf::core::RequiredPort ("org.bluez.evo.Trace", "evoTracePort"));
            (void)ccDbusIf_evoTracePort; // prevent unused variable warning

            // Port 'evoGeniviTracePort'

            ::asf::core::RequiredPort& ccDbusIf_evoGeniviTracePort = ccDbusIfDescription->addRequiredPort (::asf::core::RequiredPort ("org.bluez.genivi.Trace", "evoGeniviTracePort"));
            (void)ccDbusIf_evoGeniviTracePort; // prevent unused variable warning

            // Port 'evoDmPort'

            ::asf::core::RequiredPort& ccDbusIf_evoDmPort = ccDbusIfDescription->addRequiredPort (::asf::core::RequiredPort ("org.alps.evo.DM", "evoDmPort"));
            (void)ccDbusIf_evoDmPort; // prevent unused variable warning

            // Port 'evoObexClientPort'

            ::asf::core::RequiredPort& ccDbusIf_evoObexClientPort = ccDbusIfDescription->addRequiredPort (::asf::core::RequiredPort ("org.bluez.obex.Client", "evoObexClientPort"));
            (void)ccDbusIf_evoObexClientPort; // prevent unused variable warning

            // Port 'evoObexSessionPort'

            ::asf::core::RequiredPort& ccDbusIf_evoObexSessionPort = ccDbusIfDescription->addRequiredPort (::asf::core::RequiredPort ("org.bluez.obex.Session", "evoObexSessionPort", /* wired at runtime */ true));
            (void)ccDbusIf_evoObexSessionPort; // prevent unused variable warning

            // Port 'evoObexTransferPort'

            ::asf::core::RequiredPort& ccDbusIf_evoObexTransferPort = ccDbusIfDescription->addRequiredPort (::asf::core::RequiredPort ("org.bluez.obex.Transfer", "evoObexTransferPort", /* wired at runtime */ true));
            (void)ccDbusIf_evoObexTransferPort; // prevent unused variable warning

            // Port 'evoDidPort'

            ::asf::core::RequiredPort& ccDbusIf_evoDidPort = ccDbusIfDescription->addRequiredPort (::asf::core::RequiredPort ("org.alps.evo.DID", "evoDidPort"));
            (void)ccDbusIf_evoDidPort; // prevent unused variable warning

            // Port 'evoSppPort'

            ::asf::core::RequiredPort& ccDbusIf_evoSppPort = ccDbusIfDescription->addRequiredPort (::asf::core::RequiredPort ("org.alps.evo.SPP", "evoSppPort"));
            (void)ccDbusIf_evoSppPort; // prevent unused variable warning

            // Port 'evoPanPort'

            ::asf::core::RequiredPort& ccDbusIf_evoPanPort = ccDbusIfDescription->addRequiredPort (::asf::core::RequiredPort ("org.alps.evo.PAN", "evoPanPort"));
            (void)ccDbusIf_evoPanPort; // prevent unused variable warning

            // Port 'evoDunPort'

            ::asf::core::RequiredPort& ccDbusIf_evoDunPort = ccDbusIfDescription->addRequiredPort (::asf::core::RequiredPort ("org.alps.evo.DUN", "evoDunPort"));
            (void)ccDbusIf_evoDunPort; // prevent unused variable warning

            // Port 'evoNetworkPort'

            ::asf::core::RequiredPort& ccDbusIf_evoNetworkPort = ccDbusIfDescription->addRequiredPort (::asf::core::RequiredPort ("org.bluez.Network1", "evoNetworkPort", /* wired at runtime */ true));
            (void)ccDbusIf_evoNetworkPort; // prevent unused variable warning

            // Port 'evoSerialPort'

            ::asf::core::RequiredPort& ccDbusIf_evoSerialPort = ccDbusIfDescription->addRequiredPort (::asf::core::RequiredPort ("org.bluez.Serial", "evoSerialPort", /* wired at runtime */ true));
            (void)ccDbusIf_evoSerialPort; // prevent unused variable warning

            // Port 'evoHfpCallVolumePort'

            ::asf::core::RequiredPort& ccDbusIf_evoHfpCallVolumePort = ccDbusIfDescription->addRequiredPort (::asf::core::RequiredPort ("org.ofono.CallVolume", "evoHfpCallVolumePort", /* wired at runtime */ true));
            (void)ccDbusIf_evoHfpCallVolumePort; // prevent unused variable warning

            // Port 'evoHfpHandsfreePort'

            ::asf::core::RequiredPort& ccDbusIf_evoHfpHandsfreePort = ccDbusIfDescription->addRequiredPort (::asf::core::RequiredPort ("org.ofono.Handsfree", "evoHfpHandsfreePort", /* wired at runtime */ true));
            (void)ccDbusIf_evoHfpHandsfreePort; // prevent unused variable warning

            // Port 'evoHfpManagerPort'

            ::asf::core::RequiredPort& ccDbusIf_evoHfpManagerPort = ccDbusIfDescription->addRequiredPort (::asf::core::RequiredPort ("org.ofono.Manager", "evoHfpManagerPort"));
            (void)ccDbusIf_evoHfpManagerPort; // prevent unused variable warning

            // Port 'evoHfpModemPort'

            ::asf::core::RequiredPort& ccDbusIf_evoHfpModemPort = ccDbusIfDescription->addRequiredPort (::asf::core::RequiredPort ("org.ofono.Modem", "evoHfpModemPort", /* wired at runtime */ true));
            (void)ccDbusIf_evoHfpModemPort; // prevent unused variable warning

            // Port 'evoHfpNetworkOperatorPort'

            ::asf::core::RequiredPort& ccDbusIf_evoHfpNetworkOperatorPort = ccDbusIfDescription->addRequiredPort (::asf::core::RequiredPort ("org.ofono.NetworkOperator", "evoHfpNetworkOperatorPort", /* wired at runtime */ true));
            (void)ccDbusIf_evoHfpNetworkOperatorPort; // prevent unused variable warning

            // Port 'evoHfpNetworkRegistrationPort'

            ::asf::core::RequiredPort& ccDbusIf_evoHfpNetworkRegistrationPort = ccDbusIfDescription->addRequiredPort (::asf::core::RequiredPort ("org.ofono.NetworkRegistration", "evoHfpNetworkRegistrationPort", /* wired at runtime */ true));
            (void)ccDbusIf_evoHfpNetworkRegistrationPort; // prevent unused variable warning

            // Port 'evoHfpSiri'

            ::asf::core::RequiredPort& ccDbusIf_evoHfpSiri = ccDbusIfDescription->addRequiredPort (::asf::core::RequiredPort ("org.ofono.evo.Siri", "evoHfpSiri", /* wired at runtime */ true));
            (void)ccDbusIf_evoHfpSiri; // prevent unused variable warning

            // Port 'evoHfpVoiceCallPort'

            ::asf::core::RequiredPort& ccDbusIf_evoHfpVoiceCallPort = ccDbusIfDescription->addRequiredPort (::asf::core::RequiredPort ("org.ofono.VoiceCall", "evoHfpVoiceCallPort", /* wired at runtime */ true));
            (void)ccDbusIf_evoHfpVoiceCallPort; // prevent unused variable warning

            // Port 'evoHfpVoiceCallManagerPort'

            ::asf::core::RequiredPort& ccDbusIf_evoHfpVoiceCallManagerPort = ccDbusIfDescription->addRequiredPort (::asf::core::RequiredPort ("org.ofono.VoiceCallManager", "evoHfpVoiceCallManagerPort", /* wired at runtime */ true));
            (void)ccDbusIf_evoHfpVoiceCallManagerPort; // prevent unused variable warning

            // Port 'evoPhonebookAccessPort'

            ::asf::core::RequiredPort& ccDbusIf_evoPhonebookAccessPort = ccDbusIfDescription->addRequiredPort (::asf::core::RequiredPort ("org.bluez.obex.PhonebookAccess", "evoPhonebookAccessPort", /* wired at runtime */ true));
            (void)ccDbusIf_evoPhonebookAccessPort; // prevent unused variable warning

            // Port 'evoMessagePort'

            ::asf::core::RequiredPort& ccDbusIf_evoMessagePort = ccDbusIfDescription->addRequiredPort (::asf::core::RequiredPort ("org.bluez.obex.Message", "evoMessagePort", /* wired at runtime */ true));
            (void)ccDbusIf_evoMessagePort; // prevent unused variable warning

            // Port 'evoMessageAccessPort'

            ::asf::core::RequiredPort& ccDbusIf_evoMessageAccessPort = ccDbusIfDescription->addRequiredPort (::asf::core::RequiredPort ("org.bluez.obex.MessageAccess", "evoMessageAccessPort", /* wired at runtime */ true));
            (void)ccDbusIf_evoMessageAccessPort; // prevent unused variable warning

            // Port 'evoAvpAvpPort'

            ::asf::core::RequiredPort& ccDbusIf_evoAvpAvpPort = ccDbusIfDescription->addRequiredPort (::asf::core::RequiredPort ("org.bluez.evo.AVP", "evoAvpAvpPort", /* wired at runtime */ true));
            (void)ccDbusIf_evoAvpAvpPort; // prevent unused variable warning

            // Port 'evoAvpMediaFolderPort'

            ::asf::core::RequiredPort& ccDbusIf_evoAvpMediaFolderPort = ccDbusIfDescription->addRequiredPort (::asf::core::RequiredPort ("org.bluez.MediaFolder", "evoAvpMediaFolderPort", /* wired at runtime */ true));
            (void)ccDbusIf_evoAvpMediaFolderPort; // prevent unused variable warning

            // Port 'evoAvpMediaItemPort'

            ::asf::core::RequiredPort& ccDbusIf_evoAvpMediaItemPort = ccDbusIfDescription->addRequiredPort (::asf::core::RequiredPort ("org.bluez.MediaItem", "evoAvpMediaItemPort", /* wired at runtime */ true));
            (void)ccDbusIf_evoAvpMediaItemPort; // prevent unused variable warning

            // Port 'evoAvpMediaPlayerPort'

            ::asf::core::RequiredPort& ccDbusIf_evoAvpMediaPlayerPort = ccDbusIfDescription->addRequiredPort (::asf::core::RequiredPort ("org.bluez.MediaPlayer", "evoAvpMediaPlayerPort", /* wired at runtime */ true));
            (void)ccDbusIf_evoAvpMediaPlayerPort; // prevent unused variable warning

            // Port 'evoAvpMediaTransportPort'

            ::asf::core::RequiredPort& ccDbusIf_evoAvpMediaTransportPort = ccDbusIfDescription->addRequiredPort (::asf::core::RequiredPort ("org.bluez.MediaTransport", "evoAvpMediaTransportPort", /* wired at runtime */ true));
            (void)ccDbusIf_evoAvpMediaTransportPort; // prevent unused variable warning

            // Port 'evoLEAdapterPort'

            ::asf::core::RequiredPort& ccDbusIf_evoLEAdapterPort = ccDbusIfDescription->addRequiredPort (::asf::core::RequiredPort ("org.bluez.LE_Adapter1", "evoLEAdapterPort", /* wired at runtime */ true));
            (void)ccDbusIf_evoLEAdapterPort; // prevent unused variable warning

            // Port 'evoLEDevicePort'

            ::asf::core::RequiredPort& ccDbusIf_evoLEDevicePort = ccDbusIfDescription->addRequiredPort (::asf::core::RequiredPort ("org.bluez.LE_Device1", "evoLEDevicePort", /* wired at runtime */ true));
            (void)ccDbusIf_evoLEDevicePort; // prevent unused variable warning

            // Port 'evoLESeamlessPairingPort'

            ::asf::core::RequiredPort& ccDbusIf_evoLESeamlessPairingPort = ccDbusIfDescription->addRequiredPort (::asf::core::RequiredPort ("org.bluez.SeamlessPairing", "evoLESeamlessPairingPort", /* wired at runtime */ true));
            (void)ccDbusIf_evoLESeamlessPairingPort; // prevent unused variable warning

            // Port 'evoConnManManagerPort'

            ::asf::core::RequiredPort& ccDbusIf_evoConnManManagerPort = ccDbusIfDescription->addRequiredPort (::asf::core::RequiredPort ("net.connman.Manager", "evoConnManManagerPort"));
            (void)ccDbusIf_evoConnManManagerPort; // prevent unused variable warning

            // Port 'evoConnManTechnologyPort'

            ::asf::core::RequiredPort& ccDbusIf_evoConnManTechnologyPort = ccDbusIfDescription->addRequiredPort (::asf::core::RequiredPort ("net.connman.Technology", "evoConnManTechnologyPort", /* wired at runtime */ true));
            (void)ccDbusIf_evoConnManTechnologyPort; // prevent unused variable warning

            // Port 'evoConnManServicePort'

            ::asf::core::RequiredPort& ccDbusIf_evoConnManServicePort = ccDbusIfDescription->addRequiredPort (::asf::core::RequiredPort ("net.connman.Service", "evoConnManServicePort", /* wired at runtime */ true));
            (void)ccDbusIf_evoConnManServicePort; // prevent unused variable warning

            // Port 'ecnrServicePort'

            ::asf::core::RequiredPort& ccDbusIf_ecnrServicePort = ccDbusIfDescription->addRequiredPort (::asf::core::RequiredPort ("org.bosch.ecnr.service", "ecnrServicePort"));
            (void)ccDbusIf_ecnrServicePort; // prevent unused variable warning

            // Port 'wblLastIntendedModePort'

            ::asf::core::RequiredPort& ccDbusIf_wblLastIntendedModePort = ccDbusIfDescription->addRequiredPort (::asf::core::RequiredPort ("org.bosch.wbl.LastIntendedMode", "wblLastIntendedModePort", /* wired at runtime */ true));
            (void)ccDbusIf_wblLastIntendedModePort; // prevent unused variable warning

            // Port 'wblConflictManagementPort'

            ::asf::core::RequiredPort& ccDbusIf_wblConflictManagementPort = ccDbusIfDescription->addRequiredPort (::asf::core::RequiredPort ("org.bosch.wbl.conflictmanagement", "wblConflictManagementPort", /* wired at runtime */ true));
            (void)ccDbusIf_wblConflictManagementPort; // prevent unused variable warning

            // Port 'wblWifiSetupPort'

            ::asf::core::RequiredPort& ccDbusIf_wblWifiSetupPort = ccDbusIfDescription->addRequiredPort (::asf::core::RequiredPort ("org.bosch.wbl.wifisetup", "wblWifiSetupPort", /* wired at runtime */ true));
            (void)ccDbusIf_wblWifiSetupPort; // prevent unused variable warning

    // Expression

    ::asf::dbus::DBusImportedPort& evo_agentmanager = dbusSystemConnector_->importByName (::std::string("org.bluez"), ::std::string("/org/bluez"));
    evo_agentmanager.setServiceName("org.bluez.AgentManager");

    // Expression

    ::asf::dbus::DBusImportedPort& evo_trace = dbusSystemConnector_->importByName (::std::string("org.bluez"), ::std::string("/org/bluez/hci1"));
    evo_trace.setServiceName("org.bluez.evo.Trace");

    // Expression

    ::asf::dbus::DBusImportedPort& evo_genivi_trace = dbusSystemConnector_->importByName (::std::string("org.bluez"), ::std::string("/org/bluez/hci1"));
    evo_genivi_trace.setServiceName("org.bluez.genivi.Trace");

    // Expression

    ::asf::dbus::DBusImportedPort& evo_dm = dbusSystemConnector_->importByName (::std::string("org.alps.evolution"), ::std::string("/org/alps/evolution/hli"));
    evo_dm.setServiceName("org.alps.evo.DM");

    // Expression

    ::asf::dbus::DBusImportedPort& evo_obex_client = dbusSessionConnector_->importByName (::std::string("org.bluez.obex"), ::std::string("/org/bluez/obex"));
    evo_obex_client.setServiceName("org.bluez.obex.Client");

    // Expression

    ::asf::dbus::DBusImportedPort& evo_did = dbusSystemConnector_->importByName (::std::string("org.alps.evolution"), ::std::string("/org/alps/evolution/hli"));
    evo_did.setServiceName("org.alps.evo.DID");

    // Expression

    ::asf::dbus::DBusImportedPort& evo_spp = dbusSystemConnector_->importByName (::std::string("org.alps.evolution"), ::std::string("/org/alps/evolution/hli"));
    evo_spp.setServiceName("org.alps.evo.SPP");

    // Expression

    ::asf::dbus::DBusImportedPort& evo_pan = dbusSystemConnector_->importByName (::std::string("org.alps.evolution"), ::std::string("/org/alps/evolution/hli"));
    evo_pan.setServiceName("org.alps.evo.PAN");

    // Expression

    ::asf::dbus::DBusImportedPort& evo_dun = dbusSystemConnector_->importByName (::std::string("org.alps.evolution"), ::std::string("/org/alps/evolution/hli"));
    evo_dun.setServiceName("org.alps.evo.DUN");

    // Expression

    ::asf::dbus::DBusImportedPort& evo_manager = dbusSystemConnector_->importByName (::std::string("org.ofono"), ::std::string("/"));
    evo_manager.setServiceName("org.ofono.Manager");

    // Expression

    ::asf::dbus::DBusImportedPort& connman_manager = dbusSystemConnector_->importByName (::std::string("net.connman"), ::std::string("/"));
    connman_manager.setServiceName("net.connman.Manager");

    // Expression

    ::asf::dbus::DBusImportedPort& ecnr_service = dbusSystemConnector_->importByName (::std::string("org.bosch.ecnr"), ::std::string("/"));
    ecnr_service.setServiceName("org.bosch.ecnr.service");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (ccDbusIf_evoAgentManagerPort, evo_agentmanager);

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (ccDbusIf_evoTracePort, evo_trace);

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (ccDbusIf_evoGeniviTracePort, evo_genivi_trace);

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (ccDbusIf_evoDmPort, evo_dm);

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (ccDbusIf_evoObexClientPort, evo_obex_client);

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (ccDbusIf_evoDidPort, evo_did);

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (ccDbusIf_evoSppPort, evo_spp);

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (ccDbusIf_evoPanPort, evo_pan);

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (ccDbusIf_evoDunPort, evo_dun);

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (ccDbusIf_evoHfpManagerPort, evo_manager);

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (ccDbusIf_evoConnManManagerPort, connman_manager);

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (ccDbusIf_ecnrServicePort, ecnr_service);


    LOG_INFO_STATIC("Starting application 'CcDbusIfAppLibrary' version 1.0.0");

    app->start();
}

int executeCcDbusIfAppLibrary(int argc, char* argv[]) {
    ::asf::core::ContextData context;

    const char* logConfigFile = 0;
    std::vector<std::string> arguments;

    for (int i=1; i<argc; i++) {
        if (std::string(argv[i]) == "--logconfig" && i+1 < argc) {
            // ignore lint warning e850: modification of i inside loop is safe
            logConfigFile = argv[++i];
        } else {
            if (std::string(argv[i]) == "--help") {
                printf ("%s", helpMessage);
                exit (0);
            } else {
                arguments.push_back (argv[i]);
            }
        }
    }

    if (logConfigFile == 0) {
        ::asf::core::Logger::setupLogging ("cc.proxies.only", "CcDbusIfAppLibrary");
    } else {
        ::asf::core::Logger::setupLogging ("cc.proxies.only", "CcDbusIfAppLibrary", logConfigFile);
    }

    LOG_INFO_STATIC("%s ASF signal handler", CcDbusIfAppLibrary_enabledASFSignalHandler ? "Enabled" : "Disabled" );

    ::asf::core::Application* app = ::asf::core::Application::createApplication("cc.proxies.only", "CcDbusIfAppLibrary", ::asf::core::Version(1, 0, 0, ""), arguments);

    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't create CcDbusIfAppLibrary");

    app->enableExceptionHandler(false);

    importCcDbusIfAppLibrary();

    int exitCode = app->waitForCompletion();
    ::asf::core::Application::deleteApplication();

    return exitCode;
}

} // namespace only
} // namespace proxies
} // namespace cc
