/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef DE_BOSCH_CM_CONFIGMANAGER_CONFIGMANAGEMENTSTUB_H
#define DE_BOSCH_CM_CONFIGMANAGER_CONFIGMANAGEMENTSTUB_H

#include "asf/core/Logger.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "de/bosch/cm/ConfigManager/ConfigManagement.h"
#include "de/bosch/cm/ConfigManager/ConfigManagementConst.h"
#include <vector>

namespace de {
namespace bosch {
namespace cm {
namespace ConfigManager {
namespace ConfigManagement {

class ConfigManagementStubDelegate;

class ConfigManagementStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the ConfigManagementStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    ConfigManagementStub (const std::string& portName);

    /**
     * Create an instance of the ConfigManagementStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    ConfigManagementStub (const std::string& portName, const std::string& objectPath);

    virtual ~ConfigManagementStub();

    // method 'RegisterPrivateItem'

    /**
     * The method onRegisterPrivateItem() is called by ASF when a client
     * invokes the method 'RegisterPrivateItem'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendRegisterPrivateItem() or sendRegisterPrivateItemError() method. Do
     * not invoke this method on your own.
     *
     * <b>Documentation of 'RegisterPrivateItem'</b>:
     *
     * Method to register an application in CfgMgr for private config items.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onRegisterPrivateItemRequest (const ::boost::shared_ptr< RegisterPrivateItemRequest >& request) = 0;

    /**
     * The method sendRegisterPrivateItemResponse() sends a response of a
     * previous method invocation of 'RegisterPrivateItem' back to the client.
     *
     * <b>Documentation of 'RegisterPrivateItem'</b>:
     *
     * Method to register an application in CfgMgr for private config items.
     *
     * @param status return result of register operation
     *
     * @param act The parameter act identifies a previous invocation of
     * onRegisterPrivateItem(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendRegisterPrivateItemResponse (EnRegisterStatus status, act_t act = 0);

    /**
     * The method sendRegisterPrivateItemError() sends an error response of a
     * previous method invocation of 'RegisterPrivateItem' back to the client.
     *
     * <b>Documentation of 'RegisterPrivateItem'</b>:
     *
     * Method to register an application in CfgMgr for private config items.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onRegisterPrivateItem().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendRegisterPrivateItemError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'UnregisterPrivateItem'

    /**
     * The method onUnregisterPrivateItem() is called by ASF when a client
     * invokes the method 'UnregisterPrivateItem'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendUnregisterPrivateItem() or sendUnregisterPrivateItemError() method.
     * Do not invoke this method on your own.
     *
     * <b>Documentation of 'UnregisterPrivateItem'</b>:
     *
     * Method for Applications to UnregisterPrivateData from CfgMgr to no longer receive updates of Custom Settings Group.
     * 				   Providing clientDBusName is not required from functional point of view, but offers some protection against unintentional
     * 				   unregistrations by others clients, as they first need to know the dbus name.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onUnregisterPrivateItemRequest (const ::boost::shared_ptr< UnregisterPrivateItemRequest >& request) = 0;

    /**
     * The method sendUnregisterPrivateItemResponse() sends a response of a
     * previous method invocation of 'UnregisterPrivateItem' back to the
     * client.
     *
     * <b>Documentation of 'UnregisterPrivateItem'</b>:
     *
     * Method for Applications to UnregisterPrivateData from CfgMgr to no longer receive updates of Custom Settings Group.
     * 				   Providing clientDBusName is not required from functional point of view, but offers some protection against unintentional
     * 				   unregistrations by others clients, as they first need to know the dbus name.
     *
     * @param status return result of unregister operation
     *
     * @param act The parameter act identifies a previous invocation of
     * onUnregisterPrivateItem(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendUnregisterPrivateItemResponse (EnRegisterStatus status, act_t act = 0);

    /**
     * The method sendUnregisterPrivateItemError() sends an error response of
     * a previous method invocation of 'UnregisterPrivateItem' back to the
     * client.
     *
     * <b>Documentation of 'UnregisterPrivateItem'</b>:
     *
     * Method for Applications to UnregisterPrivateData from CfgMgr to no longer receive updates of Custom Settings Group.
     * 				   Providing clientDBusName is not required from functional point of view, but offers some protection against unintentional
     * 				   unregistrations by others clients, as they first need to know the dbus name.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onUnregisterPrivateItem(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendUnregisterPrivateItemError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'RegisterPublicItem'

    /**
     * The method onRegisterPublicItem() is called by ASF when a client
     * invokes the method 'RegisterPublicItem'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendRegisterPublicItem() or sendRegisterPublicItemError() method. Do
     * not invoke this method on your own.
     *
     * <b>Documentation of 'RegisterPublicItem'</b>:
     *
     * Method for Applications to RegisterPublicData in CfgMgr to receive updates of public configuration data.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onRegisterPublicItemRequest (const ::boost::shared_ptr< RegisterPublicItemRequest >& request) = 0;

    /**
     * The method sendRegisterPublicItemResponse() sends a response of a
     * previous method invocation of 'RegisterPublicItem' back to the client.
     *
     * <b>Documentation of 'RegisterPublicItem'</b>:
     *
     * Method for Applications to RegisterPublicData in CfgMgr to receive updates of public configuration data.
     *
     * @param status return result of register operation
     *
     * @param act The parameter act identifies a previous invocation of
     * onRegisterPublicItem(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendRegisterPublicItemResponse (EnRegisterStatus status, act_t act = 0);

    /**
     * The method sendRegisterPublicItemError() sends an error response of a
     * previous method invocation of 'RegisterPublicItem' back to the client.
     *
     * <b>Documentation of 'RegisterPublicItem'</b>:
     *
     * Method for Applications to RegisterPublicData in CfgMgr to receive updates of public configuration data.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onRegisterPublicItem().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendRegisterPublicItemError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'UnregisterPublicItem'

    /**
     * The method onUnregisterPublicItem() is called by ASF when a client
     * invokes the method 'UnregisterPublicItem'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendUnregisterPublicItem() or sendUnregisterPublicItemError() method.
     * Do not invoke this method on your own.
     *
     * <b>Documentation of 'UnregisterPublicItem'</b>:
     *
     * Method for Applications to UnregisterPublicData from CfgMgr to no longer receive updates of Public configuration data.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onUnregisterPublicItemRequest (const ::boost::shared_ptr< UnregisterPublicItemRequest >& request) = 0;

    /**
     * The method sendUnregisterPublicItemResponse() sends a response of a
     * previous method invocation of 'UnregisterPublicItem' back to the
     * client.
     *
     * <b>Documentation of 'UnregisterPublicItem'</b>:
     *
     * Method for Applications to UnregisterPublicData from CfgMgr to no longer receive updates of Public configuration data.
     *
     * @param status return result of unregister operation
     *
     * @param act The parameter act identifies a previous invocation of
     * onUnregisterPublicItem(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendUnregisterPublicItemResponse (EnRegisterStatus status, act_t act = 0);

    /**
     * The method sendUnregisterPublicItemError() sends an error response of a
     * previous method invocation of 'UnregisterPublicItem' back to the
     * client.
     *
     * <b>Documentation of 'UnregisterPublicItem'</b>:
     *
     * Method for Applications to UnregisterPublicData from CfgMgr to no longer receive updates of Public configuration data.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onUnregisterPublicItem(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendUnregisterPublicItemError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'setPublicItem'

    /**
     * The method onSetPublicItem() is called by ASF when a client invokes the
     * method 'setPublicItem'. A subclass has to implement this method and
     * send back a response to the client either with the sendSetPublicItem()
     * or sendSetPublicItemError() method. Do not invoke this method on your
     * own.
     *
     * <b>Documentation of 'setPublicItem'</b>:
     *
     * Method for HMI to update the local public items in config manager (ex: privacy mode).
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSetPublicItemRequest (const ::boost::shared_ptr< SetPublicItemRequest >& request) = 0;

    /**
     * The method sendSetPublicItemResponse() sends a response of a previous
     * method invocation of 'setPublicItem' back to the client.
     *
     * <b>Documentation of 'setPublicItem'</b>:
     *
     * Method for HMI to update the local public items in config manager (ex: privacy mode).
     *
     * @param status return result of operation
     *
     * @param act The parameter act identifies a previous invocation of
     * onSetPublicItem(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendSetPublicItemResponse (EnItemStatus status, act_t act = 0);

    /**
     * The method sendSetPublicItemError() sends an error response of a
     * previous method invocation of 'setPublicItem' back to the client.
     *
     * <b>Documentation of 'setPublicItem'</b>:
     *
     * Method for HMI to update the local public items in config manager (ex: privacy mode).
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onSetPublicItem(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendSetPublicItemError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'getPublicItem'

    /**
     * The method onGetPublicItem() is called by ASF when a client invokes the
     * method 'getPublicItem'. A subclass has to implement this method and
     * send back a response to the client either with the sendGetPublicItem()
     * or sendGetPublicItemError() method. Do not invoke this method on your
     * own.
     *
     * <b>Documentation of 'getPublicItem'</b>:
     *
     * Method for Applications to get Public configuration data from ConfigManager.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onGetPublicItemRequest (const ::boost::shared_ptr< GetPublicItemRequest >& request) = 0;

    /**
     * The method sendGetPublicItemResponse() sends a response of a previous
     * method invocation of 'getPublicItem' back to the client.
     *
     * <b>Documentation of 'getPublicItem'</b>:
     *
     * Method for Applications to get Public configuration data from ConfigManager.
     *
     * @param publicItem is an array of (key,value) pairs obtained for the respective SettingsGroupName
     *
     * @param status return result of operation
     *
     * @param act The parameter act identifies a previous invocation of
     * onGetPublicItem(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendGetPublicItemResponse (const ::std::vector< ConfigData >& publicItem, EnItemStatus status, act_t act = 0);

    /**
     * The method sendGetPublicItemError() sends an error response of a
     * previous method invocation of 'getPublicItem' back to the client.
     *
     * <b>Documentation of 'getPublicItem'</b>:
     *
     * Method for Applications to get Public configuration data from ConfigManager.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onGetPublicItem(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendGetPublicItemError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    friend class ConfigManagementStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace ConfigManagement
} // namespace ConfigManager
} // namespace cm
} // namespace bosch
} // namespace de

#endif // DE_BOSCH_CM_CONFIGMANAGER_CONFIGMANAGEMENTSTUB_H
