/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef DE_BOSCH_CM_CONFIGMANAGER_CONFIGMANAGEMENTPROXY_H
#define DE_BOSCH_CM_CONFIGMANAGER_CONFIGMANAGEMENTPROXY_H

#include "asf/core/Logger.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "de/bosch/cm/ConfigManager/ConfigManagement.h"
#include "de/bosch/cm/ConfigManager/ConfigManagementConst.h"
#include <dbus/dbus.h>
#include <string>
#include <vector>

namespace de {
namespace bosch {
namespace cm {
namespace ConfigManager {
namespace ConfigManagement {

class ConfigManagementProxy;

class GetPublicItemCallbackIF {
public:
    virtual ~GetPublicItemCallbackIF() {}

    virtual void onGetPublicItemError(const ::boost::shared_ptr< ConfigManagementProxy >& proxy, const ::boost::shared_ptr< GetPublicItemError >& error) = 0;

    virtual void onGetPublicItemResponse(const ::boost::shared_ptr< ConfigManagementProxy >& proxy, const ::boost::shared_ptr< GetPublicItemResponse >& response) = 0;
};

class RegisterPrivateItemCallbackIF {
public:
    virtual ~RegisterPrivateItemCallbackIF() {}

    virtual void onRegisterPrivateItemError(const ::boost::shared_ptr< ConfigManagementProxy >& proxy, const ::boost::shared_ptr< RegisterPrivateItemError >& error) = 0;

    virtual void onRegisterPrivateItemResponse(const ::boost::shared_ptr< ConfigManagementProxy >& proxy, const ::boost::shared_ptr< RegisterPrivateItemResponse >& response) = 0;
};

class RegisterPublicItemCallbackIF {
public:
    virtual ~RegisterPublicItemCallbackIF() {}

    virtual void onRegisterPublicItemError(const ::boost::shared_ptr< ConfigManagementProxy >& proxy, const ::boost::shared_ptr< RegisterPublicItemError >& error) = 0;

    virtual void onRegisterPublicItemResponse(const ::boost::shared_ptr< ConfigManagementProxy >& proxy, const ::boost::shared_ptr< RegisterPublicItemResponse >& response) = 0;
};

class SetPublicItemCallbackIF {
public:
    virtual ~SetPublicItemCallbackIF() {}

    virtual void onSetPublicItemError(const ::boost::shared_ptr< ConfigManagementProxy >& proxy, const ::boost::shared_ptr< SetPublicItemError >& error) = 0;

    virtual void onSetPublicItemResponse(const ::boost::shared_ptr< ConfigManagementProxy >& proxy, const ::boost::shared_ptr< SetPublicItemResponse >& response) = 0;
};

class UnregisterPrivateItemCallbackIF {
public:
    virtual ~UnregisterPrivateItemCallbackIF() {}

    virtual void onUnregisterPrivateItemError(const ::boost::shared_ptr< ConfigManagementProxy >& proxy, const ::boost::shared_ptr< UnregisterPrivateItemError >& error) = 0;

    virtual void onUnregisterPrivateItemResponse(const ::boost::shared_ptr< ConfigManagementProxy >& proxy, const ::boost::shared_ptr< UnregisterPrivateItemResponse >& response) = 0;
};

class UnregisterPublicItemCallbackIF {
public:
    virtual ~UnregisterPublicItemCallbackIF() {}

    virtual void onUnregisterPublicItemError(const ::boost::shared_ptr< ConfigManagementProxy >& proxy, const ::boost::shared_ptr< UnregisterPublicItemError >& error) = 0;

    virtual void onUnregisterPublicItemResponse(const ::boost::shared_ptr< ConfigManagementProxy >& proxy, const ::boost::shared_ptr< UnregisterPublicItemResponse >& response) = 0;
};


/**
 * ConfigManagementProxy is the client side representation of the D-Bus
 * service interface 'de.bosch.cm.ConfigManager.ConfigManagement'
 * (specified in file cfgmgr_ConfigManagement_.xml).
 *
 * This is the configuration manager control interface. It allows other applications (clients) to un-/register for properties and set/get of
 * 	public config items, handled by config manager.
 */
class ConfigManagementProxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of ConfigManagementProxy.
     */
    static ::boost::shared_ptr< ConfigManagementProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of ConfigManagementProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< ConfigManagementProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of ConfigManagementProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< ConfigManagementProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< ConfigManagementProxy > proxyNew(new ConfigManagementProxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(false);
        return proxyNew;
    }

    virtual ~ConfigManagementProxy ();




    // Method 'RegisterPrivateItem'

    /**
     * Call the method 'RegisterPrivateItem'. This method sends a message to
     * the D-Bus server.
     *
     * <b>Documentation of 'RegisterPrivateItem'</b>:
     *
     * Method to register an application in CfgMgr for private config items.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param privateItemName is the Custom settings (config item group name) of the application (for Native Apps) and AGW name (for Managed Apps)
     *
     * @param clientDBusName is the Name of DBUS used for proxy creation for a particular component
     *
     * @param dataFormat requested data format [Default, XML, ...]
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRegisterPrivateItemRequest(RegisterPrivateItemCallbackIF& cb, const ::std::string& privateItemName, const ::std::string& clientDBusName, EnItemFormats dataFormat) const;

    // Method 'UnregisterPrivateItem'

    /**
     * Call the method 'UnregisterPrivateItem'. This method sends a message to
     * the D-Bus server.
     *
     * <b>Documentation of 'UnregisterPrivateItem'</b>:
     *
     * Method for Applications to UnregisterPrivateData from CfgMgr to no longer receive updates of Custom Settings Group.
     * 				   Providing clientDBusName is not required from functional point of view, but offers some protection against unintentional
     * 				   unregistrations by others clients, as they first need to know the dbus name.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param privateItemName is the Custom settings (config item group name) of the application (for Native Apps) and AGW name (for Managed Apps)
     *
     * @param clientDBusName is the Name of DBUS used for proxy creation for a particular component
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendUnregisterPrivateItemRequest(UnregisterPrivateItemCallbackIF& cb, const ::std::string& privateItemName, const ::std::string& clientDBusName) const;

    // Method 'RegisterPublicItem'

    /**
     * Call the method 'RegisterPublicItem'. This method sends a message to
     * the D-Bus server.
     *
     * <b>Documentation of 'RegisterPublicItem'</b>:
     *
     * Method for Applications to RegisterPublicData in CfgMgr to receive updates of public configuration data.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param publicItemName is the generic configuration data that applications are interested in
     *
     * @param clientDBusName is the Name of DBUS used for proxy creation for a particular component
     *
     * @param dataFormat requested data format [Default, ...]. At the moment, only "default" is supported.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRegisterPublicItemRequest(RegisterPublicItemCallbackIF& cb, const ::std::string& publicItemName, const ::std::string& clientDBusName, EnItemFormats dataFormat) const;

    // Method 'UnregisterPublicItem'

    /**
     * Call the method 'UnregisterPublicItem'. This method sends a message to
     * the D-Bus server.
     *
     * <b>Documentation of 'UnregisterPublicItem'</b>:
     *
     * Method for Applications to UnregisterPublicData from CfgMgr to no longer receive updates of Public configuration data.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param publicItemName is the generic configuration data that applications are interested in
     *
     * @param clientDBusName is the Name of DBUS used for proxy creation for a particular component
     * 								Providing clientDBusName is not required from functional point of view, but offers some protection against unintentional
     * 								unregistrations by others clients, as they first need to know the dbus name.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendUnregisterPublicItemRequest(UnregisterPublicItemCallbackIF& cb, const ::std::string& publicItemName, const ::std::string& clientDBusName) const;

    // Method 'setPublicItem'

    /**
     * Call the method 'setPublicItem'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'setPublicItem'</b>:
     *
     * Method for HMI to update the local public items in config manager (ex: privacy mode).
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param publicItemName is the generic configuration data got from HMI
     *
     * @param publicItem is an array of (key,value) pairs obtained for the respective SettingsGroupName
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetPublicItemRequest(SetPublicItemCallbackIF& cb, const ::std::string& publicItemName, const ::std::vector< ConfigData >& publicItem) const;

    // Method 'getPublicItem'

    /**
     * Call the method 'getPublicItem'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'getPublicItem'</b>:
     *
     * Method for Applications to get Public configuration data from ConfigManager.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param publicItemName is the generic configuration data that applications are interested in. It can either be publicItemName or localItemName
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetPublicItemRequest(GetPublicItemCallbackIF& cb, const ::std::string& publicItemName) const;


private:

    ConfigManagementProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;


    DECLARE_CLASS_LOGGER();

    friend class ConfigManagementProxyCallback;
};

} // namespace ConfigManagement
} // namespace ConfigManager
} // namespace cm
} // namespace bosch
} // namespace de

#endif // DE_BOSCH_CM_CONFIGMANAGER_CONFIGMANAGEMENTPROXY_H
