/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "de/bosch/cm/ConfigManager/ConfigManagement.h"
#include "de/bosch/cm/ConfigManager/ConfigManagementConst.h"
#include "de/bosch/cm/ConfigManager/ConfigManagementDBus.h"
#include "de/bosch/cm/ConfigManager/ConfigManagementJson.h"
#include "de/bosch/cm/ConfigManager/ConfigManagementProxy.h"
#include <string>
#include <vector>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace de {
namespace bosch {
namespace cm {
namespace ConfigManager {
namespace ConfigManagement {

DEFINE_CLASS_LOGGER("/de/bosch/cm/ConfigManager/de/bosch/cm/ConfigManager/ConfigManagement", ConfigManagementProxy);

class ConfigManagementProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    ConfigManagementProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< ConfigManagementProxy >& proxyShared = ::boost::static_pointer_cast< ConfigManagementProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_RegisterPrivateItem:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), RegisterPrivateItemError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "RegisterPrivateItem", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RegisterPrivateItemError> payload = ::boost::static_pointer_cast<RegisterPrivateItemError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RegisterPrivateItemCallbackIF*) _callback)->onRegisterPrivateItemError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RegisterPrivateItemResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "RegisterPrivateItem", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RegisterPrivateItemResponse> payload = ::boost::static_pointer_cast<RegisterPrivateItemResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RegisterPrivateItemCallbackIF*) _callback)->onRegisterPrivateItemResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_UnregisterPrivateItem:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), UnregisterPrivateItemError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "UnregisterPrivateItem", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UnregisterPrivateItemError> payload = ::boost::static_pointer_cast<UnregisterPrivateItemError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((UnregisterPrivateItemCallbackIF*) _callback)->onUnregisterPrivateItemError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UnregisterPrivateItemResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "UnregisterPrivateItem", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UnregisterPrivateItemResponse> payload = ::boost::static_pointer_cast<UnregisterPrivateItemResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((UnregisterPrivateItemCallbackIF*) _callback)->onUnregisterPrivateItemResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_RegisterPublicItem:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), RegisterPublicItemError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "RegisterPublicItem", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RegisterPublicItemError> payload = ::boost::static_pointer_cast<RegisterPublicItemError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RegisterPublicItemCallbackIF*) _callback)->onRegisterPublicItemError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RegisterPublicItemResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "RegisterPublicItem", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RegisterPublicItemResponse> payload = ::boost::static_pointer_cast<RegisterPublicItemResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RegisterPublicItemCallbackIF*) _callback)->onRegisterPublicItemResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_UnregisterPublicItem:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), UnregisterPublicItemError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "UnregisterPublicItem", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UnregisterPublicItemError> payload = ::boost::static_pointer_cast<UnregisterPublicItemError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((UnregisterPublicItemCallbackIF*) _callback)->onUnregisterPublicItemError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UnregisterPublicItemResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "UnregisterPublicItem", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UnregisterPublicItemResponse> payload = ::boost::static_pointer_cast<UnregisterPublicItemResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((UnregisterPublicItemCallbackIF*) _callback)->onUnregisterPublicItemResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_setPublicItem:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SetPublicItemError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetPublicItem", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetPublicItemError> payload = ::boost::static_pointer_cast<SetPublicItemError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetPublicItemCallbackIF*) _callback)->onSetPublicItemError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetPublicItemResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetPublicItem", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetPublicItemResponse> payload = ::boost::static_pointer_cast<SetPublicItemResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetPublicItemCallbackIF*) _callback)->onSetPublicItemResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_getPublicItem:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), GetPublicItemError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetPublicItem", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetPublicItemError> payload = ::boost::static_pointer_cast<GetPublicItemError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetPublicItemCallbackIF*) _callback)->onGetPublicItemError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetPublicItemResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetPublicItem", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetPublicItemResponse> payload = ::boost::static_pointer_cast<GetPublicItemResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetPublicItemCallbackIF*) _callback)->onGetPublicItemResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_RegisterPrivateItem: {
                ::boost::shared_ptr< RegisterPrivateItemError > payload = ::boost::shared_ptr< RegisterPrivateItemError >
                (new RegisterPrivateItemError(DBUS_ERROR_NO_SERVER, "The DBus service ConfigManagement is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RegisterPrivateItem", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ConfigManagementProxy> proxyShared = ::boost::static_pointer_cast<ConfigManagementProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RegisterPrivateItemCallbackIF*) _callback)->onRegisterPrivateItemError (proxyShared,payload);
                return true;
            }
            break;
            case ID_UnregisterPrivateItem: {
                ::boost::shared_ptr< UnregisterPrivateItemError > payload = ::boost::shared_ptr< UnregisterPrivateItemError >
                (new UnregisterPrivateItemError(DBUS_ERROR_NO_SERVER, "The DBus service ConfigManagement is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "UnregisterPrivateItem", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ConfigManagementProxy> proxyShared = ::boost::static_pointer_cast<ConfigManagementProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((UnregisterPrivateItemCallbackIF*) _callback)->onUnregisterPrivateItemError (proxyShared,payload);
                return true;
            }
            break;
            case ID_RegisterPublicItem: {
                ::boost::shared_ptr< RegisterPublicItemError > payload = ::boost::shared_ptr< RegisterPublicItemError >
                (new RegisterPublicItemError(DBUS_ERROR_NO_SERVER, "The DBus service ConfigManagement is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RegisterPublicItem", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ConfigManagementProxy> proxyShared = ::boost::static_pointer_cast<ConfigManagementProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RegisterPublicItemCallbackIF*) _callback)->onRegisterPublicItemError (proxyShared,payload);
                return true;
            }
            break;
            case ID_UnregisterPublicItem: {
                ::boost::shared_ptr< UnregisterPublicItemError > payload = ::boost::shared_ptr< UnregisterPublicItemError >
                (new UnregisterPublicItemError(DBUS_ERROR_NO_SERVER, "The DBus service ConfigManagement is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "UnregisterPublicItem", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ConfigManagementProxy> proxyShared = ::boost::static_pointer_cast<ConfigManagementProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((UnregisterPublicItemCallbackIF*) _callback)->onUnregisterPublicItemError (proxyShared,payload);
                return true;
            }
            break;
            case ID_setPublicItem: {
                ::boost::shared_ptr< SetPublicItemError > payload = ::boost::shared_ptr< SetPublicItemError >
                (new SetPublicItemError(DBUS_ERROR_NO_SERVER, "The DBus service ConfigManagement is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SetPublicItem", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ConfigManagementProxy> proxyShared = ::boost::static_pointer_cast<ConfigManagementProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SetPublicItemCallbackIF*) _callback)->onSetPublicItemError (proxyShared,payload);
                return true;
            }
            break;
            case ID_getPublicItem: {
                ::boost::shared_ptr< GetPublicItemError > payload = ::boost::shared_ptr< GetPublicItemError >
                (new GetPublicItemError(DBUS_ERROR_NO_SERVER, "The DBus service ConfigManagement is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "GetPublicItem", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ConfigManagementProxy> proxyShared = ::boost::static_pointer_cast<ConfigManagementProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((GetPublicItemCallbackIF*) _callback)->onGetPublicItemError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& ConfigManagementProxyCallback::_logger (ConfigManagementProxy::_logger);

ConfigManagementProxy::ConfigManagementProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "de.bosch.cm.ConfigManager.ConfigManagement", serviceAvailable, _logger) {
}

ConfigManagementProxy::~ConfigManagementProxy()
{
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< ConfigManagementProxy > ConfigManagementProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<ConfigManagementProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< ConfigManagementProxy > proxyNew(new ConfigManagementProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(false);
    return proxyNew;
}

act_t ConfigManagementProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    ConfigManagementProxyCallback* callback = new ConfigManagementProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t ConfigManagementProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    ConfigManagementProxyCallback* callback = new ConfigManagementProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}



act_t ConfigManagementProxy::sendRegisterPrivateItemRequest(RegisterPrivateItemCallbackIF& cb, const ::std::string& privateItemName, const ::std::string& clientDBusName, EnItemFormats dataFormat) const {
    RegisterPrivateItemRequest* payload = new RegisterPrivateItemRequest();
    CHECK_ALLOCATION(payload);
    payload->setPrivateItemName(privateItemName);
    payload->setClientDBusName(clientDBusName);
    payload->setDataFormat(dataFormat);
    DBUS_MESSAGE_CALL(dbusMessage, "RegisterPrivateItem", RegisterPrivateItemRequest, payload, true)
    act_t act = addMethodCallback(ID_RegisterPrivateItem, dbusMessage.getUniqueSerial(), "RegisterPrivateItem", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "RegisterPrivateItem", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ConfigManagementProxy::sendUnregisterPrivateItemRequest(UnregisterPrivateItemCallbackIF& cb, const ::std::string& privateItemName, const ::std::string& clientDBusName) const {
    UnregisterPrivateItemRequest* payload = new UnregisterPrivateItemRequest();
    CHECK_ALLOCATION(payload);
    payload->setPrivateItemName(privateItemName);
    payload->setClientDBusName(clientDBusName);
    DBUS_MESSAGE_CALL(dbusMessage, "UnregisterPrivateItem", UnregisterPrivateItemRequest, payload, true)
    act_t act = addMethodCallback(ID_UnregisterPrivateItem, dbusMessage.getUniqueSerial(), "UnregisterPrivateItem", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "UnregisterPrivateItem", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ConfigManagementProxy::sendRegisterPublicItemRequest(RegisterPublicItemCallbackIF& cb, const ::std::string& publicItemName, const ::std::string& clientDBusName, EnItemFormats dataFormat) const {
    RegisterPublicItemRequest* payload = new RegisterPublicItemRequest();
    CHECK_ALLOCATION(payload);
    payload->setPublicItemName(publicItemName);
    payload->setClientDBusName(clientDBusName);
    payload->setDataFormat(dataFormat);
    DBUS_MESSAGE_CALL(dbusMessage, "RegisterPublicItem", RegisterPublicItemRequest, payload, true)
    act_t act = addMethodCallback(ID_RegisterPublicItem, dbusMessage.getUniqueSerial(), "RegisterPublicItem", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "RegisterPublicItem", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ConfigManagementProxy::sendUnregisterPublicItemRequest(UnregisterPublicItemCallbackIF& cb, const ::std::string& publicItemName, const ::std::string& clientDBusName) const {
    UnregisterPublicItemRequest* payload = new UnregisterPublicItemRequest();
    CHECK_ALLOCATION(payload);
    payload->setPublicItemName(publicItemName);
    payload->setClientDBusName(clientDBusName);
    DBUS_MESSAGE_CALL(dbusMessage, "UnregisterPublicItem", UnregisterPublicItemRequest, payload, true)
    act_t act = addMethodCallback(ID_UnregisterPublicItem, dbusMessage.getUniqueSerial(), "UnregisterPublicItem", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "UnregisterPublicItem", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ConfigManagementProxy::sendSetPublicItemRequest(SetPublicItemCallbackIF& cb, const ::std::string& publicItemName, const ::std::vector< ConfigData >& publicItem) const {
    SetPublicItemRequest* payload = new SetPublicItemRequest();
    CHECK_ALLOCATION(payload);
    payload->setPublicItemName(publicItemName);
    payload->setPublicItem(publicItem);
    DBUS_MESSAGE_CALL(dbusMessage, "setPublicItem", SetPublicItemRequest, payload, true)
    act_t act = addMethodCallback(ID_setPublicItem, dbusMessage.getUniqueSerial(), "setPublicItem", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SetPublicItem", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ConfigManagementProxy::sendGetPublicItemRequest(GetPublicItemCallbackIF& cb, const ::std::string& publicItemName) const {
    GetPublicItemRequest* payload = new GetPublicItemRequest();
    CHECK_ALLOCATION(payload);
    payload->setPublicItemName(publicItemName);
    DBUS_MESSAGE_CALL(dbusMessage, "getPublicItem", GetPublicItemRequest, payload, true)
    act_t act = addMethodCallback(ID_getPublicItem, dbusMessage.getUniqueSerial(), "getPublicItem", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "GetPublicItem", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace ConfigManagement
} // namespace ConfigManager
} // namespace cm
} // namespace bosch
} // namespace de
