/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef DE_BOSCH_CM_CONFIGMANAGER_CONFIGDATASTUB_H
#define DE_BOSCH_CM_CONFIGMANAGER_CONFIGDATASTUB_H

#include "asf/core/Logger.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "de/bosch/cm/ConfigManager/ConfigData.h"
#include "de/bosch/cm/ConfigManager/ConfigDataConst.h"
#include <string>
#include <vector>

namespace de {
namespace bosch {
namespace cm {
namespace ConfigManager {
namespace ConfigData {

class ConfigDataStubDelegate;

class ConfigDataStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the ConfigDataStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    ConfigDataStub (const std::string& portName);

    /**
     * Create an instance of the ConfigDataStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    ConfigDataStub (const std::string& portName, const std::string& objectPath);

    virtual ~ConfigDataStub();

    // method 'setPrivateItem'

    /**
     * The method onSetPrivateItem() is called by ASF when a client invokes
     * the method 'setPrivateItem'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendSetPrivateItem() or sendSetPrivateItemError() method. Do not invoke
     * this method on your own.
     *
     * <b>Documentation of 'setPrivateItem'</b>:
     *
     * Method called by CfgMgr to set an private item in the application
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSetPrivateItemRequest (const ::boost::shared_ptr< SetPrivateItemRequest >& request) = 0;

    /**
     * The method sendSetPrivateItemResponse() sends a response of a previous
     * method invocation of 'setPrivateItem' back to the client.
     *
     * <b>Documentation of 'setPrivateItem'</b>:
     *
     * Method called by CfgMgr to set an private item in the application
     *
     * @param status If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onSetPrivateItem(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendSetPrivateItemResponse (EnItemsStatus status, act_t act = 0);

    /**
     * The method sendSetPrivateItemError() sends an error response of a
     * previous method invocation of 'setPrivateItem' back to the client.
     *
     * <b>Documentation of 'setPrivateItem'</b>:
     *
     * Method called by CfgMgr to set an private item in the application
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onSetPrivateItem(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendSetPrivateItemError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'getPrivateItem'

    /**
     * The method onGetPrivateItem() is called by ASF when a client invokes
     * the method 'getPrivateItem'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendGetPrivateItem() or sendGetPrivateItemError() method. Do not invoke
     * this method on your own.
     *
     * <b>Documentation of 'getPrivateItem'</b>:
     *
     * Method called by cfgmgr to get the data of an private config item, stored in application.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onGetPrivateItemRequest (const ::boost::shared_ptr< GetPrivateItemRequest >& request) = 0;

    /**
     * The method sendGetPrivateItemResponse() sends a response of a previous
     * method invocation of 'getPrivateItem' back to the client.
     *
     * <b>Documentation of 'getPrivateItem'</b>:
     *
     * Method called by cfgmgr to get the data of an private config item, stored in application.
     *
     * @param privateItem is an array of (key,value) pairs obtained for the respective private item name
     *
     * @param status return value to indicate result of get operation
     *
     * @param act The parameter act identifies a previous invocation of
     * onGetPrivateItem(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendGetPrivateItemResponse (const ::std::vector< ConfigInfo >& privateItem, EnItemsStatus status, act_t act = 0);

    /**
     * The method sendGetPrivateItemError() sends an error response of a
     * previous method invocation of 'getPrivateItem' back to the client.
     *
     * <b>Documentation of 'getPrivateItem'</b>:
     *
     * Method called by cfgmgr to get the data of an private config item, stored in application.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onGetPrivateItem(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendGetPrivateItemError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'exchangeDESCMO'

    /**
     * The method onExchangeDESCMO() is called by ASF when a client invokes
     * the method 'exchangeDESCMO'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendExchangeDESCMO() or sendExchangeDESCMOError() method. Do not invoke
     * this method on your own.
     *
     * <b>Documentation of 'exchangeDESCMO'</b>:
     *
     * Method called by cfgmgr to forward an private config item in XML format. This is just one method, because SET and GET will be encoded in the XML
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onExchangeDESCMORequest (const ::boost::shared_ptr< ExchangeDESCMORequest >& request) = 0;

    /**
     * The method sendExchangeDESCMOResponse() sends a response of a previous
     * method invocation of 'exchangeDESCMO' back to the client.
     *
     * <b>Documentation of 'exchangeDESCMO'</b>:
     *
     * Method called by cfgmgr to forward an private config item in XML format. This is just one method, because SET and GET will be encoded in the XML
     *
     * @param outPrivateItemXML the XML encoded private config item data returned from application. In case of GET the application has updated the data.
     *
     * @param status return value, indicating result of exchange operation
     *
     * @param act The parameter act identifies a previous invocation of
     * onExchangeDESCMO(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendExchangeDESCMOResponse (const ::std::string& outPrivateItemXML, EnItemsStatus status, act_t act = 0);

    /**
     * The method sendExchangeDESCMOError() sends an error response of a
     * previous method invocation of 'exchangeDESCMO' back to the client.
     *
     * <b>Documentation of 'exchangeDESCMO'</b>:
     *
     * Method called by cfgmgr to forward an private config item in XML format. This is just one method, because SET and GET will be encoded in the XML
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onExchangeDESCMO(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendExchangeDESCMOError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'updatePublicConfigItem'

    /**
     * The method onUpdatePublicConfigItem() is called by ASF when a client
     * invokes the method 'updatePublicConfigItem'.  Do not invoke this method
     * on your own.
     *
     * <b>Documentation of 'updatePublicConfigItem'</b>:
     *
     * Method for Applications to receive updates of Public configuration data from ConfigManager.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onUpdatePublicConfigItemRequest (const ::boost::shared_ptr< UpdatePublicConfigItemRequest >& request) = 0;

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    friend class ConfigDataStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace ConfigData
} // namespace ConfigManager
} // namespace cm
} // namespace bosch
} // namespace de

#endif // DE_BOSCH_CM_CONFIGMANAGER_CONFIGDATASTUB_H
