/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "de/bosch/cm/ConfigManager/ConfigData.h"
#include "de/bosch/cm/ConfigManager/ConfigDataConst.h"
#include "de/bosch/cm/ConfigManager/ConfigDataDBus.h"
#include "de/bosch/cm/ConfigManager/ConfigDataJson.h"
#include "de/bosch/cm/ConfigManager/ConfigDataProxy.h"
#include <string>
#include <vector>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace de {
namespace bosch {
namespace cm {
namespace ConfigManager {
namespace ConfigData {

DEFINE_CLASS_LOGGER("/de/bosch/cm/ConfigManager/de/bosch/cm/ConfigManager/ConfigData", ConfigDataProxy);

class ConfigDataProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    ConfigDataProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< ConfigDataProxy >& proxyShared = ::boost::static_pointer_cast< ConfigDataProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_setPrivateItem:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SetPrivateItemError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetPrivateItem", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetPrivateItemError> payload = ::boost::static_pointer_cast<SetPrivateItemError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetPrivateItemCallbackIF*) _callback)->onSetPrivateItemError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetPrivateItemResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetPrivateItem", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetPrivateItemResponse> payload = ::boost::static_pointer_cast<SetPrivateItemResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetPrivateItemCallbackIF*) _callback)->onSetPrivateItemResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_getPrivateItem:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), GetPrivateItemError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetPrivateItem", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetPrivateItemError> payload = ::boost::static_pointer_cast<GetPrivateItemError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetPrivateItemCallbackIF*) _callback)->onGetPrivateItemError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetPrivateItemResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetPrivateItem", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetPrivateItemResponse> payload = ::boost::static_pointer_cast<GetPrivateItemResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetPrivateItemCallbackIF*) _callback)->onGetPrivateItemResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_exchangeDESCMO:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ExchangeDESCMOError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ExchangeDESCMO", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ExchangeDESCMOError> payload = ::boost::static_pointer_cast<ExchangeDESCMOError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ExchangeDESCMOCallbackIF*) _callback)->onExchangeDESCMOError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ExchangeDESCMOResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "ExchangeDESCMO", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ExchangeDESCMOResponse> payload = ::boost::static_pointer_cast<ExchangeDESCMOResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ExchangeDESCMOCallbackIF*) _callback)->onExchangeDESCMOResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_setPrivateItem: {
                ::boost::shared_ptr< SetPrivateItemError > payload = ::boost::shared_ptr< SetPrivateItemError >
                (new SetPrivateItemError(DBUS_ERROR_NO_SERVER, "The DBus service ConfigData is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SetPrivateItem", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ConfigDataProxy> proxyShared = ::boost::static_pointer_cast<ConfigDataProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SetPrivateItemCallbackIF*) _callback)->onSetPrivateItemError (proxyShared,payload);
                return true;
            }
            break;
            case ID_getPrivateItem: {
                ::boost::shared_ptr< GetPrivateItemError > payload = ::boost::shared_ptr< GetPrivateItemError >
                (new GetPrivateItemError(DBUS_ERROR_NO_SERVER, "The DBus service ConfigData is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "GetPrivateItem", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ConfigDataProxy> proxyShared = ::boost::static_pointer_cast<ConfigDataProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((GetPrivateItemCallbackIF*) _callback)->onGetPrivateItemError (proxyShared,payload);
                return true;
            }
            break;
            case ID_exchangeDESCMO: {
                ::boost::shared_ptr< ExchangeDESCMOError > payload = ::boost::shared_ptr< ExchangeDESCMOError >
                (new ExchangeDESCMOError(DBUS_ERROR_NO_SERVER, "The DBus service ConfigData is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ExchangeDESCMO", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ConfigDataProxy> proxyShared = ::boost::static_pointer_cast<ConfigDataProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ExchangeDESCMOCallbackIF*) _callback)->onExchangeDESCMOError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& ConfigDataProxyCallback::_logger (ConfigDataProxy::_logger);

ConfigDataProxy::ConfigDataProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "de.bosch.cm.ConfigManager.ConfigData", serviceAvailable, _logger) {
}

ConfigDataProxy::~ConfigDataProxy()
{
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< ConfigDataProxy > ConfigDataProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<ConfigDataProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< ConfigDataProxy > proxyNew(new ConfigDataProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(false);
    return proxyNew;
}

act_t ConfigDataProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    ConfigDataProxyCallback* callback = new ConfigDataProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t ConfigDataProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    ConfigDataProxyCallback* callback = new ConfigDataProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}



act_t ConfigDataProxy::sendSetPrivateItemRequest(SetPrivateItemCallbackIF& cb, const ::std::string& privateItemName, const ::std::vector< ConfigInfo >& privateItem) const {
    SetPrivateItemRequest* payload = new SetPrivateItemRequest();
    CHECK_ALLOCATION(payload);
    payload->setPrivateItemName(privateItemName);
    payload->setPrivateItem(privateItem);
    DBUS_MESSAGE_CALL(dbusMessage, "setPrivateItem", SetPrivateItemRequest, payload, true)
    act_t act = addMethodCallback(ID_setPrivateItem, dbusMessage.getUniqueSerial(), "setPrivateItem", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SetPrivateItem", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ConfigDataProxy::sendGetPrivateItemRequest(GetPrivateItemCallbackIF& cb, const ::std::string& privateItemName) const {
    GetPrivateItemRequest* payload = new GetPrivateItemRequest();
    CHECK_ALLOCATION(payload);
    payload->setPrivateItemName(privateItemName);
    DBUS_MESSAGE_CALL(dbusMessage, "getPrivateItem", GetPrivateItemRequest, payload, true)
    act_t act = addMethodCallback(ID_getPrivateItem, dbusMessage.getUniqueSerial(), "getPrivateItem", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "GetPrivateItem", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ConfigDataProxy::sendExchangeDESCMORequest(ExchangeDESCMOCallbackIF& cb, const ::std::string& privateItemName, const ::std::string& privateItemXML, const ::std::string& signatureXML) const {
    ExchangeDESCMORequest* payload = new ExchangeDESCMORequest();
    CHECK_ALLOCATION(payload);
    payload->setPrivateItemName(privateItemName);
    payload->setPrivateItemXML(privateItemXML);
    payload->setSignatureXML(signatureXML);
    DBUS_MESSAGE_CALL(dbusMessage, "exchangeDESCMO", ExchangeDESCMORequest, payload, true)
    act_t act = addMethodCallback(ID_exchangeDESCMO, dbusMessage.getUniqueSerial(), "exchangeDESCMO", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "ExchangeDESCMO", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ConfigDataProxy::sendUpdatePublicConfigItemRequest(const ::std::string& publicItemName, const ::std::vector< ConfigInfo >& publicItem, EnItemsStatus status) const {
    UpdatePublicConfigItemRequest* payload = new UpdatePublicConfigItemRequest();
    CHECK_ALLOCATION(payload);
    payload->setPublicItemName(publicItemName);
    payload->setPublicItem(publicItem);
    payload->setStatus(status);
    DBUS_MESSAGE_CALL(dbusMessage, "updatePublicConfigItem", UpdatePublicConfigItemRequest, payload, false)
    LOG_INFO ("-> send%sRequest", "UpdatePublicConfigItem");
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return 0;
}

} // namespace ConfigData
} // namespace ConfigManager
} // namespace cm
} // namespace bosch
} // namespace de
