/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef COM_BOSCH_AUTOMOTIVEPROXY_AUDIOMANAGERSTUB_H
#define COM_BOSCH_AUTOMOTIVEPROXY_AUDIOMANAGERSTUB_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/AutomotiveProxy/AudioManager.h"

namespace com {
namespace bosch {
namespace AutomotiveProxy {
namespace AudioManager {

class AudioManagerStubDelegate;

class AudioManagerStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the AudioManagerStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    AudioManagerStub (const std::string& portName);

    /**
     * Create an instance of the AudioManagerStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    AudioManagerStub (const std::string& portName, const std::string& objectPath);

    virtual ~AudioManagerStub();

    // signal 'OnMuteState'

    /**
     * Raise the signal 'OnMuteState' and send an update message to registered
     * clients.
     *
     * <b>Documentation of 'OnMuteState'</b>:
     *
     * If the meaning of "OnMuteState" isn't clear, then there should be a description here.
     */
    void sendOnMuteStateSignal(uint8 source);

    // signal 'SourceActivity'

    /**
     * Raise the signal 'SourceActivity' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'SourceActivity'</b>:
     *
     * If the meaning of "SourceActivity" isn't clear, then there should be a description here.
     */
    void sendSourceActivitySignal(uint8 source, uint16 status);

    // signal 'OnAllocate'

    /**
     * Raise the signal 'OnAllocate' and send an update message to registered
     * clients.
     *
     * <b>Documentation of 'OnAllocate'</b>:
     *
     * If the meaning of "OnAllocate" isn't clear, then there should be a description here.
     */
    void sendOnAllocateSignal(uint8 source);

    // signal 'OnDeAllocate'

    /**
     * Raise the signal 'OnDeAllocate' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'OnDeAllocate'</b>:
     *
     * If the meaning of "OnDeAllocate" isn't clear, then there should be a description here.
     */
    void sendOnDeAllocateSignal(uint8 source);

    // method 'AudioRouteRequest'

    /**
     * The method onAudioRouteRequest() is called by ASF when a client invokes
     * the method 'AudioRouteRequest'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendAudioRouteRequest() or sendAudioRouteRequestError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'AudioRouteRequest'</b>:
     *
     * If the meaning of "AudioRouteRequest" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onAudioRouteRequestRequest (const ::boost::shared_ptr< AudioRouteRequestRequest >& request) = 0;

    /**
     * The method sendAudioRouteRequestResponse() sends a response of a
     * previous method invocation of 'AudioRouteRequest' back to the client.
     *
     * <b>Documentation of 'AudioRouteRequest'</b>:
     *
     * If the meaning of "AudioRouteRequest" isn't clear, then there should be a description here.
     *
     * @param status If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onAudioRouteRequest(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendAudioRouteRequestResponse (bool status, act_t act = 0);

    /**
     * The method sendAudioRouteRequestError() sends an error response of a
     * previous method invocation of 'AudioRouteRequest' back to the client.
     *
     * <b>Documentation of 'AudioRouteRequest'</b>:
     *
     * If the meaning of "AudioRouteRequest" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onAudioRouteRequest().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendAudioRouteRequestError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'SourceAvailability'

    /**
     * The method onSourceAvailability() is called by ASF when a client
     * invokes the method 'SourceAvailability'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendSourceAvailability() or sendSourceAvailabilityError() method. Do
     * not invoke this method on your own.
     *
     * <b>Documentation of 'SourceAvailability'</b>:
     *
     * If the meaning of "SourceAvailability" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSourceAvailabilityRequest (const ::boost::shared_ptr< SourceAvailabilityRequest >& request) = 0;

    /**
     * The method sendSourceAvailabilityResponse() sends a response of a
     * previous method invocation of 'SourceAvailability' back to the client.
     *
     * <b>Documentation of 'SourceAvailability'</b>:
     *
     * If the meaning of "SourceAvailability" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onSourceAvailability(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSourceAvailabilityResponse (act_t act = 0);

    /**
     * The method sendSourceAvailabilityError() sends an error response of a
     * previous method invocation of 'SourceAvailability' back to the client.
     *
     * <b>Documentation of 'SourceAvailability'</b>:
     *
     * If the meaning of "SourceAvailability" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onSourceAvailability().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendSourceAvailabilityError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'MuteState'

    /**
     * The method onMuteState() is called by ASF when a client invokes the
     * method 'MuteState'. A subclass has to implement this method and send
     * back a response to the client either with the sendMuteState() or
     * sendMuteStateError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'MuteState'</b>:
     *
     * If the meaning of "MuteState" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onMuteStateRequest (const ::boost::shared_ptr< MuteStateRequest >& request) = 0;

    /**
     * The method sendMuteStateResponse() sends a response of a previous
     * method invocation of 'MuteState' back to the client.
     *
     * <b>Documentation of 'MuteState'</b>:
     *
     * If the meaning of "MuteState" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onMuteState(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendMuteStateResponse (act_t act = 0);

    /**
     * The method sendMuteStateError() sends an error response of a previous
     * method invocation of 'MuteState' back to the client.
     *
     * <b>Documentation of 'MuteState'</b>:
     *
     * If the meaning of "MuteState" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onMuteState(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendMuteStateError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'SourceActivityResult'

    /**
     * The method onSourceActivityResult() is called by ASF when a client
     * invokes the method 'SourceActivityResult'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendSourceActivityResult() or sendSourceActivityResultError() method.
     * Do not invoke this method on your own.
     *
     * <b>Documentation of 'SourceActivityResult'</b>:
     *
     * If the meaning of "SourceActivityResult" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSourceActivityResultRequest (const ::boost::shared_ptr< SourceActivityResultRequest >& request) = 0;

    /**
     * The method sendSourceActivityResultResponse() sends a response of a
     * previous method invocation of 'SourceActivityResult' back to the
     * client.
     *
     * <b>Documentation of 'SourceActivityResult'</b>:
     *
     * If the meaning of "SourceActivityResult" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onSourceActivityResult(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSourceActivityResultResponse (act_t act = 0);

    /**
     * The method sendSourceActivityResultError() sends an error response of a
     * previous method invocation of 'SourceActivityResult' back to the
     * client.
     *
     * <b>Documentation of 'SourceActivityResult'</b>:
     *
     * If the meaning of "SourceActivityResult" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onSourceActivityResult(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSourceActivityResultError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    friend class AudioManagerStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace AudioManager
} // namespace AutomotiveProxy
} // namespace bosch
} // namespace com

#endif // COM_BOSCH_AUTOMOTIVEPROXY_AUDIOMANAGERSTUB_H
