/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/AutomotiveProxy/AudioManager.h"
#include "com/bosch/AutomotiveProxy/AudioManagerDBus.h"
#include "com/bosch/AutomotiveProxy/AudioManagerJson.h"
#include "com/bosch/AutomotiveProxy/AudioManagerStub.h"

#include "asf/dbus/DBusMessage.h"

namespace com {
namespace bosch {
namespace AutomotiveProxy {
namespace AudioManager {

DEFINE_CLASS_LOGGER("///com/bosch/AutomotiveProxy/AudioManager", AudioManagerStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 9, "MuteState", 2 },
    { 17, "AudioRouteRequest", 0 },
    { 18, "SourceAvailability", 1 },
    { 20, "SourceActivityResult", 3 },
};


class AudioManagerStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    AudioManagerStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    AudioManagerStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    AudioManagerStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "com.bosch.AutomotiveProxy.AudioManager"),
          _logger(logger) {}

    virtual ~AudioManagerStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void AudioManagerStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 4, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'AudioRouteRequest'

            LOG_DEBUG_STUB("process method '%s'", "AudioRouteRequest");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AudioRouteRequestRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "AudioRouteRequest", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< AudioRouteRequestRequest > payload = ::boost::static_pointer_cast<AudioRouteRequestRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<AudioManagerStub*>(getStub())->onAudioRouteRequestRequest(payload);
            return;
        }
        case 1: {

            // method 'SourceAvailability'

            LOG_DEBUG_STUB("process method '%s'", "SourceAvailability");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SourceAvailabilityRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SourceAvailability", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SourceAvailabilityRequest > payload = ::boost::static_pointer_cast<SourceAvailabilityRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<AudioManagerStub*>(getStub())->onSourceAvailabilityRequest(payload);
            return;
        }
        case 2: {

            // method 'MuteState'

            LOG_DEBUG_STUB("process method '%s'", "MuteState");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), MuteStateRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "MuteState", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< MuteStateRequest > payload = ::boost::static_pointer_cast<MuteStateRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<AudioManagerStub*>(getStub())->onMuteStateRequest(payload);
            return;
        }
        case 3: {

            // method 'SourceActivityResult'

            LOG_DEBUG_STUB("process method '%s'", "SourceActivityResult");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SourceActivityResultRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SourceActivityResult", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SourceActivityResultRequest > payload = ::boost::static_pointer_cast<SourceActivityResultRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<AudioManagerStub*>(getStub())->onSourceActivityResultRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* AudioManagerStubDelegate::introspect() const {
    return     "<interface name=\"com.bosch.AutomotiveProxy.AudioManager\">\n"
            "      <method name=\"AudioRouteRequest\">\n"
            "        <annotation name=\"org.freedesktop.DBus.GLib.Async\" value=\"\"/>\n"
            "        <arg direction=\"in\" name=\"source\" type=\"y\"/>\n"
            "        <arg direction=\"in\" name=\"state_required\" type=\"y\"/>\n"
            "        <arg direction=\"out\" name=\"status\" type=\"b\"/>\n"
            "      </method>\n"
            "      <method name=\"SourceAvailability\">\n"
            "        <annotation name=\"org.freedesktop.DBus.GLib.Async\" value=\"yes\"/>\n"
            "        <arg direction=\"in\" name=\"source\" type=\"y\"/>\n"
            "        <arg direction=\"in\" name=\"availability\" type=\"b\"/>\n"
            "      </method>\n"
            "      <method name=\"MuteState\">\n"
            "        <annotation name=\"org.freedesktop.DBus.GLib.Async\" value=\"\"/>\n"
            "        <arg direction=\"in\" name=\"source\" type=\"y\"/>\n"
            "        <arg direction=\"in\" name=\"state_required\" type=\"b\"/>\n"
            "      </method>\n"
            "      <signal name=\"OnMuteState\">\n"
            "        <arg name=\"source\" type=\"y\"/>\n"
            "      </signal>\n"
            "      <signal name=\"SourceActivity\">\n"
            "        <arg name=\"source\" type=\"y\"/>\n"
            "        <arg name=\"status\" type=\"q\"/>\n"
            "      </signal>\n"
            "      <method name=\"SourceActivityResult\">\n"
            "        <annotation name=\"org.freedesktop.DBus.GLib.Async\" value=\"\"/>\n"
            "        <arg direction=\"in\" name=\"source\" type=\"y\"/>\n"
            "        <arg direction=\"in\" name=\"status\" type=\"q\"/>\n"
            "      </method>\n"
            "      <signal name=\"OnAllocate\">\n"
            "        <arg name=\"source\" type=\"y\"/>\n"
            "      </signal>\n"
            "      <signal name=\"OnDeAllocate\">\n"
            "        <arg name=\"source\" type=\"y\"/>\n"
            "      </signal>\n"
            "</interface>\n";
}

void AudioManagerStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<AudioManagerStub*>(getStub()))->onGetAll (properties);
}

void AudioManagerStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    ((void)value);  // to get rid of unused variable warning
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void AudioManagerStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

AudioManagerStub::AudioManagerStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new AudioManagerStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

AudioManagerStub::AudioManagerStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new AudioManagerStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

AudioManagerStub::~AudioManagerStub() {
    delete _stubDelegate;
}

void AudioManagerStub::sendOnMuteStateSignal(uint8 source) {
    if (_stubDelegate->isConnected()) {
        OnMuteStateSignal* payload = new OnMuteStateSignal(source);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "OnMuteState", OnMuteStateSignal, payload)
        LOG_INFO ("-> send%sSignal", "OnMuteState");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "OnMuteState");
    }
}

void AudioManagerStub::sendSourceActivitySignal(uint8 source, uint16 status) {
    if (_stubDelegate->isConnected()) {
        SourceActivitySignal* payload = new SourceActivitySignal(source, status);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "SourceActivity", SourceActivitySignal, payload)
        LOG_INFO ("-> send%sSignal", "SourceActivity");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "SourceActivity");
    }
}

void AudioManagerStub::sendOnAllocateSignal(uint8 source) {
    if (_stubDelegate->isConnected()) {
        OnAllocateSignal* payload = new OnAllocateSignal(source);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "OnAllocate", OnAllocateSignal, payload)
        LOG_INFO ("-> send%sSignal", "OnAllocate");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "OnAllocate");
    }
}

void AudioManagerStub::sendOnDeAllocateSignal(uint8 source) {
    if (_stubDelegate->isConnected()) {
        OnDeAllocateSignal* payload = new OnDeAllocateSignal(source);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "OnDeAllocate", OnDeAllocateSignal, payload)
        LOG_INFO ("-> send%sSignal", "OnDeAllocate");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "OnDeAllocate");
    }
}

void  AudioManagerStub::sendAudioRouteRequestResponse (bool status, act_t act) {
    AudioRouteRequestResponse* payload = new AudioRouteRequestResponse(status);
    DBUS_MESSAGE_REPLY(dbusMessage, "AudioRouteRequest", AudioRouteRequestResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "AudioRouteRequest", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  AudioManagerStub::sendAudioRouteRequestError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    AudioRouteRequestError* payload = new AudioRouteRequestError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "AudioRouteRequest", AudioRouteRequestError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "AudioRouteRequest", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  AudioManagerStub::sendSourceAvailabilityResponse (act_t act) {
    SourceAvailabilityResponse* payload = new SourceAvailabilityResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "SourceAvailability", SourceAvailabilityResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SourceAvailability", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  AudioManagerStub::sendSourceAvailabilityError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SourceAvailabilityError* payload = new SourceAvailabilityError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "SourceAvailability", SourceAvailabilityError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SourceAvailability", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  AudioManagerStub::sendMuteStateResponse (act_t act) {
    MuteStateResponse* payload = new MuteStateResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "MuteState", MuteStateResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "MuteState", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  AudioManagerStub::sendMuteStateError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    MuteStateError* payload = new MuteStateError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "MuteState", MuteStateError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "MuteState", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  AudioManagerStub::sendSourceActivityResultResponse (act_t act) {
    SourceActivityResultResponse* payload = new SourceActivityResultResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "SourceActivityResult", SourceActivityResultResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SourceActivityResult", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  AudioManagerStub::sendSourceActivityResultError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SourceActivityResultError* payload = new SourceActivityResultError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "SourceActivityResult", SourceActivityResultError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SourceActivityResult", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void AudioManagerStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {
    ((void)properties);  // to get rid of unused variable warning
}

} // namespace AudioManager
} // namespace AutomotiveProxy
} // namespace bosch
} // namespace com
