/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/AutomotiveProxy/AudioManager.h"
#include "com/bosch/AutomotiveProxy/AudioManagerDBus.h"
#include "com/bosch/AutomotiveProxy/AudioManagerJson.h"
#include "com/bosch/AutomotiveProxy/AudioManagerProxy.h"

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace com {
namespace bosch {
namespace AutomotiveProxy {
namespace AudioManager {

DEFINE_CLASS_LOGGER("///com/bosch/AutomotiveProxy/AudioManager", AudioManagerProxy);

class AudioManagerProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    AudioManagerProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< AudioManagerProxy >& proxyShared = ::boost::static_pointer_cast< AudioManagerProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_OnMuteState:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), OnMuteStateSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "OnMuteState", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<OnMuteStateSignal> payload = ::boost::static_pointer_cast<OnMuteStateSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((OnMuteStateCallbackIF*) _callback)->onOnMuteStateSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_SourceActivity:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SourceActivitySignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SourceActivity", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<SourceActivitySignal> payload = ::boost::static_pointer_cast<SourceActivitySignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((SourceActivityCallbackIF*) _callback)->onSourceActivitySignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_OnAllocate:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), OnAllocateSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "OnAllocate", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<OnAllocateSignal> payload = ::boost::static_pointer_cast<OnAllocateSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((OnAllocateCallbackIF*) _callback)->onOnAllocateSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_OnDeAllocate:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), OnDeAllocateSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "OnDeAllocate", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<OnDeAllocateSignal> payload = ::boost::static_pointer_cast<OnDeAllocateSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((OnDeAllocateCallbackIF*) _callback)->onOnDeAllocateSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_AudioRouteRequest:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), AudioRouteRequestError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "AudioRouteRequest", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AudioRouteRequestError> payload = ::boost::static_pointer_cast<AudioRouteRequestError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((AudioRouteRequestCallbackIF*) _callback)->onAudioRouteRequestError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AudioRouteRequestResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "AudioRouteRequest", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AudioRouteRequestResponse> payload = ::boost::static_pointer_cast<AudioRouteRequestResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((AudioRouteRequestCallbackIF*) _callback)->onAudioRouteRequestResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_SourceAvailability:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SourceAvailabilityError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SourceAvailability", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SourceAvailabilityError> payload = ::boost::static_pointer_cast<SourceAvailabilityError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SourceAvailabilityCallbackIF*) _callback)->onSourceAvailabilityError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SourceAvailabilityResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SourceAvailability", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SourceAvailabilityResponse> payload = ::boost::static_pointer_cast<SourceAvailabilityResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SourceAvailabilityCallbackIF*) _callback)->onSourceAvailabilityResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_MuteState:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), MuteStateError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "MuteState", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<MuteStateError> payload = ::boost::static_pointer_cast<MuteStateError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((MuteStateCallbackIF*) _callback)->onMuteStateError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), MuteStateResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "MuteState", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<MuteStateResponse> payload = ::boost::static_pointer_cast<MuteStateResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((MuteStateCallbackIF*) _callback)->onMuteStateResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_SourceActivityResult:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SourceActivityResultError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SourceActivityResult", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SourceActivityResultError> payload = ::boost::static_pointer_cast<SourceActivityResultError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SourceActivityResultCallbackIF*) _callback)->onSourceActivityResultError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SourceActivityResultResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SourceActivityResult", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SourceActivityResultResponse> payload = ::boost::static_pointer_cast<SourceActivityResultResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SourceActivityResultCallbackIF*) _callback)->onSourceActivityResultResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_OnMuteState: {
                ::boost::shared_ptr< OnMuteStateError > payload = ::boost::shared_ptr< OnMuteStateError >
                (new OnMuteStateError(DBUS_ERROR_NO_SERVER, "The DBus service AudioManager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "OnMuteState", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<AudioManagerProxy> proxyShared = ::boost::static_pointer_cast<AudioManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((OnMuteStateCallbackIF*) _callback)->onOnMuteStateError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SourceActivity: {
                ::boost::shared_ptr< SourceActivityError > payload = ::boost::shared_ptr< SourceActivityError >
                (new SourceActivityError(DBUS_ERROR_NO_SERVER, "The DBus service AudioManager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SourceActivity", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<AudioManagerProxy> proxyShared = ::boost::static_pointer_cast<AudioManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SourceActivityCallbackIF*) _callback)->onSourceActivityError (proxyShared,payload);
                return true;
            }
            break;
            case ID_OnAllocate: {
                ::boost::shared_ptr< OnAllocateError > payload = ::boost::shared_ptr< OnAllocateError >
                (new OnAllocateError(DBUS_ERROR_NO_SERVER, "The DBus service AudioManager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "OnAllocate", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<AudioManagerProxy> proxyShared = ::boost::static_pointer_cast<AudioManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((OnAllocateCallbackIF*) _callback)->onOnAllocateError (proxyShared,payload);
                return true;
            }
            break;
            case ID_OnDeAllocate: {
                ::boost::shared_ptr< OnDeAllocateError > payload = ::boost::shared_ptr< OnDeAllocateError >
                (new OnDeAllocateError(DBUS_ERROR_NO_SERVER, "The DBus service AudioManager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "OnDeAllocate", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<AudioManagerProxy> proxyShared = ::boost::static_pointer_cast<AudioManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((OnDeAllocateCallbackIF*) _callback)->onOnDeAllocateError (proxyShared,payload);
                return true;
            }
            break;
            case ID_AudioRouteRequest: {
                ::boost::shared_ptr< AudioRouteRequestError > payload = ::boost::shared_ptr< AudioRouteRequestError >
                (new AudioRouteRequestError(DBUS_ERROR_NO_SERVER, "The DBus service AudioManager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "AudioRouteRequest", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<AudioManagerProxy> proxyShared = ::boost::static_pointer_cast<AudioManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((AudioRouteRequestCallbackIF*) _callback)->onAudioRouteRequestError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SourceAvailability: {
                ::boost::shared_ptr< SourceAvailabilityError > payload = ::boost::shared_ptr< SourceAvailabilityError >
                (new SourceAvailabilityError(DBUS_ERROR_NO_SERVER, "The DBus service AudioManager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SourceAvailability", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<AudioManagerProxy> proxyShared = ::boost::static_pointer_cast<AudioManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SourceAvailabilityCallbackIF*) _callback)->onSourceAvailabilityError (proxyShared,payload);
                return true;
            }
            break;
            case ID_MuteState: {
                ::boost::shared_ptr< MuteStateError > payload = ::boost::shared_ptr< MuteStateError >
                (new MuteStateError(DBUS_ERROR_NO_SERVER, "The DBus service AudioManager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "MuteState", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<AudioManagerProxy> proxyShared = ::boost::static_pointer_cast<AudioManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((MuteStateCallbackIF*) _callback)->onMuteStateError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SourceActivityResult: {
                ::boost::shared_ptr< SourceActivityResultError > payload = ::boost::shared_ptr< SourceActivityResultError >
                (new SourceActivityResultError(DBUS_ERROR_NO_SERVER, "The DBus service AudioManager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SourceActivityResult", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<AudioManagerProxy> proxyShared = ::boost::static_pointer_cast<AudioManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SourceActivityResultCallbackIF*) _callback)->onSourceActivityResultError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& AudioManagerProxyCallback::_logger (AudioManagerProxy::_logger);

AudioManagerProxy::AudioManagerProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "com.bosch.AutomotiveProxy.AudioManager", serviceAvailable, _logger) {
}

AudioManagerProxy::~AudioManagerProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< AudioManagerProxy > AudioManagerProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<AudioManagerProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< AudioManagerProxy > proxyNew(new AudioManagerProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(false);
    return proxyNew;
}

act_t AudioManagerProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    AudioManagerProxyCallback* callback = new AudioManagerProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t AudioManagerProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    AudioManagerProxyCallback* callback = new AudioManagerProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


void AudioManagerProxy::sendDeregisterAll () const
{
    sendOnMuteStateDeregisterAll();
    sendSourceActivityDeregisterAll();
    sendOnAllocateDeregisterAll();
    sendOnDeAllocateDeregisterAll();
}

act_t AudioManagerProxy::sendOnMuteStateRegister(OnMuteStateCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "OnMuteState");
    act_t act = addSignalCallback(ID_OnMuteState, "OnMuteState", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "OnMuteState", &cb, act);
    return act;
}

bool AudioManagerProxy::sendOnMuteStateDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("OnMuteState", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "OnMuteState", act, static_cast<int>(rv));
    return rv;
}

void AudioManagerProxy::sendOnMuteStateDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "OnMuteState");
    _dbusProxyDelegate->deregisterSignalCallback("OnMuteState", 0, _dbusDaemonProxy.get(), false);
}

act_t AudioManagerProxy::sendSourceActivityRegister(SourceActivityCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "SourceActivity");
    act_t act = addSignalCallback(ID_SourceActivity, "SourceActivity", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "SourceActivity", &cb, act);
    return act;
}

bool AudioManagerProxy::sendSourceActivityDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("SourceActivity", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "SourceActivity", act, static_cast<int>(rv));
    return rv;
}

void AudioManagerProxy::sendSourceActivityDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "SourceActivity");
    _dbusProxyDelegate->deregisterSignalCallback("SourceActivity", 0, _dbusDaemonProxy.get(), false);
}

act_t AudioManagerProxy::sendOnAllocateRegister(OnAllocateCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "OnAllocate");
    act_t act = addSignalCallback(ID_OnAllocate, "OnAllocate", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "OnAllocate", &cb, act);
    return act;
}

bool AudioManagerProxy::sendOnAllocateDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("OnAllocate", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "OnAllocate", act, static_cast<int>(rv));
    return rv;
}

void AudioManagerProxy::sendOnAllocateDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "OnAllocate");
    _dbusProxyDelegate->deregisterSignalCallback("OnAllocate", 0, _dbusDaemonProxy.get(), false);
}

act_t AudioManagerProxy::sendOnDeAllocateRegister(OnDeAllocateCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "OnDeAllocate");
    act_t act = addSignalCallback(ID_OnDeAllocate, "OnDeAllocate", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "OnDeAllocate", &cb, act);
    return act;
}

bool AudioManagerProxy::sendOnDeAllocateDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("OnDeAllocate", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "OnDeAllocate", act, static_cast<int>(rv));
    return rv;
}

void AudioManagerProxy::sendOnDeAllocateDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "OnDeAllocate");
    _dbusProxyDelegate->deregisterSignalCallback("OnDeAllocate", 0, _dbusDaemonProxy.get(), false);
}

act_t AudioManagerProxy::sendAudioRouteRequestRequest(AudioRouteRequestCallbackIF& cb, uint8 source, uint8 state_required) const {
    AudioRouteRequestRequest* payload = new AudioRouteRequestRequest();
    CHECK_ALLOCATION(payload);
    payload->setSource(source);
    payload->setState_required(state_required);
    DBUS_MESSAGE_CALL(dbusMessage, "AudioRouteRequest", AudioRouteRequestRequest, payload, true)
    act_t act = addMethodCallback(ID_AudioRouteRequest, dbusMessage.getUniqueSerial(), "AudioRouteRequest", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "AudioRouteRequest", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t AudioManagerProxy::sendSourceAvailabilityRequest(SourceAvailabilityCallbackIF& cb, uint8 source, bool availability) const {
    SourceAvailabilityRequest* payload = new SourceAvailabilityRequest();
    CHECK_ALLOCATION(payload);
    payload->setSource(source);
    payload->setAvailability(availability);
    DBUS_MESSAGE_CALL(dbusMessage, "SourceAvailability", SourceAvailabilityRequest, payload, true)
    act_t act = addMethodCallback(ID_SourceAvailability, dbusMessage.getUniqueSerial(), "SourceAvailability", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SourceAvailability", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t AudioManagerProxy::sendMuteStateRequest(MuteStateCallbackIF& cb, uint8 source, bool state_required) const {
    MuteStateRequest* payload = new MuteStateRequest();
    CHECK_ALLOCATION(payload);
    payload->setSource(source);
    payload->setState_required(state_required);
    DBUS_MESSAGE_CALL(dbusMessage, "MuteState", MuteStateRequest, payload, true)
    act_t act = addMethodCallback(ID_MuteState, dbusMessage.getUniqueSerial(), "MuteState", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "MuteState", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t AudioManagerProxy::sendSourceActivityResultRequest(SourceActivityResultCallbackIF& cb, uint8 source, uint16 status) const {
    SourceActivityResultRequest* payload = new SourceActivityResultRequest();
    CHECK_ALLOCATION(payload);
    payload->setSource(source);
    payload->setStatus(status);
    DBUS_MESSAGE_CALL(dbusMessage, "SourceActivityResult", SourceActivityResultRequest, payload, true)
    act_t act = addMethodCallback(ID_SourceActivityResult, dbusMessage.getUniqueSerial(), "SourceActivityResult", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SourceActivityResult", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace AudioManager
} // namespace AutomotiveProxy
} // namespace bosch
} // namespace com
