/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef BOSCH_CM_AI_HMI_HMIMASTERSERVICE_APPLICATIONSWITCHSTUB_H
#define BOSCH_CM_AI_HMI_HMIMASTERSERVICE_APPLICATIONSWITCHSTUB_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "bosch/cm/ai/hmi/hmimasterservice/ApplicationSwitch.h"
#include "bosch/cm/ai/hmi/hmimasterservice/ApplicationSwitchConst.h"

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace hmimasterservice {
namespace ApplicationSwitch {

class ApplicationSwitchStubDelegate;

class ApplicationSwitchStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the ApplicationSwitchStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    ApplicationSwitchStub (const std::string& portName);

    /**
     * Create an instance of the ApplicationSwitchStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    ApplicationSwitchStub (const std::string& portName, const std::string& objectPath);

    virtual ~ApplicationSwitchStub();

    // signal 'Mapout_Activate_Deactivate'

    /**
     * Raise the signal 'Mapout_Activate_Deactivate' and send an update
     * message to registered clients.
     *
     * <b>Documentation of 'Mapout_Activate_Deactivate'</b>:
     *
     * Mapout_Activate_Deactivate = Method to request show MAP scene
     *
     * @param regionId If the meaning of "regionId" isn't clear, then there should be a description here.
     *
     * @param mapoutshow If the meaning of "mapoutshow" isn't clear, then there should be a description here.
     */
    void sendMapout_Activate_DeactivateSignal(uint32 regionId, bool mapoutshow);

    // signal 'sig_activate_spi_voicerecognition_short'

    /**
     * Raise the signal 'sig_activate_spi_voicerecognition_short' and send an
     * update message to registered clients.
     *
     * <b>Documentation of 'sig_activate_spi_voicerecognition_short'</b>:
     *
     * sig_activate_spi_voicerecognition_short = Method to request show MAP scene
     *
     * @param status If the meaning of "status" isn't clear, then there should be a description here.
     */
    void sendSig_activate_spi_voicerecognition_shortSignal(bool status);

    // signal 'sig_activate_spi_voicerecognition_long'

    /**
     * Raise the signal 'sig_activate_spi_voicerecognition_long' and send an
     * update message to registered clients.
     *
     * <b>Documentation of 'sig_activate_spi_voicerecognition_long'</b>:
     *
     * sig_activate_spi_voicerecognition_long = Method to request show MAP scene
     *
     * @param status If the meaning of "status" isn't clear, then there should be a description here.
     */
    void sendSig_activate_spi_voicerecognition_longSignal(bool status);

    // signal 'sig_activate_spi_voicerecognition_short_release'

    /**
     * Raise the signal 'sig_activate_spi_voicerecognition_short_release' and
     * send an update message to registered clients.
     *
     * <b>Documentation of 'sig_activate_spi_voicerecognition_short_release'</b>:
     *
     * sig_activate_spi_voicerecognition_short_release = Method to request show MAP scene
     *
     * @param status If the meaning of "status" isn't clear, then there should be a description here.
     */
    void sendSig_activate_spi_voicerecognition_short_releaseSignal(bool status);

    // signal 'sig_activate_spi_voicerecognition_long_release'

    /**
     * Raise the signal 'sig_activate_spi_voicerecognition_long_release' and
     * send an update message to registered clients.
     *
     * <b>Documentation of 'sig_activate_spi_voicerecognition_long_release'</b>:
     *
     * sig_activate_spi_voicerecognition_long_release = Method to request show MAP scene
     *
     * @param status If the meaning of "status" isn't clear, then there should be a description here.
     */
    void sendSig_activate_spi_voicerecognition_long_releaseSignal(bool status);

    // signal 'sig_activate_deactivate_SpeechSession'

    /**
     * Raise the signal 'sig_activate_deactivate_SpeechSession' and send an
     * update message to registered clients.
     *
     * <b>Documentation of 'sig_activate_deactivate_SpeechSession'</b>:
     *
     * sig_activate_deactivate_SpeechSession = signal to activate Speech Session when PTT button is pressed
     *
     * @param status If the meaning of "status" isn't clear, then there should be a description here.
     */
    void sendSig_activate_deactivate_SpeechSessionSignal(bool status);

    // signal 'sig_ControlPanelButtonPress'

    /**
     * Raise the signal 'sig_ControlPanelButtonPress' and send an update
     * message to registered clients.
     *
     * <b>Documentation of 'sig_ControlPanelButtonPress'</b>:
     *
     * sig_ControlPanelButtonPress = signal to indicate control panel button is pressed
     *
     * @param buttonId If the meaning of "buttonId" isn't clear, then there should be a description here.
     *
     * @param buttonState If the meaning of "buttonState" isn't clear, then there should be a description here.
     *
     * @param receiverAppID If the meaning of "receiverAppID" isn't clear, then there should be a description here.
     */
    void sendSig_ControlPanelButtonPressSignal(uint8 buttonId, uint8 buttonState, uint32 receiverAppID);

    // signal 'sig_ActivateContext'

    /**
     * Raise the signal 'sig_ActivateContext' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'sig_ActivateContext'</b>:
     *
     * sig_ActivateContext = signal to activate context
     *
     * @param regionId If the meaning of "regionId" isn't clear, then there should be a description here.
     *
     * @param targetappId If the meaning of "targetappId" isn't clear, then there should be a description here.
     *
     * @param targetactivityId If the meaning of "targetactivityId" isn't clear, then there should be a description here.
     */
    void sendSig_ActivateContextSignal(uint8 regionId, uint8 targetappId, enActivityIDs targetactivityId);

    // signal 'sig_SWCKeyEvent'

    /**
     * Raise the signal 'sig_SWCKeyEvent' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'sig_SWCKeyEvent'</b>:
     *
     * sig_SWCKeyEvent = signal to handle SWCKeyEvent
     *
     * @param keyEvent If the meaning of "keyEvent" isn't clear, then there should be a description here.
     */
    void sendSig_SWCKeyEventSignal(uint8 keyEvent);

    // property 'activeRegionId'

    /**
     * The method onActiveRegionIdGet() is called by ASF when a client invokes
     * the read method for the property 'activeRegionId'. The
     * onActiveRegionIdGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'activeRegionId'</b>:
     *
     * activeRegionId = to indicate change in active RegionId
     */
    virtual void onActiveRegionIdGet(const ::boost::shared_ptr< ActiveRegionIdGet >& payload);

    /**
     * Sends back the update to a previous onActiveRegionIdGet().
     *
     * <b>Documentation of 'activeRegionId'</b>:
     *
     * activeRegionId = to indicate change in active RegionId
     *
     * @param act Identifies a previous invocation of onActiveRegionIdGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendActiveRegionIdGetUpdate(uint8 activeRegionId, act_t act = 0);

    /**
     * The method onActiveRegionIdSet() is called by ASF when a client invokes
     * the write method for the property 'activeRegionId'. The
     * onActiveRegionIdSet() method set property value to the given parameter
     * activeRegionId by default. If this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'activeRegionId'</b>:
     *
     * activeRegionId = to indicate change in active RegionId
     */
    virtual void onActiveRegionIdSet(const ::boost::shared_ptr< ActiveRegionIdSet >& payload);

    /**
     * Sends back the update to a previous onActiveRegionIdSet().
     *
     * <b>Documentation of 'activeRegionId'</b>:
     *
     * activeRegionId = to indicate change in active RegionId
     *
     * @param act Identifies a previous invocation of onActiveRegionIdSet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendActiveRegionIdSetUpdate(act_t act = 0);

    /**
     * Set the value of the property 'activeRegionId' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'activeRegionId'</b>:
     *
     * activeRegionId = to indicate change in active RegionId
     */
    void setActiveRegionId(uint8 activeRegionId);

    /**
     * Returns the current value of the property 'activeRegionId'.
     *
     * <b>Documentation of 'activeRegionId'</b>:
     *
     * activeRegionId = to indicate change in active RegionId
     */
    uint8 getActiveRegionId() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendActiveRegionIdUpdate().
     *
     * <b>Documentation of 'activeRegionId'</b>:
     *
     * activeRegionId = to indicate change in active RegionId
     */
    void sendActiveRegionIdUpdate();

    // method 'requestApplcationSwitch'

    /**
     * The method onRequestApplcationSwitch() is called by ASF when a client
     * invokes the method 'requestApplcationSwitch'. A subclass has to
     * implement this method and send back a response to the client either
     * with the sendRequestApplcationSwitch() or
     * sendRequestApplcationSwitchError() method. Do not invoke this method on
     * your own.
     *
     * <b>Documentation of 'requestApplcationSwitch'</b>:
     *
     * requestApplcationSwitch = Method to request application switching
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onRequestApplcationSwitchRequest (const ::boost::shared_ptr< RequestApplcationSwitchRequest >& request) = 0;

    /**
     * The method sendRequestApplcationSwitchResponse() sends a response of a
     * previous method invocation of 'requestApplcationSwitch' back to the
     * client.
     *
     * <b>Documentation of 'requestApplcationSwitch'</b>:
     *
     * requestApplcationSwitch = Method to request application switching
     *
     * @param response If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onRequestApplcationSwitch(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendRequestApplcationSwitchResponse (bool response, act_t act = 0);

    /**
     * The method sendRequestApplcationSwitchError() sends an error response
     * of a previous method invocation of 'requestApplcationSwitch' back to
     * the client.
     *
     * <b>Documentation of 'requestApplcationSwitch'</b>:
     *
     * requestApplcationSwitch = Method to request application switching
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onRequestApplcationSwitch(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendRequestApplcationSwitchError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'requestShowHideWaitScene'

    /**
     * The method onRequestShowHideWaitScene() is called by ASF when a client
     * invokes the method 'requestShowHideWaitScene'. A subclass has to
     * implement this method and send back a response to the client either
     * with the sendRequestShowHideWaitScene() or
     * sendRequestShowHideWaitSceneError() method. Do not invoke this method
     * on your own.
     *
     * <b>Documentation of 'requestShowHideWaitScene'</b>:
     *
     * requestShowHideWaitScene = Method to request show Wait Animation scene
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onRequestShowHideWaitSceneRequest (const ::boost::shared_ptr< RequestShowHideWaitSceneRequest >& request) = 0;

    /**
     * The method sendRequestShowHideWaitSceneResponse() sends a response of a
     * previous method invocation of 'requestShowHideWaitScene' back to the
     * client.
     *
     * <b>Documentation of 'requestShowHideWaitScene'</b>:
     *
     * requestShowHideWaitScene = Method to request show Wait Animation scene
     *
     * @param response If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onRequestShowHideWaitScene(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendRequestShowHideWaitSceneResponse (bool response, act_t act = 0);

    /**
     * The method sendRequestShowHideWaitSceneError() sends an error response
     * of a previous method invocation of 'requestShowHideWaitScene' back to
     * the client.
     *
     * <b>Documentation of 'requestShowHideWaitScene'</b>:
     *
     * requestShowHideWaitScene = Method to request show Wait Animation scene
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onRequestShowHideWaitScene(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendRequestShowHideWaitSceneError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'activateDeactivateRVCScene'

    /**
     * The method onActivateDeactivateRVCScene() is called by ASF when a
     * client invokes the method 'activateDeactivateRVCScene'. A subclass has
     * to implement this method and send back a response to the client either
     * with the sendActivateDeactivateRVCScene() or
     * sendActivateDeactivateRVCSceneError() method. Do not invoke this method
     * on your own.
     *
     * <b>Documentation of 'activateDeactivateRVCScene'</b>:
     *
     * activateDeactivateRVCScene = Method to request show RVC scene
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onActivateDeactivateRVCSceneRequest (const ::boost::shared_ptr< ActivateDeactivateRVCSceneRequest >& request) = 0;

    /**
     * The method sendActivateDeactivateRVCSceneResponse() sends a response of
     * a previous method invocation of 'activateDeactivateRVCScene' back to
     * the client.
     *
     * <b>Documentation of 'activateDeactivateRVCScene'</b>:
     *
     * activateDeactivateRVCScene = Method to request show RVC scene
     *
     * @param response If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onActivateDeactivateRVCScene(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendActivateDeactivateRVCSceneResponse (bool response, act_t act = 0);

    /**
     * The method sendActivateDeactivateRVCSceneError() sends an error
     * response of a previous method invocation of
     * 'activateDeactivateRVCScene' back to the client.
     *
     * <b>Documentation of 'activateDeactivateRVCScene'</b>:
     *
     * activateDeactivateRVCScene = Method to request show RVC scene
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onActivateDeactivateRVCScene(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendActivateDeactivateRVCSceneError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'speechSession_activated_deactivated'

    /**
     * The method onSpeechSession_activated_deactivated() is called by ASF
     * when a client invokes the method 'speechSession_activated_deactivated'.
     * A subclass has to implement this method and send back a response to the
     * client either with the sendSpeechSession_activated_deactivated() or
     * sendSpeechSession_activated_deactivatedError() method. Do not invoke
     * this method on your own.
     *
     * <b>Documentation of 'speechSession_activated_deactivated'</b>:
     *
     * speechSession_activated_deactivated = method when speech session activates or deactivates
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSpeechSession_activated_deactivatedRequest (const ::boost::shared_ptr< SpeechSession_activated_deactivatedRequest >& request) = 0;

    /**
     * The method sendSpeechSession_activated_deactivatedResponse() sends a
     * response of a previous method invocation of
     * 'speechSession_activated_deactivated' back to the client.
     *
     * <b>Documentation of 'speechSession_activated_deactivated'</b>:
     *
     * speechSession_activated_deactivated = method when speech session activates or deactivates
     *
     * @param response If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onSpeechSession_activated_deactivated(). If the act is not specified,
     * i.e. the most recent invocation will be answered. In case multiple
     * replies are pending an act must be specified. An assertion will be
     * thrown if no or multiple method invocation could be found.
     */
    void sendSpeechSession_activated_deactivatedResponse (bool response, act_t act = 0);

    /**
     * The method sendSpeechSession_activated_deactivatedError() sends an
     * error response of a previous method invocation of
     * 'speechSession_activated_deactivated' back to the client.
     *
     * <b>Documentation of 'speechSession_activated_deactivated'</b>:
     *
     * speechSession_activated_deactivated = method when speech session activates or deactivates
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onSpeechSession_activated_deactivated(). If the act is not specified,
     * i.e. the most recent invocation will be answered. In case multiple
     * replies are pending an act must be specified. An assertion will be
     * thrown if no or multiple method invocation could be found.
     */
    void sendSpeechSession_activated_deactivatedError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'mapout_activated_deactivated'

    /**
     * The method onMapout_activated_deactivated() is called by ASF when a
     * client invokes the method 'mapout_activated_deactivated'. A subclass
     * has to implement this method and send back a response to the client
     * either with the sendMapout_activated_deactivated() or
     * sendMapout_activated_deactivatedError() method. Do not invoke this
     * method on your own.
     *
     * <b>Documentation of 'mapout_activated_deactivated'</b>:
     *
     * mapout_activated_deactivated = method called when navigation application activates or deactivates mapout streaming
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onMapout_activated_deactivatedRequest (const ::boost::shared_ptr< Mapout_activated_deactivatedRequest >& request) = 0;

    /**
     * The method sendMapout_activated_deactivatedResponse() sends a response
     * of a previous method invocation of 'mapout_activated_deactivated' back
     * to the client.
     *
     * <b>Documentation of 'mapout_activated_deactivated'</b>:
     *
     * mapout_activated_deactivated = method called when navigation application activates or deactivates mapout streaming
     *
     * @param act The parameter act identifies a previous invocation of
     * onMapout_activated_deactivated(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendMapout_activated_deactivatedResponse (act_t act = 0);

    /**
     * The method sendMapout_activated_deactivatedError() sends an error
     * response of a previous method invocation of
     * 'mapout_activated_deactivated' back to the client.
     *
     * <b>Documentation of 'mapout_activated_deactivated'</b>:
     *
     * mapout_activated_deactivated = method called when navigation application activates or deactivates mapout streaming
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onMapout_activated_deactivated(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendMapout_activated_deactivatedError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'spi_connectionstatus'

    /**
     * The method onSpi_connectionstatus() is called by ASF when a client
     * invokes the method 'spi_connectionstatus'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendSpi_connectionstatus() or sendSpi_connectionstatusError() method.
     * Do not invoke this method on your own.
     *
     * <b>Documentation of 'spi_connectionstatus'</b>:
     *
     * spi_connectionstatus = method when VR session activates or deactivates
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSpi_connectionstatusRequest (const ::boost::shared_ptr< Spi_connectionstatusRequest >& request) = 0;

    /**
     * The method sendSpi_connectionstatusResponse() sends a response of a
     * previous method invocation of 'spi_connectionstatus' back to the
     * client.
     *
     * <b>Documentation of 'spi_connectionstatus'</b>:
     *
     * spi_connectionstatus = method when VR session activates or deactivates
     *
     * @param response If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onSpi_connectionstatus(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSpi_connectionstatusResponse (bool response, act_t act = 0);

    /**
     * The method sendSpi_connectionstatusError() sends an error response of a
     * previous method invocation of 'spi_connectionstatus' back to the
     * client.
     *
     * <b>Documentation of 'spi_connectionstatus'</b>:
     *
     * spi_connectionstatus = method when VR session activates or deactivates
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onSpi_connectionstatus(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSpi_connectionstatusError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'spi_ForwardEncoder'

    /**
     * The method onSpi_ForwardEncoder() is called by ASF when a client
     * invokes the method 'spi_ForwardEncoder'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendSpi_ForwardEncoder() or sendSpi_ForwardEncoderError() method. Do
     * not invoke this method on your own.
     *
     * <b>Documentation of 'spi_ForwardEncoder'</b>:
     *
     * spi_ForwardEncoder = method when Encoder Message to be forwarded
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSpi_ForwardEncoderRequest (const ::boost::shared_ptr< Spi_ForwardEncoderRequest >& request) = 0;

    /**
     * The method sendSpi_ForwardEncoderResponse() sends a response of a
     * previous method invocation of 'spi_ForwardEncoder' back to the client.
     *
     * <b>Documentation of 'spi_ForwardEncoder'</b>:
     *
     * spi_ForwardEncoder = method when Encoder Message to be forwarded
     *
     * @param response If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onSpi_ForwardEncoder(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendSpi_ForwardEncoderResponse (bool response, act_t act = 0);

    /**
     * The method sendSpi_ForwardEncoderError() sends an error response of a
     * previous method invocation of 'spi_ForwardEncoder' back to the client.
     *
     * <b>Documentation of 'spi_ForwardEncoder'</b>:
     *
     * spi_ForwardEncoder = method when Encoder Message to be forwarded
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onSpi_ForwardEncoder().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendSpi_ForwardEncoderError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'RequestContextSwitch'

    /**
     * The method onRequestContextSwitch() is called by ASF when a client
     * invokes the method 'RequestContextSwitch'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendRequestContextSwitch() or sendRequestContextSwitchError() method.
     * Do not invoke this method on your own.
     *
     * <b>Documentation of 'RequestContextSwitch'</b>:
     *
     * RequestContextSwitch = to request for change in context
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onRequestContextSwitchRequest (const ::boost::shared_ptr< RequestContextSwitchRequest >& request) = 0;

    /**
     * The method sendRequestContextSwitchResponse() sends a response of a
     * previous method invocation of 'RequestContextSwitch' back to the
     * client.
     *
     * <b>Documentation of 'RequestContextSwitch'</b>:
     *
     * RequestContextSwitch = to request for change in context
     *
     * @param response If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onRequestContextSwitch(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendRequestContextSwitchResponse (bool response, act_t act = 0);

    /**
     * The method sendRequestContextSwitchError() sends an error response of a
     * previous method invocation of 'RequestContextSwitch' back to the
     * client.
     *
     * <b>Documentation of 'RequestContextSwitch'</b>:
     *
     * RequestContextSwitch = to request for change in context
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onRequestContextSwitch(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendRequestContextSwitchError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'sendContext'

    /**
     * The method onSendContext() is called by ASF when a client invokes the
     * method 'sendContext'. A subclass has to implement this method and send
     * back a response to the client either with the sendSendContext() or
     * sendSendContextError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'sendContext'</b>:
     *
     * sendSourceContext = to send source in context on request
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSendContextRequest (const ::boost::shared_ptr< SendContextRequest >& request) = 0;

    /**
     * The method sendSendContextResponse() sends a response of a previous
     * method invocation of 'sendContext' back to the client.
     *
     * <b>Documentation of 'sendContext'</b>:
     *
     * sendSourceContext = to send source in context on request
     *
     * @param response If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onSendContext(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendSendContextResponse (bool response, act_t act = 0);

    /**
     * The method sendSendContextError() sends an error response of a previous
     * method invocation of 'sendContext' back to the client.
     *
     * <b>Documentation of 'sendContext'</b>:
     *
     * sendSourceContext = to send source in context on request
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onSendContext(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendSendContextError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'DisplayAppFlyInReq'

    /**
     * The method onDisplayAppFlyInReq() is called by ASF when a client
     * invokes the method 'DisplayAppFlyInReq'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendDisplayAppFlyInReq() or sendDisplayAppFlyInReqError() method. Do
     * not invoke this method on your own.
     *
     * <b>Documentation of 'DisplayAppFlyInReq'</b>:
     *
     * sendSourceContext = to send source in context on request
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onDisplayAppFlyInReqRequest (const ::boost::shared_ptr< DisplayAppFlyInReqRequest >& request) = 0;

    /**
     * The method sendDisplayAppFlyInReqResponse() sends a response of a
     * previous method invocation of 'DisplayAppFlyInReq' back to the client.
     *
     * <b>Documentation of 'DisplayAppFlyInReq'</b>:
     *
     * sendSourceContext = to send source in context on request
     *
     * @param act The parameter act identifies a previous invocation of
     * onDisplayAppFlyInReq(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendDisplayAppFlyInReqResponse (act_t act = 0);

    /**
     * The method sendDisplayAppFlyInReqError() sends an error response of a
     * previous method invocation of 'DisplayAppFlyInReq' back to the client.
     *
     * <b>Documentation of 'DisplayAppFlyInReq'</b>:
     *
     * sendSourceContext = to send source in context on request
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onDisplayAppFlyInReq().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendDisplayAppFlyInReqError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'configureAppFlyInStatus'

    /**
     * The method onConfigureAppFlyInStatus() is called by ASF when a client
     * invokes the method 'configureAppFlyInStatus'.  Do not invoke this
     * method on your own.
     *
     * <b>Documentation of 'configureAppFlyInStatus'</b>:
     *
     * Method to provide acknowledgement for display sync request
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onConfigureAppFlyInStatusRequest (const ::boost::shared_ptr< ConfigureAppFlyInStatusRequest >& request) = 0;

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    ActiveRegionIdUpdate _activeRegionIdProperty;

    friend class ApplicationSwitchStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace ApplicationSwitch
} // namespace hmimasterservice
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch

#endif // BOSCH_CM_AI_HMI_HMIMASTERSERVICE_APPLICATIONSWITCHSTUB_H
