/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "bosch/cm/ai/hmi/hmimasterservice/ApplicationSwitch.h"
#include "bosch/cm/ai/hmi/hmimasterservice/ApplicationSwitchConst.h"
#include "bosch/cm/ai/hmi/hmimasterservice/ApplicationSwitchDBus.h"
#include "bosch/cm/ai/hmi/hmimasterservice/ApplicationSwitchJson.h"
#include "bosch/cm/ai/hmi/hmimasterservice/ApplicationSwitchStub.h"

#include "asf/dbus/DBusMessage.h"

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace hmimasterservice {
namespace ApplicationSwitch {

DEFINE_CLASS_LOGGER("/bosch/cm/ai/hmi/hmimasterservice/bosch/cm/ai/hmi/hmimasterservice/ApplicationSwitch", ApplicationSwitchStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 11, "sendContext", 8 },
    { 18, "DisplayAppFlyInReq", 9 },
    { 18, "spi_ForwardEncoder", 6 },
    { 20, "RequestContextSwitch", 7 },
    { 20, "spi_connectionstatus", 5 },
    { 23, "configureAppFlyInStatus", 10 },
    { 23, "requestApplcationSwitch", 0 },
    { 24, "requestShowHideWaitScene", 1 },
    { 26, "activateDeactivateRVCScene", 2 },
    { 28, "mapout_activated_deactivated", 4 },
    { 35, "speechSession_activated_deactivated", 3 },
};

static ::asf::dbus::DBusUtils::stringEntry propertiesTable[] = {
    { 14, "activeRegionId", 0 },
};

class ApplicationSwitchStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    ApplicationSwitchStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    ApplicationSwitchStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    ApplicationSwitchStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "bosch.cm.ai.hmi.hmimasterservice.ApplicationSwitch"),
          _logger(logger) {}

    virtual ~ApplicationSwitchStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void ApplicationSwitchStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 11, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'requestApplcationSwitch'

            LOG_DEBUG_STUB("process method '%s'", "requestApplcationSwitch");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RequestApplcationSwitchRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "RequestApplcationSwitch", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< RequestApplcationSwitchRequest > payload = ::boost::static_pointer_cast<RequestApplcationSwitchRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ApplicationSwitchStub*>(getStub())->onRequestApplcationSwitchRequest(payload);
            return;
        }
        case 1: {

            // method 'requestShowHideWaitScene'

            LOG_DEBUG_STUB("process method '%s'", "requestShowHideWaitScene");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RequestShowHideWaitSceneRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "RequestShowHideWaitScene", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< RequestShowHideWaitSceneRequest > payload = ::boost::static_pointer_cast<RequestShowHideWaitSceneRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ApplicationSwitchStub*>(getStub())->onRequestShowHideWaitSceneRequest(payload);
            return;
        }
        case 2: {

            // method 'activateDeactivateRVCScene'

            LOG_DEBUG_STUB("process method '%s'", "activateDeactivateRVCScene");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ActivateDeactivateRVCSceneRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ActivateDeactivateRVCScene", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ActivateDeactivateRVCSceneRequest > payload = ::boost::static_pointer_cast<ActivateDeactivateRVCSceneRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ApplicationSwitchStub*>(getStub())->onActivateDeactivateRVCSceneRequest(payload);
            return;
        }
        case 3: {

            // method 'speechSession_activated_deactivated'

            LOG_DEBUG_STUB("process method '%s'", "speechSession_activated_deactivated");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SpeechSession_activated_deactivatedRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SpeechSession_activated_deactivated", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SpeechSession_activated_deactivatedRequest > payload = ::boost::static_pointer_cast<SpeechSession_activated_deactivatedRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ApplicationSwitchStub*>(getStub())->onSpeechSession_activated_deactivatedRequest(payload);
            return;
        }
        case 4: {

            // method 'mapout_activated_deactivated'

            LOG_DEBUG_STUB("process method '%s'", "mapout_activated_deactivated");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), Mapout_activated_deactivatedRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "Mapout_activated_deactivated", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< Mapout_activated_deactivatedRequest > payload = ::boost::static_pointer_cast<Mapout_activated_deactivatedRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ApplicationSwitchStub*>(getStub())->onMapout_activated_deactivatedRequest(payload);
            return;
        }
        case 5: {

            // method 'spi_connectionstatus'

            LOG_DEBUG_STUB("process method '%s'", "spi_connectionstatus");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), Spi_connectionstatusRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "Spi_connectionstatus", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< Spi_connectionstatusRequest > payload = ::boost::static_pointer_cast<Spi_connectionstatusRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ApplicationSwitchStub*>(getStub())->onSpi_connectionstatusRequest(payload);
            return;
        }
        case 6: {

            // method 'spi_ForwardEncoder'

            LOG_DEBUG_STUB("process method '%s'", "spi_ForwardEncoder");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), Spi_ForwardEncoderRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "Spi_ForwardEncoder", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< Spi_ForwardEncoderRequest > payload = ::boost::static_pointer_cast<Spi_ForwardEncoderRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ApplicationSwitchStub*>(getStub())->onSpi_ForwardEncoderRequest(payload);
            return;
        }
        case 7: {

            // method 'RequestContextSwitch'

            LOG_DEBUG_STUB("process method '%s'", "RequestContextSwitch");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RequestContextSwitchRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "RequestContextSwitch", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< RequestContextSwitchRequest > payload = ::boost::static_pointer_cast<RequestContextSwitchRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ApplicationSwitchStub*>(getStub())->onRequestContextSwitchRequest(payload);
            return;
        }
        case 8: {

            // method 'sendContext'

            LOG_DEBUG_STUB("process method '%s'", "sendContext");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SendContextRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SendContext", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SendContextRequest > payload = ::boost::static_pointer_cast<SendContextRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ApplicationSwitchStub*>(getStub())->onSendContextRequest(payload);
            return;
        }
        case 9: {

            // method 'DisplayAppFlyInReq'

            LOG_DEBUG_STUB("process method '%s'", "DisplayAppFlyInReq");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DisplayAppFlyInReqRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "DisplayAppFlyInReq", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< DisplayAppFlyInReqRequest > payload = ::boost::static_pointer_cast<DisplayAppFlyInReqRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ApplicationSwitchStub*>(getStub())->onDisplayAppFlyInReqRequest(payload);
            return;
        }
        case 10: {

            // method 'configureAppFlyInStatus'

            LOG_DEBUG_STUB("process method '%s'", "configureAppFlyInStatus");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ConfigureAppFlyInStatusRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ConfigureAppFlyInStatus", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ConfigureAppFlyInStatusRequest > payload = ::boost::static_pointer_cast<ConfigureAppFlyInStatusRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ApplicationSwitchStub*>(getStub())->onConfigureAppFlyInStatusRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* ApplicationSwitchStubDelegate::introspect() const {
    return     "<interface name=\"bosch.cm.ai.hmi.hmimasterservice.ApplicationSwitch\">\n"
            "    <property access=\"readwrite\" name=\"activeRegionId\" type=\"y\"/>\n"
            "    <method name=\"requestApplcationSwitch\">\n"
            "      <doc>\n"
            "        <line>requestApplcationSwitch = requestApplcationSwitch = Method to request application switching</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"appID\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>appID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"response\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>response = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"requestShowHideWaitScene\">\n"
            "      <doc>\n"
            "        <line>requestShowHideWaitScene = requestShowHideWaitScene = Method to request show Wait Animation scene</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"popupshow\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>popupshow = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"response\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>response = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"activateDeactivateRVCScene\">\n"
            "      <doc>\n"
            "        <line>activateDeactivateRVCScene = activateDeactivateRVCScene = Method to request show RVC scene</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"popupshow\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>popupshow = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"response\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>response = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"speechSession_activated_deactivated\">\n"
            "      <doc>\n"
            "        <line>speechSession_activated_deactivated = speechSession_activated_deactivated = method when speech session activates or deactivates</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"status\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>status = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"response\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>response = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"mapout_activated_deactivated\">\n"
            "      <doc>\n"
            "        <line>mapout_activated_deactivated = mapout_activated_deactivated = method called when navigation application activates or deactivates mapout streaming</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"regionId\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>regionId = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"status\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>status = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"spi_connectionstatus\">\n"
            "      <doc>\n"
            "        <line>spi_connectionstatus = spi_connectionstatus = method when VR session activates or deactivates</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"status\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>status = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"response\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>response = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"spi_ForwardEncoder\">\n"
            "      <doc>\n"
            "        <line>spi_ForwardEncoder = spi_ForwardEncoder = method when Encoder Message to be forwarded</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"Encode\" type=\"i\">\n"
            "        <doc>\n"
            "          <line>Encode = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"EncodeSteps\" type=\"i\">\n"
            "        <doc>\n"
            "          <line>EncodeSteps = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"response\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>response = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"RequestContextSwitch\">\n"
            "      <doc>\n"
            "        <line>RequestContextSwitch = RequestContextSwitch = to request for change in context</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"regionId\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>regionId = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"sourceAppId\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>sourceAppId = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"sourceActivityId\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>sourceActivityId = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"targetAppId\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>targetAppId = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"targetActivityId\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>targetActivityId = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"response\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>response = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"sendContext\">\n"
            "      <doc>\n"
            "        <line>sendContext = sendSourceContext = to send source in context on request</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"regionId\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>regionId = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"sourceAppId\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>sourceAppId = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"sourceActivityId\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>sourceActivityId = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"response\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>response = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"DisplayAppFlyInReq\">\n"
            "      <doc>\n"
            "        <line>DisplayAppFlyInReq = sendSourceContext = to send source in context on request</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"status\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>status = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"configureAppFlyInStatus\">\n"
            "      <doc>\n"
            "        <line>configureAppFlyInStatus = Method to provide acknowledgement for display sync request</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"stateInfo\" type=\"a(yyysss)\">\n"
            "        <doc>\n"
            "          <line>stateInfo (of type AppFlyInStateInfoVector) = Description missing</line>\n"
            "          <line>AppFlyInStateInfoVector = array[AppFlyInStateInfo]</line>\n"
            "          <line>AppFlyInStateInfo struct[regionId, appFlyInIndex, status, bgImage, borderImage, iconImage] = Struct AppFlyInVisibilityInfo contains the information for controling the appflyin visibility</line>\n"
            "          <line>0: AppFlyInStateInfo.regionId ('y') = Description missing</line>\n"
            "          <line>1: AppFlyInStateInfo.appFlyInIndex ('y') = Description missing</line>\n"
            "          <line>2: AppFlyInStateInfo.status ('y') = Description missing</line>\n"
            "          <line>3: AppFlyInStateInfo.bgImage ('s') = Description missing</line>\n"
            "          <line>4: AppFlyInStateInfo.borderImage ('s') = Description missing</line>\n"
            "          <line>5: AppFlyInStateInfo.iconImage ('s') = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <signal name=\"Mapout_Activate_Deactivate\">\n"
            "      <doc>\n"
            "        <line>Mapout_Activate_Deactivate = Mapout_Activate_Deactivate = Method to request show MAP scene</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"regionId\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>regionId = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"mapoutshow\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>mapoutshow = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"sig_activate_spi_voicerecognition_short\">\n"
            "      <doc>\n"
            "        <line>sig_activate_spi_voicerecognition_short = sig_activate_spi_voicerecognition_short = Method to request show MAP scene</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"status\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>status = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"sig_activate_spi_voicerecognition_long\">\n"
            "      <doc>\n"
            "        <line>sig_activate_spi_voicerecognition_long = sig_activate_spi_voicerecognition_long = Method to request show MAP scene</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"status\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>status = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"sig_activate_spi_voicerecognition_short_release\">\n"
            "      <doc>\n"
            "        <line>sig_activate_spi_voicerecognition_short_release = sig_activate_spi_voicerecognition_short_release = Method to request show MAP scene</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"status\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>status = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"sig_activate_spi_voicerecognition_long_release\">\n"
            "      <doc>\n"
            "        <line>sig_activate_spi_voicerecognition_long_release = sig_activate_spi_voicerecognition_long_release = Method to request show MAP scene</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"status\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>status = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"sig_activate_deactivate_SpeechSession\">\n"
            "      <doc>\n"
            "        <line>sig_activate_deactivate_SpeechSession = sig_activate_deactivate_SpeechSession = signal to activate Speech Session when PTT button is pressed</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"status\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>status = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"sig_ControlPanelButtonPress\">\n"
            "      <doc>\n"
            "        <line>sig_ControlPanelButtonPress = sig_ControlPanelButtonPress = signal to indicate control panel button is pressed</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"buttonId\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>buttonId = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"buttonState\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>buttonState = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"receiverAppID\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>receiverAppID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"sig_ActivateContext\">\n"
            "      <doc>\n"
            "        <line>sig_ActivateContext = sig_ActivateContext = signal to activate context</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"regionId\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>regionId = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"targetappId\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>targetappId = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"targetactivityId\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>targetactivityId = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "    <signal name=\"sig_SWCKeyEvent\">\n"
            "      <doc>\n"
            "        <line>sig_SWCKeyEvent = sig_SWCKeyEvent = signal to handle SWCKeyEvent</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"keyEvent\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>keyEvent = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </signal>\n"
            "</interface>\n";
}

void ApplicationSwitchStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<ApplicationSwitchStub*>(getStub()))->onGetAll (properties);
}

void ApplicationSwitchStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 1, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "activeRegionId");
            ::boost::shared_ptr< ActiveRegionIdSet > payload(new ActiveRegionIdSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<ApplicationSwitchStub*>(getStub())->onActiveRegionIdSet (payload);
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void ApplicationSwitchStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 1, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "activeRegionId");
            ::boost::shared_ptr< ActiveRegionIdGet > payload(new ActiveRegionIdGet());
            payload->setAct(act);
            static_cast<ApplicationSwitchStub*>(getStub())->onActiveRegionIdGet (payload);
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

ApplicationSwitchStub::ApplicationSwitchStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new ApplicationSwitchStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

ApplicationSwitchStub::ApplicationSwitchStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new ApplicationSwitchStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

ApplicationSwitchStub::~ApplicationSwitchStub() {
    delete _stubDelegate;
}

void ApplicationSwitchStub::sendMapout_Activate_DeactivateSignal(uint32 regionId, bool mapoutshow) {
    if (_stubDelegate->isConnected()) {
        Mapout_Activate_DeactivateSignal* payload = new Mapout_Activate_DeactivateSignal(regionId, mapoutshow);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "Mapout_Activate_Deactivate", Mapout_Activate_DeactivateSignal, payload)
        LOG_INFO ("-> send%sSignal", "Mapout_Activate_Deactivate");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "Mapout_Activate_Deactivate");
    }
}

void ApplicationSwitchStub::sendSig_activate_spi_voicerecognition_shortSignal(bool status) {
    if (_stubDelegate->isConnected()) {
        Sig_activate_spi_voicerecognition_shortSignal* payload = new Sig_activate_spi_voicerecognition_shortSignal(status);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "sig_activate_spi_voicerecognition_short", Sig_activate_spi_voicerecognition_shortSignal, payload)
        LOG_INFO ("-> send%sSignal", "Sig_activate_spi_voicerecognition_short");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "Sig_activate_spi_voicerecognition_short");
    }
}

void ApplicationSwitchStub::sendSig_activate_spi_voicerecognition_longSignal(bool status) {
    if (_stubDelegate->isConnected()) {
        Sig_activate_spi_voicerecognition_longSignal* payload = new Sig_activate_spi_voicerecognition_longSignal(status);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "sig_activate_spi_voicerecognition_long", Sig_activate_spi_voicerecognition_longSignal, payload)
        LOG_INFO ("-> send%sSignal", "Sig_activate_spi_voicerecognition_long");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "Sig_activate_spi_voicerecognition_long");
    }
}

void ApplicationSwitchStub::sendSig_activate_spi_voicerecognition_short_releaseSignal(bool status) {
    if (_stubDelegate->isConnected()) {
        Sig_activate_spi_voicerecognition_short_releaseSignal* payload = new Sig_activate_spi_voicerecognition_short_releaseSignal(status);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "sig_activate_spi_voicerecognition_short_release", Sig_activate_spi_voicerecognition_short_releaseSignal, payload)
        LOG_INFO ("-> send%sSignal", "Sig_activate_spi_voicerecognition_short_release");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "Sig_activate_spi_voicerecognition_short_release");
    }
}

void ApplicationSwitchStub::sendSig_activate_spi_voicerecognition_long_releaseSignal(bool status) {
    if (_stubDelegate->isConnected()) {
        Sig_activate_spi_voicerecognition_long_releaseSignal* payload = new Sig_activate_spi_voicerecognition_long_releaseSignal(status);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "sig_activate_spi_voicerecognition_long_release", Sig_activate_spi_voicerecognition_long_releaseSignal, payload)
        LOG_INFO ("-> send%sSignal", "Sig_activate_spi_voicerecognition_long_release");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "Sig_activate_spi_voicerecognition_long_release");
    }
}

void ApplicationSwitchStub::sendSig_activate_deactivate_SpeechSessionSignal(bool status) {
    if (_stubDelegate->isConnected()) {
        Sig_activate_deactivate_SpeechSessionSignal* payload = new Sig_activate_deactivate_SpeechSessionSignal(status);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "sig_activate_deactivate_SpeechSession", Sig_activate_deactivate_SpeechSessionSignal, payload)
        LOG_INFO ("-> send%sSignal", "Sig_activate_deactivate_SpeechSession");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "Sig_activate_deactivate_SpeechSession");
    }
}

void ApplicationSwitchStub::sendSig_ControlPanelButtonPressSignal(uint8 buttonId, uint8 buttonState, uint32 receiverAppID) {
    if (_stubDelegate->isConnected()) {
        Sig_ControlPanelButtonPressSignal* payload = new Sig_ControlPanelButtonPressSignal(buttonId, buttonState, receiverAppID);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "sig_ControlPanelButtonPress", Sig_ControlPanelButtonPressSignal, payload)
        LOG_INFO ("-> send%sSignal", "Sig_ControlPanelButtonPress");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "Sig_ControlPanelButtonPress");
    }
}

void ApplicationSwitchStub::sendSig_ActivateContextSignal(uint8 regionId, uint8 targetappId, enActivityIDs targetactivityId) {
    if (_stubDelegate->isConnected()) {
        Sig_ActivateContextSignal* payload = new Sig_ActivateContextSignal(regionId, targetappId, targetactivityId);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "sig_ActivateContext", Sig_ActivateContextSignal, payload)
        LOG_INFO ("-> send%sSignal", "Sig_ActivateContext");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "Sig_ActivateContext");
    }
}

void ApplicationSwitchStub::sendSig_SWCKeyEventSignal(uint8 keyEvent) {
    if (_stubDelegate->isConnected()) {
        Sig_SWCKeyEventSignal* payload = new Sig_SWCKeyEventSignal(keyEvent);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "sig_SWCKeyEvent", Sig_SWCKeyEventSignal, payload)
        LOG_INFO ("-> send%sSignal", "Sig_SWCKeyEvent");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "Sig_SWCKeyEvent");
    }
}

void ApplicationSwitchStub::sendActiveRegionIdUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ActiveRegionIdUpdate payload(_activeRegionIdProperty);

        LOG_INFO ("-> send%s", "ActiveRegionIdUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("activeRegionId", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("bosch.cm.ai.hmi.hmimasterservice.ApplicationSwitch", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ActiveRegionIdUpdate");
    }
}

void ApplicationSwitchStub::onActiveRegionIdGet(const ::boost::shared_ptr< ActiveRegionIdGet >& activeRegionId) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ActiveRegionIdGet", activeRegionId->getAct());
    sendActiveRegionIdGetUpdate(_activeRegionIdProperty.getActiveRegionId(), activeRegionId->getAct());
}

void ApplicationSwitchStub::sendActiveRegionIdGetUpdate(uint8 activeRegionId, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ActiveRegionIdGet payload(activeRegionId);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ActiveRegionIdGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ApplicationSwitchStub::onActiveRegionIdSet(const ::boost::shared_ptr< ActiveRegionIdSet >& activeRegionId) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ActiveRegionIdSet", activeRegionId->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*activeRegionId, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setActiveRegionId (activeRegionId->getActiveRegionId());
    sendActiveRegionIdSetUpdate(activeRegionId->getAct());
}

void ApplicationSwitchStub::sendActiveRegionIdSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ActiveRegionIdSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void ApplicationSwitchStub::setActiveRegionId(uint8 activeRegionId) {
    if(activeRegionId!=_activeRegionIdProperty.getActiveRegionId()) {
        _activeRegionIdProperty.setActiveRegionId(activeRegionId);
        sendActiveRegionIdUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint8 ApplicationSwitchStub::getActiveRegionId() const {
    return _activeRegionIdProperty.getActiveRegionId();
}

void  ApplicationSwitchStub::sendRequestApplcationSwitchResponse (bool response, act_t act) {
    RequestApplcationSwitchResponse* payload = new RequestApplcationSwitchResponse(response);
    DBUS_MESSAGE_REPLY(dbusMessage, "requestApplcationSwitch", RequestApplcationSwitchResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "RequestApplcationSwitch", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ApplicationSwitchStub::sendRequestApplcationSwitchError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    RequestApplcationSwitchError* payload = new RequestApplcationSwitchError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "requestApplcationSwitch", RequestApplcationSwitchError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "RequestApplcationSwitch", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ApplicationSwitchStub::sendRequestShowHideWaitSceneResponse (bool response, act_t act) {
    RequestShowHideWaitSceneResponse* payload = new RequestShowHideWaitSceneResponse(response);
    DBUS_MESSAGE_REPLY(dbusMessage, "requestShowHideWaitScene", RequestShowHideWaitSceneResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "RequestShowHideWaitScene", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ApplicationSwitchStub::sendRequestShowHideWaitSceneError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    RequestShowHideWaitSceneError* payload = new RequestShowHideWaitSceneError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "requestShowHideWaitScene", RequestShowHideWaitSceneError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "RequestShowHideWaitScene", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ApplicationSwitchStub::sendActivateDeactivateRVCSceneResponse (bool response, act_t act) {
    ActivateDeactivateRVCSceneResponse* payload = new ActivateDeactivateRVCSceneResponse(response);
    DBUS_MESSAGE_REPLY(dbusMessage, "activateDeactivateRVCScene", ActivateDeactivateRVCSceneResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ActivateDeactivateRVCScene", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ApplicationSwitchStub::sendActivateDeactivateRVCSceneError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ActivateDeactivateRVCSceneError* payload = new ActivateDeactivateRVCSceneError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "activateDeactivateRVCScene", ActivateDeactivateRVCSceneError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ActivateDeactivateRVCScene", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ApplicationSwitchStub::sendSpeechSession_activated_deactivatedResponse (bool response, act_t act) {
    SpeechSession_activated_deactivatedResponse* payload = new SpeechSession_activated_deactivatedResponse(response);
    DBUS_MESSAGE_REPLY(dbusMessage, "speechSession_activated_deactivated", SpeechSession_activated_deactivatedResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SpeechSession_activated_deactivated", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ApplicationSwitchStub::sendSpeechSession_activated_deactivatedError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SpeechSession_activated_deactivatedError* payload = new SpeechSession_activated_deactivatedError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "speechSession_activated_deactivated", SpeechSession_activated_deactivatedError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SpeechSession_activated_deactivated", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ApplicationSwitchStub::sendMapout_activated_deactivatedResponse (act_t act) {
    Mapout_activated_deactivatedResponse* payload = new Mapout_activated_deactivatedResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "mapout_activated_deactivated", Mapout_activated_deactivatedResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "Mapout_activated_deactivated", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ApplicationSwitchStub::sendMapout_activated_deactivatedError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    Mapout_activated_deactivatedError* payload = new Mapout_activated_deactivatedError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "mapout_activated_deactivated", Mapout_activated_deactivatedError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "Mapout_activated_deactivated", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ApplicationSwitchStub::sendSpi_connectionstatusResponse (bool response, act_t act) {
    Spi_connectionstatusResponse* payload = new Spi_connectionstatusResponse(response);
    DBUS_MESSAGE_REPLY(dbusMessage, "spi_connectionstatus", Spi_connectionstatusResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "Spi_connectionstatus", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ApplicationSwitchStub::sendSpi_connectionstatusError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    Spi_connectionstatusError* payload = new Spi_connectionstatusError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "spi_connectionstatus", Spi_connectionstatusError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "Spi_connectionstatus", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ApplicationSwitchStub::sendSpi_ForwardEncoderResponse (bool response, act_t act) {
    Spi_ForwardEncoderResponse* payload = new Spi_ForwardEncoderResponse(response);
    DBUS_MESSAGE_REPLY(dbusMessage, "spi_ForwardEncoder", Spi_ForwardEncoderResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "Spi_ForwardEncoder", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ApplicationSwitchStub::sendSpi_ForwardEncoderError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    Spi_ForwardEncoderError* payload = new Spi_ForwardEncoderError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "spi_ForwardEncoder", Spi_ForwardEncoderError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "Spi_ForwardEncoder", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ApplicationSwitchStub::sendRequestContextSwitchResponse (bool response, act_t act) {
    RequestContextSwitchResponse* payload = new RequestContextSwitchResponse(response);
    DBUS_MESSAGE_REPLY(dbusMessage, "RequestContextSwitch", RequestContextSwitchResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "RequestContextSwitch", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ApplicationSwitchStub::sendRequestContextSwitchError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    RequestContextSwitchError* payload = new RequestContextSwitchError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "RequestContextSwitch", RequestContextSwitchError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "RequestContextSwitch", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ApplicationSwitchStub::sendSendContextResponse (bool response, act_t act) {
    SendContextResponse* payload = new SendContextResponse(response);
    DBUS_MESSAGE_REPLY(dbusMessage, "sendContext", SendContextResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SendContext", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ApplicationSwitchStub::sendSendContextError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SendContextError* payload = new SendContextError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "sendContext", SendContextError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SendContext", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ApplicationSwitchStub::sendDisplayAppFlyInReqResponse (act_t act) {
    DisplayAppFlyInReqResponse* payload = new DisplayAppFlyInReqResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "DisplayAppFlyInReq", DisplayAppFlyInReqResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "DisplayAppFlyInReq", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ApplicationSwitchStub::sendDisplayAppFlyInReqError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    DisplayAppFlyInReqError* payload = new DisplayAppFlyInReqError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "DisplayAppFlyInReq", DisplayAppFlyInReqError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "DisplayAppFlyInReq", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}


void ApplicationSwitchStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {

    //property 'activeRegionId'
    {
        ::asf::dbus::DBusVariant variant;
        ActiveRegionIdGet payload(_activeRegionIdProperty.getActiveRegionId());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("activeRegionId", variant));
    }
}

} // namespace ApplicationSwitch
} // namespace hmimasterservice
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
