/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "bosch/cm/ai/hmi/hmimasterservice/ApplicationSwitch.h"
#include "bosch/cm/ai/hmi/hmimasterservice/ApplicationSwitchConst.h"
#include "bosch/cm/ai/hmi/hmimasterservice/ApplicationSwitchDBus.h"
#include "bosch/cm/ai/hmi/hmimasterservice/ApplicationSwitchJson.h"
#include "bosch/cm/ai/hmi/hmimasterservice/ApplicationSwitchProxy.h"
#include <vector>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace hmimasterservice {
namespace ApplicationSwitch {

DEFINE_CLASS_LOGGER("/bosch/cm/ai/hmi/hmimasterservice/bosch/cm/ai/hmi/hmimasterservice/ApplicationSwitch", ApplicationSwitchProxy);

class ApplicationSwitchProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    ApplicationSwitchProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< ApplicationSwitchProxy >& proxyShared = ::boost::static_pointer_cast< ApplicationSwitchProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_Mapout_Activate_Deactivate:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), Mapout_Activate_DeactivateSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Mapout_Activate_Deactivate", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<Mapout_Activate_DeactivateSignal> payload = ::boost::static_pointer_cast<Mapout_Activate_DeactivateSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((Mapout_Activate_DeactivateCallbackIF*) _callback)->onMapout_Activate_DeactivateSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_sig_activate_spi_voicerecognition_short:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), Sig_activate_spi_voicerecognition_shortSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Sig_activate_spi_voicerecognition_short", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<Sig_activate_spi_voicerecognition_shortSignal> payload = ::boost::static_pointer_cast<Sig_activate_spi_voicerecognition_shortSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((Sig_activate_spi_voicerecognition_shortCallbackIF*) _callback)->onSig_activate_spi_voicerecognition_shortSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_sig_activate_spi_voicerecognition_long:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), Sig_activate_spi_voicerecognition_longSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Sig_activate_spi_voicerecognition_long", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<Sig_activate_spi_voicerecognition_longSignal> payload = ::boost::static_pointer_cast<Sig_activate_spi_voicerecognition_longSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((Sig_activate_spi_voicerecognition_longCallbackIF*) _callback)->onSig_activate_spi_voicerecognition_longSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_sig_activate_spi_voicerecognition_short_release:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), Sig_activate_spi_voicerecognition_short_releaseSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Sig_activate_spi_voicerecognition_short_release", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<Sig_activate_spi_voicerecognition_short_releaseSignal> payload = ::boost::static_pointer_cast<Sig_activate_spi_voicerecognition_short_releaseSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((Sig_activate_spi_voicerecognition_short_releaseCallbackIF*) _callback)->onSig_activate_spi_voicerecognition_short_releaseSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_sig_activate_spi_voicerecognition_long_release:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), Sig_activate_spi_voicerecognition_long_releaseSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Sig_activate_spi_voicerecognition_long_release", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<Sig_activate_spi_voicerecognition_long_releaseSignal> payload = ::boost::static_pointer_cast<Sig_activate_spi_voicerecognition_long_releaseSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((Sig_activate_spi_voicerecognition_long_releaseCallbackIF*) _callback)->onSig_activate_spi_voicerecognition_long_releaseSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_sig_activate_deactivate_SpeechSession:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), Sig_activate_deactivate_SpeechSessionSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Sig_activate_deactivate_SpeechSession", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<Sig_activate_deactivate_SpeechSessionSignal> payload = ::boost::static_pointer_cast<Sig_activate_deactivate_SpeechSessionSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((Sig_activate_deactivate_SpeechSessionCallbackIF*) _callback)->onSig_activate_deactivate_SpeechSessionSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_sig_ControlPanelButtonPress:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), Sig_ControlPanelButtonPressSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Sig_ControlPanelButtonPress", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<Sig_ControlPanelButtonPressSignal> payload = ::boost::static_pointer_cast<Sig_ControlPanelButtonPressSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((Sig_ControlPanelButtonPressCallbackIF*) _callback)->onSig_ControlPanelButtonPressSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_sig_ActivateContext:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), Sig_ActivateContextSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Sig_ActivateContext", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<Sig_ActivateContextSignal> payload = ::boost::static_pointer_cast<Sig_ActivateContextSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((Sig_ActivateContextCallbackIF*) _callback)->onSig_ActivateContextSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_sig_SWCKeyEvent:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), Sig_SWCKeyEventSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Sig_SWCKeyEvent", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<Sig_SWCKeyEventSignal> payload = ::boost::static_pointer_cast<Sig_SWCKeyEventSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((Sig_SWCKeyEventCallbackIF*) _callback)->onSig_SWCKeyEventSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_activeRegionId:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ActiveRegionIdError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ActiveRegionId", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ActiveRegionIdError> payload = ::boost::static_pointer_cast<ActiveRegionIdError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((ActiveRegionIdCallbackIF*) _callback)->onActiveRegionIdError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ActiveRegionIdUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ActiveRegionId", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ActiveRegionIdUpdate> payload = ::boost::static_pointer_cast<ActiveRegionIdUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((ActiveRegionIdCallbackIF*) _callback)->onActiveRegionIdUpdate(proxyShared, payload);
                        proxyShared->_activeRegionId = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_requestApplcationSwitch:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), RequestApplcationSwitchError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "RequestApplcationSwitch", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RequestApplcationSwitchError> payload = ::boost::static_pointer_cast<RequestApplcationSwitchError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RequestApplcationSwitchCallbackIF*) _callback)->onRequestApplcationSwitchError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RequestApplcationSwitchResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "RequestApplcationSwitch", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RequestApplcationSwitchResponse> payload = ::boost::static_pointer_cast<RequestApplcationSwitchResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RequestApplcationSwitchCallbackIF*) _callback)->onRequestApplcationSwitchResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_requestShowHideWaitScene:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), RequestShowHideWaitSceneError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "RequestShowHideWaitScene", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RequestShowHideWaitSceneError> payload = ::boost::static_pointer_cast<RequestShowHideWaitSceneError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RequestShowHideWaitSceneCallbackIF*) _callback)->onRequestShowHideWaitSceneError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RequestShowHideWaitSceneResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "RequestShowHideWaitScene", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RequestShowHideWaitSceneResponse> payload = ::boost::static_pointer_cast<RequestShowHideWaitSceneResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RequestShowHideWaitSceneCallbackIF*) _callback)->onRequestShowHideWaitSceneResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_activateDeactivateRVCScene:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ActivateDeactivateRVCSceneError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ActivateDeactivateRVCScene", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ActivateDeactivateRVCSceneError> payload = ::boost::static_pointer_cast<ActivateDeactivateRVCSceneError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ActivateDeactivateRVCSceneCallbackIF*) _callback)->onActivateDeactivateRVCSceneError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ActivateDeactivateRVCSceneResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "ActivateDeactivateRVCScene", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ActivateDeactivateRVCSceneResponse> payload = ::boost::static_pointer_cast<ActivateDeactivateRVCSceneResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ActivateDeactivateRVCSceneCallbackIF*) _callback)->onActivateDeactivateRVCSceneResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_speechSession_activated_deactivated:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SpeechSession_activated_deactivatedError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SpeechSession_activated_deactivated", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SpeechSession_activated_deactivatedError> payload = ::boost::static_pointer_cast<SpeechSession_activated_deactivatedError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SpeechSession_activated_deactivatedCallbackIF*) _callback)->onSpeechSession_activated_deactivatedError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SpeechSession_activated_deactivatedResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SpeechSession_activated_deactivated", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SpeechSession_activated_deactivatedResponse> payload = ::boost::static_pointer_cast<SpeechSession_activated_deactivatedResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SpeechSession_activated_deactivatedCallbackIF*) _callback)->onSpeechSession_activated_deactivatedResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_mapout_activated_deactivated:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), Mapout_activated_deactivatedError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Mapout_activated_deactivated", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<Mapout_activated_deactivatedError> payload = ::boost::static_pointer_cast<Mapout_activated_deactivatedError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((Mapout_activated_deactivatedCallbackIF*) _callback)->onMapout_activated_deactivatedError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), Mapout_activated_deactivatedResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "Mapout_activated_deactivated", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<Mapout_activated_deactivatedResponse> payload = ::boost::static_pointer_cast<Mapout_activated_deactivatedResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((Mapout_activated_deactivatedCallbackIF*) _callback)->onMapout_activated_deactivatedResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_spi_connectionstatus:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), Spi_connectionstatusError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Spi_connectionstatus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<Spi_connectionstatusError> payload = ::boost::static_pointer_cast<Spi_connectionstatusError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((Spi_connectionstatusCallbackIF*) _callback)->onSpi_connectionstatusError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), Spi_connectionstatusResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "Spi_connectionstatus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<Spi_connectionstatusResponse> payload = ::boost::static_pointer_cast<Spi_connectionstatusResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((Spi_connectionstatusCallbackIF*) _callback)->onSpi_connectionstatusResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_spi_ForwardEncoder:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), Spi_ForwardEncoderError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Spi_ForwardEncoder", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<Spi_ForwardEncoderError> payload = ::boost::static_pointer_cast<Spi_ForwardEncoderError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((Spi_ForwardEncoderCallbackIF*) _callback)->onSpi_ForwardEncoderError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), Spi_ForwardEncoderResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "Spi_ForwardEncoder", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<Spi_ForwardEncoderResponse> payload = ::boost::static_pointer_cast<Spi_ForwardEncoderResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((Spi_ForwardEncoderCallbackIF*) _callback)->onSpi_ForwardEncoderResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_RequestContextSwitch:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), RequestContextSwitchError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "RequestContextSwitch", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RequestContextSwitchError> payload = ::boost::static_pointer_cast<RequestContextSwitchError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RequestContextSwitchCallbackIF*) _callback)->onRequestContextSwitchError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RequestContextSwitchResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "RequestContextSwitch", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RequestContextSwitchResponse> payload = ::boost::static_pointer_cast<RequestContextSwitchResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RequestContextSwitchCallbackIF*) _callback)->onRequestContextSwitchResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_sendContext:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SendContextError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SendContext", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SendContextError> payload = ::boost::static_pointer_cast<SendContextError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SendContextCallbackIF*) _callback)->onSendContextError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SendContextResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SendContext", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SendContextResponse> payload = ::boost::static_pointer_cast<SendContextResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SendContextCallbackIF*) _callback)->onSendContextResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_DisplayAppFlyInReq:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), DisplayAppFlyInReqError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "DisplayAppFlyInReq", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DisplayAppFlyInReqError> payload = ::boost::static_pointer_cast<DisplayAppFlyInReqError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((DisplayAppFlyInReqCallbackIF*) _callback)->onDisplayAppFlyInReqError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DisplayAppFlyInReqResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "DisplayAppFlyInReq", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DisplayAppFlyInReqResponse> payload = ::boost::static_pointer_cast<DisplayAppFlyInReqResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((DisplayAppFlyInReqCallbackIF*) _callback)->onDisplayAppFlyInReqResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_Mapout_Activate_Deactivate: {
                ::boost::shared_ptr< Mapout_Activate_DeactivateError > payload = ::boost::shared_ptr< Mapout_Activate_DeactivateError >
                (new Mapout_Activate_DeactivateError(DBUS_ERROR_NO_SERVER, "The DBus service ApplicationSwitch is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Mapout_Activate_Deactivate", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ApplicationSwitchProxy> proxyShared = ::boost::static_pointer_cast<ApplicationSwitchProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((Mapout_Activate_DeactivateCallbackIF*) _callback)->onMapout_Activate_DeactivateError (proxyShared,payload);
                return true;
            }
            break;
            case ID_sig_activate_spi_voicerecognition_short: {
                ::boost::shared_ptr< Sig_activate_spi_voicerecognition_shortError > payload = ::boost::shared_ptr< Sig_activate_spi_voicerecognition_shortError >
                (new Sig_activate_spi_voicerecognition_shortError(DBUS_ERROR_NO_SERVER, "The DBus service ApplicationSwitch is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Sig_activate_spi_voicerecognition_short", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ApplicationSwitchProxy> proxyShared = ::boost::static_pointer_cast<ApplicationSwitchProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((Sig_activate_spi_voicerecognition_shortCallbackIF*) _callback)->onSig_activate_spi_voicerecognition_shortError (proxyShared,payload);
                return true;
            }
            break;
            case ID_sig_activate_spi_voicerecognition_long: {
                ::boost::shared_ptr< Sig_activate_spi_voicerecognition_longError > payload = ::boost::shared_ptr< Sig_activate_spi_voicerecognition_longError >
                (new Sig_activate_spi_voicerecognition_longError(DBUS_ERROR_NO_SERVER, "The DBus service ApplicationSwitch is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Sig_activate_spi_voicerecognition_long", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ApplicationSwitchProxy> proxyShared = ::boost::static_pointer_cast<ApplicationSwitchProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((Sig_activate_spi_voicerecognition_longCallbackIF*) _callback)->onSig_activate_spi_voicerecognition_longError (proxyShared,payload);
                return true;
            }
            break;
            case ID_sig_activate_spi_voicerecognition_short_release: {
                ::boost::shared_ptr< Sig_activate_spi_voicerecognition_short_releaseError > payload = ::boost::shared_ptr< Sig_activate_spi_voicerecognition_short_releaseError >
                (new Sig_activate_spi_voicerecognition_short_releaseError(DBUS_ERROR_NO_SERVER, "The DBus service ApplicationSwitch is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Sig_activate_spi_voicerecognition_short_release", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ApplicationSwitchProxy> proxyShared = ::boost::static_pointer_cast<ApplicationSwitchProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((Sig_activate_spi_voicerecognition_short_releaseCallbackIF*) _callback)->onSig_activate_spi_voicerecognition_short_releaseError (proxyShared,payload);
                return true;
            }
            break;
            case ID_sig_activate_spi_voicerecognition_long_release: {
                ::boost::shared_ptr< Sig_activate_spi_voicerecognition_long_releaseError > payload = ::boost::shared_ptr< Sig_activate_spi_voicerecognition_long_releaseError >
                (new Sig_activate_spi_voicerecognition_long_releaseError(DBUS_ERROR_NO_SERVER, "The DBus service ApplicationSwitch is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Sig_activate_spi_voicerecognition_long_release", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ApplicationSwitchProxy> proxyShared = ::boost::static_pointer_cast<ApplicationSwitchProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((Sig_activate_spi_voicerecognition_long_releaseCallbackIF*) _callback)->onSig_activate_spi_voicerecognition_long_releaseError (proxyShared,payload);
                return true;
            }
            break;
            case ID_sig_activate_deactivate_SpeechSession: {
                ::boost::shared_ptr< Sig_activate_deactivate_SpeechSessionError > payload = ::boost::shared_ptr< Sig_activate_deactivate_SpeechSessionError >
                (new Sig_activate_deactivate_SpeechSessionError(DBUS_ERROR_NO_SERVER, "The DBus service ApplicationSwitch is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Sig_activate_deactivate_SpeechSession", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ApplicationSwitchProxy> proxyShared = ::boost::static_pointer_cast<ApplicationSwitchProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((Sig_activate_deactivate_SpeechSessionCallbackIF*) _callback)->onSig_activate_deactivate_SpeechSessionError (proxyShared,payload);
                return true;
            }
            break;
            case ID_sig_ControlPanelButtonPress: {
                ::boost::shared_ptr< Sig_ControlPanelButtonPressError > payload = ::boost::shared_ptr< Sig_ControlPanelButtonPressError >
                (new Sig_ControlPanelButtonPressError(DBUS_ERROR_NO_SERVER, "The DBus service ApplicationSwitch is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Sig_ControlPanelButtonPress", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ApplicationSwitchProxy> proxyShared = ::boost::static_pointer_cast<ApplicationSwitchProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((Sig_ControlPanelButtonPressCallbackIF*) _callback)->onSig_ControlPanelButtonPressError (proxyShared,payload);
                return true;
            }
            break;
            case ID_sig_ActivateContext: {
                ::boost::shared_ptr< Sig_ActivateContextError > payload = ::boost::shared_ptr< Sig_ActivateContextError >
                (new Sig_ActivateContextError(DBUS_ERROR_NO_SERVER, "The DBus service ApplicationSwitch is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Sig_ActivateContext", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ApplicationSwitchProxy> proxyShared = ::boost::static_pointer_cast<ApplicationSwitchProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((Sig_ActivateContextCallbackIF*) _callback)->onSig_ActivateContextError (proxyShared,payload);
                return true;
            }
            break;
            case ID_sig_SWCKeyEvent: {
                ::boost::shared_ptr< Sig_SWCKeyEventError > payload = ::boost::shared_ptr< Sig_SWCKeyEventError >
                (new Sig_SWCKeyEventError(DBUS_ERROR_NO_SERVER, "The DBus service ApplicationSwitch is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Sig_SWCKeyEvent", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ApplicationSwitchProxy> proxyShared = ::boost::static_pointer_cast<ApplicationSwitchProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((Sig_SWCKeyEventCallbackIF*) _callback)->onSig_SWCKeyEventError (proxyShared,payload);
                return true;
            }
            break;
            case ID_activeRegionId: {
                ::boost::shared_ptr< ActiveRegionIdError > payload = ::boost::shared_ptr< ActiveRegionIdError >
                (new ActiveRegionIdError(DBUS_ERROR_NO_SERVER, "The DBus service ApplicationSwitch is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ActiveRegionId", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ApplicationSwitchProxy> proxyShared = ::boost::static_pointer_cast<ApplicationSwitchProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ActiveRegionIdCallbackIF*) _callback)->onActiveRegionIdError (proxyShared,payload);
                return true;
            }
            break;
            case ID_requestApplcationSwitch: {
                ::boost::shared_ptr< RequestApplcationSwitchError > payload = ::boost::shared_ptr< RequestApplcationSwitchError >
                (new RequestApplcationSwitchError(DBUS_ERROR_NO_SERVER, "The DBus service ApplicationSwitch is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RequestApplcationSwitch", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ApplicationSwitchProxy> proxyShared = ::boost::static_pointer_cast<ApplicationSwitchProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RequestApplcationSwitchCallbackIF*) _callback)->onRequestApplcationSwitchError (proxyShared,payload);
                return true;
            }
            break;
            case ID_requestShowHideWaitScene: {
                ::boost::shared_ptr< RequestShowHideWaitSceneError > payload = ::boost::shared_ptr< RequestShowHideWaitSceneError >
                (new RequestShowHideWaitSceneError(DBUS_ERROR_NO_SERVER, "The DBus service ApplicationSwitch is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RequestShowHideWaitScene", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ApplicationSwitchProxy> proxyShared = ::boost::static_pointer_cast<ApplicationSwitchProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RequestShowHideWaitSceneCallbackIF*) _callback)->onRequestShowHideWaitSceneError (proxyShared,payload);
                return true;
            }
            break;
            case ID_activateDeactivateRVCScene: {
                ::boost::shared_ptr< ActivateDeactivateRVCSceneError > payload = ::boost::shared_ptr< ActivateDeactivateRVCSceneError >
                (new ActivateDeactivateRVCSceneError(DBUS_ERROR_NO_SERVER, "The DBus service ApplicationSwitch is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ActivateDeactivateRVCScene", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ApplicationSwitchProxy> proxyShared = ::boost::static_pointer_cast<ApplicationSwitchProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ActivateDeactivateRVCSceneCallbackIF*) _callback)->onActivateDeactivateRVCSceneError (proxyShared,payload);
                return true;
            }
            break;
            case ID_speechSession_activated_deactivated: {
                ::boost::shared_ptr< SpeechSession_activated_deactivatedError > payload = ::boost::shared_ptr< SpeechSession_activated_deactivatedError >
                (new SpeechSession_activated_deactivatedError(DBUS_ERROR_NO_SERVER, "The DBus service ApplicationSwitch is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SpeechSession_activated_deactivated", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ApplicationSwitchProxy> proxyShared = ::boost::static_pointer_cast<ApplicationSwitchProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SpeechSession_activated_deactivatedCallbackIF*) _callback)->onSpeechSession_activated_deactivatedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_mapout_activated_deactivated: {
                ::boost::shared_ptr< Mapout_activated_deactivatedError > payload = ::boost::shared_ptr< Mapout_activated_deactivatedError >
                (new Mapout_activated_deactivatedError(DBUS_ERROR_NO_SERVER, "The DBus service ApplicationSwitch is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Mapout_activated_deactivated", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ApplicationSwitchProxy> proxyShared = ::boost::static_pointer_cast<ApplicationSwitchProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((Mapout_activated_deactivatedCallbackIF*) _callback)->onMapout_activated_deactivatedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_spi_connectionstatus: {
                ::boost::shared_ptr< Spi_connectionstatusError > payload = ::boost::shared_ptr< Spi_connectionstatusError >
                (new Spi_connectionstatusError(DBUS_ERROR_NO_SERVER, "The DBus service ApplicationSwitch is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Spi_connectionstatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ApplicationSwitchProxy> proxyShared = ::boost::static_pointer_cast<ApplicationSwitchProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((Spi_connectionstatusCallbackIF*) _callback)->onSpi_connectionstatusError (proxyShared,payload);
                return true;
            }
            break;
            case ID_spi_ForwardEncoder: {
                ::boost::shared_ptr< Spi_ForwardEncoderError > payload = ::boost::shared_ptr< Spi_ForwardEncoderError >
                (new Spi_ForwardEncoderError(DBUS_ERROR_NO_SERVER, "The DBus service ApplicationSwitch is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Spi_ForwardEncoder", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ApplicationSwitchProxy> proxyShared = ::boost::static_pointer_cast<ApplicationSwitchProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((Spi_ForwardEncoderCallbackIF*) _callback)->onSpi_ForwardEncoderError (proxyShared,payload);
                return true;
            }
            break;
            case ID_RequestContextSwitch: {
                ::boost::shared_ptr< RequestContextSwitchError > payload = ::boost::shared_ptr< RequestContextSwitchError >
                (new RequestContextSwitchError(DBUS_ERROR_NO_SERVER, "The DBus service ApplicationSwitch is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RequestContextSwitch", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ApplicationSwitchProxy> proxyShared = ::boost::static_pointer_cast<ApplicationSwitchProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RequestContextSwitchCallbackIF*) _callback)->onRequestContextSwitchError (proxyShared,payload);
                return true;
            }
            break;
            case ID_sendContext: {
                ::boost::shared_ptr< SendContextError > payload = ::boost::shared_ptr< SendContextError >
                (new SendContextError(DBUS_ERROR_NO_SERVER, "The DBus service ApplicationSwitch is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SendContext", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ApplicationSwitchProxy> proxyShared = ::boost::static_pointer_cast<ApplicationSwitchProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SendContextCallbackIF*) _callback)->onSendContextError (proxyShared,payload);
                return true;
            }
            break;
            case ID_DisplayAppFlyInReq: {
                ::boost::shared_ptr< DisplayAppFlyInReqError > payload = ::boost::shared_ptr< DisplayAppFlyInReqError >
                (new DisplayAppFlyInReqError(DBUS_ERROR_NO_SERVER, "The DBus service ApplicationSwitch is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "DisplayAppFlyInReq", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ApplicationSwitchProxy> proxyShared = ::boost::static_pointer_cast<ApplicationSwitchProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((DisplayAppFlyInReqCallbackIF*) _callback)->onDisplayAppFlyInReqError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& ApplicationSwitchProxyCallback::_logger (ApplicationSwitchProxy::_logger);

ApplicationSwitchProxy::ApplicationSwitchProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "bosch.cm.ai.hmi.hmimasterservice.ApplicationSwitch", serviceAvailable, _logger) {
}

ApplicationSwitchProxy::~ApplicationSwitchProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< ApplicationSwitchProxy > ApplicationSwitchProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<ApplicationSwitchProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< ApplicationSwitchProxy > proxyNew(new ApplicationSwitchProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(true);
    return proxyNew;
}

act_t ApplicationSwitchProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    ApplicationSwitchProxyCallback* callback = new ApplicationSwitchProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t ApplicationSwitchProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    ApplicationSwitchProxyCallback* callback = new ApplicationSwitchProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void ApplicationSwitchProxy::clearAllProperties ()
{
    _activeRegionId = ::asf::core::nullable< ActiveRegionIdUpdate >();
}

void ApplicationSwitchProxy::sendDeregisterAll () const
{
    sendActiveRegionIdDeregisterAll();
    sendMapout_Activate_DeactivateDeregisterAll();
    sendSig_activate_spi_voicerecognition_shortDeregisterAll();
    sendSig_activate_spi_voicerecognition_longDeregisterAll();
    sendSig_activate_spi_voicerecognition_short_releaseDeregisterAll();
    sendSig_activate_spi_voicerecognition_long_releaseDeregisterAll();
    sendSig_activate_deactivate_SpeechSessionDeregisterAll();
    sendSig_ControlPanelButtonPressDeregisterAll();
    sendSig_ActivateContextDeregisterAll();
    sendSig_SWCKeyEventDeregisterAll();
}

act_t ApplicationSwitchProxy::sendMapout_Activate_DeactivateRegister(Mapout_Activate_DeactivateCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "Mapout_Activate_Deactivate");
    act_t act = addSignalCallback(ID_Mapout_Activate_Deactivate, "Mapout_Activate_Deactivate", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Mapout_Activate_Deactivate", &cb, act);
    return act;
}

bool ApplicationSwitchProxy::sendMapout_Activate_DeactivateDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Mapout_Activate_Deactivate", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Mapout_Activate_Deactivate", act, static_cast<int>(rv));
    return rv;
}

void ApplicationSwitchProxy::sendMapout_Activate_DeactivateDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Mapout_Activate_Deactivate");
    _dbusProxyDelegate->deregisterSignalCallback("Mapout_Activate_Deactivate", 0, _dbusDaemonProxy.get(), false);
}

act_t ApplicationSwitchProxy::sendSig_activate_spi_voicerecognition_shortRegister(Sig_activate_spi_voicerecognition_shortCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "sig_activate_spi_voicerecognition_short");
    act_t act = addSignalCallback(ID_sig_activate_spi_voicerecognition_short, "sig_activate_spi_voicerecognition_short", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Sig_activate_spi_voicerecognition_short", &cb, act);
    return act;
}

bool ApplicationSwitchProxy::sendSig_activate_spi_voicerecognition_shortDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("sig_activate_spi_voicerecognition_short", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Sig_activate_spi_voicerecognition_short", act, static_cast<int>(rv));
    return rv;
}

void ApplicationSwitchProxy::sendSig_activate_spi_voicerecognition_shortDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Sig_activate_spi_voicerecognition_short");
    _dbusProxyDelegate->deregisterSignalCallback("sig_activate_spi_voicerecognition_short", 0, _dbusDaemonProxy.get(), false);
}

act_t ApplicationSwitchProxy::sendSig_activate_spi_voicerecognition_longRegister(Sig_activate_spi_voicerecognition_longCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "sig_activate_spi_voicerecognition_long");
    act_t act = addSignalCallback(ID_sig_activate_spi_voicerecognition_long, "sig_activate_spi_voicerecognition_long", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Sig_activate_spi_voicerecognition_long", &cb, act);
    return act;
}

bool ApplicationSwitchProxy::sendSig_activate_spi_voicerecognition_longDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("sig_activate_spi_voicerecognition_long", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Sig_activate_spi_voicerecognition_long", act, static_cast<int>(rv));
    return rv;
}

void ApplicationSwitchProxy::sendSig_activate_spi_voicerecognition_longDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Sig_activate_spi_voicerecognition_long");
    _dbusProxyDelegate->deregisterSignalCallback("sig_activate_spi_voicerecognition_long", 0, _dbusDaemonProxy.get(), false);
}

act_t ApplicationSwitchProxy::sendSig_activate_spi_voicerecognition_short_releaseRegister(Sig_activate_spi_voicerecognition_short_releaseCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "sig_activate_spi_voicerecognition_short_release");
    act_t act = addSignalCallback(ID_sig_activate_spi_voicerecognition_short_release, "sig_activate_spi_voicerecognition_short_release", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Sig_activate_spi_voicerecognition_short_release", &cb, act);
    return act;
}

bool ApplicationSwitchProxy::sendSig_activate_spi_voicerecognition_short_releaseDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("sig_activate_spi_voicerecognition_short_release", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Sig_activate_spi_voicerecognition_short_release", act, static_cast<int>(rv));
    return rv;
}

void ApplicationSwitchProxy::sendSig_activate_spi_voicerecognition_short_releaseDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Sig_activate_spi_voicerecognition_short_release");
    _dbusProxyDelegate->deregisterSignalCallback("sig_activate_spi_voicerecognition_short_release", 0, _dbusDaemonProxy.get(), false);
}

act_t ApplicationSwitchProxy::sendSig_activate_spi_voicerecognition_long_releaseRegister(Sig_activate_spi_voicerecognition_long_releaseCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "sig_activate_spi_voicerecognition_long_release");
    act_t act = addSignalCallback(ID_sig_activate_spi_voicerecognition_long_release, "sig_activate_spi_voicerecognition_long_release", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Sig_activate_spi_voicerecognition_long_release", &cb, act);
    return act;
}

bool ApplicationSwitchProxy::sendSig_activate_spi_voicerecognition_long_releaseDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("sig_activate_spi_voicerecognition_long_release", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Sig_activate_spi_voicerecognition_long_release", act, static_cast<int>(rv));
    return rv;
}

void ApplicationSwitchProxy::sendSig_activate_spi_voicerecognition_long_releaseDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Sig_activate_spi_voicerecognition_long_release");
    _dbusProxyDelegate->deregisterSignalCallback("sig_activate_spi_voicerecognition_long_release", 0, _dbusDaemonProxy.get(), false);
}

act_t ApplicationSwitchProxy::sendSig_activate_deactivate_SpeechSessionRegister(Sig_activate_deactivate_SpeechSessionCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "sig_activate_deactivate_SpeechSession");
    act_t act = addSignalCallback(ID_sig_activate_deactivate_SpeechSession, "sig_activate_deactivate_SpeechSession", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Sig_activate_deactivate_SpeechSession", &cb, act);
    return act;
}

bool ApplicationSwitchProxy::sendSig_activate_deactivate_SpeechSessionDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("sig_activate_deactivate_SpeechSession", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Sig_activate_deactivate_SpeechSession", act, static_cast<int>(rv));
    return rv;
}

void ApplicationSwitchProxy::sendSig_activate_deactivate_SpeechSessionDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Sig_activate_deactivate_SpeechSession");
    _dbusProxyDelegate->deregisterSignalCallback("sig_activate_deactivate_SpeechSession", 0, _dbusDaemonProxy.get(), false);
}

act_t ApplicationSwitchProxy::sendSig_ControlPanelButtonPressRegister(Sig_ControlPanelButtonPressCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "sig_ControlPanelButtonPress");
    act_t act = addSignalCallback(ID_sig_ControlPanelButtonPress, "sig_ControlPanelButtonPress", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Sig_ControlPanelButtonPress", &cb, act);
    return act;
}

bool ApplicationSwitchProxy::sendSig_ControlPanelButtonPressDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("sig_ControlPanelButtonPress", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Sig_ControlPanelButtonPress", act, static_cast<int>(rv));
    return rv;
}

void ApplicationSwitchProxy::sendSig_ControlPanelButtonPressDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Sig_ControlPanelButtonPress");
    _dbusProxyDelegate->deregisterSignalCallback("sig_ControlPanelButtonPress", 0, _dbusDaemonProxy.get(), false);
}

act_t ApplicationSwitchProxy::sendSig_ActivateContextRegister(Sig_ActivateContextCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "sig_ActivateContext");
    act_t act = addSignalCallback(ID_sig_ActivateContext, "sig_ActivateContext", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Sig_ActivateContext", &cb, act);
    return act;
}

bool ApplicationSwitchProxy::sendSig_ActivateContextDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("sig_ActivateContext", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Sig_ActivateContext", act, static_cast<int>(rv));
    return rv;
}

void ApplicationSwitchProxy::sendSig_ActivateContextDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Sig_ActivateContext");
    _dbusProxyDelegate->deregisterSignalCallback("sig_ActivateContext", 0, _dbusDaemonProxy.get(), false);
}

act_t ApplicationSwitchProxy::sendSig_SWCKeyEventRegister(Sig_SWCKeyEventCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "sig_SWCKeyEvent");
    act_t act = addSignalCallback(ID_sig_SWCKeyEvent, "sig_SWCKeyEvent", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Sig_SWCKeyEvent", &cb, act);
    return act;
}

bool ApplicationSwitchProxy::sendSig_SWCKeyEventDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("sig_SWCKeyEvent", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Sig_SWCKeyEvent", act, static_cast<int>(rv));
    return rv;
}

void ApplicationSwitchProxy::sendSig_SWCKeyEventDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Sig_SWCKeyEvent");
    _dbusProxyDelegate->deregisterSignalCallback("sig_SWCKeyEvent", 0, _dbusDaemonProxy.get(), false);
}

act_t ApplicationSwitchProxy::sendActiveRegionIdRegister(ActiveRegionIdCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_activeRegionId, "activeRegionId", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ActiveRegionId", &cb, act);
    return act;
}

bool ApplicationSwitchProxy::sendActiveRegionIdDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("activeRegionId", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ActiveRegionId", act, static_cast<int>(rv));
    return rv;
}

act_t ApplicationSwitchProxy::sendActiveRegionIdGet(ActiveRegionIdCallbackIF& cb) {
    ApplicationSwitchProxyCallback* callback = new ApplicationSwitchProxyCallback(ID_activeRegionId, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "ActiveRegionId", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("activeRegionId", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void ApplicationSwitchProxy::sendActiveRegionIdSet(uint8 activeRegionId) {
    ActiveRegionIdSet parameter(activeRegionId);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "ActiveRegionId");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "activeRegionId", propertyContent);
}

act_t ApplicationSwitchProxy::sendActiveRegionIdSet(ActiveRegionIdCallbackIF& cb, uint8 activeRegionId) {
    ApplicationSwitchProxyCallback* callback = new ApplicationSwitchProxyCallback(ID_activeRegionId, &cb);
    ActiveRegionIdSet parameter(activeRegionId);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "ActiveRegionId", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "activeRegionId", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

uint8 ApplicationSwitchProxy::getActiveRegionId() const {
    return _activeRegionId.get().getActiveRegionId();
}

bool ApplicationSwitchProxy::hasActiveRegionId() const {
    return _activeRegionId.hasValue();
}

void ApplicationSwitchProxy::sendActiveRegionIdDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ActiveRegionId");
    _dbusProxyDelegate->deregisterSignalCallback("activeRegionId", 0, _dbusDaemonProxy.get(), true);
}

act_t ApplicationSwitchProxy::sendRequestApplcationSwitchRequest(RequestApplcationSwitchCallbackIF& cb, uint8 appID) const {
    RequestApplcationSwitchRequest* payload = new RequestApplcationSwitchRequest();
    CHECK_ALLOCATION(payload);
    payload->setAppID(appID);
    DBUS_MESSAGE_CALL(dbusMessage, "requestApplcationSwitch", RequestApplcationSwitchRequest, payload, true)
    act_t act = addMethodCallback(ID_requestApplcationSwitch, dbusMessage.getUniqueSerial(), "requestApplcationSwitch", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "RequestApplcationSwitch", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ApplicationSwitchProxy::sendRequestShowHideWaitSceneRequest(RequestShowHideWaitSceneCallbackIF& cb, bool popupshow) const {
    RequestShowHideWaitSceneRequest* payload = new RequestShowHideWaitSceneRequest();
    CHECK_ALLOCATION(payload);
    payload->setPopupshow(popupshow);
    DBUS_MESSAGE_CALL(dbusMessage, "requestShowHideWaitScene", RequestShowHideWaitSceneRequest, payload, true)
    act_t act = addMethodCallback(ID_requestShowHideWaitScene, dbusMessage.getUniqueSerial(), "requestShowHideWaitScene", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "RequestShowHideWaitScene", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ApplicationSwitchProxy::sendActivateDeactivateRVCSceneRequest(ActivateDeactivateRVCSceneCallbackIF& cb, bool popupshow) const {
    ActivateDeactivateRVCSceneRequest* payload = new ActivateDeactivateRVCSceneRequest();
    CHECK_ALLOCATION(payload);
    payload->setPopupshow(popupshow);
    DBUS_MESSAGE_CALL(dbusMessage, "activateDeactivateRVCScene", ActivateDeactivateRVCSceneRequest, payload, true)
    act_t act = addMethodCallback(ID_activateDeactivateRVCScene, dbusMessage.getUniqueSerial(), "activateDeactivateRVCScene", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "ActivateDeactivateRVCScene", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ApplicationSwitchProxy::sendSpeechSession_activated_deactivatedRequest(SpeechSession_activated_deactivatedCallbackIF& cb, bool status) const {
    SpeechSession_activated_deactivatedRequest* payload = new SpeechSession_activated_deactivatedRequest();
    CHECK_ALLOCATION(payload);
    payload->setStatus(status);
    DBUS_MESSAGE_CALL(dbusMessage, "speechSession_activated_deactivated", SpeechSession_activated_deactivatedRequest, payload, true)
    act_t act = addMethodCallback(ID_speechSession_activated_deactivated, dbusMessage.getUniqueSerial(), "speechSession_activated_deactivated", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SpeechSession_activated_deactivated", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ApplicationSwitchProxy::sendMapout_activated_deactivatedRequest(Mapout_activated_deactivatedCallbackIF& cb, uint32 regionId, bool status) const {
    Mapout_activated_deactivatedRequest* payload = new Mapout_activated_deactivatedRequest();
    CHECK_ALLOCATION(payload);
    payload->setRegionId(regionId);
    payload->setStatus(status);
    DBUS_MESSAGE_CALL(dbusMessage, "mapout_activated_deactivated", Mapout_activated_deactivatedRequest, payload, true)
    act_t act = addMethodCallback(ID_mapout_activated_deactivated, dbusMessage.getUniqueSerial(), "mapout_activated_deactivated", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "Mapout_activated_deactivated", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ApplicationSwitchProxy::sendSpi_connectionstatusRequest(Spi_connectionstatusCallbackIF& cb, bool status) const {
    Spi_connectionstatusRequest* payload = new Spi_connectionstatusRequest();
    CHECK_ALLOCATION(payload);
    payload->setStatus(status);
    DBUS_MESSAGE_CALL(dbusMessage, "spi_connectionstatus", Spi_connectionstatusRequest, payload, true)
    act_t act = addMethodCallback(ID_spi_connectionstatus, dbusMessage.getUniqueSerial(), "spi_connectionstatus", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "Spi_connectionstatus", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ApplicationSwitchProxy::sendSpi_ForwardEncoderRequest(Spi_ForwardEncoderCallbackIF& cb, int32 encode, int32 encodeSteps) const {
    Spi_ForwardEncoderRequest* payload = new Spi_ForwardEncoderRequest();
    CHECK_ALLOCATION(payload);
    payload->setEncode(encode);
    payload->setEncodeSteps(encodeSteps);
    DBUS_MESSAGE_CALL(dbusMessage, "spi_ForwardEncoder", Spi_ForwardEncoderRequest, payload, true)
    act_t act = addMethodCallback(ID_spi_ForwardEncoder, dbusMessage.getUniqueSerial(), "spi_ForwardEncoder", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "Spi_ForwardEncoder", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ApplicationSwitchProxy::sendRequestContextSwitchRequest(RequestContextSwitchCallbackIF& cb, uint8 regionId, uint8 sourceAppId, enActivityIDs sourceActivityId, uint8 targetAppId, enActivityIDs targetActivityId) const {
    RequestContextSwitchRequest* payload = new RequestContextSwitchRequest();
    CHECK_ALLOCATION(payload);
    payload->setRegionId(regionId);
    payload->setSourceAppId(sourceAppId);
    payload->setSourceActivityId(sourceActivityId);
    payload->setTargetAppId(targetAppId);
    payload->setTargetActivityId(targetActivityId);
    DBUS_MESSAGE_CALL(dbusMessage, "RequestContextSwitch", RequestContextSwitchRequest, payload, true)
    act_t act = addMethodCallback(ID_RequestContextSwitch, dbusMessage.getUniqueSerial(), "RequestContextSwitch", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "RequestContextSwitch", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ApplicationSwitchProxy::sendSendContextRequest(SendContextCallbackIF& cb, uint8 regionId, uint8 sourceAppId, enActivityIDs sourceActivityId) const {
    SendContextRequest* payload = new SendContextRequest();
    CHECK_ALLOCATION(payload);
    payload->setRegionId(regionId);
    payload->setSourceAppId(sourceAppId);
    payload->setSourceActivityId(sourceActivityId);
    DBUS_MESSAGE_CALL(dbusMessage, "sendContext", SendContextRequest, payload, true)
    act_t act = addMethodCallback(ID_sendContext, dbusMessage.getUniqueSerial(), "sendContext", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SendContext", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ApplicationSwitchProxy::sendDisplayAppFlyInReqRequest(DisplayAppFlyInReqCallbackIF& cb, bool status) const {
    DisplayAppFlyInReqRequest* payload = new DisplayAppFlyInReqRequest();
    CHECK_ALLOCATION(payload);
    payload->setStatus(status);
    DBUS_MESSAGE_CALL(dbusMessage, "DisplayAppFlyInReq", DisplayAppFlyInReqRequest, payload, true)
    act_t act = addMethodCallback(ID_DisplayAppFlyInReq, dbusMessage.getUniqueSerial(), "DisplayAppFlyInReq", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "DisplayAppFlyInReq", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ApplicationSwitchProxy::sendConfigureAppFlyInStatusRequest(const ::std::vector< AppFlyInStateInfo >& stateInfo) const {
    ConfigureAppFlyInStatusRequest* payload = new ConfigureAppFlyInStatusRequest();
    CHECK_ALLOCATION(payload);
    payload->setStateInfo(stateInfo);
    DBUS_MESSAGE_CALL(dbusMessage, "configureAppFlyInStatus", ConfigureAppFlyInStatusRequest, payload, false)
    LOG_INFO ("-> send%sRequest", "ConfigureAppFlyInStatus");
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return 0;
}

} // namespace ApplicationSwitch
} // namespace hmimasterservice
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch
