#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef BOSCH_CM_AI_HMI_HMIMASTERSERVICE_APPLICATIONSWITCH_H
#define BOSCH_CM_AI_HMI_HMIMASTERSERVICE_APPLICATIONSWITCH_H

#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include "bosch/cm/ai/hmi/hmimasterservice/ApplicationSwitchConst.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * If the meaning of "bosch.cm.ai.hmi.hmimasterservice.ApplicationSwitch" isn't clear, then there should be a description here.
 */

namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace hmimasterservice {
namespace ApplicationSwitch {

// method IDs
static const uint16 ID_requestApplcationSwitch = 0;
static const uint16 ID_requestShowHideWaitScene = 1;
static const uint16 ID_activateDeactivateRVCScene = 2;
static const uint16 ID_speechSession_activated_deactivated = 3;
static const uint16 ID_mapout_activated_deactivated = 4;
static const uint16 ID_spi_connectionstatus = 5;
static const uint16 ID_spi_ForwardEncoder = 6;
static const uint16 ID_RequestContextSwitch = 7;
static const uint16 ID_sendContext = 8;
static const uint16 ID_DisplayAppFlyInReq = 9;
static const uint16 ID_configureAppFlyInStatus = 10;

// signal IDs
static const uint16 ID_Mapout_Activate_Deactivate = 11;
static const uint16 ID_sig_activate_spi_voicerecognition_short = 12;
static const uint16 ID_sig_activate_spi_voicerecognition_long = 13;
static const uint16 ID_sig_activate_spi_voicerecognition_short_release = 14;
static const uint16 ID_sig_activate_spi_voicerecognition_long_release = 15;
static const uint16 ID_sig_activate_deactivate_SpeechSession = 16;
static const uint16 ID_sig_ControlPanelButtonPress = 17;
static const uint16 ID_sig_ActivateContext = 18;
static const uint16 ID_sig_SWCKeyEvent = 19;

// property IDs
static const uint16 ID_activeRegionId = 20;

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class AppFlyInStateInfo;

class RequestApplcationSwitchRequest;

class RequestApplcationSwitchResponse;

class RequestShowHideWaitSceneRequest;

class RequestShowHideWaitSceneResponse;

class ActivateDeactivateRVCSceneRequest;

class ActivateDeactivateRVCSceneResponse;

class SpeechSession_activated_deactivatedRequest;

class SpeechSession_activated_deactivatedResponse;

class Mapout_activated_deactivatedRequest;

class Spi_connectionstatusRequest;

class Spi_connectionstatusResponse;

class Spi_ForwardEncoderRequest;

class Spi_ForwardEncoderResponse;

class RequestContextSwitchRequest;

class RequestContextSwitchResponse;

class SendContextRequest;

class SendContextResponse;

class DisplayAppFlyInReqRequest;

class ConfigureAppFlyInStatusRequest;

class ActiveRegionIdUpdate;

class ActiveRegionIdRegister;

class Mapout_Activate_DeactivateSignal;

class Sig_activate_spi_voicerecognition_shortSignal;

class Sig_activate_spi_voicerecognition_longSignal;

class Sig_activate_spi_voicerecognition_short_releaseSignal;

class Sig_activate_spi_voicerecognition_long_releaseSignal;

class Sig_activate_deactivate_SpeechSessionSignal;

class Sig_ControlPanelButtonPressSignal;

class Sig_ActivateContextSignal;

class Sig_SWCKeyEventSignal;

// type definitions
/**
 * If the meaning of "RequestApplcationSwitchError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RequestApplcationSwitchError;

/**
 * If the meaning of "RequestShowHideWaitSceneError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RequestShowHideWaitSceneError;

/**
 * If the meaning of "ActivateDeactivateRVCSceneError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ActivateDeactivateRVCSceneError;

/**
 * If the meaning of "SpeechSession_activated_deactivatedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SpeechSession_activated_deactivatedError;

/**
 * mapout_activated_deactivated = method called when navigation application activates or deactivates mapout streaming
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage Mapout_activated_deactivatedResponse;

/**
 * If the meaning of "Mapout_activated_deactivatedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError Mapout_activated_deactivatedError;

/**
 * If the meaning of "Spi_connectionstatusError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError Spi_connectionstatusError;

/**
 * If the meaning of "Spi_ForwardEncoderError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError Spi_ForwardEncoderError;

/**
 * If the meaning of "RequestContextSwitchError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RequestContextSwitchError;

/**
 * If the meaning of "SendContextError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SendContextError;

/**
 * sendSourceContext = to send source in context on request
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage DisplayAppFlyInReqResponse;

/**
 * If the meaning of "DisplayAppFlyInReqError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DisplayAppFlyInReqError;

/**
 * Method to provide acknowledgement for display sync request
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ConfigureAppFlyInStatusResponse;

/**
 * If the meaning of "ConfigureAppFlyInStatusError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ConfigureAppFlyInStatusError;

/**
 * activeRegionId = to indicate change in active RegionId
 */
typedef ActiveRegionIdUpdate ActiveRegionIdSet;

/**
 * activeRegionId = to indicate change in active RegionId
 */
typedef ActiveRegionIdUpdate ActiveRegionIdGet;

/**
 * If the meaning of "ActiveRegionIdError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ActiveRegionIdError;

/**
 * If the meaning of "Mapout_Activate_DeactivateError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError Mapout_Activate_DeactivateError;

/**
 * If the meaning of "Sig_activate_spi_voicerecognition_shortError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError Sig_activate_spi_voicerecognition_shortError;

/**
 * If the meaning of "Sig_activate_spi_voicerecognition_longError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError Sig_activate_spi_voicerecognition_longError;

/**
 * If the meaning of "Sig_activate_spi_voicerecognition_short_releaseError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError Sig_activate_spi_voicerecognition_short_releaseError;

/**
 * If the meaning of "Sig_activate_spi_voicerecognition_long_releaseError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError Sig_activate_spi_voicerecognition_long_releaseError;

/**
 * If the meaning of "Sig_activate_deactivate_SpeechSessionError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError Sig_activate_deactivate_SpeechSessionError;

/**
 * If the meaning of "Sig_ControlPanelButtonPressError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError Sig_ControlPanelButtonPressError;

/**
 * If the meaning of "Sig_ActivateContextError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError Sig_ActivateContextError;

/**
 * If the meaning of "Sig_SWCKeyEventError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError Sig_SWCKeyEventError;


/**
 * Struct AppFlyInVisibilityInfo contains the information for controling the appflyin visibility
 */
class AppFlyInStateInfo {
public:

    /**
     * Default constructor
     */
    inline  AppFlyInStateInfo ();

    /**
     * Copy constructor
     */
    inline  AppFlyInStateInfo (const AppFlyInStateInfo &rhs);

    /**
     * All fields constructor
     */
    inline  AppFlyInStateInfo (uint8 regionId_, uint8 appFlyInIndex_, uint8 status_, const ::std::string& bgImage_, const ::std::string& borderImage_, const ::std::string& iconImage_);

    /**
     * Destructor
     */
    inline  ~AppFlyInStateInfo();

    /**
     * Assignment operator
     */
    inline AppFlyInStateInfo& operator = (const AppFlyInStateInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AppFlyInStateInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AppFlyInStateInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AppFlyInStateInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AppFlyInStateInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "regionId"

    static const int kRegionId = 0;

    /**
     * Clears the field "regionId".
     *
     * The field will be set to its default value. The hasRegionId()
     * method will return false.
     */
    inline void clearRegionId();

    /**
     * Checks whether the field "regionId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRegionId()). Otherwise it will return false.
     */
    inline bool hasRegionId () const;

    /**
     * Returns the value of the member "regionId".
     *
     * If the meaning of "regionId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "regionId"
     */
    inline uint8 getRegionId () const;

    /**
     * Sets the value of the member "regionId".
     *
     * If the meaning of "regionId" isn't clear, then there should be a description here.
     *
     * @param regionId The value which will be set
     */
    inline void setRegionId (uint8 regionId_);

    // API of field "appFlyInIndex"

    static const int kAppFlyInIndex = 1;

    /**
     * Clears the field "appFlyInIndex".
     *
     * The field will be set to its default value. The hasAppFlyInIndex()
     * method will return false.
     */
    inline void clearAppFlyInIndex();

    /**
     * Checks whether the field "appFlyInIndex" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAppFlyInIndex()). Otherwise it will return false.
     */
    inline bool hasAppFlyInIndex () const;

    /**
     * Returns the value of the member "appFlyInIndex".
     *
     * If the meaning of "appFlyInIndex" isn't clear, then there should be a description here.
     *
     * @return The value of the field "appFlyInIndex"
     */
    inline uint8 getAppFlyInIndex () const;

    /**
     * Sets the value of the member "appFlyInIndex".
     *
     * If the meaning of "appFlyInIndex" isn't clear, then there should be a description here.
     *
     * @param appFlyInIndex The value which will be set
     */
    inline void setAppFlyInIndex (uint8 appFlyInIndex_);

    // API of field "status"

    static const int kStatus = 2;

    /**
     * Clears the field "status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @return The value of the field "status"
     */
    inline uint8 getStatus () const;

    /**
     * Sets the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @param status The value which will be set
     */
    inline void setStatus (uint8 status_);

    // API of field "bgImage"

    static const int kBgImage = 3;

    /**
     * Clears the field "bgImage".
     *
     * The field will be set to its default value. The hasBgImage()
     * method will return false.
     */
    inline void clearBgImage();

    /**
     * Checks whether the field "bgImage" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBgImage()). Otherwise it will return false.
     */
    inline bool hasBgImage () const;

    /**
     * Returns the value of the member "bgImage".
     *
     * If the meaning of "bgImage" isn't clear, then there should be a description here.
     *
     * @return The value of the field "bgImage"
     */
    inline const ::std::string& getBgImage () const;

    /**
     * Retrieves the value of the field "bgImage" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "bgImage".
     */
    inline ::std::string& getBgImageMutable ();

    /**
     * Sets the value of the member "bgImage".
     *
     * If the meaning of "bgImage" isn't clear, then there should be a description here.
     *
     * @param bgImage The value which will be set
     */
    inline void setBgImage (const ::std::string& bgImage_);

    /**
     * Sets the value of the member "bgImage".
     *
     * If the meaning of "bgImage" isn't clear, then there should be a description here.
     *
     * @param bgImage The value which will be set
     */
    inline void setBgImage (const char* bgImage_);

    /**
     * Sets the value of the member "bgImage".
     *
     * If the meaning of "bgImage" isn't clear, then there should be a description here.
     *
     * @param bgImage The value which will be set
     */
    inline void setBgImage (const char* value, size_t size);

    // API of field "borderImage"

    static const int kBorderImage = 4;

    /**
     * Clears the field "borderImage".
     *
     * The field will be set to its default value. The hasBorderImage()
     * method will return false.
     */
    inline void clearBorderImage();

    /**
     * Checks whether the field "borderImage" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBorderImage()). Otherwise it will return false.
     */
    inline bool hasBorderImage () const;

    /**
     * Returns the value of the member "borderImage".
     *
     * If the meaning of "borderImage" isn't clear, then there should be a description here.
     *
     * @return The value of the field "borderImage"
     */
    inline const ::std::string& getBorderImage () const;

    /**
     * Retrieves the value of the field "borderImage" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "borderImage".
     */
    inline ::std::string& getBorderImageMutable ();

    /**
     * Sets the value of the member "borderImage".
     *
     * If the meaning of "borderImage" isn't clear, then there should be a description here.
     *
     * @param borderImage The value which will be set
     */
    inline void setBorderImage (const ::std::string& borderImage_);

    /**
     * Sets the value of the member "borderImage".
     *
     * If the meaning of "borderImage" isn't clear, then there should be a description here.
     *
     * @param borderImage The value which will be set
     */
    inline void setBorderImage (const char* borderImage_);

    /**
     * Sets the value of the member "borderImage".
     *
     * If the meaning of "borderImage" isn't clear, then there should be a description here.
     *
     * @param borderImage The value which will be set
     */
    inline void setBorderImage (const char* value, size_t size);

    // API of field "iconImage"

    static const int kIconImage = 5;

    /**
     * Clears the field "iconImage".
     *
     * The field will be set to its default value. The hasIconImage()
     * method will return false.
     */
    inline void clearIconImage();

    /**
     * Checks whether the field "iconImage" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIconImage()). Otherwise it will return false.
     */
    inline bool hasIconImage () const;

    /**
     * Returns the value of the member "iconImage".
     *
     * If the meaning of "iconImage" isn't clear, then there should be a description here.
     *
     * @return The value of the field "iconImage"
     */
    inline const ::std::string& getIconImage () const;

    /**
     * Retrieves the value of the field "iconImage" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "iconImage".
     */
    inline ::std::string& getIconImageMutable ();

    /**
     * Sets the value of the member "iconImage".
     *
     * If the meaning of "iconImage" isn't clear, then there should be a description here.
     *
     * @param iconImage The value which will be set
     */
    inline void setIconImage (const ::std::string& iconImage_);

    /**
     * Sets the value of the member "iconImage".
     *
     * If the meaning of "iconImage" isn't clear, then there should be a description here.
     *
     * @param iconImage The value which will be set
     */
    inline void setIconImage (const char* iconImage_);

    /**
     * Sets the value of the member "iconImage".
     *
     * If the meaning of "iconImage" isn't clear, then there should be a description here.
     *
     * @param iconImage The value which will be set
     */
    inline void setIconImage (const char* value, size_t size);

    static const AppFlyInStateInfo &getDefaultInstance();

private:

    inline void set_has_regionId ();

    inline void clear_has_regionId ();

    inline void set_has_appFlyInIndex ();

    inline void clear_has_appFlyInIndex ();

    inline void set_has_status ();

    inline void clear_has_status ();

    inline void set_has_bgImage ();

    inline void clear_has_bgImage ();

    inline void set_has_borderImage ();

    inline void clear_has_borderImage ();

    inline void set_has_iconImage ();

    inline void clear_has_iconImage ();

    uint32 _has_bits_[ (6 + 31) / 32];

    uint8 _regionId;

    uint8 _appFlyInIndex;

    uint8 _status;

    ::std::string _bgImage;

    ::std::string _borderImage;

    ::std::string _iconImage;

};

/**
 * requestApplcationSwitch = Method to request application switching
 */
class RequestApplcationSwitchRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestApplcationSwitchRequest ();

    /**
     * Copy constructor
     */
    inline  RequestApplcationSwitchRequest (const RequestApplcationSwitchRequest &rhs);

    /**
     * All fields constructor
     */
    inline  RequestApplcationSwitchRequest (uint8 appID_);

    /**
     * Destructor
     */
    inline virtual  ~RequestApplcationSwitchRequest();

    /**
     * Assignment operator
     */
    inline RequestApplcationSwitchRequest& operator = (const RequestApplcationSwitchRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestApplcationSwitchRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestApplcationSwitchRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestApplcationSwitchRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestApplcationSwitchRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "appID"

    static const int kAppID = 0;

    /**
     * Clears the field "appID".
     *
     * The field will be set to its default value. The hasAppID()
     * method will return false.
     */
    inline void clearAppID();

    /**
     * Checks whether the field "appID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAppID()). Otherwise it will return false.
     */
    inline bool hasAppID () const;

    /**
     * Returns the value of the member "appID".
     *
     * If the meaning of "appID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "appID"
     */
    inline uint8 getAppID () const;

    /**
     * Sets the value of the member "appID".
     *
     * If the meaning of "appID" isn't clear, then there should be a description here.
     *
     * @param appID The value which will be set
     */
    inline void setAppID (uint8 appID_);

    static const RequestApplcationSwitchRequest &getDefaultInstance();

private:

    inline void set_has_appID ();

    inline void clear_has_appID ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _appID;

};

/**
 * requestApplcationSwitch = Method to request application switching
 */
class RequestApplcationSwitchResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestApplcationSwitchResponse ();

    /**
     * Copy constructor
     */
    inline  RequestApplcationSwitchResponse (const RequestApplcationSwitchResponse &rhs);

    /**
     * All fields constructor
     */
    inline  RequestApplcationSwitchResponse (bool response_);

    /**
     * Destructor
     */
    inline virtual  ~RequestApplcationSwitchResponse();

    /**
     * Assignment operator
     */
    inline RequestApplcationSwitchResponse& operator = (const RequestApplcationSwitchResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestApplcationSwitchResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestApplcationSwitchResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestApplcationSwitchResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestApplcationSwitchResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "response"

    static const int kResponse = 0;

    /**
     * Clears the field "response".
     *
     * The field will be set to its default value. The hasResponse()
     * method will return false.
     */
    inline void clearResponse();

    /**
     * Checks whether the field "response" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResponse()). Otherwise it will return false.
     */
    inline bool hasResponse () const;

    /**
     * Returns the value of the member "response".
     *
     * If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @return The value of the field "response"
     */
    inline bool getResponse () const;

    /**
     * Sets the value of the member "response".
     *
     * If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @param response The value which will be set
     */
    inline void setResponse (bool response_);

    static const RequestApplcationSwitchResponse &getDefaultInstance();

private:

    inline void set_has_response ();

    inline void clear_has_response ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _response;

};

/**
 * requestShowHideWaitScene = Method to request show Wait Animation scene
 */
class RequestShowHideWaitSceneRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestShowHideWaitSceneRequest ();

    /**
     * Copy constructor
     */
    inline  RequestShowHideWaitSceneRequest (const RequestShowHideWaitSceneRequest &rhs);

    /**
     * All fields constructor
     */
    inline  RequestShowHideWaitSceneRequest (bool popupshow_);

    /**
     * Destructor
     */
    inline virtual  ~RequestShowHideWaitSceneRequest();

    /**
     * Assignment operator
     */
    inline RequestShowHideWaitSceneRequest& operator = (const RequestShowHideWaitSceneRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestShowHideWaitSceneRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestShowHideWaitSceneRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestShowHideWaitSceneRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestShowHideWaitSceneRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "popupshow"

    static const int kPopupshow = 0;

    /**
     * Clears the field "popupshow".
     *
     * The field will be set to its default value. The hasPopupshow()
     * method will return false.
     */
    inline void clearPopupshow();

    /**
     * Checks whether the field "popupshow" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPopupshow()). Otherwise it will return false.
     */
    inline bool hasPopupshow () const;

    /**
     * Returns the value of the member "popupshow".
     *
     * If the meaning of "popupshow" isn't clear, then there should be a description here.
     *
     * @return The value of the field "popupshow"
     */
    inline bool getPopupshow () const;

    /**
     * Sets the value of the member "popupshow".
     *
     * If the meaning of "popupshow" isn't clear, then there should be a description here.
     *
     * @param popupshow The value which will be set
     */
    inline void setPopupshow (bool popupshow_);

    static const RequestShowHideWaitSceneRequest &getDefaultInstance();

private:

    inline void set_has_popupshow ();

    inline void clear_has_popupshow ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _popupshow;

};

/**
 * requestShowHideWaitScene = Method to request show Wait Animation scene
 */
class RequestShowHideWaitSceneResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestShowHideWaitSceneResponse ();

    /**
     * Copy constructor
     */
    inline  RequestShowHideWaitSceneResponse (const RequestShowHideWaitSceneResponse &rhs);

    /**
     * All fields constructor
     */
    inline  RequestShowHideWaitSceneResponse (bool response_);

    /**
     * Destructor
     */
    inline virtual  ~RequestShowHideWaitSceneResponse();

    /**
     * Assignment operator
     */
    inline RequestShowHideWaitSceneResponse& operator = (const RequestShowHideWaitSceneResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestShowHideWaitSceneResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestShowHideWaitSceneResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestShowHideWaitSceneResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestShowHideWaitSceneResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "response"

    static const int kResponse = 0;

    /**
     * Clears the field "response".
     *
     * The field will be set to its default value. The hasResponse()
     * method will return false.
     */
    inline void clearResponse();

    /**
     * Checks whether the field "response" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResponse()). Otherwise it will return false.
     */
    inline bool hasResponse () const;

    /**
     * Returns the value of the member "response".
     *
     * If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @return The value of the field "response"
     */
    inline bool getResponse () const;

    /**
     * Sets the value of the member "response".
     *
     * If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @param response The value which will be set
     */
    inline void setResponse (bool response_);

    static const RequestShowHideWaitSceneResponse &getDefaultInstance();

private:

    inline void set_has_response ();

    inline void clear_has_response ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _response;

};

/**
 * activateDeactivateRVCScene = Method to request show RVC scene
 */
class ActivateDeactivateRVCSceneRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ActivateDeactivateRVCSceneRequest ();

    /**
     * Copy constructor
     */
    inline  ActivateDeactivateRVCSceneRequest (const ActivateDeactivateRVCSceneRequest &rhs);

    /**
     * All fields constructor
     */
    inline  ActivateDeactivateRVCSceneRequest (bool popupshow_);

    /**
     * Destructor
     */
    inline virtual  ~ActivateDeactivateRVCSceneRequest();

    /**
     * Assignment operator
     */
    inline ActivateDeactivateRVCSceneRequest& operator = (const ActivateDeactivateRVCSceneRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ActivateDeactivateRVCSceneRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ActivateDeactivateRVCSceneRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ActivateDeactivateRVCSceneRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ActivateDeactivateRVCSceneRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "popupshow"

    static const int kPopupshow = 0;

    /**
     * Clears the field "popupshow".
     *
     * The field will be set to its default value. The hasPopupshow()
     * method will return false.
     */
    inline void clearPopupshow();

    /**
     * Checks whether the field "popupshow" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPopupshow()). Otherwise it will return false.
     */
    inline bool hasPopupshow () const;

    /**
     * Returns the value of the member "popupshow".
     *
     * If the meaning of "popupshow" isn't clear, then there should be a description here.
     *
     * @return The value of the field "popupshow"
     */
    inline bool getPopupshow () const;

    /**
     * Sets the value of the member "popupshow".
     *
     * If the meaning of "popupshow" isn't clear, then there should be a description here.
     *
     * @param popupshow The value which will be set
     */
    inline void setPopupshow (bool popupshow_);

    static const ActivateDeactivateRVCSceneRequest &getDefaultInstance();

private:

    inline void set_has_popupshow ();

    inline void clear_has_popupshow ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _popupshow;

};

/**
 * activateDeactivateRVCScene = Method to request show RVC scene
 */
class ActivateDeactivateRVCSceneResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ActivateDeactivateRVCSceneResponse ();

    /**
     * Copy constructor
     */
    inline  ActivateDeactivateRVCSceneResponse (const ActivateDeactivateRVCSceneResponse &rhs);

    /**
     * All fields constructor
     */
    inline  ActivateDeactivateRVCSceneResponse (bool response_);

    /**
     * Destructor
     */
    inline virtual  ~ActivateDeactivateRVCSceneResponse();

    /**
     * Assignment operator
     */
    inline ActivateDeactivateRVCSceneResponse& operator = (const ActivateDeactivateRVCSceneResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ActivateDeactivateRVCSceneResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ActivateDeactivateRVCSceneResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ActivateDeactivateRVCSceneResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ActivateDeactivateRVCSceneResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "response"

    static const int kResponse = 0;

    /**
     * Clears the field "response".
     *
     * The field will be set to its default value. The hasResponse()
     * method will return false.
     */
    inline void clearResponse();

    /**
     * Checks whether the field "response" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResponse()). Otherwise it will return false.
     */
    inline bool hasResponse () const;

    /**
     * Returns the value of the member "response".
     *
     * If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @return The value of the field "response"
     */
    inline bool getResponse () const;

    /**
     * Sets the value of the member "response".
     *
     * If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @param response The value which will be set
     */
    inline void setResponse (bool response_);

    static const ActivateDeactivateRVCSceneResponse &getDefaultInstance();

private:

    inline void set_has_response ();

    inline void clear_has_response ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _response;

};

/**
 * speechSession_activated_deactivated = method when speech session activates or deactivates
 */
class SpeechSession_activated_deactivatedRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SpeechSession_activated_deactivatedRequest ();

    /**
     * Copy constructor
     */
    inline  SpeechSession_activated_deactivatedRequest (const SpeechSession_activated_deactivatedRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SpeechSession_activated_deactivatedRequest (bool status_);

    /**
     * Destructor
     */
    inline virtual  ~SpeechSession_activated_deactivatedRequest();

    /**
     * Assignment operator
     */
    inline SpeechSession_activated_deactivatedRequest& operator = (const SpeechSession_activated_deactivatedRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SpeechSession_activated_deactivatedRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SpeechSession_activated_deactivatedRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SpeechSession_activated_deactivatedRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SpeechSession_activated_deactivatedRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "status"

    static const int kStatus = 0;

    /**
     * Clears the field "status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @return The value of the field "status"
     */
    inline bool getStatus () const;

    /**
     * Sets the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @param status The value which will be set
     */
    inline void setStatus (bool status_);

    static const SpeechSession_activated_deactivatedRequest &getDefaultInstance();

private:

    inline void set_has_status ();

    inline void clear_has_status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _status;

};

/**
 * speechSession_activated_deactivated = method when speech session activates or deactivates
 */
class SpeechSession_activated_deactivatedResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SpeechSession_activated_deactivatedResponse ();

    /**
     * Copy constructor
     */
    inline  SpeechSession_activated_deactivatedResponse (const SpeechSession_activated_deactivatedResponse &rhs);

    /**
     * All fields constructor
     */
    inline  SpeechSession_activated_deactivatedResponse (bool response_);

    /**
     * Destructor
     */
    inline virtual  ~SpeechSession_activated_deactivatedResponse();

    /**
     * Assignment operator
     */
    inline SpeechSession_activated_deactivatedResponse& operator = (const SpeechSession_activated_deactivatedResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SpeechSession_activated_deactivatedResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SpeechSession_activated_deactivatedResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SpeechSession_activated_deactivatedResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SpeechSession_activated_deactivatedResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "response"

    static const int kResponse = 0;

    /**
     * Clears the field "response".
     *
     * The field will be set to its default value. The hasResponse()
     * method will return false.
     */
    inline void clearResponse();

    /**
     * Checks whether the field "response" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResponse()). Otherwise it will return false.
     */
    inline bool hasResponse () const;

    /**
     * Returns the value of the member "response".
     *
     * If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @return The value of the field "response"
     */
    inline bool getResponse () const;

    /**
     * Sets the value of the member "response".
     *
     * If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @param response The value which will be set
     */
    inline void setResponse (bool response_);

    static const SpeechSession_activated_deactivatedResponse &getDefaultInstance();

private:

    inline void set_has_response ();

    inline void clear_has_response ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _response;

};

/**
 * mapout_activated_deactivated = method called when navigation application activates or deactivates mapout streaming
 */
class Mapout_activated_deactivatedRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Mapout_activated_deactivatedRequest ();

    /**
     * Copy constructor
     */
    inline  Mapout_activated_deactivatedRequest (const Mapout_activated_deactivatedRequest &rhs);

    /**
     * All fields constructor
     */
    inline  Mapout_activated_deactivatedRequest (uint32 regionId_, bool status_);

    /**
     * Destructor
     */
    inline virtual  ~Mapout_activated_deactivatedRequest();

    /**
     * Assignment operator
     */
    inline Mapout_activated_deactivatedRequest& operator = (const Mapout_activated_deactivatedRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Mapout_activated_deactivatedRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Mapout_activated_deactivatedRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Mapout_activated_deactivatedRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Mapout_activated_deactivatedRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "regionId"

    static const int kRegionId = 0;

    /**
     * Clears the field "regionId".
     *
     * The field will be set to its default value. The hasRegionId()
     * method will return false.
     */
    inline void clearRegionId();

    /**
     * Checks whether the field "regionId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRegionId()). Otherwise it will return false.
     */
    inline bool hasRegionId () const;

    /**
     * Returns the value of the member "regionId".
     *
     * If the meaning of "regionId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "regionId"
     */
    inline uint32 getRegionId () const;

    /**
     * Sets the value of the member "regionId".
     *
     * If the meaning of "regionId" isn't clear, then there should be a description here.
     *
     * @param regionId The value which will be set
     */
    inline void setRegionId (uint32 regionId_);

    // API of field "status"

    static const int kStatus = 1;

    /**
     * Clears the field "status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @return The value of the field "status"
     */
    inline bool getStatus () const;

    /**
     * Sets the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @param status The value which will be set
     */
    inline void setStatus (bool status_);

    static const Mapout_activated_deactivatedRequest &getDefaultInstance();

private:

    inline void set_has_regionId ();

    inline void clear_has_regionId ();

    inline void set_has_status ();

    inline void clear_has_status ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _regionId;

    bool _status;

};

/**
 * spi_connectionstatus = method when VR session activates or deactivates
 */
class Spi_connectionstatusRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Spi_connectionstatusRequest ();

    /**
     * Copy constructor
     */
    inline  Spi_connectionstatusRequest (const Spi_connectionstatusRequest &rhs);

    /**
     * All fields constructor
     */
    inline  Spi_connectionstatusRequest (bool status_);

    /**
     * Destructor
     */
    inline virtual  ~Spi_connectionstatusRequest();

    /**
     * Assignment operator
     */
    inline Spi_connectionstatusRequest& operator = (const Spi_connectionstatusRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Spi_connectionstatusRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Spi_connectionstatusRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Spi_connectionstatusRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Spi_connectionstatusRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "status"

    static const int kStatus = 0;

    /**
     * Clears the field "status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @return The value of the field "status"
     */
    inline bool getStatus () const;

    /**
     * Sets the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @param status The value which will be set
     */
    inline void setStatus (bool status_);

    static const Spi_connectionstatusRequest &getDefaultInstance();

private:

    inline void set_has_status ();

    inline void clear_has_status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _status;

};

/**
 * spi_connectionstatus = method when VR session activates or deactivates
 */
class Spi_connectionstatusResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Spi_connectionstatusResponse ();

    /**
     * Copy constructor
     */
    inline  Spi_connectionstatusResponse (const Spi_connectionstatusResponse &rhs);

    /**
     * All fields constructor
     */
    inline  Spi_connectionstatusResponse (bool response_);

    /**
     * Destructor
     */
    inline virtual  ~Spi_connectionstatusResponse();

    /**
     * Assignment operator
     */
    inline Spi_connectionstatusResponse& operator = (const Spi_connectionstatusResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Spi_connectionstatusResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Spi_connectionstatusResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Spi_connectionstatusResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Spi_connectionstatusResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "response"

    static const int kResponse = 0;

    /**
     * Clears the field "response".
     *
     * The field will be set to its default value. The hasResponse()
     * method will return false.
     */
    inline void clearResponse();

    /**
     * Checks whether the field "response" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResponse()). Otherwise it will return false.
     */
    inline bool hasResponse () const;

    /**
     * Returns the value of the member "response".
     *
     * If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @return The value of the field "response"
     */
    inline bool getResponse () const;

    /**
     * Sets the value of the member "response".
     *
     * If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @param response The value which will be set
     */
    inline void setResponse (bool response_);

    static const Spi_connectionstatusResponse &getDefaultInstance();

private:

    inline void set_has_response ();

    inline void clear_has_response ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _response;

};

/**
 * spi_ForwardEncoder = method when Encoder Message to be forwarded
 */
class Spi_ForwardEncoderRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Spi_ForwardEncoderRequest ();

    /**
     * Copy constructor
     */
    inline  Spi_ForwardEncoderRequest (const Spi_ForwardEncoderRequest &rhs);

    /**
     * All fields constructor
     */
    inline  Spi_ForwardEncoderRequest (int32 Encode_, int32 EncodeSteps_);

    /**
     * Destructor
     */
    inline virtual  ~Spi_ForwardEncoderRequest();

    /**
     * Assignment operator
     */
    inline Spi_ForwardEncoderRequest& operator = (const Spi_ForwardEncoderRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Spi_ForwardEncoderRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Spi_ForwardEncoderRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Spi_ForwardEncoderRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Spi_ForwardEncoderRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Encode"

    static const int kEncode = 0;

    /**
     * Clears the field "Encode".
     *
     * The field will be set to its default value. The hasEncode()
     * method will return false.
     */
    inline void clearEncode();

    /**
     * Checks whether the field "Encode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEncode()). Otherwise it will return false.
     */
    inline bool hasEncode () const;

    /**
     * Returns the value of the member "Encode".
     *
     * If the meaning of "Encode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Encode"
     */
    inline int32 getEncode () const;

    /**
     * Sets the value of the member "Encode".
     *
     * If the meaning of "Encode" isn't clear, then there should be a description here.
     *
     * @param Encode The value which will be set
     */
    inline void setEncode (int32 Encode_);

    // API of field "EncodeSteps"

    static const int kEncodeSteps = 1;

    /**
     * Clears the field "EncodeSteps".
     *
     * The field will be set to its default value. The hasEncodeSteps()
     * method will return false.
     */
    inline void clearEncodeSteps();

    /**
     * Checks whether the field "EncodeSteps" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEncodeSteps()). Otherwise it will return false.
     */
    inline bool hasEncodeSteps () const;

    /**
     * Returns the value of the member "EncodeSteps".
     *
     * If the meaning of "EncodeSteps" isn't clear, then there should be a description here.
     *
     * @return The value of the field "EncodeSteps"
     */
    inline int32 getEncodeSteps () const;

    /**
     * Sets the value of the member "EncodeSteps".
     *
     * If the meaning of "EncodeSteps" isn't clear, then there should be a description here.
     *
     * @param EncodeSteps The value which will be set
     */
    inline void setEncodeSteps (int32 EncodeSteps_);

    static const Spi_ForwardEncoderRequest &getDefaultInstance();

private:

    inline void set_has_Encode ();

    inline void clear_has_Encode ();

    inline void set_has_EncodeSteps ();

    inline void clear_has_EncodeSteps ();

    uint32 _has_bits_[ (2 + 31) / 32];

    int32 _Encode;

    int32 _EncodeSteps;

};

/**
 * spi_ForwardEncoder = method when Encoder Message to be forwarded
 */
class Spi_ForwardEncoderResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Spi_ForwardEncoderResponse ();

    /**
     * Copy constructor
     */
    inline  Spi_ForwardEncoderResponse (const Spi_ForwardEncoderResponse &rhs);

    /**
     * All fields constructor
     */
    inline  Spi_ForwardEncoderResponse (bool response_);

    /**
     * Destructor
     */
    inline virtual  ~Spi_ForwardEncoderResponse();

    /**
     * Assignment operator
     */
    inline Spi_ForwardEncoderResponse& operator = (const Spi_ForwardEncoderResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Spi_ForwardEncoderResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Spi_ForwardEncoderResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Spi_ForwardEncoderResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Spi_ForwardEncoderResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "response"

    static const int kResponse = 0;

    /**
     * Clears the field "response".
     *
     * The field will be set to its default value. The hasResponse()
     * method will return false.
     */
    inline void clearResponse();

    /**
     * Checks whether the field "response" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResponse()). Otherwise it will return false.
     */
    inline bool hasResponse () const;

    /**
     * Returns the value of the member "response".
     *
     * If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @return The value of the field "response"
     */
    inline bool getResponse () const;

    /**
     * Sets the value of the member "response".
     *
     * If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @param response The value which will be set
     */
    inline void setResponse (bool response_);

    static const Spi_ForwardEncoderResponse &getDefaultInstance();

private:

    inline void set_has_response ();

    inline void clear_has_response ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _response;

};

/**
 * RequestContextSwitch = to request for change in context
 */
class RequestContextSwitchRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestContextSwitchRequest ();

    /**
     * Copy constructor
     */
    inline  RequestContextSwitchRequest (const RequestContextSwitchRequest &rhs);

    /**
     * All fields constructor
     */
    inline  RequestContextSwitchRequest (uint8 regionId_, uint8 sourceAppId_, enActivityIDs sourceActivityId_, uint8 targetAppId_, enActivityIDs targetActivityId_);

    /**
     * Destructor
     */
    inline virtual  ~RequestContextSwitchRequest();

    /**
     * Assignment operator
     */
    inline RequestContextSwitchRequest& operator = (const RequestContextSwitchRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestContextSwitchRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestContextSwitchRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestContextSwitchRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestContextSwitchRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "regionId"

    static const int kRegionId = 0;

    /**
     * Clears the field "regionId".
     *
     * The field will be set to its default value. The hasRegionId()
     * method will return false.
     */
    inline void clearRegionId();

    /**
     * Checks whether the field "regionId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRegionId()). Otherwise it will return false.
     */
    inline bool hasRegionId () const;

    /**
     * Returns the value of the member "regionId".
     *
     * If the meaning of "regionId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "regionId"
     */
    inline uint8 getRegionId () const;

    /**
     * Sets the value of the member "regionId".
     *
     * If the meaning of "regionId" isn't clear, then there should be a description here.
     *
     * @param regionId The value which will be set
     */
    inline void setRegionId (uint8 regionId_);

    // API of field "sourceAppId"

    static const int kSourceAppId = 1;

    /**
     * Clears the field "sourceAppId".
     *
     * The field will be set to its default value. The hasSourceAppId()
     * method will return false.
     */
    inline void clearSourceAppId();

    /**
     * Checks whether the field "sourceAppId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSourceAppId()). Otherwise it will return false.
     */
    inline bool hasSourceAppId () const;

    /**
     * Returns the value of the member "sourceAppId".
     *
     * If the meaning of "sourceAppId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sourceAppId"
     */
    inline uint8 getSourceAppId () const;

    /**
     * Sets the value of the member "sourceAppId".
     *
     * If the meaning of "sourceAppId" isn't clear, then there should be a description here.
     *
     * @param sourceAppId The value which will be set
     */
    inline void setSourceAppId (uint8 sourceAppId_);

    // API of field "sourceActivityId"

    static const int kSourceActivityId = 2;

    /**
     * Clears the field "sourceActivityId".
     *
     * The field will be set to its default value. The hasSourceActivityId()
     * method will return false.
     */
    inline void clearSourceActivityId();

    /**
     * Checks whether the field "sourceActivityId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSourceActivityId()). Otherwise it will return false.
     */
    inline bool hasSourceActivityId () const;

    /**
     * Returns the value of the member "sourceActivityId".
     *
     * If the meaning of "sourceActivityId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sourceActivityId"
     */
    inline enActivityIDs getSourceActivityId () const;

    /**
     * Sets the value of the member "sourceActivityId".
     *
     * If the meaning of "sourceActivityId" isn't clear, then there should be a description here.
     *
     * @param sourceActivityId The value which will be set
     */
    inline void setSourceActivityId (enActivityIDs sourceActivityId_);

    // API of field "targetAppId"

    static const int kTargetAppId = 3;

    /**
     * Clears the field "targetAppId".
     *
     * The field will be set to its default value. The hasTargetAppId()
     * method will return false.
     */
    inline void clearTargetAppId();

    /**
     * Checks whether the field "targetAppId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTargetAppId()). Otherwise it will return false.
     */
    inline bool hasTargetAppId () const;

    /**
     * Returns the value of the member "targetAppId".
     *
     * If the meaning of "targetAppId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "targetAppId"
     */
    inline uint8 getTargetAppId () const;

    /**
     * Sets the value of the member "targetAppId".
     *
     * If the meaning of "targetAppId" isn't clear, then there should be a description here.
     *
     * @param targetAppId The value which will be set
     */
    inline void setTargetAppId (uint8 targetAppId_);

    // API of field "targetActivityId"

    static const int kTargetActivityId = 4;

    /**
     * Clears the field "targetActivityId".
     *
     * The field will be set to its default value. The hasTargetActivityId()
     * method will return false.
     */
    inline void clearTargetActivityId();

    /**
     * Checks whether the field "targetActivityId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTargetActivityId()). Otherwise it will return false.
     */
    inline bool hasTargetActivityId () const;

    /**
     * Returns the value of the member "targetActivityId".
     *
     * If the meaning of "targetActivityId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "targetActivityId"
     */
    inline enActivityIDs getTargetActivityId () const;

    /**
     * Sets the value of the member "targetActivityId".
     *
     * If the meaning of "targetActivityId" isn't clear, then there should be a description here.
     *
     * @param targetActivityId The value which will be set
     */
    inline void setTargetActivityId (enActivityIDs targetActivityId_);

    static const RequestContextSwitchRequest &getDefaultInstance();

private:

    inline void set_has_regionId ();

    inline void clear_has_regionId ();

    inline void set_has_sourceAppId ();

    inline void clear_has_sourceAppId ();

    inline void set_has_sourceActivityId ();

    inline void clear_has_sourceActivityId ();

    inline void set_has_targetAppId ();

    inline void clear_has_targetAppId ();

    inline void set_has_targetActivityId ();

    inline void clear_has_targetActivityId ();

    uint32 _has_bits_[ (5 + 31) / 32];

    uint8 _regionId;

    uint8 _sourceAppId;

    enActivityIDs _sourceActivityId;

    uint8 _targetAppId;

    enActivityIDs _targetActivityId;

};

/**
 * RequestContextSwitch = to request for change in context
 */
class RequestContextSwitchResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestContextSwitchResponse ();

    /**
     * Copy constructor
     */
    inline  RequestContextSwitchResponse (const RequestContextSwitchResponse &rhs);

    /**
     * All fields constructor
     */
    inline  RequestContextSwitchResponse (bool response_);

    /**
     * Destructor
     */
    inline virtual  ~RequestContextSwitchResponse();

    /**
     * Assignment operator
     */
    inline RequestContextSwitchResponse& operator = (const RequestContextSwitchResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestContextSwitchResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestContextSwitchResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestContextSwitchResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestContextSwitchResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "response"

    static const int kResponse = 0;

    /**
     * Clears the field "response".
     *
     * The field will be set to its default value. The hasResponse()
     * method will return false.
     */
    inline void clearResponse();

    /**
     * Checks whether the field "response" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResponse()). Otherwise it will return false.
     */
    inline bool hasResponse () const;

    /**
     * Returns the value of the member "response".
     *
     * If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @return The value of the field "response"
     */
    inline bool getResponse () const;

    /**
     * Sets the value of the member "response".
     *
     * If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @param response The value which will be set
     */
    inline void setResponse (bool response_);

    static const RequestContextSwitchResponse &getDefaultInstance();

private:

    inline void set_has_response ();

    inline void clear_has_response ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _response;

};

/**
 * sendSourceContext = to send source in context on request
 */
class SendContextRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SendContextRequest ();

    /**
     * Copy constructor
     */
    inline  SendContextRequest (const SendContextRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SendContextRequest (uint8 regionId_, uint8 sourceAppId_, enActivityIDs sourceActivityId_);

    /**
     * Destructor
     */
    inline virtual  ~SendContextRequest();

    /**
     * Assignment operator
     */
    inline SendContextRequest& operator = (const SendContextRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SendContextRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SendContextRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SendContextRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SendContextRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "regionId"

    static const int kRegionId = 0;

    /**
     * Clears the field "regionId".
     *
     * The field will be set to its default value. The hasRegionId()
     * method will return false.
     */
    inline void clearRegionId();

    /**
     * Checks whether the field "regionId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRegionId()). Otherwise it will return false.
     */
    inline bool hasRegionId () const;

    /**
     * Returns the value of the member "regionId".
     *
     * If the meaning of "regionId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "regionId"
     */
    inline uint8 getRegionId () const;

    /**
     * Sets the value of the member "regionId".
     *
     * If the meaning of "regionId" isn't clear, then there should be a description here.
     *
     * @param regionId The value which will be set
     */
    inline void setRegionId (uint8 regionId_);

    // API of field "sourceAppId"

    static const int kSourceAppId = 1;

    /**
     * Clears the field "sourceAppId".
     *
     * The field will be set to its default value. The hasSourceAppId()
     * method will return false.
     */
    inline void clearSourceAppId();

    /**
     * Checks whether the field "sourceAppId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSourceAppId()). Otherwise it will return false.
     */
    inline bool hasSourceAppId () const;

    /**
     * Returns the value of the member "sourceAppId".
     *
     * If the meaning of "sourceAppId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sourceAppId"
     */
    inline uint8 getSourceAppId () const;

    /**
     * Sets the value of the member "sourceAppId".
     *
     * If the meaning of "sourceAppId" isn't clear, then there should be a description here.
     *
     * @param sourceAppId The value which will be set
     */
    inline void setSourceAppId (uint8 sourceAppId_);

    // API of field "sourceActivityId"

    static const int kSourceActivityId = 2;

    /**
     * Clears the field "sourceActivityId".
     *
     * The field will be set to its default value. The hasSourceActivityId()
     * method will return false.
     */
    inline void clearSourceActivityId();

    /**
     * Checks whether the field "sourceActivityId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSourceActivityId()). Otherwise it will return false.
     */
    inline bool hasSourceActivityId () const;

    /**
     * Returns the value of the member "sourceActivityId".
     *
     * If the meaning of "sourceActivityId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sourceActivityId"
     */
    inline enActivityIDs getSourceActivityId () const;

    /**
     * Sets the value of the member "sourceActivityId".
     *
     * If the meaning of "sourceActivityId" isn't clear, then there should be a description here.
     *
     * @param sourceActivityId The value which will be set
     */
    inline void setSourceActivityId (enActivityIDs sourceActivityId_);

    static const SendContextRequest &getDefaultInstance();

private:

    inline void set_has_regionId ();

    inline void clear_has_regionId ();

    inline void set_has_sourceAppId ();

    inline void clear_has_sourceAppId ();

    inline void set_has_sourceActivityId ();

    inline void clear_has_sourceActivityId ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint8 _regionId;

    uint8 _sourceAppId;

    enActivityIDs _sourceActivityId;

};

/**
 * sendSourceContext = to send source in context on request
 */
class SendContextResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SendContextResponse ();

    /**
     * Copy constructor
     */
    inline  SendContextResponse (const SendContextResponse &rhs);

    /**
     * All fields constructor
     */
    inline  SendContextResponse (bool response_);

    /**
     * Destructor
     */
    inline virtual  ~SendContextResponse();

    /**
     * Assignment operator
     */
    inline SendContextResponse& operator = (const SendContextResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SendContextResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SendContextResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SendContextResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SendContextResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "response"

    static const int kResponse = 0;

    /**
     * Clears the field "response".
     *
     * The field will be set to its default value. The hasResponse()
     * method will return false.
     */
    inline void clearResponse();

    /**
     * Checks whether the field "response" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResponse()). Otherwise it will return false.
     */
    inline bool hasResponse () const;

    /**
     * Returns the value of the member "response".
     *
     * If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @return The value of the field "response"
     */
    inline bool getResponse () const;

    /**
     * Sets the value of the member "response".
     *
     * If the meaning of "response" isn't clear, then there should be a description here.
     *
     * @param response The value which will be set
     */
    inline void setResponse (bool response_);

    static const SendContextResponse &getDefaultInstance();

private:

    inline void set_has_response ();

    inline void clear_has_response ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _response;

};

/**
 * sendSourceContext = to send source in context on request
 */
class DisplayAppFlyInReqRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DisplayAppFlyInReqRequest ();

    /**
     * Copy constructor
     */
    inline  DisplayAppFlyInReqRequest (const DisplayAppFlyInReqRequest &rhs);

    /**
     * All fields constructor
     */
    inline  DisplayAppFlyInReqRequest (bool status_);

    /**
     * Destructor
     */
    inline virtual  ~DisplayAppFlyInReqRequest();

    /**
     * Assignment operator
     */
    inline DisplayAppFlyInReqRequest& operator = (const DisplayAppFlyInReqRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DisplayAppFlyInReqRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DisplayAppFlyInReqRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DisplayAppFlyInReqRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DisplayAppFlyInReqRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "status"

    static const int kStatus = 0;

    /**
     * Clears the field "status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @return The value of the field "status"
     */
    inline bool getStatus () const;

    /**
     * Sets the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @param status The value which will be set
     */
    inline void setStatus (bool status_);

    static const DisplayAppFlyInReqRequest &getDefaultInstance();

private:

    inline void set_has_status ();

    inline void clear_has_status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _status;

};

/**
 * Method to provide acknowledgement for display sync request
 */
class ConfigureAppFlyInStatusRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ConfigureAppFlyInStatusRequest ();

    /**
     * Copy constructor
     */
    inline  ConfigureAppFlyInStatusRequest (const ConfigureAppFlyInStatusRequest &rhs);

    /**
     * All fields constructor
     */
    inline  ConfigureAppFlyInStatusRequest (const ::std::vector< AppFlyInStateInfo >& stateInfo_);

    /**
     * Destructor
     */
    inline virtual  ~ConfigureAppFlyInStatusRequest();

    /**
     * Assignment operator
     */
    inline ConfigureAppFlyInStatusRequest& operator = (const ConfigureAppFlyInStatusRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ConfigureAppFlyInStatusRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ConfigureAppFlyInStatusRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ConfigureAppFlyInStatusRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ConfigureAppFlyInStatusRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "stateInfo"

    static const int kStateInfo = 0;

    /**
     * Clears the field "stateInfo".
     *
     * The field will be set to its default value. The hasStateInfo()
     * method will return false.
     */
    inline void clearStateInfo();

    /**
     * Checks whether the field "stateInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStateInfo()). Otherwise it will return false.
     */
    inline bool hasStateInfo () const;

    /**
     * Returns the value of the member "stateInfo".
     *
     * If the meaning of "stateInfo" isn't clear, then there should be a description here.
     *
     * @return The value of the field "stateInfo"
     */
    inline const ::std::vector< AppFlyInStateInfo >& getStateInfo () const;

    /**
     * Retrieves the value of the field "stateInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "stateInfo".
     */
    inline ::std::vector< AppFlyInStateInfo >& getStateInfoMutable ();

    /**
     * Sets the value of the member "stateInfo".
     *
     * If the meaning of "stateInfo" isn't clear, then there should be a description here.
     *
     * @param stateInfo The value which will be set
     */
    inline void setStateInfo (const ::std::vector< AppFlyInStateInfo >& stateInfo_);

    static const ConfigureAppFlyInStatusRequest &getDefaultInstance();

private:

    static const ::std::vector< AppFlyInStateInfo >& getAppFlyInStateInfoList_DefaultInstance ();

    inline void set_has_stateInfo ();

    inline void clear_has_stateInfo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< AppFlyInStateInfo > _stateInfo;

};

/**
 * activeRegionId = to indicate change in active RegionId
 */
class ActiveRegionIdUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ActiveRegionIdUpdate ();

    /**
     * Copy constructor
     */
    inline  ActiveRegionIdUpdate (const ActiveRegionIdUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  ActiveRegionIdUpdate (uint8 activeRegionId_);

    /**
     * Destructor
     */
    inline virtual  ~ActiveRegionIdUpdate();

    /**
     * Assignment operator
     */
    inline ActiveRegionIdUpdate& operator = (const ActiveRegionIdUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ActiveRegionIdUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ActiveRegionIdUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ActiveRegionIdUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ActiveRegionIdUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "activeRegionId"

    static const int kActiveRegionId = 0;

    /**
     * Clears the field "activeRegionId".
     *
     * The field will be set to its default value. The hasActiveRegionId()
     * method will return false.
     */
    inline void clearActiveRegionId();

    /**
     * Checks whether the field "activeRegionId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setActiveRegionId()). Otherwise it will return false.
     */
    inline bool hasActiveRegionId () const;

    /**
     * Returns the value of the member "activeRegionId".
     *
     * activeRegionId = to indicate change in active RegionId
     *
     * @return The value of the field "activeRegionId"
     */
    inline uint8 getActiveRegionId () const;

    /**
     * Sets the value of the member "activeRegionId".
     *
     * activeRegionId = to indicate change in active RegionId
     *
     * @param activeRegionId The value which will be set
     */
    inline void setActiveRegionId (uint8 activeRegionId_);

    static const ActiveRegionIdUpdate &getDefaultInstance();

private:

    inline void set_has_activeRegionId ();

    inline void clear_has_activeRegionId ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _activeRegionId;

};

/**
 * activeRegionId = to indicate change in active RegionId
 */
class ActiveRegionIdRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ActiveRegionIdRegister ();

    /**
     * Copy constructor
     */
    inline  ActiveRegionIdRegister (const ActiveRegionIdRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~ActiveRegionIdRegister();

    /**
     * Assignment operator
     */
    inline ActiveRegionIdRegister& operator = (const ActiveRegionIdRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ActiveRegionIdRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ActiveRegionIdRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ActiveRegionIdRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ActiveRegionIdRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const ActiveRegionIdRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Mapout_Activate_Deactivate = Method to request show MAP scene
 */
class Mapout_Activate_DeactivateSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Mapout_Activate_DeactivateSignal ();

    /**
     * Copy constructor
     */
    inline  Mapout_Activate_DeactivateSignal (const Mapout_Activate_DeactivateSignal &rhs);

    /**
     * All fields constructor
     */
    inline  Mapout_Activate_DeactivateSignal (uint32 regionId_, bool mapoutshow_);

    /**
     * Destructor
     */
    inline virtual  ~Mapout_Activate_DeactivateSignal();

    /**
     * Assignment operator
     */
    inline Mapout_Activate_DeactivateSignal& operator = (const Mapout_Activate_DeactivateSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Mapout_Activate_DeactivateSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Mapout_Activate_DeactivateSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Mapout_Activate_DeactivateSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Mapout_Activate_DeactivateSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "regionId"

    static const int kRegionId = 0;

    /**
     * Clears the field "regionId".
     *
     * The field will be set to its default value. The hasRegionId()
     * method will return false.
     */
    inline void clearRegionId();

    /**
     * Checks whether the field "regionId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRegionId()). Otherwise it will return false.
     */
    inline bool hasRegionId () const;

    /**
     * Returns the value of the member "regionId".
     *
     * If the meaning of "regionId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "regionId"
     */
    inline uint32 getRegionId () const;

    /**
     * Sets the value of the member "regionId".
     *
     * If the meaning of "regionId" isn't clear, then there should be a description here.
     *
     * @param regionId The value which will be set
     */
    inline void setRegionId (uint32 regionId_);

    // API of field "mapoutshow"

    static const int kMapoutshow = 1;

    /**
     * Clears the field "mapoutshow".
     *
     * The field will be set to its default value. The hasMapoutshow()
     * method will return false.
     */
    inline void clearMapoutshow();

    /**
     * Checks whether the field "mapoutshow" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMapoutshow()). Otherwise it will return false.
     */
    inline bool hasMapoutshow () const;

    /**
     * Returns the value of the member "mapoutshow".
     *
     * If the meaning of "mapoutshow" isn't clear, then there should be a description here.
     *
     * @return The value of the field "mapoutshow"
     */
    inline bool getMapoutshow () const;

    /**
     * Sets the value of the member "mapoutshow".
     *
     * If the meaning of "mapoutshow" isn't clear, then there should be a description here.
     *
     * @param mapoutshow The value which will be set
     */
    inline void setMapoutshow (bool mapoutshow_);

    static const Mapout_Activate_DeactivateSignal &getDefaultInstance();

private:

    inline void set_has_regionId ();

    inline void clear_has_regionId ();

    inline void set_has_mapoutshow ();

    inline void clear_has_mapoutshow ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _regionId;

    bool _mapoutshow;

};

/**
 * sig_activate_spi_voicerecognition_short = Method to request show MAP scene
 */
class Sig_activate_spi_voicerecognition_shortSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Sig_activate_spi_voicerecognition_shortSignal ();

    /**
     * Copy constructor
     */
    inline  Sig_activate_spi_voicerecognition_shortSignal (const Sig_activate_spi_voicerecognition_shortSignal &rhs);

    /**
     * All fields constructor
     */
    inline  Sig_activate_spi_voicerecognition_shortSignal (bool status_);

    /**
     * Destructor
     */
    inline virtual  ~Sig_activate_spi_voicerecognition_shortSignal();

    /**
     * Assignment operator
     */
    inline Sig_activate_spi_voicerecognition_shortSignal& operator = (const Sig_activate_spi_voicerecognition_shortSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Sig_activate_spi_voicerecognition_shortSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Sig_activate_spi_voicerecognition_shortSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Sig_activate_spi_voicerecognition_shortSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Sig_activate_spi_voicerecognition_shortSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "status"

    static const int kStatus = 0;

    /**
     * Clears the field "status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @return The value of the field "status"
     */
    inline bool getStatus () const;

    /**
     * Sets the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @param status The value which will be set
     */
    inline void setStatus (bool status_);

    static const Sig_activate_spi_voicerecognition_shortSignal &getDefaultInstance();

private:

    inline void set_has_status ();

    inline void clear_has_status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _status;

};

/**
 * sig_activate_spi_voicerecognition_long = Method to request show MAP scene
 */
class Sig_activate_spi_voicerecognition_longSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Sig_activate_spi_voicerecognition_longSignal ();

    /**
     * Copy constructor
     */
    inline  Sig_activate_spi_voicerecognition_longSignal (const Sig_activate_spi_voicerecognition_longSignal &rhs);

    /**
     * All fields constructor
     */
    inline  Sig_activate_spi_voicerecognition_longSignal (bool status_);

    /**
     * Destructor
     */
    inline virtual  ~Sig_activate_spi_voicerecognition_longSignal();

    /**
     * Assignment operator
     */
    inline Sig_activate_spi_voicerecognition_longSignal& operator = (const Sig_activate_spi_voicerecognition_longSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Sig_activate_spi_voicerecognition_longSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Sig_activate_spi_voicerecognition_longSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Sig_activate_spi_voicerecognition_longSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Sig_activate_spi_voicerecognition_longSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "status"

    static const int kStatus = 0;

    /**
     * Clears the field "status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @return The value of the field "status"
     */
    inline bool getStatus () const;

    /**
     * Sets the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @param status The value which will be set
     */
    inline void setStatus (bool status_);

    static const Sig_activate_spi_voicerecognition_longSignal &getDefaultInstance();

private:

    inline void set_has_status ();

    inline void clear_has_status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _status;

};

/**
 * sig_activate_spi_voicerecognition_short_release = Method to request show MAP scene
 */
class Sig_activate_spi_voicerecognition_short_releaseSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Sig_activate_spi_voicerecognition_short_releaseSignal ();

    /**
     * Copy constructor
     */
    inline  Sig_activate_spi_voicerecognition_short_releaseSignal (const Sig_activate_spi_voicerecognition_short_releaseSignal &rhs);

    /**
     * All fields constructor
     */
    inline  Sig_activate_spi_voicerecognition_short_releaseSignal (bool status_);

    /**
     * Destructor
     */
    inline virtual  ~Sig_activate_spi_voicerecognition_short_releaseSignal();

    /**
     * Assignment operator
     */
    inline Sig_activate_spi_voicerecognition_short_releaseSignal& operator = (const Sig_activate_spi_voicerecognition_short_releaseSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Sig_activate_spi_voicerecognition_short_releaseSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Sig_activate_spi_voicerecognition_short_releaseSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Sig_activate_spi_voicerecognition_short_releaseSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Sig_activate_spi_voicerecognition_short_releaseSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "status"

    static const int kStatus = 0;

    /**
     * Clears the field "status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @return The value of the field "status"
     */
    inline bool getStatus () const;

    /**
     * Sets the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @param status The value which will be set
     */
    inline void setStatus (bool status_);

    static const Sig_activate_spi_voicerecognition_short_releaseSignal &getDefaultInstance();

private:

    inline void set_has_status ();

    inline void clear_has_status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _status;

};

/**
 * sig_activate_spi_voicerecognition_long_release = Method to request show MAP scene
 */
class Sig_activate_spi_voicerecognition_long_releaseSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Sig_activate_spi_voicerecognition_long_releaseSignal ();

    /**
     * Copy constructor
     */
    inline  Sig_activate_spi_voicerecognition_long_releaseSignal (const Sig_activate_spi_voicerecognition_long_releaseSignal &rhs);

    /**
     * All fields constructor
     */
    inline  Sig_activate_spi_voicerecognition_long_releaseSignal (bool status_);

    /**
     * Destructor
     */
    inline virtual  ~Sig_activate_spi_voicerecognition_long_releaseSignal();

    /**
     * Assignment operator
     */
    inline Sig_activate_spi_voicerecognition_long_releaseSignal& operator = (const Sig_activate_spi_voicerecognition_long_releaseSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Sig_activate_spi_voicerecognition_long_releaseSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Sig_activate_spi_voicerecognition_long_releaseSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Sig_activate_spi_voicerecognition_long_releaseSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Sig_activate_spi_voicerecognition_long_releaseSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "status"

    static const int kStatus = 0;

    /**
     * Clears the field "status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @return The value of the field "status"
     */
    inline bool getStatus () const;

    /**
     * Sets the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @param status The value which will be set
     */
    inline void setStatus (bool status_);

    static const Sig_activate_spi_voicerecognition_long_releaseSignal &getDefaultInstance();

private:

    inline void set_has_status ();

    inline void clear_has_status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _status;

};

/**
 * sig_activate_deactivate_SpeechSession = signal to activate Speech Session when PTT button is pressed
 */
class Sig_activate_deactivate_SpeechSessionSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Sig_activate_deactivate_SpeechSessionSignal ();

    /**
     * Copy constructor
     */
    inline  Sig_activate_deactivate_SpeechSessionSignal (const Sig_activate_deactivate_SpeechSessionSignal &rhs);

    /**
     * All fields constructor
     */
    inline  Sig_activate_deactivate_SpeechSessionSignal (bool status_);

    /**
     * Destructor
     */
    inline virtual  ~Sig_activate_deactivate_SpeechSessionSignal();

    /**
     * Assignment operator
     */
    inline Sig_activate_deactivate_SpeechSessionSignal& operator = (const Sig_activate_deactivate_SpeechSessionSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Sig_activate_deactivate_SpeechSessionSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Sig_activate_deactivate_SpeechSessionSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Sig_activate_deactivate_SpeechSessionSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Sig_activate_deactivate_SpeechSessionSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "status"

    static const int kStatus = 0;

    /**
     * Clears the field "status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @return The value of the field "status"
     */
    inline bool getStatus () const;

    /**
     * Sets the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @param status The value which will be set
     */
    inline void setStatus (bool status_);

    static const Sig_activate_deactivate_SpeechSessionSignal &getDefaultInstance();

private:

    inline void set_has_status ();

    inline void clear_has_status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _status;

};

/**
 * sig_ControlPanelButtonPress = signal to indicate control panel button is pressed
 */
class Sig_ControlPanelButtonPressSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Sig_ControlPanelButtonPressSignal ();

    /**
     * Copy constructor
     */
    inline  Sig_ControlPanelButtonPressSignal (const Sig_ControlPanelButtonPressSignal &rhs);

    /**
     * All fields constructor
     */
    inline  Sig_ControlPanelButtonPressSignal (uint8 buttonId_, uint8 buttonState_, uint32 receiverAppID_);

    /**
     * Destructor
     */
    inline virtual  ~Sig_ControlPanelButtonPressSignal();

    /**
     * Assignment operator
     */
    inline Sig_ControlPanelButtonPressSignal& operator = (const Sig_ControlPanelButtonPressSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Sig_ControlPanelButtonPressSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Sig_ControlPanelButtonPressSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Sig_ControlPanelButtonPressSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Sig_ControlPanelButtonPressSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "buttonId"

    static const int kButtonId = 0;

    /**
     * Clears the field "buttonId".
     *
     * The field will be set to its default value. The hasButtonId()
     * method will return false.
     */
    inline void clearButtonId();

    /**
     * Checks whether the field "buttonId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setButtonId()). Otherwise it will return false.
     */
    inline bool hasButtonId () const;

    /**
     * Returns the value of the member "buttonId".
     *
     * If the meaning of "buttonId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "buttonId"
     */
    inline uint8 getButtonId () const;

    /**
     * Sets the value of the member "buttonId".
     *
     * If the meaning of "buttonId" isn't clear, then there should be a description here.
     *
     * @param buttonId The value which will be set
     */
    inline void setButtonId (uint8 buttonId_);

    // API of field "buttonState"

    static const int kButtonState = 1;

    /**
     * Clears the field "buttonState".
     *
     * The field will be set to its default value. The hasButtonState()
     * method will return false.
     */
    inline void clearButtonState();

    /**
     * Checks whether the field "buttonState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setButtonState()). Otherwise it will return false.
     */
    inline bool hasButtonState () const;

    /**
     * Returns the value of the member "buttonState".
     *
     * If the meaning of "buttonState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "buttonState"
     */
    inline uint8 getButtonState () const;

    /**
     * Sets the value of the member "buttonState".
     *
     * If the meaning of "buttonState" isn't clear, then there should be a description here.
     *
     * @param buttonState The value which will be set
     */
    inline void setButtonState (uint8 buttonState_);

    // API of field "receiverAppID"

    static const int kReceiverAppID = 2;

    /**
     * Clears the field "receiverAppID".
     *
     * The field will be set to its default value. The hasReceiverAppID()
     * method will return false.
     */
    inline void clearReceiverAppID();

    /**
     * Checks whether the field "receiverAppID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setReceiverAppID()). Otherwise it will return false.
     */
    inline bool hasReceiverAppID () const;

    /**
     * Returns the value of the member "receiverAppID".
     *
     * If the meaning of "receiverAppID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "receiverAppID"
     */
    inline uint32 getReceiverAppID () const;

    /**
     * Sets the value of the member "receiverAppID".
     *
     * If the meaning of "receiverAppID" isn't clear, then there should be a description here.
     *
     * @param receiverAppID The value which will be set
     */
    inline void setReceiverAppID (uint32 receiverAppID_);

    static const Sig_ControlPanelButtonPressSignal &getDefaultInstance();

private:

    inline void set_has_buttonId ();

    inline void clear_has_buttonId ();

    inline void set_has_buttonState ();

    inline void clear_has_buttonState ();

    inline void set_has_receiverAppID ();

    inline void clear_has_receiverAppID ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint8 _buttonId;

    uint8 _buttonState;

    uint32 _receiverAppID;

};

/**
 * sig_ActivateContext = signal to activate context
 */
class Sig_ActivateContextSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Sig_ActivateContextSignal ();

    /**
     * Copy constructor
     */
    inline  Sig_ActivateContextSignal (const Sig_ActivateContextSignal &rhs);

    /**
     * All fields constructor
     */
    inline  Sig_ActivateContextSignal (uint8 regionId_, uint8 targetappId_, enActivityIDs targetactivityId_);

    /**
     * Destructor
     */
    inline virtual  ~Sig_ActivateContextSignal();

    /**
     * Assignment operator
     */
    inline Sig_ActivateContextSignal& operator = (const Sig_ActivateContextSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Sig_ActivateContextSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Sig_ActivateContextSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Sig_ActivateContextSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Sig_ActivateContextSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "regionId"

    static const int kRegionId = 0;

    /**
     * Clears the field "regionId".
     *
     * The field will be set to its default value. The hasRegionId()
     * method will return false.
     */
    inline void clearRegionId();

    /**
     * Checks whether the field "regionId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRegionId()). Otherwise it will return false.
     */
    inline bool hasRegionId () const;

    /**
     * Returns the value of the member "regionId".
     *
     * If the meaning of "regionId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "regionId"
     */
    inline uint8 getRegionId () const;

    /**
     * Sets the value of the member "regionId".
     *
     * If the meaning of "regionId" isn't clear, then there should be a description here.
     *
     * @param regionId The value which will be set
     */
    inline void setRegionId (uint8 regionId_);

    // API of field "targetappId"

    static const int kTargetappId = 1;

    /**
     * Clears the field "targetappId".
     *
     * The field will be set to its default value. The hasTargetappId()
     * method will return false.
     */
    inline void clearTargetappId();

    /**
     * Checks whether the field "targetappId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTargetappId()). Otherwise it will return false.
     */
    inline bool hasTargetappId () const;

    /**
     * Returns the value of the member "targetappId".
     *
     * If the meaning of "targetappId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "targetappId"
     */
    inline uint8 getTargetappId () const;

    /**
     * Sets the value of the member "targetappId".
     *
     * If the meaning of "targetappId" isn't clear, then there should be a description here.
     *
     * @param targetappId The value which will be set
     */
    inline void setTargetappId (uint8 targetappId_);

    // API of field "targetactivityId"

    static const int kTargetactivityId = 2;

    /**
     * Clears the field "targetactivityId".
     *
     * The field will be set to its default value. The hasTargetactivityId()
     * method will return false.
     */
    inline void clearTargetactivityId();

    /**
     * Checks whether the field "targetactivityId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTargetactivityId()). Otherwise it will return false.
     */
    inline bool hasTargetactivityId () const;

    /**
     * Returns the value of the member "targetactivityId".
     *
     * If the meaning of "targetactivityId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "targetactivityId"
     */
    inline enActivityIDs getTargetactivityId () const;

    /**
     * Sets the value of the member "targetactivityId".
     *
     * If the meaning of "targetactivityId" isn't clear, then there should be a description here.
     *
     * @param targetactivityId The value which will be set
     */
    inline void setTargetactivityId (enActivityIDs targetactivityId_);

    static const Sig_ActivateContextSignal &getDefaultInstance();

private:

    inline void set_has_regionId ();

    inline void clear_has_regionId ();

    inline void set_has_targetappId ();

    inline void clear_has_targetappId ();

    inline void set_has_targetactivityId ();

    inline void clear_has_targetactivityId ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint8 _regionId;

    uint8 _targetappId;

    enActivityIDs _targetactivityId;

};

/**
 * sig_SWCKeyEvent = signal to handle SWCKeyEvent
 */
class Sig_SWCKeyEventSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Sig_SWCKeyEventSignal ();

    /**
     * Copy constructor
     */
    inline  Sig_SWCKeyEventSignal (const Sig_SWCKeyEventSignal &rhs);

    /**
     * All fields constructor
     */
    inline  Sig_SWCKeyEventSignal (uint8 keyEvent_);

    /**
     * Destructor
     */
    inline virtual  ~Sig_SWCKeyEventSignal();

    /**
     * Assignment operator
     */
    inline Sig_SWCKeyEventSignal& operator = (const Sig_SWCKeyEventSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Sig_SWCKeyEventSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Sig_SWCKeyEventSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Sig_SWCKeyEventSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Sig_SWCKeyEventSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "keyEvent"

    static const int kKeyEvent = 0;

    /**
     * Clears the field "keyEvent".
     *
     * The field will be set to its default value. The hasKeyEvent()
     * method will return false.
     */
    inline void clearKeyEvent();

    /**
     * Checks whether the field "keyEvent" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setKeyEvent()). Otherwise it will return false.
     */
    inline bool hasKeyEvent () const;

    /**
     * Returns the value of the member "keyEvent".
     *
     * If the meaning of "keyEvent" isn't clear, then there should be a description here.
     *
     * @return The value of the field "keyEvent"
     */
    inline uint8 getKeyEvent () const;

    /**
     * Sets the value of the member "keyEvent".
     *
     * If the meaning of "keyEvent" isn't clear, then there should be a description here.
     *
     * @param keyEvent The value which will be set
     */
    inline void setKeyEvent (uint8 keyEvent_);

    static const Sig_SWCKeyEventSignal &getDefaultInstance();

private:

    inline void set_has_keyEvent ();

    inline void clear_has_keyEvent ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _keyEvent;

};

inline  AppFlyInStateInfo::AppFlyInStateInfo ()  :
    _regionId (0u),
    _appFlyInIndex (0u),
    _status (0u),
    _bgImage (),
    _borderImage (),
    _iconImage ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AppFlyInStateInfo::AppFlyInStateInfo (const AppFlyInStateInfo &rhs)  :
    _regionId (0u),
    _appFlyInIndex (0u),
    _status (0u),
    _bgImage (),
    _borderImage (),
    _iconImage ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AppFlyInStateInfo::AppFlyInStateInfo (uint8 regionId_, uint8 appFlyInIndex_, uint8 status_, const ::std::string& bgImage_, const ::std::string& borderImage_, const ::std::string& iconImage_)  :
    _regionId (regionId_),
    _appFlyInIndex (appFlyInIndex_),
    _status (status_),
    _bgImage (bgImage_),
    _borderImage (borderImage_),
    _iconImage (iconImage_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (bgImage_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (borderImage_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (iconImage_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AppFlyInStateInfo::~AppFlyInStateInfo() {
}

inline AppFlyInStateInfo& AppFlyInStateInfo::operator = (const AppFlyInStateInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasRegionId()) {
            setRegionId(rhs.getRegionId());
        } else {
            clearRegionId();
        }
        if (rhs.hasAppFlyInIndex()) {
            setAppFlyInIndex(rhs.getAppFlyInIndex());
        } else {
            clearAppFlyInIndex();
        }
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
        if (rhs.hasBgImage()) {
            setBgImage(rhs.getBgImage());
        } else {
            clearBgImage();
        }
        if (rhs.hasBorderImage()) {
            setBorderImage(rhs.getBorderImage());
        } else {
            clearBorderImage();
        }
        if (rhs.hasIconImage()) {
            setIconImage(rhs.getIconImage());
        } else {
            clearIconImage();
        }
    }
    return *this;
}

inline bool AppFlyInStateInfo::operator == (const AppFlyInStateInfo& rhs) const {
    return (((!hasRegionId() && !rhs.hasRegionId()) || getRegionId() == rhs.getRegionId()) &&
        ((!hasAppFlyInIndex() && !rhs.hasAppFlyInIndex()) || getAppFlyInIndex() == rhs.getAppFlyInIndex()) &&
        ((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()) &&
        ((!hasBgImage() && !rhs.hasBgImage()) || getBgImage() == rhs.getBgImage()) &&
        ((!hasBorderImage() && !rhs.hasBorderImage()) || getBorderImage() == rhs.getBorderImage()) &&
        ((!hasIconImage() && !rhs.hasIconImage()) || getIconImage() == rhs.getIconImage()));
}

inline bool AppFlyInStateInfo::operator != (const AppFlyInStateInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool AppFlyInStateInfo::operator < (const AppFlyInStateInfo& rhs) const {
    if (hasRegionId() || rhs.hasRegionId()) {
        if (getRegionId() < rhs.getRegionId()) return true;
        if (getRegionId() > rhs.getRegionId()) return false;
    }
    if (hasAppFlyInIndex() || rhs.hasAppFlyInIndex()) {
        if (getAppFlyInIndex() < rhs.getAppFlyInIndex()) return true;
        if (getAppFlyInIndex() > rhs.getAppFlyInIndex()) return false;
    }
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    if (hasBgImage() || rhs.hasBgImage()) {
        if (getBgImage() < rhs.getBgImage()) return true;
        if (getBgImage() > rhs.getBgImage()) return false;
    }
    if (hasBorderImage() || rhs.hasBorderImage()) {
        if (getBorderImage() < rhs.getBorderImage()) return true;
        if (getBorderImage() > rhs.getBorderImage()) return false;
    }
    if (hasIconImage() || rhs.hasIconImage()) {
        if (getIconImage() < rhs.getIconImage()) return true;
        if (getIconImage() > rhs.getIconImage()) return false;
    }
    return false;
}

inline bool AppFlyInStateInfo::operator > (const AppFlyInStateInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AppFlyInStateInfo::clear() {
    clearRegionId();
    clearAppFlyInIndex();
    clearStatus();
    clearBgImage();
    clearBorderImage();
    clearIconImage();
}

inline void AppFlyInStateInfo::clearRegionId() {
    if (hasRegionId()) {
         clear_has_regionId();
        _regionId = 0u;
     }
}

inline bool AppFlyInStateInfo::hasRegionId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 AppFlyInStateInfo::getRegionId () const {
    return _regionId;
}

inline void AppFlyInStateInfo::setRegionId (uint8 regionId_) {
    set_has_regionId();
    this->_regionId = regionId_;
}

inline void AppFlyInStateInfo::clearAppFlyInIndex() {
    if (hasAppFlyInIndex()) {
         clear_has_appFlyInIndex();
        _appFlyInIndex = 0u;
     }
}

inline bool AppFlyInStateInfo::hasAppFlyInIndex () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 AppFlyInStateInfo::getAppFlyInIndex () const {
    return _appFlyInIndex;
}

inline void AppFlyInStateInfo::setAppFlyInIndex (uint8 appFlyInIndex_) {
    set_has_appFlyInIndex();
    this->_appFlyInIndex = appFlyInIndex_;
}

inline void AppFlyInStateInfo::clearStatus() {
    if (hasStatus()) {
         clear_has_status();
        _status = 0u;
     }
}

inline bool AppFlyInStateInfo::hasStatus () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 AppFlyInStateInfo::getStatus () const {
    return _status;
}

inline void AppFlyInStateInfo::setStatus (uint8 status_) {
    set_has_status();
    this->_status = status_;
}

inline void AppFlyInStateInfo::clearBgImage() {
    if (hasBgImage()) {
         clear_has_bgImage();
        _bgImage.clear();
     }
}

inline bool AppFlyInStateInfo::hasBgImage () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& AppFlyInStateInfo::getBgImage () const {
    return _bgImage;
}

inline ::std::string& AppFlyInStateInfo::getBgImageMutable () {
    set_has_bgImage();
    return _bgImage;
}

inline void AppFlyInStateInfo::setBgImage (const ::std::string& bgImage_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (bgImage_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_bgImage();
    this->_bgImage = bgImage_;
}

inline void AppFlyInStateInfo::setBgImage (const char* bgImage_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (bgImage_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_bgImage();
    this->_bgImage.assign(bgImage_);
}

inline void AppFlyInStateInfo::setBgImage (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_bgImage();
    this->_bgImage.assign(value, size);
}

inline void AppFlyInStateInfo::clearBorderImage() {
    if (hasBorderImage()) {
         clear_has_borderImage();
        _borderImage.clear();
     }
}

inline bool AppFlyInStateInfo::hasBorderImage () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::std::string& AppFlyInStateInfo::getBorderImage () const {
    return _borderImage;
}

inline ::std::string& AppFlyInStateInfo::getBorderImageMutable () {
    set_has_borderImage();
    return _borderImage;
}

inline void AppFlyInStateInfo::setBorderImage (const ::std::string& borderImage_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (borderImage_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_borderImage();
    this->_borderImage = borderImage_;
}

inline void AppFlyInStateInfo::setBorderImage (const char* borderImage_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (borderImage_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_borderImage();
    this->_borderImage.assign(borderImage_);
}

inline void AppFlyInStateInfo::setBorderImage (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_borderImage();
    this->_borderImage.assign(value, size);
}

inline void AppFlyInStateInfo::clearIconImage() {
    if (hasIconImage()) {
         clear_has_iconImage();
        _iconImage.clear();
     }
}

inline bool AppFlyInStateInfo::hasIconImage () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline const ::std::string& AppFlyInStateInfo::getIconImage () const {
    return _iconImage;
}

inline ::std::string& AppFlyInStateInfo::getIconImageMutable () {
    set_has_iconImage();
    return _iconImage;
}

inline void AppFlyInStateInfo::setIconImage (const ::std::string& iconImage_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (iconImage_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_iconImage();
    this->_iconImage = iconImage_;
}

inline void AppFlyInStateInfo::setIconImage (const char* iconImage_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (iconImage_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_iconImage();
    this->_iconImage.assign(iconImage_);
}

inline void AppFlyInStateInfo::setIconImage (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_iconImage();
    this->_iconImage.assign(value, size);
}

inline void AppFlyInStateInfo::set_has_regionId () {
    _has_bits_[0] |= 1u << 0;
}

inline void AppFlyInStateInfo::clear_has_regionId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void AppFlyInStateInfo::set_has_appFlyInIndex () {
    _has_bits_[0] |= 1u << 1;
}

inline void AppFlyInStateInfo::clear_has_appFlyInIndex () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void AppFlyInStateInfo::set_has_status () {
    _has_bits_[0] |= 1u << 2;
}

inline void AppFlyInStateInfo::clear_has_status () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void AppFlyInStateInfo::set_has_bgImage () {
    _has_bits_[0] |= 1u << 3;
}

inline void AppFlyInStateInfo::clear_has_bgImage () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void AppFlyInStateInfo::set_has_borderImage () {
    _has_bits_[0] |= 1u << 4;
}

inline void AppFlyInStateInfo::clear_has_borderImage () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void AppFlyInStateInfo::set_has_iconImage () {
    _has_bits_[0] |= 1u << 5;
}

inline void AppFlyInStateInfo::clear_has_iconImage () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline  RequestApplcationSwitchRequest::RequestApplcationSwitchRequest ()  :
    _appID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RequestApplcationSwitchRequest::RequestApplcationSwitchRequest (const RequestApplcationSwitchRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _appID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RequestApplcationSwitchRequest::RequestApplcationSwitchRequest (uint8 appID_)  :
    _appID (appID_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RequestApplcationSwitchRequest::~RequestApplcationSwitchRequest() {
}

inline RequestApplcationSwitchRequest& RequestApplcationSwitchRequest::operator = (const RequestApplcationSwitchRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAppID()) {
            setAppID(rhs.getAppID());
        } else {
            clearAppID();
        }
    }
    return *this;
}

inline bool RequestApplcationSwitchRequest::operator == (const RequestApplcationSwitchRequest& rhs) const {
    return (((!hasAppID() && !rhs.hasAppID()) || getAppID() == rhs.getAppID()));
}

inline bool RequestApplcationSwitchRequest::operator != (const RequestApplcationSwitchRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool RequestApplcationSwitchRequest::operator < (const RequestApplcationSwitchRequest& rhs) const {
    if (hasAppID() || rhs.hasAppID()) {
        if (getAppID() < rhs.getAppID()) return true;
        if (getAppID() > rhs.getAppID()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RequestApplcationSwitchRequest::clone() {
    return new RequestApplcationSwitchRequest(*this);
}

inline bool RequestApplcationSwitchRequest::operator > (const RequestApplcationSwitchRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RequestApplcationSwitchRequest::clear() {
    clearAppID();
}

inline void RequestApplcationSwitchRequest::clearAppID() {
    if (hasAppID()) {
         clear_has_appID();
        _appID = 0u;
     }
}

inline bool RequestApplcationSwitchRequest::hasAppID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 RequestApplcationSwitchRequest::getAppID () const {
    return _appID;
}

inline void RequestApplcationSwitchRequest::setAppID (uint8 appID_) {
    set_has_appID();
    this->_appID = appID_;
}

inline void RequestApplcationSwitchRequest::set_has_appID () {
    _has_bits_[0] |= 1u << 0;
}

inline void RequestApplcationSwitchRequest::clear_has_appID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RequestApplcationSwitchResponse::RequestApplcationSwitchResponse ()  :
    _response (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RequestApplcationSwitchResponse::RequestApplcationSwitchResponse (const RequestApplcationSwitchResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _response (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RequestApplcationSwitchResponse::RequestApplcationSwitchResponse (bool response_)  :
    _response (response_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RequestApplcationSwitchResponse::~RequestApplcationSwitchResponse() {
}

inline RequestApplcationSwitchResponse& RequestApplcationSwitchResponse::operator = (const RequestApplcationSwitchResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasResponse()) {
            setResponse(rhs.getResponse());
        } else {
            clearResponse();
        }
    }
    return *this;
}

inline bool RequestApplcationSwitchResponse::operator == (const RequestApplcationSwitchResponse& rhs) const {
    return (((!hasResponse() && !rhs.hasResponse()) || getResponse() == rhs.getResponse()));
}

inline bool RequestApplcationSwitchResponse::operator != (const RequestApplcationSwitchResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool RequestApplcationSwitchResponse::operator < (const RequestApplcationSwitchResponse& rhs) const {
    if (hasResponse() || rhs.hasResponse()) {
        if (getResponse() < rhs.getResponse()) return true;
        if (getResponse() > rhs.getResponse()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RequestApplcationSwitchResponse::clone() {
    return new RequestApplcationSwitchResponse(*this);
}

inline bool RequestApplcationSwitchResponse::operator > (const RequestApplcationSwitchResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RequestApplcationSwitchResponse::clear() {
    clearResponse();
}

inline void RequestApplcationSwitchResponse::clearResponse() {
    if (hasResponse()) {
         clear_has_response();
        _response = false;
     }
}

inline bool RequestApplcationSwitchResponse::hasResponse () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool RequestApplcationSwitchResponse::getResponse () const {
    return _response;
}

inline void RequestApplcationSwitchResponse::setResponse (bool response_) {
    set_has_response();
    this->_response = response_;
}

inline void RequestApplcationSwitchResponse::set_has_response () {
    _has_bits_[0] |= 1u << 0;
}

inline void RequestApplcationSwitchResponse::clear_has_response () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RequestShowHideWaitSceneRequest::RequestShowHideWaitSceneRequest ()  :
    _popupshow (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RequestShowHideWaitSceneRequest::RequestShowHideWaitSceneRequest (const RequestShowHideWaitSceneRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _popupshow (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RequestShowHideWaitSceneRequest::RequestShowHideWaitSceneRequest (bool popupshow_)  :
    _popupshow (popupshow_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RequestShowHideWaitSceneRequest::~RequestShowHideWaitSceneRequest() {
}

inline RequestShowHideWaitSceneRequest& RequestShowHideWaitSceneRequest::operator = (const RequestShowHideWaitSceneRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPopupshow()) {
            setPopupshow(rhs.getPopupshow());
        } else {
            clearPopupshow();
        }
    }
    return *this;
}

inline bool RequestShowHideWaitSceneRequest::operator == (const RequestShowHideWaitSceneRequest& rhs) const {
    return (((!hasPopupshow() && !rhs.hasPopupshow()) || getPopupshow() == rhs.getPopupshow()));
}

inline bool RequestShowHideWaitSceneRequest::operator != (const RequestShowHideWaitSceneRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool RequestShowHideWaitSceneRequest::operator < (const RequestShowHideWaitSceneRequest& rhs) const {
    if (hasPopupshow() || rhs.hasPopupshow()) {
        if (getPopupshow() < rhs.getPopupshow()) return true;
        if (getPopupshow() > rhs.getPopupshow()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RequestShowHideWaitSceneRequest::clone() {
    return new RequestShowHideWaitSceneRequest(*this);
}

inline bool RequestShowHideWaitSceneRequest::operator > (const RequestShowHideWaitSceneRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RequestShowHideWaitSceneRequest::clear() {
    clearPopupshow();
}

inline void RequestShowHideWaitSceneRequest::clearPopupshow() {
    if (hasPopupshow()) {
         clear_has_popupshow();
        _popupshow = false;
     }
}

inline bool RequestShowHideWaitSceneRequest::hasPopupshow () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool RequestShowHideWaitSceneRequest::getPopupshow () const {
    return _popupshow;
}

inline void RequestShowHideWaitSceneRequest::setPopupshow (bool popupshow_) {
    set_has_popupshow();
    this->_popupshow = popupshow_;
}

inline void RequestShowHideWaitSceneRequest::set_has_popupshow () {
    _has_bits_[0] |= 1u << 0;
}

inline void RequestShowHideWaitSceneRequest::clear_has_popupshow () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RequestShowHideWaitSceneResponse::RequestShowHideWaitSceneResponse ()  :
    _response (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RequestShowHideWaitSceneResponse::RequestShowHideWaitSceneResponse (const RequestShowHideWaitSceneResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _response (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RequestShowHideWaitSceneResponse::RequestShowHideWaitSceneResponse (bool response_)  :
    _response (response_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RequestShowHideWaitSceneResponse::~RequestShowHideWaitSceneResponse() {
}

inline RequestShowHideWaitSceneResponse& RequestShowHideWaitSceneResponse::operator = (const RequestShowHideWaitSceneResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasResponse()) {
            setResponse(rhs.getResponse());
        } else {
            clearResponse();
        }
    }
    return *this;
}

inline bool RequestShowHideWaitSceneResponse::operator == (const RequestShowHideWaitSceneResponse& rhs) const {
    return (((!hasResponse() && !rhs.hasResponse()) || getResponse() == rhs.getResponse()));
}

inline bool RequestShowHideWaitSceneResponse::operator != (const RequestShowHideWaitSceneResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool RequestShowHideWaitSceneResponse::operator < (const RequestShowHideWaitSceneResponse& rhs) const {
    if (hasResponse() || rhs.hasResponse()) {
        if (getResponse() < rhs.getResponse()) return true;
        if (getResponse() > rhs.getResponse()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RequestShowHideWaitSceneResponse::clone() {
    return new RequestShowHideWaitSceneResponse(*this);
}

inline bool RequestShowHideWaitSceneResponse::operator > (const RequestShowHideWaitSceneResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RequestShowHideWaitSceneResponse::clear() {
    clearResponse();
}

inline void RequestShowHideWaitSceneResponse::clearResponse() {
    if (hasResponse()) {
         clear_has_response();
        _response = false;
     }
}

inline bool RequestShowHideWaitSceneResponse::hasResponse () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool RequestShowHideWaitSceneResponse::getResponse () const {
    return _response;
}

inline void RequestShowHideWaitSceneResponse::setResponse (bool response_) {
    set_has_response();
    this->_response = response_;
}

inline void RequestShowHideWaitSceneResponse::set_has_response () {
    _has_bits_[0] |= 1u << 0;
}

inline void RequestShowHideWaitSceneResponse::clear_has_response () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ActivateDeactivateRVCSceneRequest::ActivateDeactivateRVCSceneRequest ()  :
    _popupshow (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ActivateDeactivateRVCSceneRequest::ActivateDeactivateRVCSceneRequest (const ActivateDeactivateRVCSceneRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _popupshow (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ActivateDeactivateRVCSceneRequest::ActivateDeactivateRVCSceneRequest (bool popupshow_)  :
    _popupshow (popupshow_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ActivateDeactivateRVCSceneRequest::~ActivateDeactivateRVCSceneRequest() {
}

inline ActivateDeactivateRVCSceneRequest& ActivateDeactivateRVCSceneRequest::operator = (const ActivateDeactivateRVCSceneRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPopupshow()) {
            setPopupshow(rhs.getPopupshow());
        } else {
            clearPopupshow();
        }
    }
    return *this;
}

inline bool ActivateDeactivateRVCSceneRequest::operator == (const ActivateDeactivateRVCSceneRequest& rhs) const {
    return (((!hasPopupshow() && !rhs.hasPopupshow()) || getPopupshow() == rhs.getPopupshow()));
}

inline bool ActivateDeactivateRVCSceneRequest::operator != (const ActivateDeactivateRVCSceneRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool ActivateDeactivateRVCSceneRequest::operator < (const ActivateDeactivateRVCSceneRequest& rhs) const {
    if (hasPopupshow() || rhs.hasPopupshow()) {
        if (getPopupshow() < rhs.getPopupshow()) return true;
        if (getPopupshow() > rhs.getPopupshow()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ActivateDeactivateRVCSceneRequest::clone() {
    return new ActivateDeactivateRVCSceneRequest(*this);
}

inline bool ActivateDeactivateRVCSceneRequest::operator > (const ActivateDeactivateRVCSceneRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ActivateDeactivateRVCSceneRequest::clear() {
    clearPopupshow();
}

inline void ActivateDeactivateRVCSceneRequest::clearPopupshow() {
    if (hasPopupshow()) {
         clear_has_popupshow();
        _popupshow = false;
     }
}

inline bool ActivateDeactivateRVCSceneRequest::hasPopupshow () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool ActivateDeactivateRVCSceneRequest::getPopupshow () const {
    return _popupshow;
}

inline void ActivateDeactivateRVCSceneRequest::setPopupshow (bool popupshow_) {
    set_has_popupshow();
    this->_popupshow = popupshow_;
}

inline void ActivateDeactivateRVCSceneRequest::set_has_popupshow () {
    _has_bits_[0] |= 1u << 0;
}

inline void ActivateDeactivateRVCSceneRequest::clear_has_popupshow () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ActivateDeactivateRVCSceneResponse::ActivateDeactivateRVCSceneResponse ()  :
    _response (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ActivateDeactivateRVCSceneResponse::ActivateDeactivateRVCSceneResponse (const ActivateDeactivateRVCSceneResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _response (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ActivateDeactivateRVCSceneResponse::ActivateDeactivateRVCSceneResponse (bool response_)  :
    _response (response_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ActivateDeactivateRVCSceneResponse::~ActivateDeactivateRVCSceneResponse() {
}

inline ActivateDeactivateRVCSceneResponse& ActivateDeactivateRVCSceneResponse::operator = (const ActivateDeactivateRVCSceneResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasResponse()) {
            setResponse(rhs.getResponse());
        } else {
            clearResponse();
        }
    }
    return *this;
}

inline bool ActivateDeactivateRVCSceneResponse::operator == (const ActivateDeactivateRVCSceneResponse& rhs) const {
    return (((!hasResponse() && !rhs.hasResponse()) || getResponse() == rhs.getResponse()));
}

inline bool ActivateDeactivateRVCSceneResponse::operator != (const ActivateDeactivateRVCSceneResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool ActivateDeactivateRVCSceneResponse::operator < (const ActivateDeactivateRVCSceneResponse& rhs) const {
    if (hasResponse() || rhs.hasResponse()) {
        if (getResponse() < rhs.getResponse()) return true;
        if (getResponse() > rhs.getResponse()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ActivateDeactivateRVCSceneResponse::clone() {
    return new ActivateDeactivateRVCSceneResponse(*this);
}

inline bool ActivateDeactivateRVCSceneResponse::operator > (const ActivateDeactivateRVCSceneResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ActivateDeactivateRVCSceneResponse::clear() {
    clearResponse();
}

inline void ActivateDeactivateRVCSceneResponse::clearResponse() {
    if (hasResponse()) {
         clear_has_response();
        _response = false;
     }
}

inline bool ActivateDeactivateRVCSceneResponse::hasResponse () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool ActivateDeactivateRVCSceneResponse::getResponse () const {
    return _response;
}

inline void ActivateDeactivateRVCSceneResponse::setResponse (bool response_) {
    set_has_response();
    this->_response = response_;
}

inline void ActivateDeactivateRVCSceneResponse::set_has_response () {
    _has_bits_[0] |= 1u << 0;
}

inline void ActivateDeactivateRVCSceneResponse::clear_has_response () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SpeechSession_activated_deactivatedRequest::SpeechSession_activated_deactivatedRequest ()  :
    _status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SpeechSession_activated_deactivatedRequest::SpeechSession_activated_deactivatedRequest (const SpeechSession_activated_deactivatedRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SpeechSession_activated_deactivatedRequest::SpeechSession_activated_deactivatedRequest (bool status_)  :
    _status (status_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SpeechSession_activated_deactivatedRequest::~SpeechSession_activated_deactivatedRequest() {
}

inline SpeechSession_activated_deactivatedRequest& SpeechSession_activated_deactivatedRequest::operator = (const SpeechSession_activated_deactivatedRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool SpeechSession_activated_deactivatedRequest::operator == (const SpeechSession_activated_deactivatedRequest& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool SpeechSession_activated_deactivatedRequest::operator != (const SpeechSession_activated_deactivatedRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool SpeechSession_activated_deactivatedRequest::operator < (const SpeechSession_activated_deactivatedRequest& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SpeechSession_activated_deactivatedRequest::clone() {
    return new SpeechSession_activated_deactivatedRequest(*this);
}

inline bool SpeechSession_activated_deactivatedRequest::operator > (const SpeechSession_activated_deactivatedRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SpeechSession_activated_deactivatedRequest::clear() {
    clearStatus();
}

inline void SpeechSession_activated_deactivatedRequest::clearStatus() {
    if (hasStatus()) {
         clear_has_status();
        _status = false;
     }
}

inline bool SpeechSession_activated_deactivatedRequest::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool SpeechSession_activated_deactivatedRequest::getStatus () const {
    return _status;
}

inline void SpeechSession_activated_deactivatedRequest::setStatus (bool status_) {
    set_has_status();
    this->_status = status_;
}

inline void SpeechSession_activated_deactivatedRequest::set_has_status () {
    _has_bits_[0] |= 1u << 0;
}

inline void SpeechSession_activated_deactivatedRequest::clear_has_status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SpeechSession_activated_deactivatedResponse::SpeechSession_activated_deactivatedResponse ()  :
    _response (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SpeechSession_activated_deactivatedResponse::SpeechSession_activated_deactivatedResponse (const SpeechSession_activated_deactivatedResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _response (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SpeechSession_activated_deactivatedResponse::SpeechSession_activated_deactivatedResponse (bool response_)  :
    _response (response_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SpeechSession_activated_deactivatedResponse::~SpeechSession_activated_deactivatedResponse() {
}

inline SpeechSession_activated_deactivatedResponse& SpeechSession_activated_deactivatedResponse::operator = (const SpeechSession_activated_deactivatedResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasResponse()) {
            setResponse(rhs.getResponse());
        } else {
            clearResponse();
        }
    }
    return *this;
}

inline bool SpeechSession_activated_deactivatedResponse::operator == (const SpeechSession_activated_deactivatedResponse& rhs) const {
    return (((!hasResponse() && !rhs.hasResponse()) || getResponse() == rhs.getResponse()));
}

inline bool SpeechSession_activated_deactivatedResponse::operator != (const SpeechSession_activated_deactivatedResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool SpeechSession_activated_deactivatedResponse::operator < (const SpeechSession_activated_deactivatedResponse& rhs) const {
    if (hasResponse() || rhs.hasResponse()) {
        if (getResponse() < rhs.getResponse()) return true;
        if (getResponse() > rhs.getResponse()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SpeechSession_activated_deactivatedResponse::clone() {
    return new SpeechSession_activated_deactivatedResponse(*this);
}

inline bool SpeechSession_activated_deactivatedResponse::operator > (const SpeechSession_activated_deactivatedResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SpeechSession_activated_deactivatedResponse::clear() {
    clearResponse();
}

inline void SpeechSession_activated_deactivatedResponse::clearResponse() {
    if (hasResponse()) {
         clear_has_response();
        _response = false;
     }
}

inline bool SpeechSession_activated_deactivatedResponse::hasResponse () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool SpeechSession_activated_deactivatedResponse::getResponse () const {
    return _response;
}

inline void SpeechSession_activated_deactivatedResponse::setResponse (bool response_) {
    set_has_response();
    this->_response = response_;
}

inline void SpeechSession_activated_deactivatedResponse::set_has_response () {
    _has_bits_[0] |= 1u << 0;
}

inline void SpeechSession_activated_deactivatedResponse::clear_has_response () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  Mapout_activated_deactivatedRequest::Mapout_activated_deactivatedRequest ()  :
    _regionId (0u),
    _status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Mapout_activated_deactivatedRequest::Mapout_activated_deactivatedRequest (const Mapout_activated_deactivatedRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _regionId (0u),
    _status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Mapout_activated_deactivatedRequest::Mapout_activated_deactivatedRequest (uint32 regionId_, bool status_)  :
    _regionId (regionId_),
    _status (status_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Mapout_activated_deactivatedRequest::~Mapout_activated_deactivatedRequest() {
}

inline Mapout_activated_deactivatedRequest& Mapout_activated_deactivatedRequest::operator = (const Mapout_activated_deactivatedRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasRegionId()) {
            setRegionId(rhs.getRegionId());
        } else {
            clearRegionId();
        }
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool Mapout_activated_deactivatedRequest::operator == (const Mapout_activated_deactivatedRequest& rhs) const {
    return (((!hasRegionId() && !rhs.hasRegionId()) || getRegionId() == rhs.getRegionId()) &&
        ((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool Mapout_activated_deactivatedRequest::operator != (const Mapout_activated_deactivatedRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool Mapout_activated_deactivatedRequest::operator < (const Mapout_activated_deactivatedRequest& rhs) const {
    if (hasRegionId() || rhs.hasRegionId()) {
        if (getRegionId() < rhs.getRegionId()) return true;
        if (getRegionId() > rhs.getRegionId()) return false;
    }
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Mapout_activated_deactivatedRequest::clone() {
    return new Mapout_activated_deactivatedRequest(*this);
}

inline bool Mapout_activated_deactivatedRequest::operator > (const Mapout_activated_deactivatedRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Mapout_activated_deactivatedRequest::clear() {
    clearRegionId();
    clearStatus();
}

inline void Mapout_activated_deactivatedRequest::clearRegionId() {
    if (hasRegionId()) {
         clear_has_regionId();
        _regionId = 0u;
     }
}

inline bool Mapout_activated_deactivatedRequest::hasRegionId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 Mapout_activated_deactivatedRequest::getRegionId () const {
    return _regionId;
}

inline void Mapout_activated_deactivatedRequest::setRegionId (uint32 regionId_) {
    set_has_regionId();
    this->_regionId = regionId_;
}

inline void Mapout_activated_deactivatedRequest::clearStatus() {
    if (hasStatus()) {
         clear_has_status();
        _status = false;
     }
}

inline bool Mapout_activated_deactivatedRequest::hasStatus () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline bool Mapout_activated_deactivatedRequest::getStatus () const {
    return _status;
}

inline void Mapout_activated_deactivatedRequest::setStatus (bool status_) {
    set_has_status();
    this->_status = status_;
}

inline void Mapout_activated_deactivatedRequest::set_has_regionId () {
    _has_bits_[0] |= 1u << 0;
}

inline void Mapout_activated_deactivatedRequest::clear_has_regionId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void Mapout_activated_deactivatedRequest::set_has_status () {
    _has_bits_[0] |= 1u << 1;
}

inline void Mapout_activated_deactivatedRequest::clear_has_status () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  Spi_connectionstatusRequest::Spi_connectionstatusRequest ()  :
    _status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Spi_connectionstatusRequest::Spi_connectionstatusRequest (const Spi_connectionstatusRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Spi_connectionstatusRequest::Spi_connectionstatusRequest (bool status_)  :
    _status (status_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Spi_connectionstatusRequest::~Spi_connectionstatusRequest() {
}

inline Spi_connectionstatusRequest& Spi_connectionstatusRequest::operator = (const Spi_connectionstatusRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool Spi_connectionstatusRequest::operator == (const Spi_connectionstatusRequest& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool Spi_connectionstatusRequest::operator != (const Spi_connectionstatusRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool Spi_connectionstatusRequest::operator < (const Spi_connectionstatusRequest& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Spi_connectionstatusRequest::clone() {
    return new Spi_connectionstatusRequest(*this);
}

inline bool Spi_connectionstatusRequest::operator > (const Spi_connectionstatusRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Spi_connectionstatusRequest::clear() {
    clearStatus();
}

inline void Spi_connectionstatusRequest::clearStatus() {
    if (hasStatus()) {
         clear_has_status();
        _status = false;
     }
}

inline bool Spi_connectionstatusRequest::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool Spi_connectionstatusRequest::getStatus () const {
    return _status;
}

inline void Spi_connectionstatusRequest::setStatus (bool status_) {
    set_has_status();
    this->_status = status_;
}

inline void Spi_connectionstatusRequest::set_has_status () {
    _has_bits_[0] |= 1u << 0;
}

inline void Spi_connectionstatusRequest::clear_has_status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  Spi_connectionstatusResponse::Spi_connectionstatusResponse ()  :
    _response (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Spi_connectionstatusResponse::Spi_connectionstatusResponse (const Spi_connectionstatusResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _response (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Spi_connectionstatusResponse::Spi_connectionstatusResponse (bool response_)  :
    _response (response_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Spi_connectionstatusResponse::~Spi_connectionstatusResponse() {
}

inline Spi_connectionstatusResponse& Spi_connectionstatusResponse::operator = (const Spi_connectionstatusResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasResponse()) {
            setResponse(rhs.getResponse());
        } else {
            clearResponse();
        }
    }
    return *this;
}

inline bool Spi_connectionstatusResponse::operator == (const Spi_connectionstatusResponse& rhs) const {
    return (((!hasResponse() && !rhs.hasResponse()) || getResponse() == rhs.getResponse()));
}

inline bool Spi_connectionstatusResponse::operator != (const Spi_connectionstatusResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool Spi_connectionstatusResponse::operator < (const Spi_connectionstatusResponse& rhs) const {
    if (hasResponse() || rhs.hasResponse()) {
        if (getResponse() < rhs.getResponse()) return true;
        if (getResponse() > rhs.getResponse()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Spi_connectionstatusResponse::clone() {
    return new Spi_connectionstatusResponse(*this);
}

inline bool Spi_connectionstatusResponse::operator > (const Spi_connectionstatusResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Spi_connectionstatusResponse::clear() {
    clearResponse();
}

inline void Spi_connectionstatusResponse::clearResponse() {
    if (hasResponse()) {
         clear_has_response();
        _response = false;
     }
}

inline bool Spi_connectionstatusResponse::hasResponse () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool Spi_connectionstatusResponse::getResponse () const {
    return _response;
}

inline void Spi_connectionstatusResponse::setResponse (bool response_) {
    set_has_response();
    this->_response = response_;
}

inline void Spi_connectionstatusResponse::set_has_response () {
    _has_bits_[0] |= 1u << 0;
}

inline void Spi_connectionstatusResponse::clear_has_response () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  Spi_ForwardEncoderRequest::Spi_ForwardEncoderRequest ()  :
    _Encode (0),
    _EncodeSteps (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Spi_ForwardEncoderRequest::Spi_ForwardEncoderRequest (const Spi_ForwardEncoderRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _Encode (0),
    _EncodeSteps (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Spi_ForwardEncoderRequest::Spi_ForwardEncoderRequest (int32 Encode_, int32 EncodeSteps_)  :
    _Encode (Encode_),
    _EncodeSteps (EncodeSteps_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Spi_ForwardEncoderRequest::~Spi_ForwardEncoderRequest() {
}

inline Spi_ForwardEncoderRequest& Spi_ForwardEncoderRequest::operator = (const Spi_ForwardEncoderRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasEncode()) {
            setEncode(rhs.getEncode());
        } else {
            clearEncode();
        }
        if (rhs.hasEncodeSteps()) {
            setEncodeSteps(rhs.getEncodeSteps());
        } else {
            clearEncodeSteps();
        }
    }
    return *this;
}

inline bool Spi_ForwardEncoderRequest::operator == (const Spi_ForwardEncoderRequest& rhs) const {
    return (((!hasEncode() && !rhs.hasEncode()) || getEncode() == rhs.getEncode()) &&
        ((!hasEncodeSteps() && !rhs.hasEncodeSteps()) || getEncodeSteps() == rhs.getEncodeSteps()));
}

inline bool Spi_ForwardEncoderRequest::operator != (const Spi_ForwardEncoderRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool Spi_ForwardEncoderRequest::operator < (const Spi_ForwardEncoderRequest& rhs) const {
    if (hasEncode() || rhs.hasEncode()) {
        if (getEncode() < rhs.getEncode()) return true;
        if (getEncode() > rhs.getEncode()) return false;
    }
    if (hasEncodeSteps() || rhs.hasEncodeSteps()) {
        if (getEncodeSteps() < rhs.getEncodeSteps()) return true;
        if (getEncodeSteps() > rhs.getEncodeSteps()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Spi_ForwardEncoderRequest::clone() {
    return new Spi_ForwardEncoderRequest(*this);
}

inline bool Spi_ForwardEncoderRequest::operator > (const Spi_ForwardEncoderRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Spi_ForwardEncoderRequest::clear() {
    clearEncode();
    clearEncodeSteps();
}

inline void Spi_ForwardEncoderRequest::clearEncode() {
    if (hasEncode()) {
         clear_has_Encode();
        _Encode = 0;
     }
}

inline bool Spi_ForwardEncoderRequest::hasEncode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int32 Spi_ForwardEncoderRequest::getEncode () const {
    return _Encode;
}

inline void Spi_ForwardEncoderRequest::setEncode (int32 Encode_) {
    set_has_Encode();
    this->_Encode = Encode_;
}

inline void Spi_ForwardEncoderRequest::clearEncodeSteps() {
    if (hasEncodeSteps()) {
         clear_has_EncodeSteps();
        _EncodeSteps = 0;
     }
}

inline bool Spi_ForwardEncoderRequest::hasEncodeSteps () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline int32 Spi_ForwardEncoderRequest::getEncodeSteps () const {
    return _EncodeSteps;
}

inline void Spi_ForwardEncoderRequest::setEncodeSteps (int32 EncodeSteps_) {
    set_has_EncodeSteps();
    this->_EncodeSteps = EncodeSteps_;
}

inline void Spi_ForwardEncoderRequest::set_has_Encode () {
    _has_bits_[0] |= 1u << 0;
}

inline void Spi_ForwardEncoderRequest::clear_has_Encode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void Spi_ForwardEncoderRequest::set_has_EncodeSteps () {
    _has_bits_[0] |= 1u << 1;
}

inline void Spi_ForwardEncoderRequest::clear_has_EncodeSteps () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  Spi_ForwardEncoderResponse::Spi_ForwardEncoderResponse ()  :
    _response (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Spi_ForwardEncoderResponse::Spi_ForwardEncoderResponse (const Spi_ForwardEncoderResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _response (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Spi_ForwardEncoderResponse::Spi_ForwardEncoderResponse (bool response_)  :
    _response (response_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Spi_ForwardEncoderResponse::~Spi_ForwardEncoderResponse() {
}

inline Spi_ForwardEncoderResponse& Spi_ForwardEncoderResponse::operator = (const Spi_ForwardEncoderResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasResponse()) {
            setResponse(rhs.getResponse());
        } else {
            clearResponse();
        }
    }
    return *this;
}

inline bool Spi_ForwardEncoderResponse::operator == (const Spi_ForwardEncoderResponse& rhs) const {
    return (((!hasResponse() && !rhs.hasResponse()) || getResponse() == rhs.getResponse()));
}

inline bool Spi_ForwardEncoderResponse::operator != (const Spi_ForwardEncoderResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool Spi_ForwardEncoderResponse::operator < (const Spi_ForwardEncoderResponse& rhs) const {
    if (hasResponse() || rhs.hasResponse()) {
        if (getResponse() < rhs.getResponse()) return true;
        if (getResponse() > rhs.getResponse()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Spi_ForwardEncoderResponse::clone() {
    return new Spi_ForwardEncoderResponse(*this);
}

inline bool Spi_ForwardEncoderResponse::operator > (const Spi_ForwardEncoderResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Spi_ForwardEncoderResponse::clear() {
    clearResponse();
}

inline void Spi_ForwardEncoderResponse::clearResponse() {
    if (hasResponse()) {
         clear_has_response();
        _response = false;
     }
}

inline bool Spi_ForwardEncoderResponse::hasResponse () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool Spi_ForwardEncoderResponse::getResponse () const {
    return _response;
}

inline void Spi_ForwardEncoderResponse::setResponse (bool response_) {
    set_has_response();
    this->_response = response_;
}

inline void Spi_ForwardEncoderResponse::set_has_response () {
    _has_bits_[0] |= 1u << 0;
}

inline void Spi_ForwardEncoderResponse::clear_has_response () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RequestContextSwitchRequest::RequestContextSwitchRequest ()  :
    _regionId (0u),
    _sourceAppId (0u),
    _sourceActivityId (::bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch::enActivityIDs__eActivityID_NONE),
    _targetAppId (0u),
    _targetActivityId (::bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch::enActivityIDs__eActivityID_NONE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RequestContextSwitchRequest::RequestContextSwitchRequest (const RequestContextSwitchRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _regionId (0u),
    _sourceAppId (0u),
    _sourceActivityId (::bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch::enActivityIDs__eActivityID_NONE),
    _targetAppId (0u),
    _targetActivityId (::bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch::enActivityIDs__eActivityID_NONE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RequestContextSwitchRequest::RequestContextSwitchRequest (uint8 regionId_, uint8 sourceAppId_, enActivityIDs sourceActivityId_, uint8 targetAppId_, enActivityIDs targetActivityId_)  :
    _regionId (regionId_),
    _sourceAppId (sourceAppId_),
    _sourceActivityId (sourceActivityId_),
    _targetAppId (targetAppId_),
    _targetActivityId (targetActivityId_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(enActivityIDs_IsValid(sourceActivityId_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", sourceActivityId_, "enActivityIDs", "sourceActivityId", "RequestContextSwitchRequest");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(enActivityIDs_IsValid(targetActivityId_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", targetActivityId_, "enActivityIDs", "targetActivityId", "RequestContextSwitchRequest");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RequestContextSwitchRequest::~RequestContextSwitchRequest() {
}

inline RequestContextSwitchRequest& RequestContextSwitchRequest::operator = (const RequestContextSwitchRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasRegionId()) {
            setRegionId(rhs.getRegionId());
        } else {
            clearRegionId();
        }
        if (rhs.hasSourceAppId()) {
            setSourceAppId(rhs.getSourceAppId());
        } else {
            clearSourceAppId();
        }
        if (rhs.hasSourceActivityId()) {
            setSourceActivityId(rhs.getSourceActivityId());
        } else {
            clearSourceActivityId();
        }
        if (rhs.hasTargetAppId()) {
            setTargetAppId(rhs.getTargetAppId());
        } else {
            clearTargetAppId();
        }
        if (rhs.hasTargetActivityId()) {
            setTargetActivityId(rhs.getTargetActivityId());
        } else {
            clearTargetActivityId();
        }
    }
    return *this;
}

inline bool RequestContextSwitchRequest::operator == (const RequestContextSwitchRequest& rhs) const {
    return (((!hasRegionId() && !rhs.hasRegionId()) || getRegionId() == rhs.getRegionId()) &&
        ((!hasSourceAppId() && !rhs.hasSourceAppId()) || getSourceAppId() == rhs.getSourceAppId()) &&
        ((!hasSourceActivityId() && !rhs.hasSourceActivityId()) || getSourceActivityId() == rhs.getSourceActivityId()) &&
        ((!hasTargetAppId() && !rhs.hasTargetAppId()) || getTargetAppId() == rhs.getTargetAppId()) &&
        ((!hasTargetActivityId() && !rhs.hasTargetActivityId()) || getTargetActivityId() == rhs.getTargetActivityId()));
}

inline bool RequestContextSwitchRequest::operator != (const RequestContextSwitchRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool RequestContextSwitchRequest::operator < (const RequestContextSwitchRequest& rhs) const {
    if (hasRegionId() || rhs.hasRegionId()) {
        if (getRegionId() < rhs.getRegionId()) return true;
        if (getRegionId() > rhs.getRegionId()) return false;
    }
    if (hasSourceAppId() || rhs.hasSourceAppId()) {
        if (getSourceAppId() < rhs.getSourceAppId()) return true;
        if (getSourceAppId() > rhs.getSourceAppId()) return false;
    }
    if (hasSourceActivityId() || rhs.hasSourceActivityId()) {
        if ((uint32)getSourceActivityId() < (uint32)rhs.getSourceActivityId()) return true;
        if ((uint32)getSourceActivityId() > (uint32)rhs.getSourceActivityId()) return false;
    }
    if (hasTargetAppId() || rhs.hasTargetAppId()) {
        if (getTargetAppId() < rhs.getTargetAppId()) return true;
        if (getTargetAppId() > rhs.getTargetAppId()) return false;
    }
    if (hasTargetActivityId() || rhs.hasTargetActivityId()) {
        if ((uint32)getTargetActivityId() < (uint32)rhs.getTargetActivityId()) return true;
        if ((uint32)getTargetActivityId() > (uint32)rhs.getTargetActivityId()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RequestContextSwitchRequest::clone() {
    return new RequestContextSwitchRequest(*this);
}

inline bool RequestContextSwitchRequest::operator > (const RequestContextSwitchRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RequestContextSwitchRequest::clear() {
    clearRegionId();
    clearSourceAppId();
    clearSourceActivityId();
    clearTargetAppId();
    clearTargetActivityId();
}

inline void RequestContextSwitchRequest::clearRegionId() {
    if (hasRegionId()) {
         clear_has_regionId();
        _regionId = 0u;
     }
}

inline bool RequestContextSwitchRequest::hasRegionId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 RequestContextSwitchRequest::getRegionId () const {
    return _regionId;
}

inline void RequestContextSwitchRequest::setRegionId (uint8 regionId_) {
    set_has_regionId();
    this->_regionId = regionId_;
}

inline void RequestContextSwitchRequest::clearSourceAppId() {
    if (hasSourceAppId()) {
         clear_has_sourceAppId();
        _sourceAppId = 0u;
     }
}

inline bool RequestContextSwitchRequest::hasSourceAppId () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 RequestContextSwitchRequest::getSourceAppId () const {
    return _sourceAppId;
}

inline void RequestContextSwitchRequest::setSourceAppId (uint8 sourceAppId_) {
    set_has_sourceAppId();
    this->_sourceAppId = sourceAppId_;
}

inline void RequestContextSwitchRequest::clearSourceActivityId() {
    if (hasSourceActivityId()) {
         clear_has_sourceActivityId();
        _sourceActivityId = ::bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch::enActivityIDs__eActivityID_NONE;
     }
}

inline bool RequestContextSwitchRequest::hasSourceActivityId () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline enActivityIDs RequestContextSwitchRequest::getSourceActivityId () const {
    return _sourceActivityId;
}

inline void RequestContextSwitchRequest::setSourceActivityId (enActivityIDs sourceActivityId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(enActivityIDs_IsValid(sourceActivityId_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", sourceActivityId_, "enActivityIDs", "sourceActivityId", "RequestContextSwitchRequest");
    }
    set_has_sourceActivityId();
    this->_sourceActivityId = sourceActivityId_;
}

inline void RequestContextSwitchRequest::clearTargetAppId() {
    if (hasTargetAppId()) {
         clear_has_targetAppId();
        _targetAppId = 0u;
     }
}

inline bool RequestContextSwitchRequest::hasTargetAppId () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint8 RequestContextSwitchRequest::getTargetAppId () const {
    return _targetAppId;
}

inline void RequestContextSwitchRequest::setTargetAppId (uint8 targetAppId_) {
    set_has_targetAppId();
    this->_targetAppId = targetAppId_;
}

inline void RequestContextSwitchRequest::clearTargetActivityId() {
    if (hasTargetActivityId()) {
         clear_has_targetActivityId();
        _targetActivityId = ::bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch::enActivityIDs__eActivityID_NONE;
     }
}

inline bool RequestContextSwitchRequest::hasTargetActivityId () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline enActivityIDs RequestContextSwitchRequest::getTargetActivityId () const {
    return _targetActivityId;
}

inline void RequestContextSwitchRequest::setTargetActivityId (enActivityIDs targetActivityId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(enActivityIDs_IsValid(targetActivityId_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", targetActivityId_, "enActivityIDs", "targetActivityId", "RequestContextSwitchRequest");
    }
    set_has_targetActivityId();
    this->_targetActivityId = targetActivityId_;
}

inline void RequestContextSwitchRequest::set_has_regionId () {
    _has_bits_[0] |= 1u << 0;
}

inline void RequestContextSwitchRequest::clear_has_regionId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void RequestContextSwitchRequest::set_has_sourceAppId () {
    _has_bits_[0] |= 1u << 1;
}

inline void RequestContextSwitchRequest::clear_has_sourceAppId () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void RequestContextSwitchRequest::set_has_sourceActivityId () {
    _has_bits_[0] |= 1u << 2;
}

inline void RequestContextSwitchRequest::clear_has_sourceActivityId () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void RequestContextSwitchRequest::set_has_targetAppId () {
    _has_bits_[0] |= 1u << 3;
}

inline void RequestContextSwitchRequest::clear_has_targetAppId () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void RequestContextSwitchRequest::set_has_targetActivityId () {
    _has_bits_[0] |= 1u << 4;
}

inline void RequestContextSwitchRequest::clear_has_targetActivityId () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline  RequestContextSwitchResponse::RequestContextSwitchResponse ()  :
    _response (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RequestContextSwitchResponse::RequestContextSwitchResponse (const RequestContextSwitchResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _response (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RequestContextSwitchResponse::RequestContextSwitchResponse (bool response_)  :
    _response (response_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RequestContextSwitchResponse::~RequestContextSwitchResponse() {
}

inline RequestContextSwitchResponse& RequestContextSwitchResponse::operator = (const RequestContextSwitchResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasResponse()) {
            setResponse(rhs.getResponse());
        } else {
            clearResponse();
        }
    }
    return *this;
}

inline bool RequestContextSwitchResponse::operator == (const RequestContextSwitchResponse& rhs) const {
    return (((!hasResponse() && !rhs.hasResponse()) || getResponse() == rhs.getResponse()));
}

inline bool RequestContextSwitchResponse::operator != (const RequestContextSwitchResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool RequestContextSwitchResponse::operator < (const RequestContextSwitchResponse& rhs) const {
    if (hasResponse() || rhs.hasResponse()) {
        if (getResponse() < rhs.getResponse()) return true;
        if (getResponse() > rhs.getResponse()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RequestContextSwitchResponse::clone() {
    return new RequestContextSwitchResponse(*this);
}

inline bool RequestContextSwitchResponse::operator > (const RequestContextSwitchResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RequestContextSwitchResponse::clear() {
    clearResponse();
}

inline void RequestContextSwitchResponse::clearResponse() {
    if (hasResponse()) {
         clear_has_response();
        _response = false;
     }
}

inline bool RequestContextSwitchResponse::hasResponse () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool RequestContextSwitchResponse::getResponse () const {
    return _response;
}

inline void RequestContextSwitchResponse::setResponse (bool response_) {
    set_has_response();
    this->_response = response_;
}

inline void RequestContextSwitchResponse::set_has_response () {
    _has_bits_[0] |= 1u << 0;
}

inline void RequestContextSwitchResponse::clear_has_response () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SendContextRequest::SendContextRequest ()  :
    _regionId (0u),
    _sourceAppId (0u),
    _sourceActivityId (::bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch::enActivityIDs__eActivityID_NONE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SendContextRequest::SendContextRequest (const SendContextRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _regionId (0u),
    _sourceAppId (0u),
    _sourceActivityId (::bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch::enActivityIDs__eActivityID_NONE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SendContextRequest::SendContextRequest (uint8 regionId_, uint8 sourceAppId_, enActivityIDs sourceActivityId_)  :
    _regionId (regionId_),
    _sourceAppId (sourceAppId_),
    _sourceActivityId (sourceActivityId_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(enActivityIDs_IsValid(sourceActivityId_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", sourceActivityId_, "enActivityIDs", "sourceActivityId", "SendContextRequest");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SendContextRequest::~SendContextRequest() {
}

inline SendContextRequest& SendContextRequest::operator = (const SendContextRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasRegionId()) {
            setRegionId(rhs.getRegionId());
        } else {
            clearRegionId();
        }
        if (rhs.hasSourceAppId()) {
            setSourceAppId(rhs.getSourceAppId());
        } else {
            clearSourceAppId();
        }
        if (rhs.hasSourceActivityId()) {
            setSourceActivityId(rhs.getSourceActivityId());
        } else {
            clearSourceActivityId();
        }
    }
    return *this;
}

inline bool SendContextRequest::operator == (const SendContextRequest& rhs) const {
    return (((!hasRegionId() && !rhs.hasRegionId()) || getRegionId() == rhs.getRegionId()) &&
        ((!hasSourceAppId() && !rhs.hasSourceAppId()) || getSourceAppId() == rhs.getSourceAppId()) &&
        ((!hasSourceActivityId() && !rhs.hasSourceActivityId()) || getSourceActivityId() == rhs.getSourceActivityId()));
}

inline bool SendContextRequest::operator != (const SendContextRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool SendContextRequest::operator < (const SendContextRequest& rhs) const {
    if (hasRegionId() || rhs.hasRegionId()) {
        if (getRegionId() < rhs.getRegionId()) return true;
        if (getRegionId() > rhs.getRegionId()) return false;
    }
    if (hasSourceAppId() || rhs.hasSourceAppId()) {
        if (getSourceAppId() < rhs.getSourceAppId()) return true;
        if (getSourceAppId() > rhs.getSourceAppId()) return false;
    }
    if (hasSourceActivityId() || rhs.hasSourceActivityId()) {
        if ((uint32)getSourceActivityId() < (uint32)rhs.getSourceActivityId()) return true;
        if ((uint32)getSourceActivityId() > (uint32)rhs.getSourceActivityId()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SendContextRequest::clone() {
    return new SendContextRequest(*this);
}

inline bool SendContextRequest::operator > (const SendContextRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SendContextRequest::clear() {
    clearRegionId();
    clearSourceAppId();
    clearSourceActivityId();
}

inline void SendContextRequest::clearRegionId() {
    if (hasRegionId()) {
         clear_has_regionId();
        _regionId = 0u;
     }
}

inline bool SendContextRequest::hasRegionId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 SendContextRequest::getRegionId () const {
    return _regionId;
}

inline void SendContextRequest::setRegionId (uint8 regionId_) {
    set_has_regionId();
    this->_regionId = regionId_;
}

inline void SendContextRequest::clearSourceAppId() {
    if (hasSourceAppId()) {
         clear_has_sourceAppId();
        _sourceAppId = 0u;
     }
}

inline bool SendContextRequest::hasSourceAppId () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 SendContextRequest::getSourceAppId () const {
    return _sourceAppId;
}

inline void SendContextRequest::setSourceAppId (uint8 sourceAppId_) {
    set_has_sourceAppId();
    this->_sourceAppId = sourceAppId_;
}

inline void SendContextRequest::clearSourceActivityId() {
    if (hasSourceActivityId()) {
         clear_has_sourceActivityId();
        _sourceActivityId = ::bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch::enActivityIDs__eActivityID_NONE;
     }
}

inline bool SendContextRequest::hasSourceActivityId () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline enActivityIDs SendContextRequest::getSourceActivityId () const {
    return _sourceActivityId;
}

inline void SendContextRequest::setSourceActivityId (enActivityIDs sourceActivityId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(enActivityIDs_IsValid(sourceActivityId_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", sourceActivityId_, "enActivityIDs", "sourceActivityId", "SendContextRequest");
    }
    set_has_sourceActivityId();
    this->_sourceActivityId = sourceActivityId_;
}

inline void SendContextRequest::set_has_regionId () {
    _has_bits_[0] |= 1u << 0;
}

inline void SendContextRequest::clear_has_regionId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SendContextRequest::set_has_sourceAppId () {
    _has_bits_[0] |= 1u << 1;
}

inline void SendContextRequest::clear_has_sourceAppId () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void SendContextRequest::set_has_sourceActivityId () {
    _has_bits_[0] |= 1u << 2;
}

inline void SendContextRequest::clear_has_sourceActivityId () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  SendContextResponse::SendContextResponse ()  :
    _response (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SendContextResponse::SendContextResponse (const SendContextResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _response (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SendContextResponse::SendContextResponse (bool response_)  :
    _response (response_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SendContextResponse::~SendContextResponse() {
}

inline SendContextResponse& SendContextResponse::operator = (const SendContextResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasResponse()) {
            setResponse(rhs.getResponse());
        } else {
            clearResponse();
        }
    }
    return *this;
}

inline bool SendContextResponse::operator == (const SendContextResponse& rhs) const {
    return (((!hasResponse() && !rhs.hasResponse()) || getResponse() == rhs.getResponse()));
}

inline bool SendContextResponse::operator != (const SendContextResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool SendContextResponse::operator < (const SendContextResponse& rhs) const {
    if (hasResponse() || rhs.hasResponse()) {
        if (getResponse() < rhs.getResponse()) return true;
        if (getResponse() > rhs.getResponse()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SendContextResponse::clone() {
    return new SendContextResponse(*this);
}

inline bool SendContextResponse::operator > (const SendContextResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SendContextResponse::clear() {
    clearResponse();
}

inline void SendContextResponse::clearResponse() {
    if (hasResponse()) {
         clear_has_response();
        _response = false;
     }
}

inline bool SendContextResponse::hasResponse () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool SendContextResponse::getResponse () const {
    return _response;
}

inline void SendContextResponse::setResponse (bool response_) {
    set_has_response();
    this->_response = response_;
}

inline void SendContextResponse::set_has_response () {
    _has_bits_[0] |= 1u << 0;
}

inline void SendContextResponse::clear_has_response () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DisplayAppFlyInReqRequest::DisplayAppFlyInReqRequest ()  :
    _status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DisplayAppFlyInReqRequest::DisplayAppFlyInReqRequest (const DisplayAppFlyInReqRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DisplayAppFlyInReqRequest::DisplayAppFlyInReqRequest (bool status_)  :
    _status (status_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DisplayAppFlyInReqRequest::~DisplayAppFlyInReqRequest() {
}

inline DisplayAppFlyInReqRequest& DisplayAppFlyInReqRequest::operator = (const DisplayAppFlyInReqRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool DisplayAppFlyInReqRequest::operator == (const DisplayAppFlyInReqRequest& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool DisplayAppFlyInReqRequest::operator != (const DisplayAppFlyInReqRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool DisplayAppFlyInReqRequest::operator < (const DisplayAppFlyInReqRequest& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DisplayAppFlyInReqRequest::clone() {
    return new DisplayAppFlyInReqRequest(*this);
}

inline bool DisplayAppFlyInReqRequest::operator > (const DisplayAppFlyInReqRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DisplayAppFlyInReqRequest::clear() {
    clearStatus();
}

inline void DisplayAppFlyInReqRequest::clearStatus() {
    if (hasStatus()) {
         clear_has_status();
        _status = false;
     }
}

inline bool DisplayAppFlyInReqRequest::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool DisplayAppFlyInReqRequest::getStatus () const {
    return _status;
}

inline void DisplayAppFlyInReqRequest::setStatus (bool status_) {
    set_has_status();
    this->_status = status_;
}

inline void DisplayAppFlyInReqRequest::set_has_status () {
    _has_bits_[0] |= 1u << 0;
}

inline void DisplayAppFlyInReqRequest::clear_has_status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ConfigureAppFlyInStatusRequest::ConfigureAppFlyInStatusRequest ()  :
    _stateInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ConfigureAppFlyInStatusRequest::ConfigureAppFlyInStatusRequest (const ConfigureAppFlyInStatusRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _stateInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ConfigureAppFlyInStatusRequest::ConfigureAppFlyInStatusRequest (const ::std::vector< AppFlyInStateInfo >& stateInfo_)  :
    _stateInfo (stateInfo_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ConfigureAppFlyInStatusRequest::~ConfigureAppFlyInStatusRequest() {
}

inline ConfigureAppFlyInStatusRequest& ConfigureAppFlyInStatusRequest::operator = (const ConfigureAppFlyInStatusRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStateInfo()) {
            setStateInfo(rhs.getStateInfo());
        } else {
            clearStateInfo();
        }
    }
    return *this;
}

inline bool ConfigureAppFlyInStatusRequest::operator == (const ConfigureAppFlyInStatusRequest& rhs) const {
    return (((!hasStateInfo() && !rhs.hasStateInfo()) || getStateInfo() == rhs.getStateInfo()));
}

inline bool ConfigureAppFlyInStatusRequest::operator != (const ConfigureAppFlyInStatusRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool ConfigureAppFlyInStatusRequest::operator < (const ConfigureAppFlyInStatusRequest& rhs) const {
    if (hasStateInfo() || rhs.hasStateInfo()) {
        if (getStateInfo() < rhs.getStateInfo()) return true;
        if (getStateInfo() > rhs.getStateInfo()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ConfigureAppFlyInStatusRequest::clone() {
    return new ConfigureAppFlyInStatusRequest(*this);
}

inline bool ConfigureAppFlyInStatusRequest::operator > (const ConfigureAppFlyInStatusRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ConfigureAppFlyInStatusRequest::clear() {
    clearStateInfo();
}

inline void ConfigureAppFlyInStatusRequest::clearStateInfo() {
    if (hasStateInfo()) {
         clear_has_stateInfo();
        _stateInfo.clear();
     }
}

inline bool ConfigureAppFlyInStatusRequest::hasStateInfo () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< AppFlyInStateInfo >& ConfigureAppFlyInStatusRequest::getStateInfo () const {
    return _stateInfo;
}

inline ::std::vector< AppFlyInStateInfo >& ConfigureAppFlyInStatusRequest::getStateInfoMutable () {
    set_has_stateInfo();
    return _stateInfo;
}

inline void ConfigureAppFlyInStatusRequest::setStateInfo (const ::std::vector< AppFlyInStateInfo >& stateInfo_) {
    set_has_stateInfo();
    this->_stateInfo = stateInfo_;
}

inline void ConfigureAppFlyInStatusRequest::set_has_stateInfo () {
    _has_bits_[0] |= 1u << 0;
}

inline void ConfigureAppFlyInStatusRequest::clear_has_stateInfo () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ActiveRegionIdUpdate::ActiveRegionIdUpdate ()  :
    _activeRegionId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ActiveRegionIdUpdate::ActiveRegionIdUpdate (const ActiveRegionIdUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _activeRegionId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ActiveRegionIdUpdate::ActiveRegionIdUpdate (uint8 activeRegionId_)  :
    _activeRegionId (activeRegionId_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ActiveRegionIdUpdate::~ActiveRegionIdUpdate() {
}

inline ActiveRegionIdUpdate& ActiveRegionIdUpdate::operator = (const ActiveRegionIdUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasActiveRegionId()) {
            setActiveRegionId(rhs.getActiveRegionId());
        } else {
            clearActiveRegionId();
        }
    }
    return *this;
}

inline bool ActiveRegionIdUpdate::operator == (const ActiveRegionIdUpdate& rhs) const {
    return (((!hasActiveRegionId() && !rhs.hasActiveRegionId()) || getActiveRegionId() == rhs.getActiveRegionId()));
}

inline bool ActiveRegionIdUpdate::operator != (const ActiveRegionIdUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool ActiveRegionIdUpdate::operator < (const ActiveRegionIdUpdate& rhs) const {
    if (hasActiveRegionId() || rhs.hasActiveRegionId()) {
        if (getActiveRegionId() < rhs.getActiveRegionId()) return true;
        if (getActiveRegionId() > rhs.getActiveRegionId()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ActiveRegionIdUpdate::clone() {
    return new ActiveRegionIdUpdate(*this);
}

inline bool ActiveRegionIdUpdate::operator > (const ActiveRegionIdUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ActiveRegionIdUpdate::clear() {
    clearActiveRegionId();
}

inline void ActiveRegionIdUpdate::clearActiveRegionId() {
    if (hasActiveRegionId()) {
         clear_has_activeRegionId();
        _activeRegionId = 0u;
     }
}

inline bool ActiveRegionIdUpdate::hasActiveRegionId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 ActiveRegionIdUpdate::getActiveRegionId () const {
    return _activeRegionId;
}

inline void ActiveRegionIdUpdate::setActiveRegionId (uint8 activeRegionId_) {
    set_has_activeRegionId();
    this->_activeRegionId = activeRegionId_;
}

inline void ActiveRegionIdUpdate::set_has_activeRegionId () {
    _has_bits_[0] |= 1u << 0;
}

inline void ActiveRegionIdUpdate::clear_has_activeRegionId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ActiveRegionIdRegister::ActiveRegionIdRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ActiveRegionIdRegister::ActiveRegionIdRegister (const ActiveRegionIdRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ActiveRegionIdRegister::~ActiveRegionIdRegister() {
}

inline ActiveRegionIdRegister& ActiveRegionIdRegister::operator = (const ActiveRegionIdRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool ActiveRegionIdRegister::operator == (const ActiveRegionIdRegister& ) const {
    return true;
}

inline bool ActiveRegionIdRegister::operator != (const ActiveRegionIdRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool ActiveRegionIdRegister::operator < (const ActiveRegionIdRegister& ) const {
    return false;
}

inline ::asf::core::Payload* ActiveRegionIdRegister::clone() {
    return new ActiveRegionIdRegister(*this);
}

inline bool ActiveRegionIdRegister::operator > (const ActiveRegionIdRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ActiveRegionIdRegister::clear() {
}

inline  Mapout_Activate_DeactivateSignal::Mapout_Activate_DeactivateSignal ()  :
    _regionId (0u),
    _mapoutshow (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Mapout_Activate_DeactivateSignal::Mapout_Activate_DeactivateSignal (const Mapout_Activate_DeactivateSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _regionId (0u),
    _mapoutshow (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Mapout_Activate_DeactivateSignal::Mapout_Activate_DeactivateSignal (uint32 regionId_, bool mapoutshow_)  :
    _regionId (regionId_),
    _mapoutshow (mapoutshow_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Mapout_Activate_DeactivateSignal::~Mapout_Activate_DeactivateSignal() {
}

inline Mapout_Activate_DeactivateSignal& Mapout_Activate_DeactivateSignal::operator = (const Mapout_Activate_DeactivateSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasRegionId()) {
            setRegionId(rhs.getRegionId());
        } else {
            clearRegionId();
        }
        if (rhs.hasMapoutshow()) {
            setMapoutshow(rhs.getMapoutshow());
        } else {
            clearMapoutshow();
        }
    }
    return *this;
}

inline bool Mapout_Activate_DeactivateSignal::operator == (const Mapout_Activate_DeactivateSignal& rhs) const {
    return (((!hasRegionId() && !rhs.hasRegionId()) || getRegionId() == rhs.getRegionId()) &&
        ((!hasMapoutshow() && !rhs.hasMapoutshow()) || getMapoutshow() == rhs.getMapoutshow()));
}

inline bool Mapout_Activate_DeactivateSignal::operator != (const Mapout_Activate_DeactivateSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool Mapout_Activate_DeactivateSignal::operator < (const Mapout_Activate_DeactivateSignal& rhs) const {
    if (hasRegionId() || rhs.hasRegionId()) {
        if (getRegionId() < rhs.getRegionId()) return true;
        if (getRegionId() > rhs.getRegionId()) return false;
    }
    if (hasMapoutshow() || rhs.hasMapoutshow()) {
        if (getMapoutshow() < rhs.getMapoutshow()) return true;
        if (getMapoutshow() > rhs.getMapoutshow()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Mapout_Activate_DeactivateSignal::clone() {
    return new Mapout_Activate_DeactivateSignal(*this);
}

inline bool Mapout_Activate_DeactivateSignal::operator > (const Mapout_Activate_DeactivateSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Mapout_Activate_DeactivateSignal::clear() {
    clearRegionId();
    clearMapoutshow();
}

inline void Mapout_Activate_DeactivateSignal::clearRegionId() {
    if (hasRegionId()) {
         clear_has_regionId();
        _regionId = 0u;
     }
}

inline bool Mapout_Activate_DeactivateSignal::hasRegionId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 Mapout_Activate_DeactivateSignal::getRegionId () const {
    return _regionId;
}

inline void Mapout_Activate_DeactivateSignal::setRegionId (uint32 regionId_) {
    set_has_regionId();
    this->_regionId = regionId_;
}

inline void Mapout_Activate_DeactivateSignal::clearMapoutshow() {
    if (hasMapoutshow()) {
         clear_has_mapoutshow();
        _mapoutshow = false;
     }
}

inline bool Mapout_Activate_DeactivateSignal::hasMapoutshow () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline bool Mapout_Activate_DeactivateSignal::getMapoutshow () const {
    return _mapoutshow;
}

inline void Mapout_Activate_DeactivateSignal::setMapoutshow (bool mapoutshow_) {
    set_has_mapoutshow();
    this->_mapoutshow = mapoutshow_;
}

inline void Mapout_Activate_DeactivateSignal::set_has_regionId () {
    _has_bits_[0] |= 1u << 0;
}

inline void Mapout_Activate_DeactivateSignal::clear_has_regionId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void Mapout_Activate_DeactivateSignal::set_has_mapoutshow () {
    _has_bits_[0] |= 1u << 1;
}

inline void Mapout_Activate_DeactivateSignal::clear_has_mapoutshow () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  Sig_activate_spi_voicerecognition_shortSignal::Sig_activate_spi_voicerecognition_shortSignal ()  :
    _status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Sig_activate_spi_voicerecognition_shortSignal::Sig_activate_spi_voicerecognition_shortSignal (const Sig_activate_spi_voicerecognition_shortSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Sig_activate_spi_voicerecognition_shortSignal::Sig_activate_spi_voicerecognition_shortSignal (bool status_)  :
    _status (status_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Sig_activate_spi_voicerecognition_shortSignal::~Sig_activate_spi_voicerecognition_shortSignal() {
}

inline Sig_activate_spi_voicerecognition_shortSignal& Sig_activate_spi_voicerecognition_shortSignal::operator = (const Sig_activate_spi_voicerecognition_shortSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool Sig_activate_spi_voicerecognition_shortSignal::operator == (const Sig_activate_spi_voicerecognition_shortSignal& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool Sig_activate_spi_voicerecognition_shortSignal::operator != (const Sig_activate_spi_voicerecognition_shortSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool Sig_activate_spi_voicerecognition_shortSignal::operator < (const Sig_activate_spi_voicerecognition_shortSignal& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Sig_activate_spi_voicerecognition_shortSignal::clone() {
    return new Sig_activate_spi_voicerecognition_shortSignal(*this);
}

inline bool Sig_activate_spi_voicerecognition_shortSignal::operator > (const Sig_activate_spi_voicerecognition_shortSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Sig_activate_spi_voicerecognition_shortSignal::clear() {
    clearStatus();
}

inline void Sig_activate_spi_voicerecognition_shortSignal::clearStatus() {
    if (hasStatus()) {
         clear_has_status();
        _status = false;
     }
}

inline bool Sig_activate_spi_voicerecognition_shortSignal::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool Sig_activate_spi_voicerecognition_shortSignal::getStatus () const {
    return _status;
}

inline void Sig_activate_spi_voicerecognition_shortSignal::setStatus (bool status_) {
    set_has_status();
    this->_status = status_;
}

inline void Sig_activate_spi_voicerecognition_shortSignal::set_has_status () {
    _has_bits_[0] |= 1u << 0;
}

inline void Sig_activate_spi_voicerecognition_shortSignal::clear_has_status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  Sig_activate_spi_voicerecognition_longSignal::Sig_activate_spi_voicerecognition_longSignal ()  :
    _status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Sig_activate_spi_voicerecognition_longSignal::Sig_activate_spi_voicerecognition_longSignal (const Sig_activate_spi_voicerecognition_longSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Sig_activate_spi_voicerecognition_longSignal::Sig_activate_spi_voicerecognition_longSignal (bool status_)  :
    _status (status_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Sig_activate_spi_voicerecognition_longSignal::~Sig_activate_spi_voicerecognition_longSignal() {
}

inline Sig_activate_spi_voicerecognition_longSignal& Sig_activate_spi_voicerecognition_longSignal::operator = (const Sig_activate_spi_voicerecognition_longSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool Sig_activate_spi_voicerecognition_longSignal::operator == (const Sig_activate_spi_voicerecognition_longSignal& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool Sig_activate_spi_voicerecognition_longSignal::operator != (const Sig_activate_spi_voicerecognition_longSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool Sig_activate_spi_voicerecognition_longSignal::operator < (const Sig_activate_spi_voicerecognition_longSignal& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Sig_activate_spi_voicerecognition_longSignal::clone() {
    return new Sig_activate_spi_voicerecognition_longSignal(*this);
}

inline bool Sig_activate_spi_voicerecognition_longSignal::operator > (const Sig_activate_spi_voicerecognition_longSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Sig_activate_spi_voicerecognition_longSignal::clear() {
    clearStatus();
}

inline void Sig_activate_spi_voicerecognition_longSignal::clearStatus() {
    if (hasStatus()) {
         clear_has_status();
        _status = false;
     }
}

inline bool Sig_activate_spi_voicerecognition_longSignal::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool Sig_activate_spi_voicerecognition_longSignal::getStatus () const {
    return _status;
}

inline void Sig_activate_spi_voicerecognition_longSignal::setStatus (bool status_) {
    set_has_status();
    this->_status = status_;
}

inline void Sig_activate_spi_voicerecognition_longSignal::set_has_status () {
    _has_bits_[0] |= 1u << 0;
}

inline void Sig_activate_spi_voicerecognition_longSignal::clear_has_status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  Sig_activate_spi_voicerecognition_short_releaseSignal::Sig_activate_spi_voicerecognition_short_releaseSignal ()  :
    _status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Sig_activate_spi_voicerecognition_short_releaseSignal::Sig_activate_spi_voicerecognition_short_releaseSignal (const Sig_activate_spi_voicerecognition_short_releaseSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Sig_activate_spi_voicerecognition_short_releaseSignal::Sig_activate_spi_voicerecognition_short_releaseSignal (bool status_)  :
    _status (status_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Sig_activate_spi_voicerecognition_short_releaseSignal::~Sig_activate_spi_voicerecognition_short_releaseSignal() {
}

inline Sig_activate_spi_voicerecognition_short_releaseSignal& Sig_activate_spi_voicerecognition_short_releaseSignal::operator = (const Sig_activate_spi_voicerecognition_short_releaseSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool Sig_activate_spi_voicerecognition_short_releaseSignal::operator == (const Sig_activate_spi_voicerecognition_short_releaseSignal& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool Sig_activate_spi_voicerecognition_short_releaseSignal::operator != (const Sig_activate_spi_voicerecognition_short_releaseSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool Sig_activate_spi_voicerecognition_short_releaseSignal::operator < (const Sig_activate_spi_voicerecognition_short_releaseSignal& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Sig_activate_spi_voicerecognition_short_releaseSignal::clone() {
    return new Sig_activate_spi_voicerecognition_short_releaseSignal(*this);
}

inline bool Sig_activate_spi_voicerecognition_short_releaseSignal::operator > (const Sig_activate_spi_voicerecognition_short_releaseSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Sig_activate_spi_voicerecognition_short_releaseSignal::clear() {
    clearStatus();
}

inline void Sig_activate_spi_voicerecognition_short_releaseSignal::clearStatus() {
    if (hasStatus()) {
         clear_has_status();
        _status = false;
     }
}

inline bool Sig_activate_spi_voicerecognition_short_releaseSignal::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool Sig_activate_spi_voicerecognition_short_releaseSignal::getStatus () const {
    return _status;
}

inline void Sig_activate_spi_voicerecognition_short_releaseSignal::setStatus (bool status_) {
    set_has_status();
    this->_status = status_;
}

inline void Sig_activate_spi_voicerecognition_short_releaseSignal::set_has_status () {
    _has_bits_[0] |= 1u << 0;
}

inline void Sig_activate_spi_voicerecognition_short_releaseSignal::clear_has_status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  Sig_activate_spi_voicerecognition_long_releaseSignal::Sig_activate_spi_voicerecognition_long_releaseSignal ()  :
    _status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Sig_activate_spi_voicerecognition_long_releaseSignal::Sig_activate_spi_voicerecognition_long_releaseSignal (const Sig_activate_spi_voicerecognition_long_releaseSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Sig_activate_spi_voicerecognition_long_releaseSignal::Sig_activate_spi_voicerecognition_long_releaseSignal (bool status_)  :
    _status (status_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Sig_activate_spi_voicerecognition_long_releaseSignal::~Sig_activate_spi_voicerecognition_long_releaseSignal() {
}

inline Sig_activate_spi_voicerecognition_long_releaseSignal& Sig_activate_spi_voicerecognition_long_releaseSignal::operator = (const Sig_activate_spi_voicerecognition_long_releaseSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool Sig_activate_spi_voicerecognition_long_releaseSignal::operator == (const Sig_activate_spi_voicerecognition_long_releaseSignal& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool Sig_activate_spi_voicerecognition_long_releaseSignal::operator != (const Sig_activate_spi_voicerecognition_long_releaseSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool Sig_activate_spi_voicerecognition_long_releaseSignal::operator < (const Sig_activate_spi_voicerecognition_long_releaseSignal& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Sig_activate_spi_voicerecognition_long_releaseSignal::clone() {
    return new Sig_activate_spi_voicerecognition_long_releaseSignal(*this);
}

inline bool Sig_activate_spi_voicerecognition_long_releaseSignal::operator > (const Sig_activate_spi_voicerecognition_long_releaseSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Sig_activate_spi_voicerecognition_long_releaseSignal::clear() {
    clearStatus();
}

inline void Sig_activate_spi_voicerecognition_long_releaseSignal::clearStatus() {
    if (hasStatus()) {
         clear_has_status();
        _status = false;
     }
}

inline bool Sig_activate_spi_voicerecognition_long_releaseSignal::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool Sig_activate_spi_voicerecognition_long_releaseSignal::getStatus () const {
    return _status;
}

inline void Sig_activate_spi_voicerecognition_long_releaseSignal::setStatus (bool status_) {
    set_has_status();
    this->_status = status_;
}

inline void Sig_activate_spi_voicerecognition_long_releaseSignal::set_has_status () {
    _has_bits_[0] |= 1u << 0;
}

inline void Sig_activate_spi_voicerecognition_long_releaseSignal::clear_has_status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  Sig_activate_deactivate_SpeechSessionSignal::Sig_activate_deactivate_SpeechSessionSignal ()  :
    _status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Sig_activate_deactivate_SpeechSessionSignal::Sig_activate_deactivate_SpeechSessionSignal (const Sig_activate_deactivate_SpeechSessionSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Sig_activate_deactivate_SpeechSessionSignal::Sig_activate_deactivate_SpeechSessionSignal (bool status_)  :
    _status (status_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Sig_activate_deactivate_SpeechSessionSignal::~Sig_activate_deactivate_SpeechSessionSignal() {
}

inline Sig_activate_deactivate_SpeechSessionSignal& Sig_activate_deactivate_SpeechSessionSignal::operator = (const Sig_activate_deactivate_SpeechSessionSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool Sig_activate_deactivate_SpeechSessionSignal::operator == (const Sig_activate_deactivate_SpeechSessionSignal& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool Sig_activate_deactivate_SpeechSessionSignal::operator != (const Sig_activate_deactivate_SpeechSessionSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool Sig_activate_deactivate_SpeechSessionSignal::operator < (const Sig_activate_deactivate_SpeechSessionSignal& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Sig_activate_deactivate_SpeechSessionSignal::clone() {
    return new Sig_activate_deactivate_SpeechSessionSignal(*this);
}

inline bool Sig_activate_deactivate_SpeechSessionSignal::operator > (const Sig_activate_deactivate_SpeechSessionSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Sig_activate_deactivate_SpeechSessionSignal::clear() {
    clearStatus();
}

inline void Sig_activate_deactivate_SpeechSessionSignal::clearStatus() {
    if (hasStatus()) {
         clear_has_status();
        _status = false;
     }
}

inline bool Sig_activate_deactivate_SpeechSessionSignal::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool Sig_activate_deactivate_SpeechSessionSignal::getStatus () const {
    return _status;
}

inline void Sig_activate_deactivate_SpeechSessionSignal::setStatus (bool status_) {
    set_has_status();
    this->_status = status_;
}

inline void Sig_activate_deactivate_SpeechSessionSignal::set_has_status () {
    _has_bits_[0] |= 1u << 0;
}

inline void Sig_activate_deactivate_SpeechSessionSignal::clear_has_status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  Sig_ControlPanelButtonPressSignal::Sig_ControlPanelButtonPressSignal ()  :
    _buttonId (0u),
    _buttonState (0u),
    _receiverAppID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Sig_ControlPanelButtonPressSignal::Sig_ControlPanelButtonPressSignal (const Sig_ControlPanelButtonPressSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _buttonId (0u),
    _buttonState (0u),
    _receiverAppID (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Sig_ControlPanelButtonPressSignal::Sig_ControlPanelButtonPressSignal (uint8 buttonId_, uint8 buttonState_, uint32 receiverAppID_)  :
    _buttonId (buttonId_),
    _buttonState (buttonState_),
    _receiverAppID (receiverAppID_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Sig_ControlPanelButtonPressSignal::~Sig_ControlPanelButtonPressSignal() {
}

inline Sig_ControlPanelButtonPressSignal& Sig_ControlPanelButtonPressSignal::operator = (const Sig_ControlPanelButtonPressSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasButtonId()) {
            setButtonId(rhs.getButtonId());
        } else {
            clearButtonId();
        }
        if (rhs.hasButtonState()) {
            setButtonState(rhs.getButtonState());
        } else {
            clearButtonState();
        }
        if (rhs.hasReceiverAppID()) {
            setReceiverAppID(rhs.getReceiverAppID());
        } else {
            clearReceiverAppID();
        }
    }
    return *this;
}

inline bool Sig_ControlPanelButtonPressSignal::operator == (const Sig_ControlPanelButtonPressSignal& rhs) const {
    return (((!hasButtonId() && !rhs.hasButtonId()) || getButtonId() == rhs.getButtonId()) &&
        ((!hasButtonState() && !rhs.hasButtonState()) || getButtonState() == rhs.getButtonState()) &&
        ((!hasReceiverAppID() && !rhs.hasReceiverAppID()) || getReceiverAppID() == rhs.getReceiverAppID()));
}

inline bool Sig_ControlPanelButtonPressSignal::operator != (const Sig_ControlPanelButtonPressSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool Sig_ControlPanelButtonPressSignal::operator < (const Sig_ControlPanelButtonPressSignal& rhs) const {
    if (hasButtonId() || rhs.hasButtonId()) {
        if (getButtonId() < rhs.getButtonId()) return true;
        if (getButtonId() > rhs.getButtonId()) return false;
    }
    if (hasButtonState() || rhs.hasButtonState()) {
        if (getButtonState() < rhs.getButtonState()) return true;
        if (getButtonState() > rhs.getButtonState()) return false;
    }
    if (hasReceiverAppID() || rhs.hasReceiverAppID()) {
        if (getReceiverAppID() < rhs.getReceiverAppID()) return true;
        if (getReceiverAppID() > rhs.getReceiverAppID()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Sig_ControlPanelButtonPressSignal::clone() {
    return new Sig_ControlPanelButtonPressSignal(*this);
}

inline bool Sig_ControlPanelButtonPressSignal::operator > (const Sig_ControlPanelButtonPressSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Sig_ControlPanelButtonPressSignal::clear() {
    clearButtonId();
    clearButtonState();
    clearReceiverAppID();
}

inline void Sig_ControlPanelButtonPressSignal::clearButtonId() {
    if (hasButtonId()) {
         clear_has_buttonId();
        _buttonId = 0u;
     }
}

inline bool Sig_ControlPanelButtonPressSignal::hasButtonId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 Sig_ControlPanelButtonPressSignal::getButtonId () const {
    return _buttonId;
}

inline void Sig_ControlPanelButtonPressSignal::setButtonId (uint8 buttonId_) {
    set_has_buttonId();
    this->_buttonId = buttonId_;
}

inline void Sig_ControlPanelButtonPressSignal::clearButtonState() {
    if (hasButtonState()) {
         clear_has_buttonState();
        _buttonState = 0u;
     }
}

inline bool Sig_ControlPanelButtonPressSignal::hasButtonState () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 Sig_ControlPanelButtonPressSignal::getButtonState () const {
    return _buttonState;
}

inline void Sig_ControlPanelButtonPressSignal::setButtonState (uint8 buttonState_) {
    set_has_buttonState();
    this->_buttonState = buttonState_;
}

inline void Sig_ControlPanelButtonPressSignal::clearReceiverAppID() {
    if (hasReceiverAppID()) {
         clear_has_receiverAppID();
        _receiverAppID = 0u;
     }
}

inline bool Sig_ControlPanelButtonPressSignal::hasReceiverAppID () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 Sig_ControlPanelButtonPressSignal::getReceiverAppID () const {
    return _receiverAppID;
}

inline void Sig_ControlPanelButtonPressSignal::setReceiverAppID (uint32 receiverAppID_) {
    set_has_receiverAppID();
    this->_receiverAppID = receiverAppID_;
}

inline void Sig_ControlPanelButtonPressSignal::set_has_buttonId () {
    _has_bits_[0] |= 1u << 0;
}

inline void Sig_ControlPanelButtonPressSignal::clear_has_buttonId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void Sig_ControlPanelButtonPressSignal::set_has_buttonState () {
    _has_bits_[0] |= 1u << 1;
}

inline void Sig_ControlPanelButtonPressSignal::clear_has_buttonState () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void Sig_ControlPanelButtonPressSignal::set_has_receiverAppID () {
    _has_bits_[0] |= 1u << 2;
}

inline void Sig_ControlPanelButtonPressSignal::clear_has_receiverAppID () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  Sig_ActivateContextSignal::Sig_ActivateContextSignal ()  :
    _regionId (0u),
    _targetappId (0u),
    _targetactivityId (::bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch::enActivityIDs__eActivityID_NONE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Sig_ActivateContextSignal::Sig_ActivateContextSignal (const Sig_ActivateContextSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _regionId (0u),
    _targetappId (0u),
    _targetactivityId (::bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch::enActivityIDs__eActivityID_NONE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Sig_ActivateContextSignal::Sig_ActivateContextSignal (uint8 regionId_, uint8 targetappId_, enActivityIDs targetactivityId_)  :
    _regionId (regionId_),
    _targetappId (targetappId_),
    _targetactivityId (targetactivityId_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(enActivityIDs_IsValid(targetactivityId_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", targetactivityId_, "enActivityIDs", "targetactivityId", "Sig_ActivateContextSignal");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Sig_ActivateContextSignal::~Sig_ActivateContextSignal() {
}

inline Sig_ActivateContextSignal& Sig_ActivateContextSignal::operator = (const Sig_ActivateContextSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasRegionId()) {
            setRegionId(rhs.getRegionId());
        } else {
            clearRegionId();
        }
        if (rhs.hasTargetappId()) {
            setTargetappId(rhs.getTargetappId());
        } else {
            clearTargetappId();
        }
        if (rhs.hasTargetactivityId()) {
            setTargetactivityId(rhs.getTargetactivityId());
        } else {
            clearTargetactivityId();
        }
    }
    return *this;
}

inline bool Sig_ActivateContextSignal::operator == (const Sig_ActivateContextSignal& rhs) const {
    return (((!hasRegionId() && !rhs.hasRegionId()) || getRegionId() == rhs.getRegionId()) &&
        ((!hasTargetappId() && !rhs.hasTargetappId()) || getTargetappId() == rhs.getTargetappId()) &&
        ((!hasTargetactivityId() && !rhs.hasTargetactivityId()) || getTargetactivityId() == rhs.getTargetactivityId()));
}

inline bool Sig_ActivateContextSignal::operator != (const Sig_ActivateContextSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool Sig_ActivateContextSignal::operator < (const Sig_ActivateContextSignal& rhs) const {
    if (hasRegionId() || rhs.hasRegionId()) {
        if (getRegionId() < rhs.getRegionId()) return true;
        if (getRegionId() > rhs.getRegionId()) return false;
    }
    if (hasTargetappId() || rhs.hasTargetappId()) {
        if (getTargetappId() < rhs.getTargetappId()) return true;
        if (getTargetappId() > rhs.getTargetappId()) return false;
    }
    if (hasTargetactivityId() || rhs.hasTargetactivityId()) {
        if ((uint32)getTargetactivityId() < (uint32)rhs.getTargetactivityId()) return true;
        if ((uint32)getTargetactivityId() > (uint32)rhs.getTargetactivityId()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Sig_ActivateContextSignal::clone() {
    return new Sig_ActivateContextSignal(*this);
}

inline bool Sig_ActivateContextSignal::operator > (const Sig_ActivateContextSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Sig_ActivateContextSignal::clear() {
    clearRegionId();
    clearTargetappId();
    clearTargetactivityId();
}

inline void Sig_ActivateContextSignal::clearRegionId() {
    if (hasRegionId()) {
         clear_has_regionId();
        _regionId = 0u;
     }
}

inline bool Sig_ActivateContextSignal::hasRegionId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 Sig_ActivateContextSignal::getRegionId () const {
    return _regionId;
}

inline void Sig_ActivateContextSignal::setRegionId (uint8 regionId_) {
    set_has_regionId();
    this->_regionId = regionId_;
}

inline void Sig_ActivateContextSignal::clearTargetappId() {
    if (hasTargetappId()) {
         clear_has_targetappId();
        _targetappId = 0u;
     }
}

inline bool Sig_ActivateContextSignal::hasTargetappId () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 Sig_ActivateContextSignal::getTargetappId () const {
    return _targetappId;
}

inline void Sig_ActivateContextSignal::setTargetappId (uint8 targetappId_) {
    set_has_targetappId();
    this->_targetappId = targetappId_;
}

inline void Sig_ActivateContextSignal::clearTargetactivityId() {
    if (hasTargetactivityId()) {
         clear_has_targetactivityId();
        _targetactivityId = ::bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch::enActivityIDs__eActivityID_NONE;
     }
}

inline bool Sig_ActivateContextSignal::hasTargetactivityId () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline enActivityIDs Sig_ActivateContextSignal::getTargetactivityId () const {
    return _targetactivityId;
}

inline void Sig_ActivateContextSignal::setTargetactivityId (enActivityIDs targetactivityId_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(enActivityIDs_IsValid(targetactivityId_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", targetactivityId_, "enActivityIDs", "targetactivityId", "Sig_ActivateContextSignal");
    }
    set_has_targetactivityId();
    this->_targetactivityId = targetactivityId_;
}

inline void Sig_ActivateContextSignal::set_has_regionId () {
    _has_bits_[0] |= 1u << 0;
}

inline void Sig_ActivateContextSignal::clear_has_regionId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void Sig_ActivateContextSignal::set_has_targetappId () {
    _has_bits_[0] |= 1u << 1;
}

inline void Sig_ActivateContextSignal::clear_has_targetappId () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void Sig_ActivateContextSignal::set_has_targetactivityId () {
    _has_bits_[0] |= 1u << 2;
}

inline void Sig_ActivateContextSignal::clear_has_targetactivityId () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  Sig_SWCKeyEventSignal::Sig_SWCKeyEventSignal ()  :
    _keyEvent (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Sig_SWCKeyEventSignal::Sig_SWCKeyEventSignal (const Sig_SWCKeyEventSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _keyEvent (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Sig_SWCKeyEventSignal::Sig_SWCKeyEventSignal (uint8 keyEvent_)  :
    _keyEvent (keyEvent_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Sig_SWCKeyEventSignal::~Sig_SWCKeyEventSignal() {
}

inline Sig_SWCKeyEventSignal& Sig_SWCKeyEventSignal::operator = (const Sig_SWCKeyEventSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasKeyEvent()) {
            setKeyEvent(rhs.getKeyEvent());
        } else {
            clearKeyEvent();
        }
    }
    return *this;
}

inline bool Sig_SWCKeyEventSignal::operator == (const Sig_SWCKeyEventSignal& rhs) const {
    return (((!hasKeyEvent() && !rhs.hasKeyEvent()) || getKeyEvent() == rhs.getKeyEvent()));
}

inline bool Sig_SWCKeyEventSignal::operator != (const Sig_SWCKeyEventSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool Sig_SWCKeyEventSignal::operator < (const Sig_SWCKeyEventSignal& rhs) const {
    if (hasKeyEvent() || rhs.hasKeyEvent()) {
        if (getKeyEvent() < rhs.getKeyEvent()) return true;
        if (getKeyEvent() > rhs.getKeyEvent()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Sig_SWCKeyEventSignal::clone() {
    return new Sig_SWCKeyEventSignal(*this);
}

inline bool Sig_SWCKeyEventSignal::operator > (const Sig_SWCKeyEventSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Sig_SWCKeyEventSignal::clear() {
    clearKeyEvent();
}

inline void Sig_SWCKeyEventSignal::clearKeyEvent() {
    if (hasKeyEvent()) {
         clear_has_keyEvent();
        _keyEvent = 0u;
     }
}

inline bool Sig_SWCKeyEventSignal::hasKeyEvent () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 Sig_SWCKeyEventSignal::getKeyEvent () const {
    return _keyEvent;
}

inline void Sig_SWCKeyEventSignal::setKeyEvent (uint8 keyEvent_) {
    set_has_keyEvent();
    this->_keyEvent = keyEvent_;
}

inline void Sig_SWCKeyEventSignal::set_has_keyEvent () {
    _has_bits_[0] |= 1u << 0;
}

inline void Sig_SWCKeyEventSignal::clear_has_keyEvent () {
    _has_bits_[0] &= ~ (1u << 0);
}

} // namespace ApplicationSwitch
} // namespace hmimasterservice
} // namespace hmi
} // namespace ai
} // namespace cm
} // namespace bosch

#endif // BOSCH_CM_AI_HMI_HMIMASTERSERVICE_APPLICATIONSWITCH_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
