/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "App/Core/AppHmi_Testmode.h"
#include "App/Core/TestmodeGui.h"
#include "App/Core/TestmodeHall.h"
#include "asf/cca/CcaConnector.h"
#include "asf/cca/CcaImportedPort.h"
#include "asf/cms/CmsProvidedPortListener.h"
#include "asf/core/Application.h"
#include "asf/core/ComponentContainer.h"
#include "asf/core/ComponentDescription.h"
#include "asf/core/ContextData.h"
#include "asf/core/Logger.h"
#include "asf/core/ProvidedPort.h"
#include "asf/core/RequiredPort.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusImportedPort.h"
#include "com/bosch/cm/asf/lang/cca/Connectors.h"
#include "com/bosch/cm/asf/lang/cca/ConnectorsJson.h"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "com/bosch/cm/asf/lang/dbus/ConnectorsJson.h"
#include <cstdio>
#include <string>

/**
 * If the meaning of "AppHmi_Testmode" isn't clear, then there should be a description here.
 */

namespace App {
namespace Core {

DEFINE_LOGGER_AND_LEVEL (_logger, "/App/Core/AppHmi_Testmode", Info);

/* static */ const char* AppHmi_Testmode::testmodeGui = "testmodeGui";
/* static */ const char* AppHmi_Testmode::testmodeHall = "testmodeHall";

static const char* helpMessage =
    "--logconfig <file>     Read the logging configuration from <file>\n"
    "                       see the ASF User Guide, section 6.3. Logging API\n"
    "--help                 Print this help message\n";

bool AppHmi_Testmode_enabledASFSignalHandler = false;

void importAppHmi_Testmode() {
    ::asf::core::Application* app = ::asf::core::Application::getApplication();
    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't attach AppHmi_Testmode, because no Application is instantiated");

    // Expression

    ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector dbusSystemConnector;
    {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector __expression0;
        {
            __expression0.setBusType(::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector::BusType__System);
        }
        dbusSystemConnector = __expression0;
    }
    {
        std::string jsonPayload;
        serializeJson (dbusSystemConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "dbusSystemConnector", "DBusConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::dbus::DBusConnector > dbusSystemConnector_(new ::asf::dbus::DBusConnector(*app, dbusSystemConnector));
    app->addStarter(dbusSystemConnector_);

    // Expression

    ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector dbusSessionConnector;
    {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector __expression1;
        {
            __expression1.setBusType(::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector::BusType__Session);
        }
        dbusSessionConnector = __expression1;
    }
    {
        std::string jsonPayload;
        serializeJson (dbusSessionConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "dbusSessionConnector", "DBusConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::dbus::DBusConnector > dbusSessionConnector_(new ::asf::dbus::DBusConnector(*app, dbusSessionConnector));
    app->addStarter(dbusSessionConnector_);

    // Expression

    ::com::bosch::cm::asf::lang::cca::Connectors::CcaConnector ccaConnector;
    {
        ::com::bosch::cm::asf::lang::cca::Connectors::CcaConnector __expression2;
        {
            __expression2.setApplicationId(155);
        }
        ccaConnector = __expression2;
    }
    {
        std::string jsonPayload;
        serializeJson (ccaConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "ccaConnector", "CcaConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::cca::CcaConnector > ccaConnector_(new ::asf::cca::CcaConnector(*app, ccaConnector));
    app->addStarter(ccaConnector_);

    // Thread 'TestmodeHmi'

    ::asf::core::ComponentContainerSharedPtr TestmodeHmi(new ::asf::core::ComponentContainer("TestmodeHmi", ::asf::core::ThreadConfiguration(1)));
    app->addContainer (TestmodeHmi);

        // Component 'TestmodeGui testmodeGui'

        ::boost::shared_ptr< ::asf::core::ComponentFactory< ::App::Core::TestmodeGui > > testmodeGuiFactory(new ::asf::core::ComponentFactory< ::App::Core::TestmodeGui >);
        ::asf::core::ComponentDescriptionSharedPtr testmodeGuiDescription(new ::asf::core::ComponentDescription(1, "testmodeGui", /* immediate = */ true, /* threadBridge = */ false, testmodeGuiFactory));
        TestmodeHmi->addComponentDescription(testmodeGuiDescription);

            // Port 'courierMessageReceiverPort'

            ::asf::core::RequiredPort& testmodeGui_courierMessageReceiverPort = testmodeGuiDescription->addRequiredPort (::asf::core::RequiredPort ("CourierTunnelService.CourierMessageReceiver", "courierMessageReceiverPort"));
            (void)testmodeGui_courierMessageReceiverPort; // prevent unused variable warning

            // Port 'hmiAppCtrlPort'

            ::asf::core::RequiredPort& testmodeGui_hmiAppCtrlPort = testmodeGuiDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.ai.hmi.appctrl.HMIAppCtrl", "hmiAppCtrlPort"));
            (void)testmodeGui_hmiAppCtrlPort; // prevent unused variable warning

            // Port 'hmiAppCtrlTraceCmdPort'

            ::asf::core::RequiredPort& testmodeGui_hmiAppCtrlTraceCmdPort = testmodeGuiDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.ai.hmi.appctrl.trace.Commands", "hmiAppCtrlTraceCmdPort"));
            (void)testmodeGui_hmiAppCtrlTraceCmdPort; // prevent unused variable warning

            // Port 'SBServicePort'

            ::asf::core::RequiredPort& testmodeGui_SBServicePort = testmodeGuiDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.ai.hmi.screenbroker.Service", "SBServicePort"));
            (void)testmodeGui_SBServicePort; // prevent unused variable warning

        // Component 'TestmodeHall testmodeHall'

        ::boost::shared_ptr< ::asf::core::ComponentFactory< ::App::Core::TestmodeHall > > testmodeHallFactory(new ::asf::core::ComponentFactory< ::App::Core::TestmodeHall >);
        ::asf::core::ComponentDescriptionSharedPtr testmodeHallDescription(new ::asf::core::ComponentDescription(2, "testmodeHall", /* immediate = */ true, /* threadBridge = */ false, testmodeHallFactory));
        TestmodeHmi->addComponentDescription(testmodeHallDescription);

            // Port 'spmFiPort'

            ::asf::core::RequiredPort& testmodeHall_spmFiPort = testmodeHallDescription->addRequiredPort (::asf::core::RequiredPort ("CFC_SPM_FI", "spmFiPort"));
            (void)testmodeHall_spmFiPort; // prevent unused variable warning

            // Port 'ConsumerPort'

            ::asf::core::RequiredPort& testmodeHall_ConsumerPort = testmodeHallDescription->addRequiredPort (::asf::core::RequiredPort ("org.genivi.NodeStateManager.Consumer", "ConsumerPort"));
            (void)testmodeHall_ConsumerPort; // prevent unused variable warning

            // Port 'LifecycleControlPort'

            ::asf::core::RequiredPort& testmodeHall_LifecycleControlPort = testmodeHallDescription->addRequiredPort (::asf::core::RequiredPort ("org.genivi.NodeStateManager.LifecycleControl", "LifecycleControlPort"));
            (void)testmodeHall_LifecycleControlPort; // prevent unused variable warning

            // Port 'LifeCycleConsumerPort'

            ::asf::core::ProvidedPort& testmodeHall_LifeCycleConsumerPort = testmodeHallDescription->addProvidedPort (::asf::core::ProvidedPort ("org.genivi.NodeStateManager.LifeCycleConsumer", "LifeCycleConsumerPort", false, false));
            (void)testmodeHall_LifeCycleConsumerPort; // prevent unused variable warning

            // Port 'courierMessageReceiverPort'

            ::asf::core::ProvidedPort& testmodeHall_courierMessageReceiverPort = testmodeHallDescription->addProvidedPort (::asf::core::ProvidedPort ("CourierTunnelService.CourierMessageReceiver", "courierMessageReceiverPort", ::boost::shared_ptr< ::asf::core::ProvidedPortListener >(new ::asf::cms::CmsProvidedPortListener())));
            (void)testmodeHall_courierMessageReceiverPort; // prevent unused variable warning

            // Port 'tunerFiPort'

            ::asf::core::RequiredPort& testmodeHall_tunerFiPort = testmodeHallDescription->addRequiredPort (::asf::core::RequiredPort ("MIDW_TUNER_FI", "tunerFiPort"));
            (void)testmodeHall_tunerFiPort; // prevent unused variable warning

            // Port 'dabFiPort'

            ::asf::core::RequiredPort& testmodeHall_dabFiPort = testmodeHallDescription->addRequiredPort (::asf::core::RequiredPort ("MIDW_EXT_DABTUNER_FI", "dabFiPort"));
            (void)testmodeHall_dabFiPort; // prevent unused variable warning

            // Port 'tunermasterFiPort'

            ::asf::core::RequiredPort& testmodeHall_tunermasterFiPort = testmodeHallDescription->addRequiredPort (::asf::core::RequiredPort ("MIDW_TUNERMASTER_FI", "tunermasterFiPort"));
            (void)testmodeHall_tunermasterFiPort; // prevent unused variable warning

            // Port 'audioMascfFiPort'

            ::asf::core::RequiredPort& testmodeHall_audioMascfFiPort = testmodeHallDescription->addRequiredPort (::asf::core::RequiredPort ("midw_mascf_fi", "audioMascfFiPort"));
            (void)testmodeHall_audioMascfFiPort; // prevent unused variable warning

            // Port 'diagnosticsFiPort'

            ::asf::core::RequiredPort& testmodeHall_diagnosticsFiPort = testmodeHallDescription->addRequiredPort (::asf::core::RequiredPort ("Midw_Diagnostics_FI", "diagnosticsFiPort"));
            (void)testmodeHall_diagnosticsFiPort; // prevent unused variable warning

            // Port 'vehicleMainFiPort'

            ::asf::core::RequiredPort& testmodeHall_vehicleMainFiPort = testmodeHallDescription->addRequiredPort (::asf::core::RequiredPort ("VEHICLE_MAIN_FI", "vehicleMainFiPort"));
            (void)testmodeHall_vehicleMainFiPort; // prevent unused variable warning

            // Port 'SxmAudioFiPort'

            ::asf::core::RequiredPort& testmodeHall_SxmAudioFiPort = testmodeHallDescription->addRequiredPort (::asf::core::RequiredPort ("sxm_audio_main_fi", "SxmAudioFiPort"));
            (void)testmodeHall_SxmAudioFiPort; // prevent unused variable warning

            // Port 'SxmChannelArtFiPort'

            ::asf::core::RequiredPort& testmodeHall_SxmChannelArtFiPort = testmodeHallDescription->addRequiredPort (::asf::core::RequiredPort ("sxm_channelart_main_fi", "SxmChannelArtFiPort"));
            (void)testmodeHall_SxmChannelArtFiPort; // prevent unused variable warning

            // Port 'SxmFuelFiPort'

            ::asf::core::RequiredPort& testmodeHall_SxmFuelFiPort = testmodeHallDescription->addRequiredPort (::asf::core::RequiredPort ("sxm_fuel_main_fi", "SxmFuelFiPort"));
            (void)testmodeHall_SxmFuelFiPort; // prevent unused variable warning

            // Port 'SxmMoviesFiPort'

            ::asf::core::RequiredPort& testmodeHall_SxmMoviesFiPort = testmodeHallDescription->addRequiredPort (::asf::core::RequiredPort ("sxm_movies_main_fi", "SxmMoviesFiPort"));
            (void)testmodeHall_SxmMoviesFiPort; // prevent unused variable warning

            // Port 'SxmSportsFiPort'

            ::asf::core::RequiredPort& testmodeHall_SxmSportsFiPort = testmodeHallDescription->addRequiredPort (::asf::core::RequiredPort ("sxm_sports_main_fi", "SxmSportsFiPort"));
            (void)testmodeHall_SxmSportsFiPort; // prevent unused variable warning

            // Port 'SxmStocksFiPort'

            ::asf::core::RequiredPort& testmodeHall_SxmStocksFiPort = testmodeHallDescription->addRequiredPort (::asf::core::RequiredPort ("sxm_stocks_main_fi", "SxmStocksFiPort"));
            (void)testmodeHall_SxmStocksFiPort; // prevent unused variable warning

            // Port 'SxmTabWeatherFiPort'

            ::asf::core::RequiredPort& testmodeHall_SxmTabWeatherFiPort = testmodeHallDescription->addRequiredPort (::asf::core::RequiredPort ("sxm_tabweather_main_fi", "SxmTabWeatherFiPort"));
            (void)testmodeHall_SxmTabWeatherFiPort; // prevent unused variable warning

            // Port 'SxmWsAlertsFiPort'

            ::asf::core::RequiredPort& testmodeHall_SxmWsAlertsFiPort = testmodeHallDescription->addRequiredPort (::asf::core::RequiredPort ("sxm_wsalerts_main_fi", "SxmWsAlertsFiPort"));
            (void)testmodeHall_SxmWsAlertsFiPort; // prevent unused variable warning

            // Port 'SxmCanadianFuelFiPort'

            ::asf::core::RequiredPort& testmodeHall_SxmCanadianFuelFiPort = testmodeHallDescription->addRequiredPort (::asf::core::RequiredPort ("sxm_canadian_fuel_main_fi", "SxmCanadianFuelFiPort"));
            (void)testmodeHall_SxmCanadianFuelFiPort; // prevent unused variable warning

            // Port 'SxmParkingFiPort'

            ::asf::core::RequiredPort& testmodeHall_SxmParkingFiPort = testmodeHallDescription->addRequiredPort (::asf::core::RequiredPort ("sxm_parking_main_fi", "SxmParkingFiPort"));
            (void)testmodeHall_SxmParkingFiPort; // prevent unused variable warning

            // Port 'SxmAudioSourceChangePort'

            ::asf::core::RequiredPort& testmodeHall_SxmAudioSourceChangePort = testmodeHallDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.ai.hmi.masteraudioservice.AudioSourceChange", "SxmAudioSourceChangePort"));
            (void)testmodeHall_SxmAudioSourceChangePort; // prevent unused variable warning

            // Port 'SXMSoundPropertiesPort'

            ::asf::core::RequiredPort& testmodeHall_SXMSoundPropertiesPort = testmodeHallDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.ai.hmi.masteraudioservice.SoundProperties", "SXMSoundPropertiesPort"));
            (void)testmodeHall_SXMSoundPropertiesPort; // prevent unused variable warning

            // Port 'applicationSwitchPort'

            ::asf::core::RequiredPort& testmodeHall_applicationSwitchPort = testmodeHallDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.ai.hmi.hmimasterservice.ApplicationSwitch", "applicationSwitchPort"));
            (void)testmodeHall_applicationSwitchPort; // prevent unused variable warning

            // Port 'audioSourceChangePort'

            ::asf::core::RequiredPort& testmodeHall_audioSourceChangePort = testmodeHallDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.ai.hmi.masteraudioservice.AudioSourceChange", "audioSourceChangePort"));
            (void)testmodeHall_audioSourceChangePort; // prevent unused variable warning

            // Port 'soundPropertiesPort'

            ::asf::core::RequiredPort& testmodeHall_soundPropertiesPort = testmodeHallDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.ai.hmi.masteraudioservice.SoundProperties", "soundPropertiesPort"));
            (void)testmodeHall_soundPropertiesPort; // prevent unused variable warning

            // Port 'rvcFiPort'

            ::asf::core::RequiredPort& testmodeHall_rvcFiPort = testmodeHallDescription->addRequiredPort (::asf::core::RequiredPort ("rvc_cca_fi", "rvcFiPort"));
            (void)testmodeHall_rvcFiPort; // prevent unused variable warning

            // Port 'hmiinfoservicePort'

            ::asf::core::RequiredPort& testmodeHall_hmiinfoservicePort = testmodeHallDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.ai.hmi.hmiinfoservice.HmiInfoService", "hmiinfoservicePort"));
            (void)testmodeHall_hmiinfoservicePort; // prevent unused variable warning

            // Port 'btSetFiPort'

            ::asf::core::RequiredPort& testmodeHall_btSetFiPort = testmodeHallDescription->addRequiredPort (::asf::core::RequiredPort ("MOST_BTSet_FI", "btSetFiPort"));
            (void)testmodeHall_btSetFiPort; // prevent unused variable warning

            // Port 'btTelFiPort'

            ::asf::core::RequiredPort& testmodeHall_btTelFiPort = testmodeHallDescription->addRequiredPort (::asf::core::RequiredPort ("MOST_Tel_FI", "btTelFiPort"));
            (void)testmodeHall_btTelFiPort; // prevent unused variable warning

            // Port 'mediaPlayerFiPort'

            ::asf::core::RequiredPort& testmodeHall_mediaPlayerFiPort = testmodeHallDescription->addRequiredPort (::asf::core::RequiredPort ("mplay_MediaPlayer_FI", "mediaPlayerFiPort"));
            (void)testmodeHall_mediaPlayerFiPort; // prevent unused variable warning

            // Port 'HealthcareMonServerPort'

            ::asf::core::RequiredPort& testmodeHall_HealthcareMonServerPort = testmodeHallDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.ai.HealthcareMonService", "HealthcareMonServerPort"));
            (void)testmodeHall_HealthcareMonServerPort; // prevent unused variable warning

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (testmodeGui_courierMessageReceiverPort, testmodeHall_courierMessageReceiverPort);

    // Expression

    ::asf::dbus::DBusImportedPort& hmiAppCtrlImport = dbusSessionConnector_->importByName (::std::string("App.Core.AppHmi_Master"), ::std::string("/bosch/cm/ai/hmi/hmiappctrl"));
    hmiAppCtrlImport.setServiceName("bosch.cm.ai.hmi.appctrl.HMIAppCtrl");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (testmodeGui_hmiAppCtrlPort, hmiAppCtrlImport);

    // Expression

    ::asf::cca::CcaImportedPort& spmFiImport = ccaConnector_->importByName (0, 1, 0, 2);
    spmFiImport.setServiceName("CFC_SPM_FI");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (testmodeHall_spmFiPort, spmFiImport);

    // Expression

    ::asf::dbus::DBusImportedPort& hmiTraceCmdImport = dbusSessionConnector_->importByName (::std::string("hmibase.trace.HMITraceCmd_Daemon"), ::std::string("/bosch/cm/ai/hmi/appctrl/trace/Commands"));
    hmiTraceCmdImport.setServiceName("bosch.cm.ai.hmi.appctrl.trace.Commands");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (testmodeGui_hmiAppCtrlTraceCmdPort, hmiTraceCmdImport);

    // Expression

    ::asf::dbus::DBusImportedPort& soundPropertiesImport = dbusSessionConnector_->importByName (::std::string("App.Core.AppHmi_Master"), ::std::string("/bosch/cm/ai/hmi/hmisoundsettings"));
    soundPropertiesImport.setServiceName("bosch.cm.ai.hmi.masteraudioservice.SoundProperties");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (testmodeHall_soundPropertiesPort, soundPropertiesImport);

    // Expression

    ::asf::cca::CcaImportedPort& diagnosticsFiImport = ccaConnector_->importByName (276, 1, 3, 2);
    diagnosticsFiImport.setServiceName("Midw_Diagnostics_FI");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (testmodeHall_diagnosticsFiPort, diagnosticsFiImport);

    // Expression

    ::asf::cca::CcaImportedPort& tunerFiImport = ccaConnector_->importByName (264, 3, 0, 2);
    tunerFiImport.setServiceName("MIDW_TUNER_FI");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (testmodeHall_tunerFiPort, tunerFiImport);

    // Expression

    ::asf::cca::CcaImportedPort& dabFiImport = ccaConnector_->importByName (46, 2, 0, 2);
    dabFiImport.setServiceName("MIDW_EXT_DABTUNER_FI");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (testmodeHall_dabFiPort, dabFiImport);

    // Expression

    ::asf::cca::CcaImportedPort& tunermasterFiImport = ccaConnector_->importByName (286, 3, 0, 2);
    tunermasterFiImport.setServiceName("MIDW_TUNERMASTER_FI");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (testmodeHall_tunermasterFiPort, tunermasterFiImport);

    // Expression

    ::asf::cca::CcaImportedPort& audioMascfFiImport = ccaConnector_->importByName (263, 1, 0, 2);
    audioMascfFiImport.setServiceName("midw_mascf_fi");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (testmodeHall_audioMascfFiPort, audioMascfFiImport);

    // Expression

    ::asf::cca::CcaImportedPort& btSetFiImport = ccaConnector_->importByName (95, 5, 7, 2);
    btSetFiImport.setServiceName("MOST_BTSet_FI");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (testmodeHall_btSetFiPort, btSetFiImport);

    // Expression

    ::asf::cca::CcaImportedPort& btTelFiImport = ccaConnector_->importByName (10, 4, 3, 2);
    btTelFiImport.setServiceName("MOST_Tel_FI");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (testmodeHall_btTelFiPort, btTelFiImport);

    // Expression

    ::asf::dbus::DBusImportedPort& LcmConsumer = dbusSystemConnector_->importByName (::std::string("org.genivi.NodeStateManager"), ::std::string("/org/genivi/NodeStateManager/Consumer"));
    LcmConsumer.setServiceName("org.genivi.NodeStateManager.Consumer");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (testmodeHall_ConsumerPort, LcmConsumer);

    // Expression

    ::asf::dbus::DBusImportedPort& LcmLifecycleControl = dbusSystemConnector_->importByName (::std::string("org.genivi.NodeStateManager"), ::std::string("/org/genivi/NodeStateManager/LifecycleControl"));
    LcmLifecycleControl.setServiceName("org.genivi.NodeStateManager.LifecycleControl");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (testmodeHall_LifecycleControlPort, LcmLifecycleControl);

    // Expression

    dbusSystemConnector_->exportByName (testmodeHall_LifeCycleConsumerPort, ::std::string("/org/genivi/NodeStateManager/LifeCycleConsumer/AppHmi_Testmode"));

    // Expression

    ::asf::dbus::DBusImportedPort& audioSourceChangeImport = dbusSessionConnector_->importByName (::std::string("App.Core.AppHmi_Master"), ::std::string("/bosch/cm/ai/hmi/hmiaudiosourcechange"));
    audioSourceChangeImport.setServiceName("bosch.cm.ai.hmi.masteraudioservice.AudioSourceChange");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (testmodeHall_audioSourceChangePort, audioSourceChangeImport);

    // Expression

    ::asf::dbus::DBusImportedPort& SxmAudioSourceChangeImport = dbusSessionConnector_->importByName (::std::string("App.Core.AppHmi_Master"), ::std::string("/bosch/cm/ai/hmi/hmiaudiosourcechange"));
    SxmAudioSourceChangeImport.setServiceName("bosch.cm.ai.hmi.masteraudioservice.AudioSourceChange");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (testmodeHall_SxmAudioSourceChangePort, SxmAudioSourceChangeImport);

    // Expression

    ::asf::dbus::DBusImportedPort& SXMSoundPropertiesImport = dbusSessionConnector_->importByName (::std::string("App.Core.AppHmi_Master"), ::std::string("/bosch/cm/ai/hmi/hmisoundsettings"));
    SXMSoundPropertiesImport.setServiceName("bosch.cm.ai.hmi.masteraudioservice.SoundProperties");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (testmodeHall_SXMSoundPropertiesPort, SXMSoundPropertiesImport);

    // Expression

    ::asf::dbus::DBusImportedPort& applicationSwitchImport = dbusSessionConnector_->importByName (::std::string("App.Core.AppHmi_Master"), ::std::string("/bosch/cm/ai/hmi/applcationswitchservice"));
    applicationSwitchImport.setServiceName("bosch.cm.ai.hmi.hmimasterservice.ApplicationSwitch");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (testmodeHall_applicationSwitchPort, applicationSwitchImport);

    // Expression

    ::asf::cca::CcaImportedPort& vehicleMainFiImport = ccaConnector_->importByName (47, 1, 0, 2);
    vehicleMainFiImport.setServiceName("VEHICLE_MAIN_FI");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (testmodeHall_vehicleMainFiPort, vehicleMainFiImport);

    // Expression

    ::asf::cca::CcaImportedPort& sxmAudioFiImport = ccaConnector_->importByName (140, 2, 7, 2);
    sxmAudioFiImport.setServiceName("sxm_audio_main_fi");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (testmodeHall_SxmAudioFiPort, sxmAudioFiImport);

    // Expression

    ::asf::cca::CcaImportedPort& sxmChannelArtFiImport = ccaConnector_->importByName (140, 1, 3, 2);
    sxmChannelArtFiImport.setServiceName("sxm_channelart_main_fi");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (testmodeHall_SxmChannelArtFiPort, sxmChannelArtFiImport);

    // Expression

    ::asf::cca::CcaImportedPort& sxmFuelFiImport = ccaConnector_->importByName (140, 1, 1, 2);
    sxmFuelFiImport.setServiceName("sxm_fuel_main_fi");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (testmodeHall_SxmFuelFiPort, sxmFuelFiImport);

    // Expression

    ::asf::cca::CcaImportedPort& sxmMoviesFiImport = ccaConnector_->importByName (140, 1, 1, 2);
    sxmMoviesFiImport.setServiceName("sxm_movies_main_fi");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (testmodeHall_SxmMoviesFiPort, sxmMoviesFiImport);

    // Expression

    ::asf::cca::CcaImportedPort& sxmSportsFiImport = ccaConnector_->importByName (140, 1, 1, 2);
    sxmSportsFiImport.setServiceName("sxm_sports_main_fi");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (testmodeHall_SxmSportsFiPort, sxmSportsFiImport);

    // Expression

    ::asf::cca::CcaImportedPort& sxmStocksFiImport = ccaConnector_->importByName (140, 1, 0, 2);
    sxmStocksFiImport.setServiceName("sxm_stocks_main_fi");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (testmodeHall_SxmStocksFiPort, sxmStocksFiImport);

    // Expression

    ::asf::cca::CcaImportedPort& sxmTabWeatherFiImport = ccaConnector_->importByName (140, 1, 0, 2);
    sxmTabWeatherFiImport.setServiceName("sxm_tabweather_main_fi");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (testmodeHall_SxmTabWeatherFiPort, sxmTabWeatherFiImport);

    // Expression

    ::asf::cca::CcaImportedPort& sxmWsAlertsFiImport = ccaConnector_->importByName (140, 2, 0, 2);
    sxmWsAlertsFiImport.setServiceName("sxm_wsalerts_main_fi");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (testmodeHall_SxmWsAlertsFiPort, sxmWsAlertsFiImport);

    // Expression

    ::asf::cca::CcaImportedPort& sxmCanadianFuelFiImport = ccaConnector_->importByName (140, 1, 0, 2);
    sxmCanadianFuelFiImport.setServiceName("sxm_canadian_fuel_main_fi");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (testmodeHall_SxmCanadianFuelFiPort, sxmCanadianFuelFiImport);

    // Expression

    ::asf::cca::CcaImportedPort& sxmParkingFiImport = ccaConnector_->importByName (140, 1, 2, 2);
    sxmParkingFiImport.setServiceName("sxm_parking_main_fi");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (testmodeHall_SxmParkingFiPort, sxmParkingFiImport);

    // Expression

    ::asf::cca::CcaImportedPort& rvcFiImport = ccaConnector_->importByName (84, 1, 0, 2);
    rvcFiImport.setServiceName("rvc_cca_fi");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (testmodeHall_rvcFiPort, rvcFiImport);

    // Expression

    ::asf::dbus::DBusImportedPort& sbServiceImport = dbusSessionConnector_->importByName (::std::string("ScreenBroker.Service.ScreenBroker"), ::std::string("/bosch/cm/ai/hmi/screenbroker/Service"));
    sbServiceImport.setServiceName("bosch.cm.ai.hmi.screenbroker.Service");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (testmodeGui_SBServicePort, sbServiceImport);

    // Expression

    ::asf::dbus::DBusImportedPort& hmiinfoserviceImport = dbusSessionConnector_->importByName (::std::string("App.Core.AppHmi_Master"), ::std::string("/bosch/cm/ai/hmi/hmiinfoservice/hmiinfoservice"));
    hmiinfoserviceImport.setServiceName("bosch.cm.ai.hmi.hmiinfoservice.HmiInfoService");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (testmodeHall_hmiinfoservicePort, hmiinfoserviceImport);

    // Expression

    ::asf::cca::CcaImportedPort& mediaPlayerFiImport = ccaConnector_->importByName (89, 4, 4, 2);
    mediaPlayerFiImport.setServiceName("mplay_MediaPlayer_FI");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (testmodeHall_mediaPlayerFiPort, mediaPlayerFiImport);

    // Expression

    ::asf::dbus::DBusImportedPort& HealthcareMonServerImport = dbusSessionConnector_->importByName (::std::string("HealthcareMonInterface.HealthcareMonApplication"), ::std::string("/bosch/cm/ai/HealthcareMonService"));
    HealthcareMonServerImport.setServiceName("bosch.cm.ai.HealthcareMonService");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (testmodeHall_HealthcareMonServerPort, HealthcareMonServerImport);


    LOG_INFO_STATIC("Starting application 'AppHmi_Testmode' version 0.1.0");

    app->start();
}

int executeAppHmi_Testmode(int argc, char* argv[]) {
    ::asf::core::ContextData context;

    const char* logConfigFile = 0;
    std::vector<std::string> arguments;

    for (int i=1; i<argc; i++) {
        if (std::string(argv[i]) == "--logconfig" && i+1 < argc) {
            // ignore lint warning e850: modification of i inside loop is safe
            logConfigFile = argv[++i];
        } else {
            if (std::string(argv[i]) == "--help") {
                printf ("%s", helpMessage);
                exit (0);
            } else {
                arguments.push_back (argv[i]);
            }
        }
    }

    if (logConfigFile == 0) {
        ::asf::core::Logger::setupLogging ("App.Core", "AppHmi_Testmode");
    } else {
        ::asf::core::Logger::setupLogging ("App.Core", "AppHmi_Testmode", logConfigFile);
    }

    LOG_INFO_STATIC("%s ASF signal handler", AppHmi_Testmode_enabledASFSignalHandler ? "Enabled" : "Disabled" );

    ::asf::core::Application* app = ::asf::core::Application::createApplication("App.Core", "AppHmi_Testmode", ::asf::core::Version(0, 1, 0, ""), arguments);

    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't create AppHmi_Testmode");

    app->enableExceptionHandler(false);

    importAppHmi_Testmode();

    int exitCode = app->waitForCompletion();
    ::asf::core::Application::deleteApplication();

    return exitCode;
}

} // namespace Core
} // namespace App

int main(int argc, char* argv[]) {
    ::boost::shared_ptr< ::asf::threading::Thread > mainThread = ::asf::threading::Thread::attach();
    return ::App::Core::executeAppHmi_Testmode(argc, argv);
}

