/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "App/Core/AppHmi_System.h"
#include "App/Core/SystemGui.h"
#include "App/Core/SystemHall.h"
#include "asf/cca/CcaConnector.h"
#include "asf/cca/CcaImportedPort.h"
#include "asf/cms/CmsProvidedPortListener.h"
#include "asf/core/Application.h"
#include "asf/core/ComponentContainer.h"
#include "asf/core/ComponentDescription.h"
#include "asf/core/ContextData.h"
#include "asf/core/Logger.h"
#include "asf/core/ProvidedPort.h"
#include "asf/core/RequiredPort.h"
#include "asf/core/SignalHandler.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusImportedPort.h"
#include "com/bosch/cm/asf/lang/cca/Connectors.h"
#include "com/bosch/cm/asf/lang/cca/ConnectorsJson.h"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "com/bosch/cm/asf/lang/dbus/ConnectorsJson.h"
#include <cstdio>
#include <string>

/**
 * If the meaning of "AppHmi_System" isn't clear, then there should be a description here.
 */

namespace App {
namespace Core {

DEFINE_LOGGER_AND_LEVEL (_logger, "/App/Core/AppHmi_System", Info);

/* static */ const char* AppHmi_System::systemGui = "systemGui";
/* static */ const char* AppHmi_System::systemHall = "systemHall";

static const char* helpMessage =
    "--logconfig <file>     Read the logging configuration from <file>\n"
    "                       see the ASF User Guide, section 6.3. Logging API\n"
    "--help                 Print this help message\n";

bool AppHmi_System_enabledASFSignalHandler = false;

void importAppHmi_System() {
    ::asf::core::Application* app = ::asf::core::Application::getApplication();
    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't attach AppHmi_System, because no Application is instantiated");

    // Expression

    ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector dbusSystemConnector;
    {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector __expression0;
        {
            __expression0.setBusType(::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector::BusType__System);
        }
        dbusSystemConnector = __expression0;
    }
    {
        std::string jsonPayload;
        serializeJson (dbusSystemConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "dbusSystemConnector", "DBusConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::dbus::DBusConnector > dbusSystemConnector_(new ::asf::dbus::DBusConnector(*app, dbusSystemConnector));
    app->addStarter(dbusSystemConnector_);

    // Expression

    ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector dbusSessionConnector;
    {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector __expression1;
        {
            __expression1.setBusType(::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector::BusType__Session);
        }
        dbusSessionConnector = __expression1;
    }
    {
        std::string jsonPayload;
        serializeJson (dbusSessionConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "dbusSessionConnector", "DBusConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::dbus::DBusConnector > dbusSessionConnector_(new ::asf::dbus::DBusConnector(*app, dbusSessionConnector));
    app->addStarter(dbusSessionConnector_);

    // Expression

    ::com::bosch::cm::asf::lang::cca::Connectors::CcaConnector ccaConnector;
    {
        ::com::bosch::cm::asf::lang::cca::Connectors::CcaConnector __expression2;
        {
            __expression2.setApplicationId(159);
        }
        ccaConnector = __expression2;
    }
    {
        std::string jsonPayload;
        serializeJson (ccaConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "ccaConnector", "CcaConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::cca::CcaConnector > ccaConnector_(new ::asf::cca::CcaConnector(*app, ccaConnector));
    app->addStarter(ccaConnector_);

    // Thread 'systemHmi'

    ::asf::core::ComponentContainerSharedPtr SystemHmi(new ::asf::core::ComponentContainer("systemHmi", ::asf::core::ThreadConfiguration(1)));
    app->addContainer (SystemHmi);

        // Component 'SystemGui systemGui'

        ::boost::shared_ptr< ::asf::core::ComponentFactory< ::App::Core::SystemGui > > systemGuiFactory(new ::asf::core::ComponentFactory< ::App::Core::SystemGui >);
        ::asf::core::ComponentDescriptionSharedPtr systemGuiDescription(new ::asf::core::ComponentDescription(1, "systemGui", /* immediate = */ true, /* threadBridge = */ false, systemGuiFactory));
        SystemHmi->addComponentDescription(systemGuiDescription);

            // Port 'courierMessageReceiverPort'

            ::asf::core::RequiredPort& systemGui_courierMessageReceiverPort = systemGuiDescription->addRequiredPort (::asf::core::RequiredPort ("CourierTunnelService.CourierMessageReceiver", "courierMessageReceiverPort"));
            (void)systemGui_courierMessageReceiverPort; // prevent unused variable warning

            // Port 'hmiAppCtrlPort'

            ::asf::core::RequiredPort& systemGui_hmiAppCtrlPort = systemGuiDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.ai.hmi.appctrl.HMIAppCtrl", "hmiAppCtrlPort"));
            (void)systemGui_hmiAppCtrlPort; // prevent unused variable warning

            // Port 'hmiAppCtrlTraceCmdPort'

            ::asf::core::RequiredPort& systemGui_hmiAppCtrlTraceCmdPort = systemGuiDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.ai.hmi.appctrl.trace.Commands", "hmiAppCtrlTraceCmdPort"));
            (void)systemGui_hmiAppCtrlTraceCmdPort; // prevent unused variable warning

            // Port 'SBServicePort'

            ::asf::core::RequiredPort& systemGui_SBServicePort = systemGuiDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.ai.hmi.screenbroker.Service", "SBServicePort"));
            (void)systemGui_SBServicePort; // prevent unused variable warning

        // Component 'SystemHall systemHall'

        ::boost::shared_ptr< ::asf::core::ComponentFactory< ::App::Core::SystemHall > > systemHallFactory(new ::asf::core::ComponentFactory< ::App::Core::SystemHall >);
        ::asf::core::ComponentDescriptionSharedPtr systemHallDescription(new ::asf::core::ComponentDescription(2, "systemHall", /* immediate = */ true, /* threadBridge = */ false, systemHallFactory));
        SystemHmi->addComponentDescription(systemHallDescription);

            // Port 'spmFiPort'

            ::asf::core::RequiredPort& systemHall_spmFiPort = systemHallDescription->addRequiredPort (::asf::core::RequiredPort ("SPM_CORE_FI", "spmFiPort"));
            (void)systemHall_spmFiPort; // prevent unused variable warning

            // Port 'ConsumerPort'

            ::asf::core::RequiredPort& systemHall_ConsumerPort = systemHallDescription->addRequiredPort (::asf::core::RequiredPort ("org.genivi.NodeStateManager.Consumer", "ConsumerPort"));
            (void)systemHall_ConsumerPort; // prevent unused variable warning

            // Port 'LifecycleControlPort'

            ::asf::core::RequiredPort& systemHall_LifecycleControlPort = systemHallDescription->addRequiredPort (::asf::core::RequiredPort ("org.genivi.NodeStateManager.LifecycleControl", "LifecycleControlPort"));
            (void)systemHall_LifecycleControlPort; // prevent unused variable warning

            // Port 'dimmingFiPort'

            ::asf::core::RequiredPort& systemHall_dimmingFiPort = systemHallDescription->addRequiredPort (::asf::core::RequiredPort ("dimming_main_fi", "dimmingFiPort"));
            (void)systemHall_dimmingFiPort; // prevent unused variable warning

            // Port 'LifeCycleConsumerPort'

            ::asf::core::ProvidedPort& systemHall_LifeCycleConsumerPort = systemHallDescription->addProvidedPort (::asf::core::ProvidedPort ("org.genivi.NodeStateManager.LifeCycleConsumer", "LifeCycleConsumerPort", false, false));
            (void)systemHall_LifeCycleConsumerPort; // prevent unused variable warning

            // Port 'clockFiPort'

            ::asf::core::RequiredPort& systemHall_clockFiPort = systemHallDescription->addRequiredPort (::asf::core::RequiredPort ("clock_main_fi", "clockFiPort"));
            (void)systemHall_clockFiPort; // prevent unused variable warning

            // Port 'commandInterfacePort'

            ::asf::core::RequiredPort& systemHall_commandInterfacePort = systemHallDescription->addRequiredPort (::asf::core::RequiredPort ("org.genivi.audiomanager.CommandInterface", "commandInterfacePort"));
            (void)systemHall_commandInterfacePort; // prevent unused variable warning

            // Port 'audioSourceChangePort'

            ::asf::core::RequiredPort& systemHall_audioSourceChangePort = systemHallDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.ai.hmi.masteraudioservice.AudioSourceChange", "audioSourceChangePort"));
            (void)systemHall_audioSourceChangePort; // prevent unused variable warning

            // Port 'soundPropertiesPort'

            ::asf::core::RequiredPort& systemHall_soundPropertiesPort = systemHallDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.ai.hmi.masteraudioservice.SoundProperties", "soundPropertiesPort"));
            (void)systemHall_soundPropertiesPort; // prevent unused variable warning

            // Port 'vehicleMainFiPort'

            ::asf::core::RequiredPort& systemHall_vehicleMainFiPort = systemHallDescription->addRequiredPort (::asf::core::RequiredPort ("VEHICLE_MAIN_FI", "vehicleMainFiPort"));
            (void)systemHall_vehicleMainFiPort; // prevent unused variable warning

            // Port 'applicationSwitchPort'

            ::asf::core::RequiredPort& systemHall_applicationSwitchPort = systemHallDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.ai.hmi.hmimasterservice.ApplicationSwitch", "applicationSwitchPort"));
            (void)systemHall_applicationSwitchPort; // prevent unused variable warning

            // Port 'PluginDbusInterfacePort'

            ::asf::core::RequiredPort& systemHall_PluginDbusInterfacePort = systemHallDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.ai.PluginDbusInterface", "PluginDbusInterfacePort"));
            (void)systemHall_PluginDbusInterfacePort; // prevent unused variable warning

            // Port 'hmiDataServerPort'

            ::asf::core::ProvidedPort& systemHall_hmiDataServerPort = systemHallDescription->addProvidedPort (::asf::core::ProvidedPort ("bosch.cm.ai.nissan.hmi.hmidataservice.HmiData", "hmiDataServerPort", false, false));
            (void)systemHall_hmiDataServerPort; // prevent unused variable warning

            // Port 'hmiDataServicePort'

            ::asf::core::RequiredPort& systemHall_hmiDataServicePort = systemHallDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.ai.nissan.hmi.hmidataservice.HmiData", "hmiDataServicePort"));
            (void)systemHall_hmiDataServicePort; // prevent unused variable warning

            // Port 'AppHmi_SystemPort'

            ::asf::core::ProvidedPort& systemHall_AppHmi_SystemPort = systemHallDescription->addProvidedPort (::asf::core::ProvidedPort ("org.bosch.cm.diagnosis.dbus.Diagnosis1.SystemSettings1", "AppHmi_SystemPort", false, false));
            (void)systemHall_AppHmi_SystemPort; // prevent unused variable warning

            // Port 'control1Port'

            ::asf::core::RequiredPort& systemHall_control1Port = systemHallDescription->addRequiredPort (::asf::core::RequiredPort ("org.bosch.cm.diagnosis.dbus.Diagnosis1.Control1", "control1Port"));
            (void)systemHall_control1Port; // prevent unused variable warning

            // Port 'rvcFiPort'

            ::asf::core::RequiredPort& systemHall_rvcFiPort = systemHallDescription->addRequiredPort (::asf::core::RequiredPort ("rvc_cca_fi", "rvcFiPort"));
            (void)systemHall_rvcFiPort; // prevent unused variable warning

            // Port 'btSetFiPort'

            ::asf::core::RequiredPort& systemHall_btSetFiPort = systemHallDescription->addRequiredPort (::asf::core::RequiredPort ("MOST_BTSet_FI", "btSetFiPort"));
            (void)systemHall_btSetFiPort; // prevent unused variable warning

            // Port 'fcSwUpdatePort'

            ::asf::core::RequiredPort& systemHall_fcSwUpdatePort = systemHallDescription->addRequiredPort (::asf::core::RequiredPort ("fcswupdatesrv.FcSwUpdateSrv", "fcSwUpdatePort"));
            (void)systemHall_fcSwUpdatePort; // prevent unused variable warning

            // Port 'courierMessageReceiverPort'

            ::asf::core::ProvidedPort& systemHall_courierMessageReceiverPort = systemHallDescription->addProvidedPort (::asf::core::ProvidedPort ("CourierTunnelService.CourierMessageReceiver", "courierMessageReceiverPort", ::boost::shared_ptr< ::asf::core::ProvidedPortListener >(new ::asf::cms::CmsProvidedPortListener())));
            (void)systemHall_courierMessageReceiverPort; // prevent unused variable warning

            // Port 'hmiinfoservicePort'

            ::asf::core::RequiredPort& systemHall_hmiinfoservicePort = systemHallDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.ai.hmi.hmiinfoservice.HmiInfoService", "hmiinfoservicePort"));
            (void)systemHall_hmiinfoservicePort; // prevent unused variable warning

            // Port 'diagnosticsFiPort'

            ::asf::core::RequiredPort& systemHall_diagnosticsFiPort = systemHallDescription->addRequiredPort (::asf::core::RequiredPort ("Midw_Diagnostics_FI", "diagnosticsFiPort"));
            (void)systemHall_diagnosticsFiPort; // prevent unused variable warning

            // Port 'navigationServicePort'

            ::asf::core::RequiredPort& systemHall_navigationServicePort = systemHallDescription->addRequiredPort (::asf::core::RequiredPort ("org.bosch.cm.navigation.NavigationService", "navigationServicePort"));
            (void)systemHall_navigationServicePort; // prevent unused variable warning

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (systemGui_courierMessageReceiverPort, systemHall_courierMessageReceiverPort);

    // Expression

    ::asf::dbus::DBusImportedPort& hmiAppCtrlImport = dbusSessionConnector_->importByName (::std::string("App.Core.AppHmi_Master"), ::std::string("/bosch/cm/ai/hmi/hmiappctrl"));
    hmiAppCtrlImport.setServiceName("bosch.cm.ai.hmi.appctrl.HMIAppCtrl");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (systemGui_hmiAppCtrlPort, hmiAppCtrlImport);

    // Expression

    ::asf::dbus::DBusImportedPort& hmiTraceCmdImport = dbusSessionConnector_->importByName (::std::string("hmibase.trace.HMITraceCmd_Daemon"), ::std::string("/bosch/cm/ai/hmi/appctrl/trace/Commands"));
    hmiTraceCmdImport.setServiceName("bosch.cm.ai.hmi.appctrl.trace.Commands");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (systemGui_hmiAppCtrlTraceCmdPort, hmiTraceCmdImport);

    // Expression

    ::asf::cca::CcaImportedPort& spmFiImport = ccaConnector_->importByName (0, 1, 0, 2);
    spmFiImport.setServiceName("SPM_CORE_FI");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (systemHall_spmFiPort, spmFiImport);

    // Expression

    ::asf::dbus::DBusImportedPort& LcmConsumer = dbusSystemConnector_->importByName (::std::string("org.genivi.NodeStateManager"), ::std::string("/org/genivi/NodeStateManager/Consumer"));
    LcmConsumer.setServiceName("org.genivi.NodeStateManager.Consumer");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (systemHall_ConsumerPort, LcmConsumer);

    // Expression

    ::asf::dbus::DBusImportedPort& LcmLifecycleControl = dbusSystemConnector_->importByName (::std::string("org.genivi.NodeStateManager"), ::std::string("/org/genivi/NodeStateManager/LifecycleControl"));
    LcmLifecycleControl.setServiceName("org.genivi.NodeStateManager.LifecycleControl");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (systemHall_LifecycleControlPort, LcmLifecycleControl);

    // Expression

    ::asf::cca::CcaImportedPort& dimmingFiImport = ccaConnector_->importByName (84, 4, 0, 2);
    dimmingFiImport.setServiceName("dimming_main_fi");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (systemHall_dimmingFiPort, dimmingFiImport);

    // Expression

    ::asf::cca::CcaImportedPort& diagnosticsFiImport = ccaConnector_->importByName (276, 1, 3, 2);
    diagnosticsFiImport.setServiceName("Midw_Diagnostics_FI");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (systemHall_diagnosticsFiPort, diagnosticsFiImport);

    // Expression

    ::asf::cca::CcaImportedPort& btSetFiImport = ccaConnector_->importByName (95, 5, 7, 2);
    btSetFiImport.setServiceName("MOST_BTSet_FI");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (systemHall_btSetFiPort, btSetFiImport);

    // Expression

    dbusSessionConnector_->exportByName (systemHall_hmiDataServerPort, ::std::string("/bosch/cm/ai/nissan/hmi/hmidataservice"));

    // Expression

    dbusSessionConnector_->exportByName (systemHall_AppHmi_SystemPort, ::std::string("/org/bosch/cm/diagnosis/dbus/Diagnosis1/SystemSettings1/systemservice"));

    // Expression

    ::asf::dbus::DBusImportedPort& control1Import = dbusSessionConnector_->importByName (::std::string("asf.ProcDiagnosis"), ::std::string("/org/bosch/cm/diagnosis/dbus/Diagnosis1/Control1"));
    control1Import.setServiceName("org.bosch.cm.diagnosis.dbus.Diagnosis1.Control1");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (systemHall_control1Port, control1Import);

    // Expression

    ::asf::cca::CcaImportedPort& rvcFiImport = ccaConnector_->importByName (84, 1, 0, 2);
    rvcFiImport.setServiceName("rvc_cca_fi");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (systemHall_rvcFiPort, rvcFiImport);

    // Expression

    ::asf::dbus::DBusImportedPort& fcswupdatesrvImport = dbusSessionConnector_->importByName (::std::string("fcswupdate.FcSwUpdateApp"), ::std::string("/org/bosch/cm/ai_sw_update/fcSwUpdateService"));
    fcswupdatesrvImport.setServiceName("fcswupdatesrv.FcSwUpdateSrv");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (systemHall_fcSwUpdatePort, fcswupdatesrvImport);

    // Expression

    ::asf::dbus::DBusImportedPort& commandInterfaceImport = dbusSystemConnector_->importByName (::std::string("org.genivi.audiomanager"), ::std::string("/org/genivi/audiomanager/CommandInterface"));
    commandInterfaceImport.setServiceName("org.genivi.audiomanager.CommandInterface");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (systemHall_commandInterfacePort, commandInterfaceImport);

    // Expression

    ::asf::dbus::DBusImportedPort& audioSourceChangeImport = dbusSessionConnector_->importByName (::std::string("App.Core.AppHmi_Master"), ::std::string("/bosch/cm/ai/hmi/hmiaudiosourcechange"));
    audioSourceChangeImport.setServiceName("bosch.cm.ai.hmi.masteraudioservice.AudioSourceChange");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (systemHall_audioSourceChangePort, audioSourceChangeImport);

    // Expression

    ::asf::dbus::DBusImportedPort& soundPropertiesImport = dbusSessionConnector_->importByName (::std::string("App.Core.AppHmi_Master"), ::std::string("/bosch/cm/ai/hmi/hmisoundsettings"));
    soundPropertiesImport.setServiceName("bosch.cm.ai.hmi.masteraudioservice.SoundProperties");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (systemHall_soundPropertiesPort, soundPropertiesImport);

    // Expression

    ::asf::dbus::DBusImportedPort& hmidataserviceImport = dbusSessionConnector_->importByName (::std::string("App.Core.AppHmi_System"), ::std::string("/bosch/cm/ai/nissan/hmi/hmidataservice"));
    hmidataserviceImport.setServiceName("bosch.cm.ai.nissan.hmi.hmidataservice.HmiData");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (systemHall_hmiDataServicePort, hmidataserviceImport);

    // Expression

    ::asf::cca::CcaImportedPort& clockFiImport = ccaConnector_->importByName (41, 1, 5, 2);
    clockFiImport.setServiceName("clock_main_fi");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (systemHall_clockFiPort, clockFiImport);

    // Expression

    ::asf::dbus::DBusImportedPort& pluginDbusImport = dbusSessionConnector_->importByName (::std::string("PluginServer.PluginServer"), ::std::string("/bosch/cm/ai/PluginDbusInterface"));
    pluginDbusImport.setServiceName("bosch.cm.ai.PluginDbusInterface");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (systemHall_PluginDbusInterfacePort, pluginDbusImport);

    // Expression

    ::asf::cca::CcaImportedPort& vehicleMainFiImport = ccaConnector_->importByName (47, 1, 0, 2);
    vehicleMainFiImport.setServiceName("VEHICLE_MAIN_FI");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (systemHall_vehicleMainFiPort, vehicleMainFiImport);

    // Expression

    dbusSystemConnector_->exportByName (systemHall_LifeCycleConsumerPort, ::std::string("/org/genivi/NodeStateManager/LifeCycleConsumer/AppHmi_System"));

    // Expression

    ::asf::dbus::DBusImportedPort& applicationSwitchImport = dbusSessionConnector_->importByName (::std::string("App.Core.AppHmi_Master"), ::std::string("/bosch/cm/ai/hmi/applcationswitchservice"));
    applicationSwitchImport.setServiceName("bosch.cm.ai.hmi.hmimasterservice.ApplicationSwitch");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (systemHall_applicationSwitchPort, applicationSwitchImport);

    // Expression

    ::asf::dbus::DBusImportedPort& sbServiceImport = dbusSessionConnector_->importByName (::std::string("ScreenBroker.Service.ScreenBroker"), ::std::string("/bosch/cm/ai/hmi/screenbroker/Service"));
    sbServiceImport.setServiceName("bosch.cm.ai.hmi.screenbroker.Service");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (systemGui_SBServicePort, sbServiceImport);

    // Expression

    ::asf::dbus::DBusImportedPort& hmiinfoserviceImport = dbusSessionConnector_->importByName (::std::string("App.Core.AppHmi_Master"), ::std::string("/bosch/cm/ai/hmi/hmiinfoservice/hmiinfoservice"));
    hmiinfoserviceImport.setServiceName("bosch.cm.ai.hmi.hmiinfoservice.HmiInfoService");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (systemHall_hmiinfoservicePort, hmiinfoserviceImport);

    // Expression

    ::asf::dbus::DBusImportedPort& navigationServiceImport = dbusSessionConnector_->importByName (::std::string("App.Core.AppHmi_Navigation"), ::std::string("/com/bosch/cm/ai/navigation"));
    navigationServiceImport.setServiceName("org.bosch.cm.navigation.NavigationService");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (systemHall_navigationServicePort, navigationServiceImport);


    LOG_INFO_STATIC("Starting application 'AppHmi_System' version 0.1.0");

    app->start();
}

int executeAppHmi_System(int argc, char* argv[]) {
    ::asf::core::ContextData context;

    const char* logConfigFile = 0;
    std::vector<std::string> arguments;

    for (int i=1; i<argc; i++) {
        if (std::string(argv[i]) == "--logconfig" && i+1 < argc) {
            // ignore lint warning e850: modification of i inside loop is safe
            logConfigFile = argv[++i];
        } else {
            if (std::string(argv[i]) == "--help") {
                printf ("%s", helpMessage);
                exit (0);
            } else {
                arguments.push_back (argv[i]);
            }
        }
    }

    if (logConfigFile == 0) {
        ::asf::core::Logger::setupLogging ("App.Core", "AppHmi_System");
    } else {
        ::asf::core::Logger::setupLogging ("App.Core", "AppHmi_System", logConfigFile);
    }

    LOG_INFO_STATIC("%s ASF signal handler", AppHmi_System_enabledASFSignalHandler ? "Enabled" : "Disabled" );

    ::asf::core::Application* app = ::asf::core::Application::createApplication("App.Core", "AppHmi_System", ::asf::core::Version(0, 1, 0, ""), arguments);

    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't create AppHmi_System");

    app->enableExceptionHandler(true);

    importAppHmi_System();

    int exitCode = app->waitForCompletion();
    ::asf::core::Application::deleteApplication();

    return exitCode;
}

} // namespace Core
} // namespace App

int main(int argc, char* argv[]) {
    ::App::Core::AppHmi_System_enabledASFSignalHandler = true;
    ::asf::core::SignalHandler asfSignalHandler;
    ::boost::shared_ptr< ::asf::threading::Thread > mainThread = ::asf::threading::Thread::attach();
    return ::App::Core::executeAppHmi_System(argc, argv);
}

