/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "App/Core/AppHmi_Sxm.h"
#include "App/Core/SxmGui.h"
#include "App/Core/SxmHall.h"
#include "asf/cca/CcaConnector.h"
#include "asf/cca/CcaImportedPort.h"
#include "asf/cms/CmsProvidedPortListener.h"
#include "asf/core/Application.h"
#include "asf/core/ComponentContainer.h"
#include "asf/core/ComponentDescription.h"
#include "asf/core/ContextData.h"
#include "asf/core/Logger.h"
#include "asf/core/ProvidedPort.h"
#include "asf/core/RequiredPort.h"
#include "asf/core/SignalHandler.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusImportedPort.h"
#include "com/bosch/cm/asf/lang/cca/Connectors.h"
#include "com/bosch/cm/asf/lang/cca/ConnectorsJson.h"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "com/bosch/cm/asf/lang/dbus/ConnectorsJson.h"
#include <cstdio>
#include <string>

/**
 * If the meaning of "AppHmi_Sxm" isn't clear, then there should be a description here.
 */

namespace App {
namespace Core {

DEFINE_LOGGER_AND_LEVEL (_logger, "/App/Core/AppHmi_Sxm", Info);

/* static */ const char* AppHmi_Sxm::sxmGui = "sxmGui";
/* static */ const char* AppHmi_Sxm::sxmHall = "sxmHall";

static const char* helpMessage =
    "--logconfig <file>     Read the logging configuration from <file>\n"
    "                       see the ASF User Guide, section 6.3. Logging API\n"
    "--help                 Print this help message\n";

bool AppHmi_Sxm_enabledASFSignalHandler = false;

void importAppHmi_Sxm() {
    ::asf::core::Application* app = ::asf::core::Application::getApplication();
    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't attach AppHmi_Sxm, because no Application is instantiated");

    // Expression

    ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector dbusSystemConnector;
    {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector __expression0;
        {
            __expression0.setBusType(::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector::BusType__System);
        }
        dbusSystemConnector = __expression0;
    }
    {
        std::string jsonPayload;
        serializeJson (dbusSystemConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "dbusSystemConnector", "DBusConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::dbus::DBusConnector > dbusSystemConnector_(new ::asf::dbus::DBusConnector(*app, dbusSystemConnector));
    app->addStarter(dbusSystemConnector_);

    // Expression

    ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector dbusSessionConnector;
    {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector __expression1;
        {
            __expression1.setBusType(::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector::BusType__Session);
        }
        dbusSessionConnector = __expression1;
    }
    {
        std::string jsonPayload;
        serializeJson (dbusSessionConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "dbusSessionConnector", "DBusConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::dbus::DBusConnector > dbusSessionConnector_(new ::asf::dbus::DBusConnector(*app, dbusSessionConnector));
    app->addStarter(dbusSessionConnector_);

    // Expression

    ::com::bosch::cm::asf::lang::cca::Connectors::CcaConnector ccaConnector;
    {
        ::com::bosch::cm::asf::lang::cca::Connectors::CcaConnector __expression2;
        {
            __expression2.setApplicationId(161);
        }
        ccaConnector = __expression2;
    }
    {
        std::string jsonPayload;
        serializeJson (ccaConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "ccaConnector", "CcaConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::cca::CcaConnector > ccaConnector_(new ::asf::cca::CcaConnector(*app, ccaConnector));
    app->addStarter(ccaConnector_);

    // Thread 'sxmHmi'

    ::asf::core::ComponentContainerSharedPtr SxmHmi(new ::asf::core::ComponentContainer("sxmHmi", ::asf::core::ThreadConfiguration(1)));
    app->addContainer (SxmHmi);

        // Component 'SxmGui sxmGui'

        ::boost::shared_ptr< ::asf::core::ComponentFactory< ::App::Core::SxmGui > > sxmGuiFactory(new ::asf::core::ComponentFactory< ::App::Core::SxmGui >);
        ::asf::core::ComponentDescriptionSharedPtr sxmGuiDescription(new ::asf::core::ComponentDescription(1, "sxmGui", /* immediate = */ true, /* threadBridge = */ false, sxmGuiFactory));
        SxmHmi->addComponentDescription(sxmGuiDescription);

            // Port 'courierMessageReceiverPort'

            ::asf::core::RequiredPort& sxmGui_courierMessageReceiverPort = sxmGuiDescription->addRequiredPort (::asf::core::RequiredPort ("CourierTunnelService.CourierMessageReceiver", "courierMessageReceiverPort"));
            (void)sxmGui_courierMessageReceiverPort; // prevent unused variable warning

            // Port 'hmiAppCtrlPort'

            ::asf::core::RequiredPort& sxmGui_hmiAppCtrlPort = sxmGuiDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.ai.hmi.appctrl.HMIAppCtrl", "hmiAppCtrlPort"));
            (void)sxmGui_hmiAppCtrlPort; // prevent unused variable warning

            // Port 'hmiAppCtrlTraceCmdPort'

            ::asf::core::RequiredPort& sxmGui_hmiAppCtrlTraceCmdPort = sxmGuiDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.ai.hmi.appctrl.trace.Commands", "hmiAppCtrlTraceCmdPort"));
            (void)sxmGui_hmiAppCtrlTraceCmdPort; // prevent unused variable warning

            // Port 'SBServicePort'

            ::asf::core::RequiredPort& sxmGui_SBServicePort = sxmGuiDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.ai.hmi.screenbroker.Service", "SBServicePort"));
            (void)sxmGui_SBServicePort; // prevent unused variable warning

        // Component 'SxmHall sxmHall'

        ::boost::shared_ptr< ::asf::core::ComponentFactory< ::App::Core::SxmHall > > sxmHallFactory(new ::asf::core::ComponentFactory< ::App::Core::SxmHall >);
        ::asf::core::ComponentDescriptionSharedPtr sxmHallDescription(new ::asf::core::ComponentDescription(2, "sxmHall", /* immediate = */ true, /* threadBridge = */ false, sxmHallFactory));
        SxmHmi->addComponentDescription(sxmHallDescription);

            // Port 'spmFiPort'

            ::asf::core::RequiredPort& sxmHall_spmFiPort = sxmHallDescription->addRequiredPort (::asf::core::RequiredPort ("SPM_CORE_FI", "spmFiPort"));
            (void)sxmHall_spmFiPort; // prevent unused variable warning

            // Port 'ConsumerPort'

            ::asf::core::RequiredPort& sxmHall_ConsumerPort = sxmHallDescription->addRequiredPort (::asf::core::RequiredPort ("org.genivi.NodeStateManager.Consumer", "ConsumerPort"));
            (void)sxmHall_ConsumerPort; // prevent unused variable warning

            // Port 'LifecycleControlPort'

            ::asf::core::RequiredPort& sxmHall_LifecycleControlPort = sxmHallDescription->addRequiredPort (::asf::core::RequiredPort ("org.genivi.NodeStateManager.LifecycleControl", "LifecycleControlPort"));
            (void)sxmHall_LifecycleControlPort; // prevent unused variable warning

            // Port 'LifeCycleConsumerPort'

            ::asf::core::ProvidedPort& sxmHall_LifeCycleConsumerPort = sxmHallDescription->addProvidedPort (::asf::core::ProvidedPort ("org.genivi.NodeStateManager.LifeCycleConsumer", "LifeCycleConsumerPort", false, false));
            (void)sxmHall_LifeCycleConsumerPort; // prevent unused variable warning

            // Port 'AppHmiSxmServicePort'

            ::asf::core::ProvidedPort& sxmHall_AppHmiSxmServicePort = sxmHallDescription->addProvidedPort (::asf::core::ProvidedPort ("org.bosch.cm.diagnosis.dbus.Diagnosis1.SystemSettings1", "AppHmiSxmServicePort", false, false));
            (void)sxmHall_AppHmiSxmServicePort; // prevent unused variable warning

            // Port 'courierMessageReceiverPort'

            ::asf::core::ProvidedPort& sxmHall_courierMessageReceiverPort = sxmHallDescription->addProvidedPort (::asf::core::ProvidedPort ("CourierTunnelService.CourierMessageReceiver", "courierMessageReceiverPort", ::boost::shared_ptr< ::asf::core::ProvidedPortListener >(new ::asf::cms::CmsProvidedPortListener())));
            (void)sxmHall_courierMessageReceiverPort; // prevent unused variable warning

            // Port 'SxmAudioFiPort'

            ::asf::core::RequiredPort& sxmHall_SxmAudioFiPort = sxmHallDescription->addRequiredPort (::asf::core::RequiredPort ("sxm_audio_main_fi", "SxmAudioFiPort"));
            (void)sxmHall_SxmAudioFiPort; // prevent unused variable warning

            // Port 'SxmChannelArtFiPort'

            ::asf::core::RequiredPort& sxmHall_SxmChannelArtFiPort = sxmHallDescription->addRequiredPort (::asf::core::RequiredPort ("sxm_channelart_main_fi", "SxmChannelArtFiPort"));
            (void)sxmHall_SxmChannelArtFiPort; // prevent unused variable warning

            // Port 'SxmClockFiPort'

            ::asf::core::RequiredPort& sxmHall_SxmClockFiPort = sxmHallDescription->addRequiredPort (::asf::core::RequiredPort ("clock_main_fi", "SxmClockFiPort"));
            (void)sxmHall_SxmClockFiPort; // prevent unused variable warning

            // Port 'audioSourceChangePort'

            ::asf::core::RequiredPort& sxmHall_audioSourceChangePort = sxmHallDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.ai.hmi.masteraudioservice.AudioSourceChange", "audioSourceChangePort"));
            (void)sxmHall_audioSourceChangePort; // prevent unused variable warning

            // Port 'soundPropertiesPort'

            ::asf::core::RequiredPort& sxmHall_soundPropertiesPort = sxmHallDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.ai.hmi.masteraudioservice.SoundProperties", "soundPropertiesPort"));
            (void)sxmHall_soundPropertiesPort; // prevent unused variable warning

            // Port 'applicationSwitchPort'

            ::asf::core::RequiredPort& sxmHall_applicationSwitchPort = sxmHallDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.ai.hmi.hmimasterservice.ApplicationSwitch", "applicationSwitchPort"));
            (void)sxmHall_applicationSwitchPort; // prevent unused variable warning

            // Port 'hmiinfoservicePort'

            ::asf::core::RequiredPort& sxmHall_hmiinfoservicePort = sxmHallDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.ai.hmi.hmiinfoservice.HmiInfoService", "hmiinfoservicePort"));
            (void)sxmHall_hmiinfoservicePort; // prevent unused variable warning

            // Port 'diagnosticsFiPort'

            ::asf::core::RequiredPort& sxmHall_diagnosticsFiPort = sxmHallDescription->addRequiredPort (::asf::core::RequiredPort ("Midw_Diagnostics_FI", "diagnosticsFiPort"));
            (void)sxmHall_diagnosticsFiPort; // prevent unused variable warning

            // Port 'vehicleMainFiPort'

            ::asf::core::RequiredPort& sxmHall_vehicleMainFiPort = sxmHallDescription->addRequiredPort (::asf::core::RequiredPort ("VEHICLE_MAIN_FI", "vehicleMainFiPort"));
            (void)sxmHall_vehicleMainFiPort; // prevent unused variable warning

    // Expression

    ::asf::cca::CcaImportedPort& sxmAudioFiImport = ccaConnector_->importByName (140, 2, 7, 2);
    sxmAudioFiImport.setServiceName("sxm_audio_main_fi");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (sxmHall_SxmAudioFiPort, sxmAudioFiImport);

    // Expression

    ::asf::cca::CcaImportedPort& sxmChannelArtFiImport = ccaConnector_->importByName (140, 1, 3, 2);
    sxmChannelArtFiImport.setServiceName("sxm_channelart_main_fi");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (sxmHall_SxmChannelArtFiPort, sxmChannelArtFiImport);

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (sxmGui_courierMessageReceiverPort, sxmHall_courierMessageReceiverPort);

    // Expression

    ::asf::dbus::DBusImportedPort& audioSourceChangeImport = dbusSessionConnector_->importByName (::std::string("App.Core.AppHmi_Master"), ::std::string("/bosch/cm/ai/hmi/hmiaudiosourcechange"));
    audioSourceChangeImport.setServiceName("bosch.cm.ai.hmi.masteraudioservice.AudioSourceChange");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (sxmHall_audioSourceChangePort, audioSourceChangeImport);

    // Expression

    ::asf::dbus::DBusImportedPort& soundPropertiesImport = dbusSessionConnector_->importByName (::std::string("App.Core.AppHmi_Master"), ::std::string("/bosch/cm/ai/hmi/hmisoundsettings"));
    soundPropertiesImport.setServiceName("bosch.cm.ai.hmi.masteraudioservice.SoundProperties");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (sxmHall_soundPropertiesPort, soundPropertiesImport);

    // Expression

    ::asf::dbus::DBusImportedPort& hmiAppCtrlImport = dbusSessionConnector_->importByName (::std::string("App.Core.AppHmi_Master"), ::std::string("/bosch/cm/ai/hmi/hmiappctrl"));
    hmiAppCtrlImport.setServiceName("bosch.cm.ai.hmi.appctrl.HMIAppCtrl");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (sxmGui_hmiAppCtrlPort, hmiAppCtrlImport);

    // Expression

    ::asf::dbus::DBusImportedPort& hmiTraceCmdImport = dbusSessionConnector_->importByName (::std::string("hmibase.trace.HMITraceCmd_Daemon"), ::std::string("/bosch/cm/ai/hmi/appctrl/trace/Commands"));
    hmiTraceCmdImport.setServiceName("bosch.cm.ai.hmi.appctrl.trace.Commands");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (sxmGui_hmiAppCtrlTraceCmdPort, hmiTraceCmdImport);

    // Expression

    ::asf::cca::CcaImportedPort& spmFiImport = ccaConnector_->importByName (0, 1, 0, 2);
    spmFiImport.setServiceName("SPM_CORE_FI");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (sxmHall_spmFiPort, spmFiImport);

    // Expression

    dbusSessionConnector_->exportByName (sxmHall_AppHmiSxmServicePort, ::std::string("/org/bosch/cm/diagnosis/dbus/Diagnosis1/SystemSettings1/sxmservice"));

    // Expression

    ::asf::dbus::DBusImportedPort& LcmConsumer = dbusSystemConnector_->importByName (::std::string("org.genivi.NodeStateManager"), ::std::string("/org/genivi/NodeStateManager/Consumer"));
    LcmConsumer.setServiceName("org.genivi.NodeStateManager.Consumer");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (sxmHall_ConsumerPort, LcmConsumer);

    // Expression

    ::asf::dbus::DBusImportedPort& LcmLifecycleControl = dbusSystemConnector_->importByName (::std::string("org.genivi.NodeStateManager"), ::std::string("/org/genivi/NodeStateManager/LifecycleControl"));
    LcmLifecycleControl.setServiceName("org.genivi.NodeStateManager.LifecycleControl");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (sxmHall_LifecycleControlPort, LcmLifecycleControl);

    // Expression

    ::asf::dbus::DBusImportedPort& applicationSwitchImport = dbusSessionConnector_->importByName (::std::string("App.Core.AppHmi_Master"), ::std::string("/bosch/cm/ai/hmi/applcationswitchservice"));
    applicationSwitchImport.setServiceName("bosch.cm.ai.hmi.hmimasterservice.ApplicationSwitch");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (sxmHall_applicationSwitchPort, applicationSwitchImport);

    // Expression

    dbusSystemConnector_->exportByName (sxmHall_LifeCycleConsumerPort, ::std::string("/org/genivi/NodeStateManager/LifeCycleConsumer/AppHmi_Sxm"));

    // Expression

    ::asf::dbus::DBusImportedPort& sbServiceImport = dbusSessionConnector_->importByName (::std::string("ScreenBroker.Service.ScreenBroker"), ::std::string("/bosch/cm/ai/hmi/screenbroker/Service"));
    sbServiceImport.setServiceName("bosch.cm.ai.hmi.screenbroker.Service");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (sxmGui_SBServicePort, sbServiceImport);

    // Expression

    ::asf::dbus::DBusImportedPort& hmiinfoserviceImport = dbusSessionConnector_->importByName (::std::string("App.Core.AppHmi_Master"), ::std::string("/bosch/cm/ai/hmi/hmiinfoservice/hmiinfoservice"));
    hmiinfoserviceImport.setServiceName("bosch.cm.ai.hmi.hmiinfoservice.HmiInfoService");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (sxmHall_hmiinfoservicePort, hmiinfoserviceImport);

    // Expression

    ::asf::cca::CcaImportedPort& SxmClockFiImport = ccaConnector_->importByName (41, 1, 5, 2);
    SxmClockFiImport.setServiceName("clock_main_fi");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (sxmHall_SxmClockFiPort, SxmClockFiImport);

    // Expression

    ::asf::cca::CcaImportedPort& vehicleMainFiImport = ccaConnector_->importByName (47, 1, 0, 2);
    vehicleMainFiImport.setServiceName("VEHICLE_MAIN_FI");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (sxmHall_vehicleMainFiPort, vehicleMainFiImport);

    // Expression

    ::asf::cca::CcaImportedPort& diagnosticsFiImport = ccaConnector_->importByName (276, 1, 3, 2);
    diagnosticsFiImport.setServiceName("Midw_Diagnostics_FI");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (sxmHall_diagnosticsFiPort, diagnosticsFiImport);


    LOG_INFO_STATIC("Starting application 'AppHmi_Sxm' version 0.1.0");

    app->start();
}

int executeAppHmi_Sxm(int argc, char* argv[]) {
    ::asf::core::ContextData context;

    const char* logConfigFile = 0;
    std::vector<std::string> arguments;

    for (int i=1; i<argc; i++) {
        if (std::string(argv[i]) == "--logconfig" && i+1 < argc) {
            // ignore lint warning e850: modification of i inside loop is safe
            logConfigFile = argv[++i];
        } else {
            if (std::string(argv[i]) == "--help") {
                printf ("%s", helpMessage);
                exit (0);
            } else {
                arguments.push_back (argv[i]);
            }
        }
    }

    if (logConfigFile == 0) {
        ::asf::core::Logger::setupLogging ("App.Core", "AppHmi_Sxm");
    } else {
        ::asf::core::Logger::setupLogging ("App.Core", "AppHmi_Sxm", logConfigFile);
    }

    LOG_INFO_STATIC("%s ASF signal handler", AppHmi_Sxm_enabledASFSignalHandler ? "Enabled" : "Disabled" );

    ::asf::core::Application* app = ::asf::core::Application::createApplication("App.Core", "AppHmi_Sxm", ::asf::core::Version(0, 1, 0, ""), arguments);

    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't create AppHmi_Sxm");

    app->enableExceptionHandler(true);

    importAppHmi_Sxm();

    int exitCode = app->waitForCompletion();
    ::asf::core::Application::deleteApplication();

    return exitCode;
}

} // namespace Core
} // namespace App

int main(int argc, char* argv[]) {
    ::App::Core::AppHmi_Sxm_enabledASFSignalHandler = true;
    ::asf::core::SignalHandler asfSignalHandler;
    ::boost::shared_ptr< ::asf::threading::Thread > mainThread = ::asf::threading::Thread::attach();
    return ::App::Core::executeAppHmi_Sxm(argc, argv);
}

