/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "App/Core/AppHmi_Phone.h"
#include "App/Core/PhoneGui.h"
#include "App/Core/PhoneHall.h"
#include "asf/cca/CcaConnector.h"
#include "asf/cca/CcaImportedPort.h"
#include "asf/cms/CmsProvidedPortListener.h"
#include "asf/core/Application.h"
#include "asf/core/ComponentContainer.h"
#include "asf/core/ComponentDescription.h"
#include "asf/core/ContextData.h"
#include "asf/core/Logger.h"
#include "asf/core/ProvidedPort.h"
#include "asf/core/RequiredPort.h"
#include "asf/core/SignalHandler.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusImportedPort.h"
#include "com/bosch/cm/asf/lang/cca/Connectors.h"
#include "com/bosch/cm/asf/lang/cca/ConnectorsJson.h"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "com/bosch/cm/asf/lang/dbus/ConnectorsJson.h"
#include <cstdio>
#include <string>

/**
 * If the meaning of "AppHmi_Phone" isn't clear, then there should be a description here.
 */

namespace App {
namespace Core {

DEFINE_LOGGER_AND_LEVEL (_logger, "/App/Core/AppHmi_Phone", Info);

/* static */ const char* AppHmi_Phone::phoneGui = "phoneGui";
/* static */ const char* AppHmi_Phone::phoneHall = "phoneHall";

static const char* helpMessage =
    "--logconfig <file>     Read the logging configuration from <file>\n"
    "                       see the ASF User Guide, section 6.3. Logging API\n"
    "--help                 Print this help message\n";

bool AppHmi_Phone_enabledASFSignalHandler = false;

void importAppHmi_Phone() {
    ::asf::core::Application* app = ::asf::core::Application::getApplication();
    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't attach AppHmi_Phone, because no Application is instantiated");

    // Expression

    ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector dbusSystemConnector;
    {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector __expression0;
        {
            __expression0.setBusType(::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector::BusType__System);
        }
        dbusSystemConnector = __expression0;
    }
    {
        std::string jsonPayload;
        serializeJson (dbusSystemConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "dbusSystemConnector", "DBusConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::dbus::DBusConnector > dbusSystemConnector_(new ::asf::dbus::DBusConnector(*app, dbusSystemConnector));
    app->addStarter(dbusSystemConnector_);

    // Expression

    ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector dbusSessionConnector;
    {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector __expression1;
        {
            __expression1.setBusType(::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector::BusType__Session);
        }
        dbusSessionConnector = __expression1;
    }
    {
        std::string jsonPayload;
        serializeJson (dbusSessionConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "dbusSessionConnector", "DBusConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::dbus::DBusConnector > dbusSessionConnector_(new ::asf::dbus::DBusConnector(*app, dbusSessionConnector));
    app->addStarter(dbusSessionConnector_);

    // Expression

    ::com::bosch::cm::asf::lang::cca::Connectors::CcaConnector ccaConnector;
    {
        ::com::bosch::cm::asf::lang::cca::Connectors::CcaConnector __expression2;
        {
            __expression2.setApplicationId(151);
        }
        ccaConnector = __expression2;
    }
    {
        std::string jsonPayload;
        serializeJson (ccaConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "ccaConnector", "CcaConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::cca::CcaConnector > ccaConnector_(new ::asf::cca::CcaConnector(*app, ccaConnector));
    app->addStarter(ccaConnector_);

    // Thread 'phoneHmi'

    ::asf::core::ComponentContainerSharedPtr PhoneHmi(new ::asf::core::ComponentContainer("phoneHmi", ::asf::core::ThreadConfiguration(1)));
    app->addContainer (PhoneHmi);

        // Component 'PhoneGui phoneGui'

        ::boost::shared_ptr< ::asf::core::ComponentFactory< ::App::Core::PhoneGui > > phoneGuiFactory(new ::asf::core::ComponentFactory< ::App::Core::PhoneGui >);
        ::asf::core::ComponentDescriptionSharedPtr phoneGuiDescription(new ::asf::core::ComponentDescription(1, "phoneGui", /* immediate = */ true, /* threadBridge = */ false, phoneGuiFactory));
        PhoneHmi->addComponentDescription(phoneGuiDescription);

            // Port 'courierMessageReceiverPort'

            ::asf::core::RequiredPort& phoneGui_courierMessageReceiverPort = phoneGuiDescription->addRequiredPort (::asf::core::RequiredPort ("CourierTunnelService.CourierMessageReceiver", "courierMessageReceiverPort"));
            (void)phoneGui_courierMessageReceiverPort; // prevent unused variable warning

            // Port 'hmiAppCtrlPort'

            ::asf::core::RequiredPort& phoneGui_hmiAppCtrlPort = phoneGuiDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.ai.hmi.appctrl.HMIAppCtrl", "hmiAppCtrlPort"));
            (void)phoneGui_hmiAppCtrlPort; // prevent unused variable warning

            // Port 'hmiAppCtrlTraceCmdPort'

            ::asf::core::RequiredPort& phoneGui_hmiAppCtrlTraceCmdPort = phoneGuiDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.ai.hmi.appctrl.trace.Commands", "hmiAppCtrlTraceCmdPort"));
            (void)phoneGui_hmiAppCtrlTraceCmdPort; // prevent unused variable warning

            // Port 'SBServicePort'

            ::asf::core::RequiredPort& phoneGui_SBServicePort = phoneGuiDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.ai.hmi.screenbroker.Service", "SBServicePort"));
            (void)phoneGui_SBServicePort; // prevent unused variable warning

        // Component 'PhoneHall phoneHall'

        ::boost::shared_ptr< ::asf::core::ComponentFactory< ::App::Core::PhoneHall > > phoneHallFactory(new ::asf::core::ComponentFactory< ::App::Core::PhoneHall >);
        ::asf::core::ComponentDescriptionSharedPtr phoneHallDescription(new ::asf::core::ComponentDescription(2, "phoneHall", /* immediate = */ true, /* threadBridge = */ false, phoneHallFactory));
        PhoneHmi->addComponentDescription(phoneHallDescription);

            // Port 'spmFiPort'

            ::asf::core::RequiredPort& phoneHall_spmFiPort = phoneHallDescription->addRequiredPort (::asf::core::RequiredPort ("SPM_CORE_FI", "spmFiPort"));
            (void)phoneHall_spmFiPort; // prevent unused variable warning

            // Port 'ConsumerPort'

            ::asf::core::RequiredPort& phoneHall_ConsumerPort = phoneHallDescription->addRequiredPort (::asf::core::RequiredPort ("org.genivi.NodeStateManager.Consumer", "ConsumerPort"));
            (void)phoneHall_ConsumerPort; // prevent unused variable warning

            // Port 'LifecycleControlPort'

            ::asf::core::RequiredPort& phoneHall_LifecycleControlPort = phoneHallDescription->addRequiredPort (::asf::core::RequiredPort ("org.genivi.NodeStateManager.LifecycleControl", "LifecycleControlPort"));
            (void)phoneHall_LifecycleControlPort; // prevent unused variable warning

            // Port 'LifeCycleConsumerPort'

            ::asf::core::ProvidedPort& phoneHall_LifeCycleConsumerPort = phoneHallDescription->addProvidedPort (::asf::core::ProvidedPort ("org.genivi.NodeStateManager.LifeCycleConsumer", "LifeCycleConsumerPort", false, false));
            (void)phoneHall_LifeCycleConsumerPort; // prevent unused variable warning

            // Port 'courierMessageReceiverPort'

            ::asf::core::ProvidedPort& phoneHall_courierMessageReceiverPort = phoneHallDescription->addProvidedPort (::asf::core::ProvidedPort ("CourierTunnelService.CourierMessageReceiver", "courierMessageReceiverPort", ::boost::shared_ptr< ::asf::core::ProvidedPortListener >(new ::asf::cms::CmsProvidedPortListener())));
            (void)phoneHall_courierMessageReceiverPort; // prevent unused variable warning

            // Port 'appHmiPhoneServicePort'

            ::asf::core::ProvidedPort& phoneHall_appHmiPhoneServicePort = phoneHallDescription->addProvidedPort (::asf::core::ProvidedPort ("org.bosch.cm.diagnosis.dbus.Diagnosis1.SystemSettings1", "appHmiPhoneServicePort", false, false));
            (void)phoneHall_appHmiPhoneServicePort; // prevent unused variable warning

            // Port 'btSetFiPort'

            ::asf::core::RequiredPort& phoneHall_btSetFiPort = phoneHallDescription->addRequiredPort (::asf::core::RequiredPort ("MOST_BTSet_FI", "btSetFiPort"));
            (void)phoneHall_btSetFiPort; // prevent unused variable warning

            // Port 'btPhonBkFiPort'

            ::asf::core::RequiredPort& phoneHall_btPhonBkFiPort = phoneHallDescription->addRequiredPort (::asf::core::RequiredPort ("MOST_PhonBk_FI", "btPhonBkFiPort"));
            (void)phoneHall_btPhonBkFiPort; // prevent unused variable warning

            // Port 'btTelFiPort'

            ::asf::core::RequiredPort& phoneHall_btTelFiPort = phoneHallDescription->addRequiredPort (::asf::core::RequiredPort ("MOST_Tel_FI", "btTelFiPort"));
            (void)phoneHall_btTelFiPort; // prevent unused variable warning

            // Port 'btMsgFiPort'

            ::asf::core::RequiredPort& phoneHall_btMsgFiPort = phoneHallDescription->addRequiredPort (::asf::core::RequiredPort ("MOST_Msg_FI", "btMsgFiPort"));
            (void)phoneHall_btMsgFiPort; // prevent unused variable warning

            // Port 'midwspiPort'

            ::asf::core::RequiredPort& phoneHall_midwspiPort = phoneHallDescription->addRequiredPort (::asf::core::RequiredPort ("midw_smartphoneint_fi", "midwspiPort"));
            (void)phoneHall_midwspiPort; // prevent unused variable warning

            // Port 'applicationSwitchPort'

            ::asf::core::RequiredPort& phoneHall_applicationSwitchPort = phoneHallDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.ai.hmi.hmimasterservice.ApplicationSwitch", "applicationSwitchPort"));
            (void)phoneHall_applicationSwitchPort; // prevent unused variable warning

            // Port 'vehicleMainFiPort'

            ::asf::core::RequiredPort& phoneHall_vehicleMainFiPort = phoneHallDescription->addRequiredPort (::asf::core::RequiredPort ("VEHICLE_MAIN_FI", "vehicleMainFiPort"));
            (void)phoneHall_vehicleMainFiPort; // prevent unused variable warning

            // Port 'clockFiPort'

            ::asf::core::RequiredPort& phoneHall_clockFiPort = phoneHallDescription->addRequiredPort (::asf::core::RequiredPort ("clock_main_fi", "clockFiPort"));
            (void)phoneHall_clockFiPort; // prevent unused variable warning

            // Port 'IntercomAudioPort'

            ::asf::core::RequiredPort& phoneHall_IntercomAudioPort = phoneHallDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.ai.IntercomAudioService", "IntercomAudioPort"));
            (void)phoneHall_IntercomAudioPort; // prevent unused variable warning

            // Port 'hmiinfoservicePort'

            ::asf::core::RequiredPort& phoneHall_hmiinfoservicePort = phoneHallDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.ai.hmi.hmiinfoservice.HmiInfoService", "hmiinfoservicePort"));
            (void)phoneHall_hmiinfoservicePort; // prevent unused variable warning

            // Port 'hmiDataServicePort'

            ::asf::core::RequiredPort& phoneHall_hmiDataServicePort = phoneHallDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.ai.nissan.hmi.hmidataservice.HmiData", "hmiDataServicePort"));
            (void)phoneHall_hmiDataServicePort; // prevent unused variable warning

            // Port 'audioSourceChangePort'

            ::asf::core::RequiredPort& phoneHall_audioSourceChangePort = phoneHallDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.ai.hmi.masteraudioservice.AudioSourceChange", "audioSourceChangePort"));
            (void)phoneHall_audioSourceChangePort; // prevent unused variable warning

            // Port 'soundPropertiesPort'

            ::asf::core::RequiredPort& phoneHall_soundPropertiesPort = phoneHallDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.ai.hmi.masteraudioservice.SoundProperties", "soundPropertiesPort"));
            (void)phoneHall_soundPropertiesPort; // prevent unused variable warning

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (phoneGui_courierMessageReceiverPort, phoneHall_courierMessageReceiverPort);

    // Expression

    ::asf::cca::CcaImportedPort& btSetFiImport = ccaConnector_->importByName (95, 5, 7, 2);
    btSetFiImport.setServiceName("MOST_BTSet_FI");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (phoneHall_btSetFiPort, btSetFiImport);

    // Expression

    ::asf::cca::CcaImportedPort& btTelFiImport = ccaConnector_->importByName (10, 4, 3, 2);
    btTelFiImport.setServiceName("MOST_Tel_FI");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (phoneHall_btTelFiPort, btTelFiImport);

    // Expression

    ::asf::cca::CcaImportedPort& vehicleMainFiImport = ccaConnector_->importByName (47, 1, 0, 2);
    vehicleMainFiImport.setServiceName("VEHICLE_MAIN_FI");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (phoneHall_vehicleMainFiPort, vehicleMainFiImport);

    // Expression

    ::asf::cca::CcaImportedPort& clockFiImport = ccaConnector_->importByName (41, 1, 5, 2);
    clockFiImport.setServiceName("clock_main_fi");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (phoneHall_clockFiPort, clockFiImport);

    // Expression

    ::asf::cca::CcaImportedPort& btPhonBkFiImport = ccaConnector_->importByName (97, 3, 0, 2);
    btPhonBkFiImport.setServiceName("MOST_PhonBk_FI");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (phoneHall_btPhonBkFiPort, btPhonBkFiImport);

    // Expression

    ::asf::cca::CcaImportedPort& btMsgFiImport = ccaConnector_->importByName (96, 2, 4, 2);
    btMsgFiImport.setServiceName("MOST_Msg_FI");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (phoneHall_btMsgFiPort, btMsgFiImport);

    // Expression

    ::asf::cca::CcaImportedPort& midwspiImport = ccaConnector_->importByName (285, 1, 0, 2);
    midwspiImport.setServiceName("midw_smartphoneint_fi");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (phoneHall_midwspiPort, midwspiImport);

    // Expression

    ::asf::dbus::DBusImportedPort& hmiAppCtrlImport = dbusSessionConnector_->importByName (::std::string("App.Core.AppHmi_Master"), ::std::string("/bosch/cm/ai/hmi/hmiappctrl"));
    hmiAppCtrlImport.setServiceName("bosch.cm.ai.hmi.appctrl.HMIAppCtrl");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (phoneGui_hmiAppCtrlPort, hmiAppCtrlImport);

    // Expression

    ::asf::dbus::DBusImportedPort& applicationSwitchImport = dbusSessionConnector_->importByName (::std::string("App.Core.AppHmi_Master"), ::std::string("/bosch/cm/ai/hmi/applcationswitchservice"));
    applicationSwitchImport.setServiceName("bosch.cm.ai.hmi.hmimasterservice.ApplicationSwitch");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (phoneHall_applicationSwitchPort, applicationSwitchImport);

    // Expression

    ::asf::dbus::DBusImportedPort& hmiTraceCmdImport = dbusSessionConnector_->importByName (::std::string("hmibase.trace.HMITraceCmd_Daemon"), ::std::string("/bosch/cm/ai/hmi/appctrl/trace/Commands"));
    hmiTraceCmdImport.setServiceName("bosch.cm.ai.hmi.appctrl.trace.Commands");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (phoneGui_hmiAppCtrlTraceCmdPort, hmiTraceCmdImport);

    // Expression

    ::asf::cca::CcaImportedPort& spmFiImport = ccaConnector_->importByName (0, 1, 0, 2);
    spmFiImport.setServiceName("SPM_CORE_FI");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (phoneHall_spmFiPort, spmFiImport);

    // Expression

    ::asf::dbus::DBusImportedPort& hmiDataServiceImport = dbusSessionConnector_->importByName (::std::string("App.Core.AppHmi_System"), ::std::string("/bosch/cm/ai/nissan/hmi/hmidataservice"));
    hmiDataServiceImport.setServiceName("bosch.cm.ai.nissan.hmi.hmidataservice.HmiData");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (phoneHall_hmiDataServicePort, hmiDataServiceImport);

    // Expression

    ::asf::dbus::DBusImportedPort& LcmConsumer = dbusSystemConnector_->importByName (::std::string("org.genivi.NodeStateManager"), ::std::string("/org/genivi/NodeStateManager/Consumer"));
    LcmConsumer.setServiceName("org.genivi.NodeStateManager.Consumer");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (phoneHall_ConsumerPort, LcmConsumer);

    // Expression

    ::asf::dbus::DBusImportedPort& LcmLifecycleControl = dbusSystemConnector_->importByName (::std::string("org.genivi.NodeStateManager"), ::std::string("/org/genivi/NodeStateManager/LifecycleControl"));
    LcmLifecycleControl.setServiceName("org.genivi.NodeStateManager.LifecycleControl");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (phoneHall_LifecycleControlPort, LcmLifecycleControl);

    // Expression

    dbusSessionConnector_->exportByName (phoneHall_appHmiPhoneServicePort, ::std::string("/org/bosch/cm/diagnosis/dbus/Diagnosis1/SystemSettings1/Phoneservice"));

    // Expression

    dbusSystemConnector_->exportByName (phoneHall_LifeCycleConsumerPort, ::std::string("/org/genivi/NodeStateManager/LifeCycleConsumer/AppHmi_Phone"));

    // Expression

    ::asf::dbus::DBusImportedPort& sbServiceImport = dbusSessionConnector_->importByName (::std::string("ScreenBroker.Service.ScreenBroker"), ::std::string("/bosch/cm/ai/hmi/screenbroker/Service"));
    sbServiceImport.setServiceName("bosch.cm.ai.hmi.screenbroker.Service");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (phoneGui_SBServicePort, sbServiceImport);

    // Expression

    ::asf::dbus::DBusImportedPort& IntercomAudioImport = dbusSessionConnector_->importByName (::std::string("IntercomApp.IntercomApplication"), ::std::string("/bosch/cm/ai/IntercomAudioService"));
    IntercomAudioImport.setServiceName("bosch.cm.ai.IntercomAudioService");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (phoneHall_IntercomAudioPort, IntercomAudioImport);

    // Expression

    ::asf::dbus::DBusImportedPort& hmiinfoserviceImport = dbusSessionConnector_->importByName (::std::string("App.Core.AppHmi_Master"), ::std::string("/bosch/cm/ai/hmi/hmiinfoservice/hmiinfoservice"));
    hmiinfoserviceImport.setServiceName("bosch.cm.ai.hmi.hmiinfoservice.HmiInfoService");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (phoneHall_hmiinfoservicePort, hmiinfoserviceImport);

    // Expression

    ::asf::dbus::DBusImportedPort& audioSourceChangeImport = dbusSessionConnector_->importByName (::std::string("App.Core.AppHmi_Master"), ::std::string("/bosch/cm/ai/hmi/hmiaudiosourcechange"));
    audioSourceChangeImport.setServiceName("bosch.cm.ai.hmi.masteraudioservice.AudioSourceChange");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (phoneHall_audioSourceChangePort, audioSourceChangeImport);

    // Expression

    ::asf::dbus::DBusImportedPort& soundPropertiesImport = dbusSessionConnector_->importByName (::std::string("App.Core.AppHmi_Master"), ::std::string("/bosch/cm/ai/hmi/hmisoundsettings"));
    soundPropertiesImport.setServiceName("bosch.cm.ai.hmi.masteraudioservice.SoundProperties");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (phoneHall_soundPropertiesPort, soundPropertiesImport);


    LOG_INFO_STATIC("Starting application 'AppHmi_Phone' version 0.1.0");

    app->start();
}

int executeAppHmi_Phone(int argc, char* argv[]) {
    ::asf::core::ContextData context;

    const char* logConfigFile = 0;
    std::vector<std::string> arguments;

    for (int i=1; i<argc; i++) {
        if (std::string(argv[i]) == "--logconfig" && i+1 < argc) {
            // ignore lint warning e850: modification of i inside loop is safe
            logConfigFile = argv[++i];
        } else {
            if (std::string(argv[i]) == "--help") {
                printf ("%s", helpMessage);
                exit (0);
            } else {
                arguments.push_back (argv[i]);
            }
        }
    }

    if (logConfigFile == 0) {
        ::asf::core::Logger::setupLogging ("App.Core", "AppHmi_Phone");
    } else {
        ::asf::core::Logger::setupLogging ("App.Core", "AppHmi_Phone", logConfigFile);
    }

    LOG_INFO_STATIC("%s ASF signal handler", AppHmi_Phone_enabledASFSignalHandler ? "Enabled" : "Disabled" );

    ::asf::core::Application* app = ::asf::core::Application::createApplication("App.Core", "AppHmi_Phone", ::asf::core::Version(0, 1, 0, ""), arguments);

    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't create AppHmi_Phone");

    app->enableExceptionHandler(true);

    importAppHmi_Phone();

    int exitCode = app->waitForCompletion();
    ::asf::core::Application::deleteApplication();

    return exitCode;
}

} // namespace Core
} // namespace App

int main(int argc, char* argv[]) {
    ::App::Core::AppHmi_Phone_enabledASFSignalHandler = true;
    ::asf::core::SignalHandler asfSignalHandler;
    ::boost::shared_ptr< ::asf::threading::Thread > mainThread = ::asf::threading::Thread::attach();
    return ::App::Core::executeAppHmi_Phone(argc, argv);
}

