/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "App/Core/AppHmi_Navigation.h"
#include "App/Core/NavigationGui.h"
#include "App/Core/NavigationHall.h"
#include "asf/cca/CcaConnector.h"
#include "asf/cca/CcaImportedPort.h"
#include "asf/cms/CmsProvidedPortListener.h"
#include "asf/core/Application.h"
#include "asf/core/ComponentContainer.h"
#include "asf/core/ComponentDescription.h"
#include "asf/core/ContextData.h"
#include "asf/core/Logger.h"
#include "asf/core/ProvidedPort.h"
#include "asf/core/RequiredPort.h"
#include "asf/core/SignalHandler.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusImportedPort.h"
#include "com/bosch/cm/asf/lang/cca/Connectors.h"
#include "com/bosch/cm/asf/lang/cca/ConnectorsJson.h"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "com/bosch/cm/asf/lang/dbus/ConnectorsJson.h"
#include <cstdio>
#include <string>

/**
 * If the meaning of "AppHmi_Navigation" isn't clear, then there should be a description here.
 */

namespace App {
namespace Core {

DEFINE_LOGGER_AND_LEVEL (_logger, "/App/Core/AppHmi_Navigation", Info);

/* static */ const char* AppHmi_Navigation::navigationGui = "navigationGui";
/* static */ const char* AppHmi_Navigation::navigationHall = "navigationHall";

static const char* helpMessage =
    "--logconfig <file>     Read the logging configuration from <file>\n"
    "                       see the ASF User Guide, section 6.3. Logging API\n"
    "--help                 Print this help message\n";

bool AppHmi_Navigation_enabledASFSignalHandler = false;

void importAppHmi_Navigation() {
    ::asf::core::Application* app = ::asf::core::Application::getApplication();
    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't attach AppHmi_Navigation, because no Application is instantiated");

    // Expression

    ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector dbusSystemConnector;
    {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector __expression0;
        {
            __expression0.setBusType(::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector::BusType__System);
        }
        dbusSystemConnector = __expression0;
    }
    {
        std::string jsonPayload;
        serializeJson (dbusSystemConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "dbusSystemConnector", "DBusConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::dbus::DBusConnector > dbusSystemConnector_(new ::asf::dbus::DBusConnector(*app, dbusSystemConnector));
    app->addStarter(dbusSystemConnector_);

    // Expression

    ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector dbusSessionConnector;
    {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector __expression1;
        {
            __expression1.setBusType(::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector::BusType__Session);
        }
        dbusSessionConnector = __expression1;
    }
    {
        std::string jsonPayload;
        serializeJson (dbusSessionConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "dbusSessionConnector", "DBusConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::dbus::DBusConnector > dbusSessionConnector_(new ::asf::dbus::DBusConnector(*app, dbusSessionConnector));
    app->addStarter(dbusSessionConnector_);

    // Expression

    ::com::bosch::cm::asf::lang::cca::Connectors::CcaConnector ccaConnector;
    {
        ::com::bosch::cm::asf::lang::cca::Connectors::CcaConnector __expression2;
        {
            __expression2.setApplicationId(153);
        }
        ccaConnector = __expression2;
    }
    {
        std::string jsonPayload;
        serializeJson (ccaConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "ccaConnector", "CcaConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::cca::CcaConnector > ccaConnector_(new ::asf::cca::CcaConnector(*app, ccaConnector));
    app->addStarter(ccaConnector_);

    // Thread 'navigationHmi'

    ::asf::core::ComponentContainerSharedPtr NavigationHmi(new ::asf::core::ComponentContainer("navigationHmi", ::asf::core::ThreadConfiguration(1)));
    app->addContainer (NavigationHmi);

        // Component 'NavigationGui navigationGui'

        ::boost::shared_ptr< ::asf::core::ComponentFactory< ::App::Core::NavigationGui > > navigationGuiFactory(new ::asf::core::ComponentFactory< ::App::Core::NavigationGui >);
        ::asf::core::ComponentDescriptionSharedPtr navigationGuiDescription(new ::asf::core::ComponentDescription(1, "navigationGui", /* immediate = */ true, /* threadBridge = */ false, navigationGuiFactory));
        NavigationHmi->addComponentDescription(navigationGuiDescription);

            // Port 'courierMessageReceiverPort'

            ::asf::core::RequiredPort& navigationGui_courierMessageReceiverPort = navigationGuiDescription->addRequiredPort (::asf::core::RequiredPort ("CourierTunnelService.CourierMessageReceiver", "courierMessageReceiverPort"));
            (void)navigationGui_courierMessageReceiverPort; // prevent unused variable warning

            // Port 'hmiAppCtrlPort'

            ::asf::core::RequiredPort& navigationGui_hmiAppCtrlPort = navigationGuiDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.ai.hmi.appctrl.HMIAppCtrl", "hmiAppCtrlPort"));
            (void)navigationGui_hmiAppCtrlPort; // prevent unused variable warning

            // Port 'hmiAppCtrlTraceCmdPort'

            ::asf::core::RequiredPort& navigationGui_hmiAppCtrlTraceCmdPort = navigationGuiDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.ai.hmi.appctrl.trace.Commands", "hmiAppCtrlTraceCmdPort"));
            (void)navigationGui_hmiAppCtrlTraceCmdPort; // prevent unused variable warning

            // Port 'SBServicePort'

            ::asf::core::RequiredPort& navigationGui_SBServicePort = navigationGuiDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.ai.hmi.screenbroker.Service", "SBServicePort"));
            (void)navigationGui_SBServicePort; // prevent unused variable warning

        // Component 'NavigationHall navigationHall'

        ::boost::shared_ptr< ::asf::core::ComponentFactory< ::App::Core::NavigationHall > > navigationHallFactory(new ::asf::core::ComponentFactory< ::App::Core::NavigationHall >);
        ::asf::core::ComponentDescriptionSharedPtr navigationHallDescription(new ::asf::core::ComponentDescription(2, "navigationHall", /* immediate = */ true, /* threadBridge = */ false, navigationHallFactory));
        NavigationHmi->addComponentDescription(navigationHallDescription);

            // Port 'spmFiPort'

            ::asf::core::RequiredPort& navigationHall_spmFiPort = navigationHallDescription->addRequiredPort (::asf::core::RequiredPort ("SPM_CORE_FI", "spmFiPort"));
            (void)navigationHall_spmFiPort; // prevent unused variable warning

            // Port 'ConsumerPort'

            ::asf::core::RequiredPort& navigationHall_ConsumerPort = navigationHallDescription->addRequiredPort (::asf::core::RequiredPort ("org.genivi.NodeStateManager.Consumer", "ConsumerPort"));
            (void)navigationHall_ConsumerPort; // prevent unused variable warning

            // Port 'LifecycleControlPort'

            ::asf::core::RequiredPort& navigationHall_LifecycleControlPort = navigationHallDescription->addRequiredPort (::asf::core::RequiredPort ("org.genivi.NodeStateManager.LifecycleControl", "LifecycleControlPort"));
            (void)navigationHall_LifecycleControlPort; // prevent unused variable warning

            // Port 'LifeCycleConsumerPort'

            ::asf::core::ProvidedPort& navigationHall_LifeCycleConsumerPort = navigationHallDescription->addProvidedPort (::asf::core::ProvidedPort ("org.genivi.NodeStateManager.LifeCycleConsumer", "LifeCycleConsumerPort", false, false));
            (void)navigationHall_LifeCycleConsumerPort; // prevent unused variable warning

            // Port 'courierMessageReceiverPort'

            ::asf::core::ProvidedPort& navigationHall_courierMessageReceiverPort = navigationHallDescription->addProvidedPort (::asf::core::ProvidedPort ("CourierTunnelService.CourierMessageReceiver", "courierMessageReceiverPort", ::boost::shared_ptr< ::asf::core::ProvidedPortListener >(new ::asf::cms::CmsProvidedPortListener())));
            (void)navigationHall_courierMessageReceiverPort; // prevent unused variable warning

            // Port 'navigationPort'

            ::asf::core::ProvidedPort& navigationHall_navigationPort = navigationHallDescription->addProvidedPort (::asf::core::ProvidedPort ("org.bosch.cm.navigation.NavigationService", "navigationPort", false, false));
            (void)navigationHall_navigationPort; // prevent unused variable warning

            // Port 'navigationSDSPort'

            ::asf::core::ProvidedPort& navigationHall_navigationSDSPort = navigationHallDescription->addProvidedPort (::asf::core::ProvidedPort ("org.bosch.cm.navigation.NavigationSDSService", "navigationSDSPort", false, false));
            (void)navigationHall_navigationSDSPort; // prevent unused variable warning

            // Port 'navigationDataUpdatePort'

            ::asf::core::ProvidedPort& navigationHall_navigationDataUpdatePort = navigationHallDescription->addProvidedPort (::asf::core::ProvidedPort ("org.bosch.cm.navigation.NavigationDataUpdateService", "navigationDataUpdatePort", false, false));
            (void)navigationHall_navigationDataUpdatePort; // prevent unused variable warning

            // Port 'applicationSwitchPort'

            ::asf::core::RequiredPort& navigationHall_applicationSwitchPort = navigationHallDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.ai.hmi.hmimasterservice.ApplicationSwitch", "applicationSwitchPort"));
            (void)navigationHall_applicationSwitchPort; // prevent unused variable warning

            // Port 'hmiDataServicePort'

            ::asf::core::RequiredPort& navigationHall_hmiDataServicePort = navigationHallDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.ai.nissan.hmi.hmidataservice.HmiData", "hmiDataServicePort"));
            (void)navigationHall_hmiDataServicePort; // prevent unused variable warning

            // Port 'appHmiNavigationServicePort'

            ::asf::core::ProvidedPort& navigationHall_appHmiNavigationServicePort = navigationHallDescription->addProvidedPort (::asf::core::ProvidedPort ("org.bosch.cm.diagnosis.dbus.Diagnosis1.SystemSettings1", "appHmiNavigationServicePort", false, false));
            (void)navigationHall_appHmiNavigationServicePort; // prevent unused variable warning

            // Port 'vehicleMainFiPort'

            ::asf::core::RequiredPort& navigationHall_vehicleMainFiPort = navigationHallDescription->addRequiredPort (::asf::core::RequiredPort ("VEHICLE_MAIN_FI", "vehicleMainFiPort"));
            (void)navigationHall_vehicleMainFiPort; // prevent unused variable warning

            // Port 'btSetFiPort'

            ::asf::core::RequiredPort& navigationHall_btSetFiPort = navigationHallDescription->addRequiredPort (::asf::core::RequiredPort ("MOST_BTSet_FI", "btSetFiPort"));
            (void)navigationHall_btSetFiPort; // prevent unused variable warning

            // Port 'btTelFiPort'

            ::asf::core::RequiredPort& navigationHall_btTelFiPort = navigationHallDescription->addRequiredPort (::asf::core::RequiredPort ("MOST_Tel_FI", "btTelFiPort"));
            (void)navigationHall_btTelFiPort; // prevent unused variable warning

            // Port 'vdDimFiPort'

            ::asf::core::RequiredPort& navigationHall_vdDimFiPort = navigationHallDescription->addRequiredPort (::asf::core::RequiredPort ("dimming_main_fi", "vdDimFiPort"));
            (void)navigationHall_vdDimFiPort; // prevent unused variable warning

            // Port 'commandInterfacePort'

            ::asf::core::RequiredPort& navigationHall_commandInterfacePort = navigationHallDescription->addRequiredPort (::asf::core::RequiredPort ("org.genivi.audiomanager.CommandInterface", "commandInterfacePort"));
            (void)navigationHall_commandInterfacePort; // prevent unused variable warning

            // Port 'clockFiPort'

            ::asf::core::RequiredPort& navigationHall_clockFiPort = navigationHallDescription->addRequiredPort (::asf::core::RequiredPort ("clock_main_fi", "clockFiPort"));
            (void)navigationHall_clockFiPort; // prevent unused variable warning

            // Port 'mascfFiPort'

            ::asf::core::RequiredPort& navigationHall_mascfFiPort = navigationHallDescription->addRequiredPort (::asf::core::RequiredPort ("midw_mascf_fi", "mascfFiPort"));
            (void)navigationHall_mascfFiPort; // prevent unused variable warning

            // Port 'audioSourceChangePort'

            ::asf::core::RequiredPort& navigationHall_audioSourceChangePort = navigationHallDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.ai.hmi.masteraudioservice.AudioSourceChange", "audioSourceChangePort"));
            (void)navigationHall_audioSourceChangePort; // prevent unused variable warning

            // Port 'soundPropertiesPort'

            ::asf::core::RequiredPort& navigationHall_soundPropertiesPort = navigationHallDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.ai.hmi.masteraudioservice.SoundProperties", "soundPropertiesPort"));
            (void)navigationHall_soundPropertiesPort; // prevent unused variable warning

            // Port 'fcSwUpdatePort'

            ::asf::core::RequiredPort& navigationHall_fcSwUpdatePort = navigationHallDescription->addRequiredPort (::asf::core::RequiredPort ("fcswupdatesrv.FcSwUpdateSrv", "fcSwUpdatePort"));
            (void)navigationHall_fcSwUpdatePort; // prevent unused variable warning

            // Port 'hmiinfoservicePort'

            ::asf::core::RequiredPort& navigationHall_hmiinfoservicePort = navigationHallDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.ai.hmi.hmiinfoservice.HmiInfoService", "hmiinfoservicePort"));
            (void)navigationHall_hmiinfoservicePort; // prevent unused variable warning

            // Port 'diagnosticsFiPort'

            ::asf::core::RequiredPort& navigationHall_diagnosticsFiPort = navigationHallDescription->addRequiredPort (::asf::core::RequiredPort ("Midw_Diagnostics_FI", "diagnosticsFiPort"));
            (void)navigationHall_diagnosticsFiPort; // prevent unused variable warning

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (navigationGui_courierMessageReceiverPort, navigationHall_courierMessageReceiverPort);

    // Expression

    ::asf::dbus::DBusImportedPort& hmiAppCtrlImport = dbusSessionConnector_->importByName (::std::string("App.Core.AppHmi_Master"), ::std::string("/bosch/cm/ai/hmi/hmiappctrl"));
    hmiAppCtrlImport.setServiceName("bosch.cm.ai.hmi.appctrl.HMIAppCtrl");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (navigationGui_hmiAppCtrlPort, hmiAppCtrlImport);

    // Expression

    ::asf::dbus::DBusImportedPort& hmiTraceCmdImport = dbusSessionConnector_->importByName (::std::string("hmibase.trace.HMITraceCmd_Daemon"), ::std::string("/bosch/cm/ai/hmi/appctrl/trace/Commands"));
    hmiTraceCmdImport.setServiceName("bosch.cm.ai.hmi.appctrl.trace.Commands");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (navigationGui_hmiAppCtrlTraceCmdPort, hmiTraceCmdImport);

    // Expression

    ::asf::dbus::DBusImportedPort& applicationSwitchImport = dbusSessionConnector_->importByName (::std::string("App.Core.AppHmi_Master"), ::std::string("/bosch/cm/ai/hmi/applcationswitchservice"));
    applicationSwitchImport.setServiceName("bosch.cm.ai.hmi.hmimasterservice.ApplicationSwitch");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (navigationHall_applicationSwitchPort, applicationSwitchImport);

    // Expression

    ::asf::dbus::DBusImportedPort& hmiDataServiceImport = dbusSessionConnector_->importByName (::std::string("App.Core.AppHmi_System"), ::std::string("/bosch/cm/ai/nissan/hmi/hmidataservice"));
    hmiDataServiceImport.setServiceName("bosch.cm.ai.nissan.hmi.hmidataservice.HmiData");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (navigationHall_hmiDataServicePort, hmiDataServiceImport);

    // Expression

    ::asf::cca::CcaImportedPort& spmFiImport = ccaConnector_->importByName (0, 1, 0, 2);
    spmFiImport.setServiceName("SPM_CORE_FI");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (navigationHall_spmFiPort, spmFiImport);

    // Expression

    ::asf::dbus::DBusImportedPort& LcmConsumer = dbusSystemConnector_->importByName (::std::string("org.genivi.NodeStateManager"), ::std::string("/org/genivi/NodeStateManager/Consumer"));
    LcmConsumer.setServiceName("org.genivi.NodeStateManager.Consumer");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (navigationHall_ConsumerPort, LcmConsumer);

    // Expression

    ::asf::dbus::DBusImportedPort& LcmLifecycleControl = dbusSystemConnector_->importByName (::std::string("org.genivi.NodeStateManager"), ::std::string("/org/genivi/NodeStateManager/LifecycleControl"));
    LcmLifecycleControl.setServiceName("org.genivi.NodeStateManager.LifecycleControl");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (navigationHall_LifecycleControlPort, LcmLifecycleControl);

    // Expression

    dbusSystemConnector_->exportByName (navigationHall_LifeCycleConsumerPort, ::std::string("/org/genivi/NodeStateManager/LifeCycleConsumer/AppHmi_Navigation"));

    // Expression

    ::asf::cca::CcaImportedPort& vehicleMainFiImport = ccaConnector_->importByName (47, 1, 0, 2);
    vehicleMainFiImport.setServiceName("VEHICLE_MAIN_FI");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (navigationHall_vehicleMainFiPort, vehicleMainFiImport);

    // Expression

    ::asf::cca::CcaImportedPort& vdDimFiImport = ccaConnector_->importByName (84, 4, 0, 2);
    vdDimFiImport.setServiceName("dimming_main_fi");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (navigationHall_vdDimFiPort, vdDimFiImport);

    // Expression

    ::asf::cca::CcaImportedPort& btSetFiImport = ccaConnector_->importByName (95, 5, 7, 2);
    btSetFiImport.setServiceName("MOST_BTSet_FI");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (navigationHall_btSetFiPort, btSetFiImport);

    // Expression

    ::asf::cca::CcaImportedPort& btTelFiImport = ccaConnector_->importByName (10, 4, 3, 2);
    btTelFiImport.setServiceName("MOST_Tel_FI");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (navigationHall_btTelFiPort, btTelFiImport);

    // Expression

    ::asf::dbus::DBusImportedPort& commandInterfaceImport = dbusSystemConnector_->importByName (::std::string("org.genivi.audiomanager"), ::std::string("/org/genivi/audiomanager/CommandInterface"));
    commandInterfaceImport.setServiceName("org.genivi.audiomanager.CommandInterface");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (navigationHall_commandInterfacePort, commandInterfaceImport);

    // Expression

    ::asf::cca::CcaImportedPort& clockFiImport = ccaConnector_->importByName (41, 1, 5, 2);
    clockFiImport.setServiceName("clock_main_fi");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (navigationHall_clockFiPort, clockFiImport);

    // Expression

    ::asf::cca::CcaImportedPort& mascfFiImport = ccaConnector_->importByName (263, 1, 0, 2);
    mascfFiImport.setServiceName("midw_mascf_fi");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (navigationHall_mascfFiPort, mascfFiImport);

    // Expression

    dbusSessionConnector_->exportByName (navigationHall_navigationPort, ::std::string("/com/bosch/cm/ai/navigation"));

    // Expression

    dbusSessionConnector_->exportByName (navigationHall_navigationSDSPort, ::std::string("/com/bosch/cm/ai/navigationsds"));

    // Expression

    dbusSessionConnector_->exportByName (navigationHall_navigationDataUpdatePort, ::std::string("/com/bosch/cm/ai/navigationDataUpdate"));

    // Expression

    dbusSessionConnector_->exportByName (navigationHall_appHmiNavigationServicePort, ::std::string("/org/bosch/cm/diagnosis/dbus/Diagnosis1/SystemSettings1/HmiNavigationService"));

    // Expression

    ::asf::dbus::DBusImportedPort& audioSourceChangeImport = dbusSessionConnector_->importByName (::std::string("App.Core.AppHmi_Master"), ::std::string("/bosch/cm/ai/hmi/hmiaudiosourcechange"));
    audioSourceChangeImport.setServiceName("bosch.cm.ai.hmi.masteraudioservice.AudioSourceChange");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (navigationHall_audioSourceChangePort, audioSourceChangeImport);

    // Expression

    ::asf::dbus::DBusImportedPort& soundPropertiesImport = dbusSessionConnector_->importByName (::std::string("App.Core.AppHmi_Master"), ::std::string("/bosch/cm/ai/hmi/hmisoundsettings"));
    soundPropertiesImport.setServiceName("bosch.cm.ai.hmi.masteraudioservice.SoundProperties");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (navigationHall_soundPropertiesPort, soundPropertiesImport);

    // Expression

    ::asf::dbus::DBusImportedPort& fcswupdatesrvImport = dbusSessionConnector_->importByName (::std::string("fcswupdate.FcSwUpdateApp"), ::std::string("/org/bosch/cm/ai_sw_update/fcSwUpdateService"));
    fcswupdatesrvImport.setServiceName("fcswupdatesrv.FcSwUpdateSrv");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (navigationHall_fcSwUpdatePort, fcswupdatesrvImport);

    // Expression

    ::asf::dbus::DBusImportedPort& sbServiceImport = dbusSessionConnector_->importByName (::std::string("ScreenBroker.Service.ScreenBroker"), ::std::string("/bosch/cm/ai/hmi/screenbroker/Service"));
    sbServiceImport.setServiceName("bosch.cm.ai.hmi.screenbroker.Service");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (navigationGui_SBServicePort, sbServiceImport);

    // Expression

    ::asf::dbus::DBusImportedPort& hmiinfoserviceImport = dbusSessionConnector_->importByName (::std::string("App.Core.AppHmi_Master"), ::std::string("/bosch/cm/ai/hmi/hmiinfoservice/hmiinfoservice"));
    hmiinfoserviceImport.setServiceName("bosch.cm.ai.hmi.hmiinfoservice.HmiInfoService");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (navigationHall_hmiinfoservicePort, hmiinfoserviceImport);

    // Expression

    ::asf::cca::CcaImportedPort& diagnosticsFiImport = ccaConnector_->importByName (276, 1, 3, 2);
    diagnosticsFiImport.setServiceName("Midw_Diagnostics_FI");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (navigationHall_diagnosticsFiPort, diagnosticsFiImport);


    LOG_INFO_STATIC("Starting application 'AppHmi_Navigation' version 0.1.0");

    app->start();
}

int executeAppHmi_Navigation(int argc, char* argv[]) {
    ::asf::core::ContextData context;

    const char* logConfigFile = 0;
    std::vector<std::string> arguments;

    for (int i=1; i<argc; i++) {
        if (std::string(argv[i]) == "--logconfig" && i+1 < argc) {
            // ignore lint warning e850: modification of i inside loop is safe
            logConfigFile = argv[++i];
        } else {
            if (std::string(argv[i]) == "--help") {
                printf ("%s", helpMessage);
                exit (0);
            } else {
                arguments.push_back (argv[i]);
            }
        }
    }

    if (logConfigFile == 0) {
        ::asf::core::Logger::setupLogging ("App.Core", "AppHmi_Navigation");
    } else {
        ::asf::core::Logger::setupLogging ("App.Core", "AppHmi_Navigation", logConfigFile);
    }

    LOG_INFO_STATIC("%s ASF signal handler", AppHmi_Navigation_enabledASFSignalHandler ? "Enabled" : "Disabled" );

    ::asf::core::Application* app = ::asf::core::Application::createApplication("App.Core", "AppHmi_Navigation", ::asf::core::Version(0, 1, 0, ""), arguments);

    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't create AppHmi_Navigation");

    app->enableExceptionHandler(true);

    importAppHmi_Navigation();

    int exitCode = app->waitForCompletion();
    ::asf::core::Application::deleteApplication();

    return exitCode;
}

} // namespace Core
} // namespace App

int main(int argc, char* argv[]) {
    ::App::Core::AppHmi_Navigation_enabledASFSignalHandler = true;
    ::asf::core::SignalHandler asfSignalHandler;
    ::boost::shared_ptr< ::asf::threading::Thread > mainThread = ::asf::threading::Thread::attach();
    return ::App::Core::executeAppHmi_Navigation(argc, argv);
}

