/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "App/Core/AppHmi_Media.h"
#include "App/Core/MediaGui.h"
#include "App/Core/MediaHall.h"
#include "asf/cca/CcaConnector.h"
#include "asf/cca/CcaImportedPort.h"
#include "asf/cms/CmsProvidedPortListener.h"
#include "asf/core/Application.h"
#include "asf/core/ComponentContainer.h"
#include "asf/core/ComponentDescription.h"
#include "asf/core/ContextData.h"
#include "asf/core/Logger.h"
#include "asf/core/ProvidedPort.h"
#include "asf/core/RequiredPort.h"
#include "asf/core/SignalHandler.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusImportedPort.h"
#include "com/bosch/cm/asf/lang/cca/Connectors.h"
#include "com/bosch/cm/asf/lang/cca/ConnectorsJson.h"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "com/bosch/cm/asf/lang/dbus/ConnectorsJson.h"
#include <cstdio>
#include <string>

/**
 * If the meaning of "AppHmi_Media" isn't clear, then there should be a description here.
 */

namespace App {
namespace Core {

DEFINE_LOGGER_AND_LEVEL (_logger, "/App/Core/AppHmi_Media", Info);

/* static */ const char* AppHmi_Media::mediaGui = "mediaGui";
/* static */ const char* AppHmi_Media::mediaHall = "mediaHall";

static const char* helpMessage =
    "--logconfig <file>     Read the logging configuration from <file>\n"
    "                       see the ASF User Guide, section 6.3. Logging API\n"
    "--help                 Print this help message\n";

bool AppHmi_Media_enabledASFSignalHandler = false;

void importAppHmi_Media() {
    ::asf::core::Application* app = ::asf::core::Application::getApplication();
    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't attach AppHmi_Media, because no Application is instantiated");

    // Expression

    ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector dbusSystemConnector;
    {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector __expression0;
        {
            __expression0.setBusType(::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector::BusType__System);
        }
        dbusSystemConnector = __expression0;
    }
    {
        std::string jsonPayload;
        serializeJson (dbusSystemConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "dbusSystemConnector", "DBusConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::dbus::DBusConnector > dbusSystemConnector_(new ::asf::dbus::DBusConnector(*app, dbusSystemConnector));
    app->addStarter(dbusSystemConnector_);

    // Expression

    ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector dbusSessionConnector;
    {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector __expression1;
        {
            __expression1.setBusType(::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector::BusType__Session);
        }
        dbusSessionConnector = __expression1;
    }
    {
        std::string jsonPayload;
        serializeJson (dbusSessionConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "dbusSessionConnector", "DBusConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::dbus::DBusConnector > dbusSessionConnector_(new ::asf::dbus::DBusConnector(*app, dbusSessionConnector));
    app->addStarter(dbusSessionConnector_);

    // Expression

    ::com::bosch::cm::asf::lang::cca::Connectors::CcaConnector ccaConnector;
    {
        ::com::bosch::cm::asf::lang::cca::Connectors::CcaConnector __expression2;
        {
            __expression2.setApplicationId(152);
        }
        ccaConnector = __expression2;
    }
    {
        std::string jsonPayload;
        serializeJson (ccaConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "ccaConnector", "CcaConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::cca::CcaConnector > ccaConnector_(new ::asf::cca::CcaConnector(*app, ccaConnector));
    app->addStarter(ccaConnector_);

    // Thread 'mediaHmi'

    ::asf::core::ComponentContainerSharedPtr MediaHmi(new ::asf::core::ComponentContainer("mediaHmi", ::asf::core::ThreadConfiguration(1)));
    app->addContainer (MediaHmi);

        // Component 'MediaGui mediaGui'

        ::boost::shared_ptr< ::asf::core::ComponentFactory< ::App::Core::MediaGui > > mediaGuiFactory(new ::asf::core::ComponentFactory< ::App::Core::MediaGui >);
        ::asf::core::ComponentDescriptionSharedPtr mediaGuiDescription(new ::asf::core::ComponentDescription(1, "mediaGui", /* immediate = */ true, /* threadBridge = */ false, mediaGuiFactory));
        MediaHmi->addComponentDescription(mediaGuiDescription);

            // Port 'courierMessageReceiverPort'

            ::asf::core::RequiredPort& mediaGui_courierMessageReceiverPort = mediaGuiDescription->addRequiredPort (::asf::core::RequiredPort ("CourierTunnelService.CourierMessageReceiver", "courierMessageReceiverPort"));
            (void)mediaGui_courierMessageReceiverPort; // prevent unused variable warning

            // Port 'hmiAppCtrlPort'

            ::asf::core::RequiredPort& mediaGui_hmiAppCtrlPort = mediaGuiDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.ai.hmi.appctrl.HMIAppCtrl", "hmiAppCtrlPort"));
            (void)mediaGui_hmiAppCtrlPort; // prevent unused variable warning

            // Port 'hmiAppCtrlTraceCmdPort'

            ::asf::core::RequiredPort& mediaGui_hmiAppCtrlTraceCmdPort = mediaGuiDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.ai.hmi.appctrl.trace.Commands", "hmiAppCtrlTraceCmdPort"));
            (void)mediaGui_hmiAppCtrlTraceCmdPort; // prevent unused variable warning

            // Port 'SBServicePort'

            ::asf::core::RequiredPort& mediaGui_SBServicePort = mediaGuiDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.ai.hmi.screenbroker.Service", "SBServicePort"));
            (void)mediaGui_SBServicePort; // prevent unused variable warning

        // Component 'MediaHall mediaHall'

        ::boost::shared_ptr< ::asf::core::ComponentFactory< ::App::Core::MediaHall > > mediaHallFactory(new ::asf::core::ComponentFactory< ::App::Core::MediaHall >);
        ::asf::core::ComponentDescriptionSharedPtr mediaHallDescription(new ::asf::core::ComponentDescription(2, "mediaHall", /* immediate = */ true, /* threadBridge = */ false, mediaHallFactory));
        MediaHmi->addComponentDescription(mediaHallDescription);

            // Port 'spmFiPort'

            ::asf::core::RequiredPort& mediaHall_spmFiPort = mediaHallDescription->addRequiredPort (::asf::core::RequiredPort ("SPM_CORE_FI", "spmFiPort"));
            (void)mediaHall_spmFiPort; // prevent unused variable warning

            // Port 'ConsumerPort'

            ::asf::core::RequiredPort& mediaHall_ConsumerPort = mediaHallDescription->addRequiredPort (::asf::core::RequiredPort ("org.genivi.NodeStateManager.Consumer", "ConsumerPort"));
            (void)mediaHall_ConsumerPort; // prevent unused variable warning

            // Port 'LifecycleControlPort'

            ::asf::core::RequiredPort& mediaHall_LifecycleControlPort = mediaHallDescription->addRequiredPort (::asf::core::RequiredPort ("org.genivi.NodeStateManager.LifecycleControl", "LifecycleControlPort"));
            (void)mediaHall_LifecycleControlPort; // prevent unused variable warning

            // Port 'LifeCycleConsumerPort'

            ::asf::core::ProvidedPort& mediaHall_LifeCycleConsumerPort = mediaHallDescription->addProvidedPort (::asf::core::ProvidedPort ("org.genivi.NodeStateManager.LifeCycleConsumer", "LifeCycleConsumerPort", false, false));
            (void)mediaHall_LifeCycleConsumerPort; // prevent unused variable warning

            // Port 'courierMessageReceiverPort'

            ::asf::core::ProvidedPort& mediaHall_courierMessageReceiverPort = mediaHallDescription->addProvidedPort (::asf::core::ProvidedPort ("CourierTunnelService.CourierMessageReceiver", "courierMessageReceiverPort", ::boost::shared_ptr< ::asf::core::ProvidedPortListener >(new ::asf::cms::CmsProvidedPortListener())));
            (void)mediaHall_courierMessageReceiverPort; // prevent unused variable warning

            // Port 'AppHmiMediaServicePort'

            ::asf::core::ProvidedPort& mediaHall_AppHmiMediaServicePort = mediaHallDescription->addProvidedPort (::asf::core::ProvidedPort ("org.bosch.cm.diagnosis.dbus.Diagnosis1.SystemSettings1", "AppHmiMediaServicePort", false, false));
            (void)mediaHall_AppHmiMediaServicePort; // prevent unused variable warning

            // Port 'mediaBTSetFiPort'

            ::asf::core::RequiredPort& mediaHall_mediaBTSetFiPort = mediaHallDescription->addRequiredPort (::asf::core::RequiredPort ("MOST_BTSet_FI", "mediaBTSetFiPort"));
            (void)mediaHall_mediaBTSetFiPort; // prevent unused variable warning

            // Port 'mediaPlayerFiPort'

            ::asf::core::RequiredPort& mediaHall_mediaPlayerFiPort = mediaHallDescription->addRequiredPort (::asf::core::RequiredPort ("mplay_MediaPlayer_FI", "mediaPlayerFiPort"));
            (void)mediaHall_mediaPlayerFiPort; // prevent unused variable warning

            // Port 'tunermasterFiPort'

            ::asf::core::RequiredPort& mediaHall_tunermasterFiPort = mediaHallDescription->addRequiredPort (::asf::core::RequiredPort ("MIDW_TUNERMASTER_FI", "tunermasterFiPort"));
            (void)mediaHall_tunermasterFiPort; // prevent unused variable warning

            // Port 'vehicleMainFiPort'

            ::asf::core::RequiredPort& mediaHall_vehicleMainFiPort = mediaHallDescription->addRequiredPort (::asf::core::RequiredPort ("VEHICLE_MAIN_FI", "vehicleMainFiPort"));
            (void)mediaHall_vehicleMainFiPort; // prevent unused variable warning

            // Port 'applicationSwitchPort'

            ::asf::core::RequiredPort& mediaHall_applicationSwitchPort = mediaHallDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.ai.hmi.hmimasterservice.ApplicationSwitch", "applicationSwitchPort"));
            (void)mediaHall_applicationSwitchPort; // prevent unused variable warning

            // Port 'commandInterfacePort'

            ::asf::core::RequiredPort& mediaHall_commandInterfacePort = mediaHallDescription->addRequiredPort (::asf::core::RequiredPort ("org.genivi.audiomanager.CommandInterface", "commandInterfacePort"));
            (void)mediaHall_commandInterfacePort; // prevent unused variable warning

            // Port 'audioSourceChangePort'

            ::asf::core::RequiredPort& mediaHall_audioSourceChangePort = mediaHallDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.ai.hmi.masteraudioservice.AudioSourceChange", "audioSourceChangePort"));
            (void)mediaHall_audioSourceChangePort; // prevent unused variable warning

            // Port 'soundPropertiesPort'

            ::asf::core::RequiredPort& mediaHall_soundPropertiesPort = mediaHallDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.ai.hmi.masteraudioservice.SoundProperties", "soundPropertiesPort"));
            (void)mediaHall_soundPropertiesPort; // prevent unused variable warning

            // Port 'PluginDbusInterfacePort'

            ::asf::core::RequiredPort& mediaHall_PluginDbusInterfacePort = mediaHallDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.ai.PluginDbusInterface", "PluginDbusInterfacePort"));
            (void)mediaHall_PluginDbusInterfacePort; // prevent unused variable warning

            // Port 'HmiEmpListInterfacePort'

            ::asf::core::RequiredPort& mediaHall_HmiEmpListInterfacePort = mediaHallDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.di.HmiEmpListInterface", "HmiEmpListInterfacePort"));
            (void)mediaHall_HmiEmpListInterfacePort; // prevent unused variable warning

            // Port 'tunerFiPort'

            ::asf::core::RequiredPort& mediaHall_tunerFiPort = mediaHallDescription->addRequiredPort (::asf::core::RequiredPort ("MIDW_TUNER_FI", "tunerFiPort"));
            (void)mediaHall_tunerFiPort; // prevent unused variable warning

            // Port 'hmiinfoservicePort'

            ::asf::core::RequiredPort& mediaHall_hmiinfoservicePort = mediaHallDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.ai.hmi.hmiinfoservice.HmiInfoService", "hmiinfoservicePort"));
            (void)mediaHall_hmiinfoservicePort; // prevent unused variable warning

            // Port 'mPlayDeviceManagerFiPort'

            ::asf::core::RequiredPort& mediaHall_mPlayDeviceManagerFiPort = mediaHallDescription->addRequiredPort (::asf::core::RequiredPort ("mplay_devicemanager_fi", "mPlayDeviceManagerFiPort"));
            (void)mediaHall_mPlayDeviceManagerFiPort; // prevent unused variable warning

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (mediaGui_courierMessageReceiverPort, mediaHall_courierMessageReceiverPort);

    // Expression

    ::asf::dbus::DBusImportedPort& hmiAppCtrlImport = dbusSessionConnector_->importByName (::std::string("App.Core.AppHmi_Master"), ::std::string("/bosch/cm/ai/hmi/hmiappctrl"));
    hmiAppCtrlImport.setServiceName("bosch.cm.ai.hmi.appctrl.HMIAppCtrl");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (mediaGui_hmiAppCtrlPort, hmiAppCtrlImport);

    // Expression

    ::asf::dbus::DBusImportedPort& hmiTraceCmdImport = dbusSessionConnector_->importByName (::std::string("hmibase.trace.HMITraceCmd_Daemon"), ::std::string("/bosch/cm/ai/hmi/appctrl/trace/Commands"));
    hmiTraceCmdImport.setServiceName("bosch.cm.ai.hmi.appctrl.trace.Commands");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (mediaGui_hmiAppCtrlTraceCmdPort, hmiTraceCmdImport);

    // Expression

    ::asf::cca::CcaImportedPort& spmFiImport = ccaConnector_->importByName (0, 1, 0, 2);
    spmFiImport.setServiceName("SPM_CORE_FI");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (mediaHall_spmFiPort, spmFiImport);

    // Expression

    ::asf::dbus::DBusImportedPort& pluginDbusInterfaceImport = dbusSessionConnector_->importByName (::std::string("PluginServer.PluginServer"), ::std::string("/bosch/cm/ai/PluginDbusInterface"));
    pluginDbusInterfaceImport.setServiceName("bosch.cm.ai.PluginDbusInterface");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (mediaHall_PluginDbusInterfacePort, pluginDbusInterfaceImport);

    // Expression

    ::asf::dbus::DBusImportedPort& EmpListInterfaceImport = dbusSessionConnector_->importByName (::std::string("EMP_ListHandler.DbusComponent.EMPServer.EmpListDbusApplication"), ::std::string("/bosch/cm/di/HmiEmpListInterface"));
    EmpListInterfaceImport.setServiceName("bosch.cm.di.HmiEmpListInterface");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (mediaHall_HmiEmpListInterfacePort, EmpListInterfaceImport);

    // Expression

    ::asf::dbus::DBusImportedPort& LcmConsumer = dbusSystemConnector_->importByName (::std::string("org.genivi.NodeStateManager"), ::std::string("/org/genivi/NodeStateManager/Consumer"));
    LcmConsumer.setServiceName("org.genivi.NodeStateManager.Consumer");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (mediaHall_ConsumerPort, LcmConsumer);

    // Expression

    ::asf::dbus::DBusImportedPort& LcmLifecycleControl = dbusSystemConnector_->importByName (::std::string("org.genivi.NodeStateManager"), ::std::string("/org/genivi/NodeStateManager/LifecycleControl"));
    LcmLifecycleControl.setServiceName("org.genivi.NodeStateManager.LifecycleControl");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (mediaHall_LifecycleControlPort, LcmLifecycleControl);

    // Expression

    ::asf::dbus::DBusImportedPort& applicationSwitchImport = dbusSessionConnector_->importByName (::std::string("App.Core.AppHmi_Master"), ::std::string("/bosch/cm/ai/hmi/applcationswitchservice"));
    applicationSwitchImport.setServiceName("bosch.cm.ai.hmi.hmimasterservice.ApplicationSwitch");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (mediaHall_applicationSwitchPort, applicationSwitchImport);

    // Expression

    dbusSystemConnector_->exportByName (mediaHall_LifeCycleConsumerPort, ::std::string("/org/genivi/NodeStateManager/LifeCycleConsumer/AppHmi_Media"));

    // Expression

    ::asf::cca::CcaImportedPort& mediaBTSetFiImport = ccaConnector_->importByName (95, 5, 7, 2);
    mediaBTSetFiImport.setServiceName("MOST_BTSet_FI");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (mediaHall_mediaBTSetFiPort, mediaBTSetFiImport);

    // Expression

    ::asf::cca::CcaImportedPort& mediaPlayerFiImport = ccaConnector_->importByName (89, 4, 4, 2);
    mediaPlayerFiImport.setServiceName("mplay_MediaPlayer_FI");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (mediaHall_mediaPlayerFiPort, mediaPlayerFiImport);

    // Expression

    ::asf::cca::CcaImportedPort& tunermasterFiImport = ccaConnector_->importByName (286, 3, 1, 2);
    tunermasterFiImport.setServiceName("MIDW_TUNERMASTER_FI");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (mediaHall_tunermasterFiPort, tunermasterFiImport);

    // Expression

    ::asf::cca::CcaImportedPort& tunerFiImport = ccaConnector_->importByName (264, 3, 0, 2);
    tunerFiImport.setServiceName("MIDW_TUNER_FI");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (mediaHall_tunerFiPort, tunerFiImport);

    // Expression

    ::asf::cca::CcaImportedPort& vehicleMainFiImport = ccaConnector_->importByName (47, 1, 0, 2);
    vehicleMainFiImport.setServiceName("VEHICLE_MAIN_FI");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (mediaHall_vehicleMainFiPort, vehicleMainFiImport);

    // Expression

    dbusSessionConnector_->exportByName (mediaHall_AppHmiMediaServicePort, ::std::string("/org/bosch/cm/diagnosis/dbus/Diagnosis1/SystemSettings1/mediaservice"));

    // Expression

    ::asf::dbus::DBusImportedPort& commandInterfaceImport = dbusSystemConnector_->importByName (::std::string("org.genivi.audiomanager"), ::std::string("/org/genivi/audiomanager/CommandInterface"));
    commandInterfaceImport.setServiceName("org.genivi.audiomanager.CommandInterface");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (mediaHall_commandInterfacePort, commandInterfaceImport);

    // Expression

    ::asf::dbus::DBusImportedPort& audioSourceChangeImport = dbusSessionConnector_->importByName (::std::string("App.Core.AppHmi_Master"), ::std::string("/bosch/cm/ai/hmi/hmiaudiosourcechange"));
    audioSourceChangeImport.setServiceName("bosch.cm.ai.hmi.masteraudioservice.AudioSourceChange");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (mediaHall_audioSourceChangePort, audioSourceChangeImport);

    // Expression

    ::asf::dbus::DBusImportedPort& soundPropertiesImport = dbusSessionConnector_->importByName (::std::string("App.Core.AppHmi_Master"), ::std::string("/bosch/cm/ai/hmi/hmisoundsettings"));
    soundPropertiesImport.setServiceName("bosch.cm.ai.hmi.masteraudioservice.SoundProperties");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (mediaHall_soundPropertiesPort, soundPropertiesImport);

    // Expression

    ::asf::dbus::DBusImportedPort& sbServiceImport = dbusSessionConnector_->importByName (::std::string("ScreenBroker.Service.ScreenBroker"), ::std::string("/bosch/cm/ai/hmi/screenbroker/Service"));
    sbServiceImport.setServiceName("bosch.cm.ai.hmi.screenbroker.Service");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (mediaGui_SBServicePort, sbServiceImport);

    // Expression

    ::asf::dbus::DBusImportedPort& hmiinfoserviceImport = dbusSessionConnector_->importByName (::std::string("App.Core.AppHmi_Master"), ::std::string("/bosch/cm/ai/hmi/hmiinfoservice/hmiinfoservice"));
    hmiinfoserviceImport.setServiceName("bosch.cm.ai.hmi.hmiinfoservice.HmiInfoService");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (mediaHall_hmiinfoservicePort, hmiinfoserviceImport);

    // Expression

    ::asf::cca::CcaImportedPort& mPlayDeviceManagerFiImport = ccaConnector_->importByName (27, 3, 1, 2);
    mPlayDeviceManagerFiImport.setServiceName("mplay_devicemanager_fi");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (mediaHall_mPlayDeviceManagerFiPort, mPlayDeviceManagerFiImport);


    LOG_INFO_STATIC("Starting application 'AppHmi_Media' version 0.1.0");

    app->start();
}

int executeAppHmi_Media(int argc, char* argv[]) {
    ::asf::core::ContextData context;

    const char* logConfigFile = 0;
    std::vector<std::string> arguments;

    for (int i=1; i<argc; i++) {
        if (std::string(argv[i]) == "--logconfig" && i+1 < argc) {
            // ignore lint warning e850: modification of i inside loop is safe
            logConfigFile = argv[++i];
        } else {
            if (std::string(argv[i]) == "--help") {
                printf ("%s", helpMessage);
                exit (0);
            } else {
                arguments.push_back (argv[i]);
            }
        }
    }

    if (logConfigFile == 0) {
        ::asf::core::Logger::setupLogging ("App.Core", "AppHmi_Media");
    } else {
        ::asf::core::Logger::setupLogging ("App.Core", "AppHmi_Media", logConfigFile);
    }

    LOG_INFO_STATIC("%s ASF signal handler", AppHmi_Media_enabledASFSignalHandler ? "Enabled" : "Disabled" );

    ::asf::core::Application* app = ::asf::core::Application::createApplication("App.Core", "AppHmi_Media", ::asf::core::Version(0, 1, 0, ""), arguments);

    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't create AppHmi_Media");

    app->enableExceptionHandler(true);

    importAppHmi_Media();

    int exitCode = app->waitForCompletion();
    ::asf::core::Application::deleteApplication();

    return exitCode;
}

} // namespace Core
} // namespace App

int main(int argc, char* argv[]) {
    ::App::Core::AppHmi_Media_enabledASFSignalHandler = true;
    ::asf::core::SignalHandler asfSignalHandler;
    ::boost::shared_ptr< ::asf::threading::Thread > mainThread = ::asf::threading::Thread::attach();
    return ::App::Core::executeAppHmi_Media(argc, argv);
}

