/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "App/Core/AppHmi_Master.h"
#include "App/Core/MasterGui.h"
#include "App/Core/MasterHall.h"
#include "asf/cca/CcaConnector.h"
#include "asf/cca/CcaImportedPort.h"
#include "asf/cms/CmsProvidedPortListener.h"
#include "asf/core/Application.h"
#include "asf/core/ComponentContainer.h"
#include "asf/core/ComponentDescription.h"
#include "asf/core/ContextData.h"
#include "asf/core/Logger.h"
#include "asf/core/ProvidedPort.h"
#include "asf/core/RequiredPort.h"
#include "asf/core/SignalHandler.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusImportedPort.h"
#include "com/bosch/cm/asf/lang/cca/Connectors.h"
#include "com/bosch/cm/asf/lang/cca/ConnectorsJson.h"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "com/bosch/cm/asf/lang/dbus/ConnectorsJson.h"
#include <cstdio>
#include <string>

/**
 * If the meaning of "AppHmi_Master" isn't clear, then there should be a description here.
 */

namespace App {
namespace Core {

DEFINE_LOGGER_AND_LEVEL (_logger, "/App/Core/AppHmi_Master", Info);

/* static */ const char* AppHmi_Master::masterGui = "masterGui";
/* static */ const char* AppHmi_Master::masterHall = "masterHall";

static const char* helpMessage =
    "--logconfig <file>     Read the logging configuration from <file>\n"
    "                       see the ASF User Guide, section 6.3. Logging API\n"
    "--help                 Print this help message\n";

bool AppHmi_Master_enabledASFSignalHandler = false;

void importAppHmi_Master() {
    ::asf::core::Application* app = ::asf::core::Application::getApplication();
    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't attach AppHmi_Master, because no Application is instantiated");

    // Expression

    ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector dbusSystemConnector;
    {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector __expression0;
        {
            __expression0.setBusType(::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector::BusType__System);
        }
        dbusSystemConnector = __expression0;
    }
    {
        std::string jsonPayload;
        serializeJson (dbusSystemConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "dbusSystemConnector", "DBusConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::dbus::DBusConnector > dbusSystemConnector_(new ::asf::dbus::DBusConnector(*app, dbusSystemConnector));
    app->addStarter(dbusSystemConnector_);

    // Expression

    ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector dbusSessionConnector;
    {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector __expression1;
        {
            __expression1.setBusType(::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector::BusType__Session);
        }
        dbusSessionConnector = __expression1;
    }
    {
        std::string jsonPayload;
        serializeJson (dbusSessionConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "dbusSessionConnector", "DBusConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::dbus::DBusConnector > dbusSessionConnector_(new ::asf::dbus::DBusConnector(*app, dbusSessionConnector));
    app->addStarter(dbusSessionConnector_);

    // Expression

    ::com::bosch::cm::asf::lang::cca::Connectors::CcaConnector ccaConnector;
    {
        ::com::bosch::cm::asf::lang::cca::Connectors::CcaConnector __expression2;
        {
            __expression2.setApplicationId(148);
        }
        ccaConnector = __expression2;
    }
    {
        std::string jsonPayload;
        serializeJson (ccaConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "ccaConnector", "CcaConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::cca::CcaConnector > ccaConnector_(new ::asf::cca::CcaConnector(*app, ccaConnector));
    app->addStarter(ccaConnector_);

    // Thread 'thHmiMaster'

    ::asf::core::ComponentContainerSharedPtr ThHmiMaster(new ::asf::core::ComponentContainer("thHmiMaster", ::asf::core::ThreadConfiguration(1)));
    app->addContainer (ThHmiMaster);

        // Component 'MasterGui masterGui'

        ::boost::shared_ptr< ::asf::core::ComponentFactory< ::App::Core::MasterGui > > masterGuiFactory(new ::asf::core::ComponentFactory< ::App::Core::MasterGui >);
        ::asf::core::ComponentDescriptionSharedPtr masterGuiDescription(new ::asf::core::ComponentDescription(1, "masterGui", /* immediate = */ true, /* threadBridge = */ false, masterGuiFactory));
        ThHmiMaster->addComponentDescription(masterGuiDescription);

            // Port 'hmiAppCtrlPort_o'

            ::asf::core::ProvidedPort& masterGui_hmiAppCtrlPort_o = masterGuiDescription->addProvidedPort (::asf::core::ProvidedPort ("bosch.cm.ai.hmi.appctrl.HMIAppCtrl", "hmiAppCtrlPort_o", false, false));
            (void)masterGui_hmiAppCtrlPort_o; // prevent unused variable warning

            // Port 'courierMessageReceiverPort'

            ::asf::core::RequiredPort& masterGui_courierMessageReceiverPort = masterGuiDescription->addRequiredPort (::asf::core::RequiredPort ("CourierTunnelService.CourierMessageReceiver", "courierMessageReceiverPort"));
            (void)masterGui_courierMessageReceiverPort; // prevent unused variable warning

            // Port 'hmiAppCtrlPort'

            ::asf::core::RequiredPort& masterGui_hmiAppCtrlPort = masterGuiDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.ai.hmi.appctrl.HMIAppCtrl", "hmiAppCtrlPort"));
            (void)masterGui_hmiAppCtrlPort; // prevent unused variable warning

            // Port 'hmiAppCtrlTraceCmdPort'

            ::asf::core::RequiredPort& masterGui_hmiAppCtrlTraceCmdPort = masterGuiDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.ai.hmi.appctrl.trace.Commands", "hmiAppCtrlTraceCmdPort"));
            (void)masterGui_hmiAppCtrlTraceCmdPort; // prevent unused variable warning

            // Port 'SBServicePort'

            ::asf::core::RequiredPort& masterGui_SBServicePort = masterGuiDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.ai.hmi.screenbroker.Service", "SBServicePort"));
            (void)masterGui_SBServicePort; // prevent unused variable warning

        // Component 'MasterHall masterHall'

        ::boost::shared_ptr< ::asf::core::ComponentFactory< ::App::Core::MasterHall > > masterHallFactory(new ::asf::core::ComponentFactory< ::App::Core::MasterHall >);
        ::asf::core::ComponentDescriptionSharedPtr masterHallDescription(new ::asf::core::ComponentDescription(2, "masterHall", /* immediate = */ true, /* threadBridge = */ false, masterHallFactory));
        ThHmiMaster->addComponentDescription(masterHallDescription);

            // Port 'ConsumerPort'

            ::asf::core::RequiredPort& masterHall_ConsumerPort = masterHallDescription->addRequiredPort (::asf::core::RequiredPort ("org.genivi.NodeStateManager.Consumer", "ConsumerPort"));
            (void)masterHall_ConsumerPort; // prevent unused variable warning

            // Port 'LifecycleControlPort'

            ::asf::core::RequiredPort& masterHall_LifecycleControlPort = masterHallDescription->addRequiredPort (::asf::core::RequiredPort ("org.genivi.NodeStateManager.LifecycleControl", "LifecycleControlPort"));
            (void)masterHall_LifecycleControlPort; // prevent unused variable warning

            // Port 'LifeCycleConsumerPort'

            ::asf::core::ProvidedPort& masterHall_LifeCycleConsumerPort = masterHallDescription->addProvidedPort (::asf::core::ProvidedPort ("org.genivi.NodeStateManager.LifeCycleConsumer", "LifeCycleConsumerPort", false, false));
            (void)masterHall_LifeCycleConsumerPort; // prevent unused variable warning

            // Port 'courierMessageReceiverPort'

            ::asf::core::ProvidedPort& masterHall_courierMessageReceiverPort = masterHallDescription->addProvidedPort (::asf::core::ProvidedPort ("CourierTunnelService.CourierMessageReceiver", "courierMessageReceiverPort", ::boost::shared_ptr< ::asf::core::ProvidedPortListener >(new ::asf::cms::CmsProvidedPortListener())));
            (void)masterHall_courierMessageReceiverPort; // prevent unused variable warning

            // Port 'audioSourceChangePort'

            ::asf::core::ProvidedPort& masterHall_audioSourceChangePort = masterHallDescription->addProvidedPort (::asf::core::ProvidedPort ("bosch.cm.ai.hmi.masteraudioservice.AudioSourceChange", "audioSourceChangePort", false, false));
            (void)masterHall_audioSourceChangePort; // prevent unused variable warning

            // Port 'soundPropertiesPort'

            ::asf::core::ProvidedPort& masterHall_soundPropertiesPort = masterHallDescription->addProvidedPort (::asf::core::ProvidedPort ("bosch.cm.ai.hmi.masteraudioservice.SoundProperties", "soundPropertiesPort", false, false));
            (void)masterHall_soundPropertiesPort; // prevent unused variable warning

            // Port 'spmFiPort'

            ::asf::core::RequiredPort& masterHall_spmFiPort = masterHallDescription->addRequiredPort (::asf::core::RequiredPort ("SPM_CORE_FI", "spmFiPort"));
            (void)masterHall_spmFiPort; // prevent unused variable warning

            // Port 'commandInterfacePort'

            ::asf::core::RequiredPort& masterHall_commandInterfacePort = masterHallDescription->addRequiredPort (::asf::core::RequiredPort ("org.genivi.audiomanager.CommandInterface", "commandInterfacePort"));
            (void)masterHall_commandInterfacePort; // prevent unused variable warning

            // Port 'diagnosticsFiPort'

            ::asf::core::RequiredPort& masterHall_diagnosticsFiPort = masterHallDescription->addRequiredPort (::asf::core::RequiredPort ("Midw_Diagnostics_FI", "diagnosticsFiPort"));
            (void)masterHall_diagnosticsFiPort; // prevent unused variable warning

            // Port 'applicationSwitchServerPort'

            ::asf::core::ProvidedPort& masterHall_applicationSwitchServerPort = masterHallDescription->addProvidedPort (::asf::core::ProvidedPort ("bosch.cm.ai.hmi.hmimasterservice.ApplicationSwitch", "applicationSwitchServerPort", false, false));
            (void)masterHall_applicationSwitchServerPort; // prevent unused variable warning

            // Port 'applicationSwitchPort'

            ::asf::core::RequiredPort& masterHall_applicationSwitchPort = masterHallDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.ai.hmi.hmimasterservice.ApplicationSwitch", "applicationSwitchPort"));
            (void)masterHall_applicationSwitchPort; // prevent unused variable warning

            // Port 'PluginDbusInterfacePort'

            ::asf::core::RequiredPort& masterHall_PluginDbusInterfacePort = masterHallDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.ai.PluginDbusInterface", "PluginDbusInterfacePort"));
            (void)masterHall_PluginDbusInterfacePort; // prevent unused variable warning

            // Port 'rvcFiPort'

            ::asf::core::RequiredPort& masterHall_rvcFiPort = masterHallDescription->addRequiredPort (::asf::core::RequiredPort ("rvc_cca_fi", "rvcFiPort"));
            (void)masterHall_rvcFiPort; // prevent unused variable warning

            // Port 'syncdisplayFiPort'

            ::asf::core::RequiredPort& masterHall_syncdisplayFiPort = masterHallDescription->addRequiredPort (::asf::core::RequiredPort ("syncdisplay_main_fi", "syncdisplayFiPort"));
            (void)masterHall_syncdisplayFiPort; // prevent unused variable warning

            // Port 'AppHmi_MasterServicePort'

            ::asf::core::ProvidedPort& masterHall_AppHmi_MasterServicePort = masterHallDescription->addProvidedPort (::asf::core::ProvidedPort ("org.bosch.cm.diagnosis.dbus.Diagnosis1.SystemSettings1", "AppHmi_MasterServicePort", false, false));
            (void)masterHall_AppHmi_MasterServicePort; // prevent unused variable warning

            // Port 'hmiInfoServiceServerPort'

            ::asf::core::ProvidedPort& masterHall_hmiInfoServiceServerPort = masterHallDescription->addProvidedPort (::asf::core::ProvidedPort ("bosch.cm.ai.hmi.hmiinfoservice.HmiInfoService", "hmiInfoServiceServerPort", false, false));
            (void)masterHall_hmiInfoServiceServerPort; // prevent unused variable warning

            // Port 'vehicleMainFiPort'

            ::asf::core::RequiredPort& masterHall_vehicleMainFiPort = masterHallDescription->addRequiredPort (::asf::core::RequiredPort ("VEHICLE_MAIN_FI", "vehicleMainFiPort"));
            (void)masterHall_vehicleMainFiPort; // prevent unused variable warning

            // Port 'masterBTSetFiPort'

            ::asf::core::RequiredPort& masterHall_masterBTSetFiPort = masterHallDescription->addRequiredPort (::asf::core::RequiredPort ("MOST_BTSet_FI", "masterBTSetFiPort"));
            (void)masterHall_masterBTSetFiPort; // prevent unused variable warning

            // Port 'hmiinfoservicePort'

            ::asf::core::RequiredPort& masterHall_hmiinfoservicePort = masterHallDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.ai.hmi.hmiinfoservice.HmiInfoService", "hmiinfoservicePort"));
            (void)masterHall_hmiinfoservicePort; // prevent unused variable warning

            // Port 'mediaPlayerFiPort'

            ::asf::core::RequiredPort& masterHall_mediaPlayerFiPort = masterHallDescription->addRequiredPort (::asf::core::RequiredPort ("mplay_MediaPlayer_FI", "mediaPlayerFiPort"));
            (void)masterHall_mediaPlayerFiPort; // prevent unused variable warning

            // Port 'heatCtrlMainFiPort'

            ::asf::core::RequiredPort& masterHall_heatCtrlMainFiPort = masterHallDescription->addRequiredPort (::asf::core::RequiredPort ("heatctrl_main_fi", "heatCtrlMainFiPort"));
            (void)masterHall_heatCtrlMainFiPort; // prevent unused variable warning

            // Port 'NanoMsgGenericPort'

            ::asf::core::RequiredPort& masterHall_NanoMsgGenericPort = masterHallDescription->addRequiredPort (::asf::core::RequiredPort ("bosch.cm.di.NanoMsgGenericInterface", "NanoMsgGenericPort"));
            (void)masterHall_NanoMsgGenericPort; // prevent unused variable warning

            // Port 'lcmdbusclient_main_fiPort'

            ::asf::core::RequiredPort& masterHall_lcmdbusclient_main_fiPort = masterHallDescription->addRequiredPort (::asf::core::RequiredPort ("lcmdbusclient_main_fi", "lcmdbusclient_main_fiPort"));
            (void)masterHall_lcmdbusclient_main_fiPort; // prevent unused variable warning

    // Expression

    ::asf::dbus::DBusImportedPort& commandInterfaceImport = dbusSystemConnector_->importByName (::std::string("org.genivi.audiomanager"), ::std::string("/org/genivi/audiomanager/CommandInterface"));
    commandInterfaceImport.setServiceName("org.genivi.audiomanager.CommandInterface");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (masterHall_commandInterfacePort, commandInterfaceImport);

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (masterGui_courierMessageReceiverPort, masterHall_courierMessageReceiverPort);

    // Expression

    dbusSessionConnector_->exportByName (masterHall_audioSourceChangePort, ::std::string("/bosch/cm/ai/hmi/hmiaudiosourcechange"));

    // Expression

    dbusSessionConnector_->exportByName (masterHall_soundPropertiesPort, ::std::string("/bosch/cm/ai/hmi/hmisoundsettings"));

    // Expression

    dbusSessionConnector_->exportByName (masterHall_applicationSwitchServerPort, ::std::string("/bosch/cm/ai/hmi/applcationswitchservice"));

    // Expression

    dbusSessionConnector_->exportByName (masterGui_hmiAppCtrlPort_o, ::std::string("/bosch/cm/ai/hmi/hmiappctrl"));

    // Expression

    dbusSessionConnector_->exportByName (masterHall_hmiInfoServiceServerPort, ::std::string("/bosch/cm/ai/hmi/hmiinfoservice/hmiinfoservice"));

    // Expression

    ::asf::cca::CcaImportedPort& spmFiImport = ccaConnector_->importByName (0, 1, 0, 2);
    spmFiImport.setServiceName("SPM_CORE_FI");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (masterHall_spmFiPort, spmFiImport);

    // Expression

    ::asf::dbus::DBusImportedPort& sbServiceImport = dbusSessionConnector_->importByName (::std::string("ScreenBroker.Service.ScreenBroker"), ::std::string("/bosch/cm/ai/hmi/screenbroker/Service"));
    sbServiceImport.setServiceName("bosch.cm.ai.hmi.screenbroker.Service");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (masterGui_SBServicePort, sbServiceImport);

    // Expression

    ::asf::dbus::DBusImportedPort& HmiAppCtrl = dbusSessionConnector_->importByName (::std::string("App.Core.AppHmi_Master"), ::std::string("/bosch/cm/ai/hmi/hmiappctrl"));
    HmiAppCtrl.setServiceName("bosch.cm.ai.hmi.appctrl.HMIAppCtrl");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (masterGui_hmiAppCtrlPort, HmiAppCtrl);

    // Expression

    ::asf::dbus::DBusImportedPort& hmiTraceCmdImport = dbusSessionConnector_->importByName (::std::string("hmibase.trace.HMITraceCmd_Daemon"), ::std::string("/bosch/cm/ai/hmi/appctrl/trace/Commands"));
    hmiTraceCmdImport.setServiceName("bosch.cm.ai.hmi.appctrl.trace.Commands");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (masterGui_hmiAppCtrlTraceCmdPort, hmiTraceCmdImport);

    // Expression

    ::asf::dbus::DBusImportedPort& applicationSwitchImport = dbusSessionConnector_->importByName (::std::string("App.Core.AppHmi_Master"), ::std::string("/bosch/cm/ai/hmi/applcationswitchservice"));
    applicationSwitchImport.setServiceName("bosch.cm.ai.hmi.hmimasterservice.ApplicationSwitch");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (masterHall_applicationSwitchPort, applicationSwitchImport);

    // Expression

    ::asf::dbus::DBusImportedPort& pluginDbusImport = dbusSessionConnector_->importByName (::std::string("PluginServer.PluginServer"), ::std::string("/bosch/cm/ai/PluginDbusInterface"));
    pluginDbusImport.setServiceName("bosch.cm.ai.PluginDbusInterface");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (masterHall_PluginDbusInterfacePort, pluginDbusImport);

    // Expression

    ::asf::cca::CcaImportedPort& diagnosticsFiImport = ccaConnector_->importByName (276, 1, 3, 2);
    diagnosticsFiImport.setServiceName("Midw_Diagnostics_FI");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (masterHall_diagnosticsFiPort, diagnosticsFiImport);

    // Expression

    ::asf::cca::CcaImportedPort& syncdisplayFiImport = ccaConnector_->importByName (84, 1, 0, 2);
    syncdisplayFiImport.setServiceName("syncdisplay_main_fi");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (masterHall_syncdisplayFiPort, syncdisplayFiImport);

    // Expression

    dbusSessionConnector_->exportByName (masterHall_AppHmi_MasterServicePort, ::std::string("/org/bosch/cm/diagnosis/dbus/Diagnosis1/SystemSettings1/masterservice"));

    // Expression

    ::asf::dbus::DBusImportedPort& LcmConsumer = dbusSystemConnector_->importByName (::std::string("org.genivi.NodeStateManager"), ::std::string("/org/genivi/NodeStateManager/Consumer"));
    LcmConsumer.setServiceName("org.genivi.NodeStateManager.Consumer");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (masterHall_ConsumerPort, LcmConsumer);

    // Expression

    ::asf::dbus::DBusImportedPort& LcmLifecycleControl = dbusSystemConnector_->importByName (::std::string("org.genivi.NodeStateManager"), ::std::string("/org/genivi/NodeStateManager/LifecycleControl"));
    LcmLifecycleControl.setServiceName("org.genivi.NodeStateManager.LifecycleControl");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (masterHall_LifecycleControlPort, LcmLifecycleControl);

    // Expression

    dbusSystemConnector_->exportByName (masterHall_LifeCycleConsumerPort, ::std::string("/org/genivi/NodeStateManager/LifeCycleConsumer/AppHmi_Master"));

    // Expression

    ::asf::cca::CcaImportedPort& rvcFiImport = ccaConnector_->importByName (84, 1, 0, 2);
    rvcFiImport.setServiceName("rvc_cca_fi");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (masterHall_rvcFiPort, rvcFiImport);

    // Expression

    ::asf::cca::CcaImportedPort& heatctrlmainFiImport = ccaConnector_->importByName (38, 1, 4, 2);
    heatctrlmainFiImport.setServiceName("heatctrl_main_fi");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (masterHall_heatCtrlMainFiPort, heatctrlmainFiImport);

    // Expression

    ::asf::cca::CcaImportedPort& vehicleMainFiImport = ccaConnector_->importByName (47, 1, 0, 2);
    vehicleMainFiImport.setServiceName("VEHICLE_MAIN_FI");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (masterHall_vehicleMainFiPort, vehicleMainFiImport);

    // Expression

    ::asf::cca::CcaImportedPort& masterBTSetFiImport = ccaConnector_->importByName (95, 5, 7, 2);
    masterBTSetFiImport.setServiceName("MOST_BTSet_FI");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (masterHall_masterBTSetFiPort, masterBTSetFiImport);

    // Expression

    ::asf::dbus::DBusImportedPort& hmiinfoserviceImport = dbusSessionConnector_->importByName (::std::string("App.Core.AppHmi_Master"), ::std::string("/bosch/cm/ai/hmi/hmiinfoservice/hmiinfoservice"));
    hmiinfoserviceImport.setServiceName("bosch.cm.ai.hmi.hmiinfoservice.HmiInfoService");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (masterHall_hmiinfoservicePort, hmiinfoserviceImport);

    // Expression

    ::asf::cca::CcaImportedPort& mediaPlayerFiImport = ccaConnector_->importByName (89, 4, 4, 2);
    mediaPlayerFiImport.setServiceName("mplay_MediaPlayer_FI");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (masterHall_mediaPlayerFiPort, mediaPlayerFiImport);

    // Expression

    ::asf::dbus::DBusImportedPort& NanoMsgGenericImport = dbusSessionConnector_->importByName (::std::string("NanoMsg_MasterApp.NanoMsgServer.NanoMsgMasterApplication"), ::std::string("/bosch/cm/di/NanoMsgGenericInterface"));
    NanoMsgGenericImport.setServiceName("bosch.cm.di.NanoMsgGenericInterface");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (masterHall_NanoMsgGenericPort, NanoMsgGenericImport);

    // Expression

    ::asf::cca::CcaImportedPort& lcmdbusclient_main_fiImport = ccaConnector_->importByName (243, 1, 0, 2);
    lcmdbusclient_main_fiImport.setServiceName("lcmdbusclient_main_fi");

    // Binding

    ::asf::core::ComponentMessageAdapter::bind (masterHall_lcmdbusclient_main_fiPort, lcmdbusclient_main_fiImport);


    LOG_INFO_STATIC("Starting application 'AppHmi_Master' version 1.0.0");

    app->start();
}

int executeAppHmi_Master(int argc, char* argv[]) {
    ::asf::core::ContextData context;

    const char* logConfigFile = 0;
    std::vector<std::string> arguments;

    for (int i=1; i<argc; i++) {
        if (std::string(argv[i]) == "--logconfig" && i+1 < argc) {
            // ignore lint warning e850: modification of i inside loop is safe
            logConfigFile = argv[++i];
        } else {
            if (std::string(argv[i]) == "--help") {
                printf ("%s", helpMessage);
                exit (0);
            } else {
                arguments.push_back (argv[i]);
            }
        }
    }

    if (logConfigFile == 0) {
        ::asf::core::Logger::setupLogging ("App.Core", "AppHmi_Master");
    } else {
        ::asf::core::Logger::setupLogging ("App.Core", "AppHmi_Master", logConfigFile);
    }

    LOG_INFO_STATIC("%s ASF signal handler", AppHmi_Master_enabledASFSignalHandler ? "Enabled" : "Disabled" );

    ::asf::core::Application* app = ::asf::core::Application::createApplication("App.Core", "AppHmi_Master", ::asf::core::Version(1, 0, 0, ""), arguments);

    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't create AppHmi_Master");

    app->enableExceptionHandler(true);

    importAppHmi_Master();

    int exitCode = app->waitForCompletion();
    ::asf::core::Application::deleteApplication();

    return exitCode;
}

} // namespace Core
} // namespace App

int main(int argc, char* argv[]) {
    ::App::Core::AppHmi_Master_enabledASFSignalHandler = true;
    ::asf::core::SignalHandler asfSignalHandler;
    ::boost::shared_ptr< ::asf::threading::Thread > mainThread = ::asf::threading::Thread::attach();
    return ::App::Core::executeAppHmi_Master(argc, argv);
}

