/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/Application.h"
#include "asf/core/ComponentContainer.h"
#include "asf/core/ComponentDescription.h"
#include "asf/core/ContextData.h"
#include "asf/core/Logger.h"
#include "asf/core/ProvidedPort.h"
#include "asf/dbus/DBusConnector.h"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "com/bosch/cm/asf/lang/dbus/ConnectorsJson.h"
#include "hmibase/trace/HMIBaseTraceCmds.h"
#include "hmibase/trace/HMITraceCmd_Daemon.h"
#include <cstdio>
#include <string>

/**
 * If the meaning of "HMITraceCmd_Daemon" isn't clear, then there should be a description here.
 */

namespace hmibase {
namespace trace {

DEFINE_LOGGER_AND_LEVEL (_logger, "/hmibase/trace/HMITraceCmd_Daemon", Info);

/* static */ const char* HMITraceCmd_Daemon::hmi_base_trace_cmds = "hmi_base_trace_cmds";

static const char* helpMessage =
    "--logconfig <file>     Read the logging configuration from <file>\n"
    "                       see the ASF User Guide, section 6.3. Logging API\n"
    "--help                 Print this help message\n";

bool HMITraceCmd_Daemon_enabledASFSignalHandler = false;

void importHMITraceCmd_Daemon() {
    ::asf::core::Application* app = ::asf::core::Application::getApplication();
    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't attach HMITraceCmd_Daemon, because no Application is instantiated");

    // Expression

    ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector dbusSessionConnector;
    {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector __expression0;
        {
            __expression0.setBusType(::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector::BusType__Session);
        }
        dbusSessionConnector = __expression0;
    }
    {
        std::string jsonPayload;
        serializeJson (dbusSessionConnector, jsonPayload);
        LOG_INFO_STATIC ("Creating connector %s (%s), configuration: %s", "dbusSessionConnector", "DBusConnector", jsonPayload.c_str());
    }
    ::boost::shared_ptr< ::asf::dbus::DBusConnector > dbusSessionConnector_(new ::asf::dbus::DBusConnector(*app, dbusSessionConnector));
    app->addStarter(dbusSessionConnector_);

    // Thread 'thHmiBaseTraceCmdDaemon'

    ::asf::core::ComponentContainerSharedPtr ThHmiBaseTraceCmdDaemon(new ::asf::core::ComponentContainer("thHmiBaseTraceCmdDaemon", ::asf::core::ThreadConfiguration(1)));
    app->addContainer (ThHmiBaseTraceCmdDaemon);

        // Component 'HMIBaseTraceCmds hmi_base_trace_cmds'

        ::boost::shared_ptr< ::asf::core::ComponentFactory< ::hmibase::trace::HMIBaseTraceCmds > > hmi_base_trace_cmdsFactory(new ::asf::core::ComponentFactory< ::hmibase::trace::HMIBaseTraceCmds >);
        ::asf::core::ComponentDescriptionSharedPtr hmi_base_trace_cmdsDescription(new ::asf::core::ComponentDescription(1, "hmi_base_trace_cmds", /* immediate = */ true, /* threadBridge = */ false, hmi_base_trace_cmdsFactory));
        ThHmiBaseTraceCmdDaemon->addComponentDescription(hmi_base_trace_cmdsDescription);

            // Port 'port'

            ::asf::core::ProvidedPort& hmi_base_trace_cmds_port = hmi_base_trace_cmdsDescription->addProvidedPort (::asf::core::ProvidedPort ("bosch.cm.ai.hmi.appctrl.trace.Commands", "port", false, false));
            (void)hmi_base_trace_cmds_port; // prevent unused variable warning

    // Expression

    dbusSessionConnector_->exportByName (hmi_base_trace_cmds_port, ::std::string("/bosch/cm/ai/hmi/appctrl/trace/Commands"));


    LOG_INFO_STATIC("Starting application 'HMITraceCmd_Daemon' version 1.0.0");

    app->start();
}

int executeHMITraceCmd_Daemon(int argc, char* argv[]) {
    ::asf::core::ContextData context;

    const char* logConfigFile = 0;
    std::vector<std::string> arguments;

    for (int i=1; i<argc; i++) {
        if (std::string(argv[i]) == "--logconfig" && i+1 < argc) {
            // ignore lint warning e850: modification of i inside loop is safe
            logConfigFile = argv[++i];
        } else {
            if (std::string(argv[i]) == "--help") {
                printf ("%s", helpMessage);
                exit (0);
            } else {
                arguments.push_back (argv[i]);
            }
        }
    }

    if (logConfigFile == 0) {
        ::asf::core::Logger::setupLogging ("hmibase.trace", "HMITraceCmd_Daemon");
    } else {
        ::asf::core::Logger::setupLogging ("hmibase.trace", "HMITraceCmd_Daemon", logConfigFile);
    }

    LOG_INFO_STATIC("%s ASF signal handler", HMITraceCmd_Daemon_enabledASFSignalHandler ? "Enabled" : "Disabled" );

    ::asf::core::Application* app = ::asf::core::Application::createApplication("hmibase.trace", "HMITraceCmd_Daemon", ::asf::core::Version(1, 0, 0, ""), arguments);

    LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't create HMITraceCmd_Daemon");

    app->enableExceptionHandler(false);

    importHMITraceCmd_Daemon();

    int exitCode = app->waitForCompletion();
    ::asf::core::Application::deleteApplication();

    return exitCode;
}

} // namespace trace
} // namespace hmibase

int main(int argc, char* argv[]) {
    ::boost::shared_ptr< ::asf::threading::Thread > mainThread = ::asf::threading::Thread::attach();
    return ::hmibase::trace::executeHMITraceCmd_Daemon(argc, argv);
}

