/*****************************************************************************************
*
* \file    dia_IWifiSetupsListener.h
*
* \brief   listener of dia_IWifiSetupsListener
*
* The interface-class covers methods for sending requests and data to SAFeature.
* The reception and processing is replied with a tDiaResult value.
* For details about the available methods see the list below.
*
* \author stc2hi (generated with ifGen.py tool)
*
*     !!!  THIS FILE IS GENERATED - DO NOT EDIT
*     !!!  MANUAL CHANGES WILL BE OVERWRITTEN BY BUILD-PROCESS
*     !!!  TO UPDATE THIS FILE EDIT dia_IWifiSetups.xml
*
* (c) 2019 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_WIFI_SETUPS_LISTENER__
#define __INCLUDED_DIA_INTERFACE_WIFI_SETUPS_LISTENER__

#ifndef __INCLUDED_DIA_INTERFACE_WIFI_SETUPS__
#include "dia_IWifiSetups.h"
#endif

#define IID_WIFI_SETUPS_LISTENER ((dia::IID) 0xdb5dabb4)
/**
 *
 *  \class dia_IWifiSetupsListener
 *
 */

class dia_IWifiSetupsListener :
   public virtual dia_Listener
{
public:
   static dia::IID getUID (void ) { return (dia::IID)IID_WIFI_SETUPS_LISTENER; }
public:
   //! List of currently active wifi setups (wlan devices).
   virtual void OnActiveSetups (const std::vector<dia_stWifiSetup>& setupList ) = 0;
   //! Response for request 'prepare Setup'
   virtual void onPrepareSetup (tDiaResult response ) = 0;
   //! Response for request 'DeActivate Setup'
   virtual void onDeActivateSetup (tDiaResult response ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_IWifiSetupsListener( void ) {}
};
/**
 *
 *  \class dia_IWifiSetupsListenerImpl
 *
 */

class dia_IWifiSetupsListenerImpl
   : public dia_IWifiSetupsListener
{
public:
   //! List of currently active wifi setups (wlan devices).
   virtual void OnActiveSetups (const std::vector<dia_stWifiSetup>& /*setupList*/ ) {}
   //! Response for request 'prepare Setup'
   virtual void onPrepareSetup (tDiaResult /*response*/ ) {}
   //! Response for request 'DeActivate Setup'
   virtual void onDeActivateSetup (tDiaResult /*response*/ ) {}

protected:
   //! virtual base class destructor
   virtual ~dia_IWifiSetupsListenerImpl( void ) {}
};
/**
 *
 *  \class dia_IWifiSetupsNotifier
 *
 */

//lint -e665 review result: lint does not handle the macro properly 665:

class dia_IWifiSetupsNotifier
   : public dia_IWifiSetupsListener,
     public dia_Notifier<dia_IWifiSetupsListener>
{
public:
   //! List of currently active wifi setups (wlan devices).
   virtual void OnActiveSetups (const std::vector<dia_stWifiSetup>& setupList)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->OnActiveSetups(setupList);
      }
   }
   //! Response for request 'prepare Setup'
   virtual void onPrepareSetup (tDiaResult response)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->onPrepareSetup(response);
      }
   }
   //! Response for request 'DeActivate Setup'
   virtual void onDeActivateSetup (tDiaResult response)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->onDeActivateSetup(response);
      }
   }
};

//lint +e665

#endif /* __INCLUDED_DIA_INTERFACE_WIFI_SETUPS_LISTENER__ */
