/*****************************************************************************************
*
* \file    dia_IWifiConnman.h
*
* \brief   interface of dia_IWifiConnman
*
* The interface-class covers methods for sending requests and data to SAFeature.
* The reception and processing is replied with a tDiaResult value.
* For details about the available methods see the list below.
*
* \author kaa1hi (generated with ifGen.py tool)
*
*     !!!  THIS FILE IS GENERATED - DO NOT EDIT
*     !!!  MANUAL CHANGES WILL BE OVERWRITTEN BY BUILD-PROCESS
*     !!!  TO UPDATE THIS FILE EDIT dia_IWifiConnman.xml
*
* (c) 2019 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_WIFI_CONNMAN__
#define __INCLUDED_DIA_INTERFACE_WIFI_CONNMAN__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif
#ifndef __INCLUDED_DIA_INTERFACES__
#include "common/interfaces/dia_interfaces.h"
#endif
#include "common/framework/errmgmt/dia_ErrorInfoInterface.h"
#define IID_WIFI_CONNMAN ((dia::IID) 0xd3b5fcf4)
//------------------------------------------------------------------------------
enum dia_enWifiState
{
   DIA_ENUM_WIFI_STATE_UNKNOWN = 0,
   DIA_ENUM_WIFI_STATE_IDLE/*  */,
   DIA_ENUM_WIFI_STATE_READY/*  */,
   DIA_ENUM_WIFI_STATE_ONLINE/*  */,
   DIA_ENUM_WIFI_STATE_COUNT = 4
};
struct dia_stWifiStation
{
public:
   //! default constructor
   dia_stWifiStation() :
      mState(DIA_ENUM_WIFI_STATE_UNKNOWN),
      mName(),
      mAddress(),
      mStrength(0)
   {}

   //! class constructor
   dia_stWifiStation(
      dia_enWifiState mState_,
      std::string mName_,
      std::string mAddress_,
      tU8 mStrength_
   ) :
      mState(mState_),
      mName(mName_),
      mAddress(mAddress_),
      mStrength(mStrength_)
   {}
   void reset ( void )
   {
      mState = DIA_ENUM_WIFI_STATE_UNKNOWN;
      mName.clear();
      mAddress.clear();
      mStrength = 0;
   }

   dia_enWifiState mState;
   std::string mName;
   std::string mAddress;
   tU8 mStrength;
};
class dia_IWifiConnman
{
public:
   static dia::IID getUID (void ) { return (dia::IID)IID_WIFI_CONNMAN; }
public:
   //! Request currently active wifi network connections.
   virtual tDiaResult GetWifiStations ( ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_IWifiConnman( void ) {}
};

#endif /* __INCLUDED_DIA_INTERFACE_WIFI_CONNMAN__ */
