/*****************************************************************************************
*
* \file    dia_IVideoSourceControlListener.h
*
* \brief   listener of dia_IVideoSourceControlListener
*
* The interface-class covers methods for sending requests and data to SAFeature.
* The reception and processing is replied with a tDiaResult value.
* For details about the available methods see the list below.
*
* \author shw2abt (generated with ifGen.py tool)
*
*     !!!  THIS FILE IS GENERATED - DO NOT EDIT
*     !!!  MANUAL CHANGES WILL BE OVERWRITTEN BY BUILD-PROCESS
*     !!!  TO UPDATE THIS FILE EDIT dia_IVideoSourceControl.xml
*
* (c) 2019 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_VIDEO_SOURCE_CONTROL_LISTENER__
#define __INCLUDED_DIA_INTERFACE_VIDEO_SOURCE_CONTROL_LISTENER__

#ifndef __INCLUDED_DIA_INTERFACE_VIDEO_SOURCE_CONTROL__
#include "dia_IVideoSourceControl.h"
#endif

#define IID_VIDEO_SOURCE_CONTROL_LISTENER ((dia::IID) 0xe2b024ca)
/**
 *
 *  \class dia_IVideoSourceControlListener
 *
 */

class dia_IVideoSourceControlListener :
   public virtual dia_Listener
{
public:
   static dia::IID getUID (void ) { return (dia::IID)IID_VIDEO_SOURCE_CONTROL_LISTENER; }
public:
   //! remote control mode has been changed to the given mode
   virtual void vOnVideoSourceUpdate (dia_eVideoSourceID newSrcID, dia_eVideoSourceID prevSrcID ) = 0;
   //! remote control mode has been changed to the given mode
   virtual void vOnVideoSourceError (tDiaResult errCode ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_IVideoSourceControlListener( void ) {}
};
/**
 *
 *  \class dia_IVideoSourceControlListenerImpl
 *
 */

class dia_IVideoSourceControlListenerImpl
   : public dia_IVideoSourceControlListener
{
public:
   //! remote control mode has been changed to the given mode
   virtual void vOnVideoSourceUpdate (dia_eVideoSourceID /*newSrcID*/, dia_eVideoSourceID /*prevSrcID*/ ) {}
   //! remote control mode has been changed to the given mode
   virtual void vOnVideoSourceError (tDiaResult /*errCode*/ ) {}

protected:
   //! virtual base class destructor
   virtual ~dia_IVideoSourceControlListenerImpl( void ) {}
};
/**
 *
 *  \class dia_IVideoSourceControlNotifier
 *
 */

//lint -e665 review result: lint does not handle the macro properly 665:

class dia_IVideoSourceControlNotifier
   : public dia_IVideoSourceControlListener,
     public dia_Notifier<dia_IVideoSourceControlListener>
{
public:
   //! remote control mode has been changed to the given mode
   virtual void vOnVideoSourceUpdate (dia_eVideoSourceID newSrcID, dia_eVideoSourceID prevSrcID)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnVideoSourceUpdate(newSrcID, prevSrcID);
      }
   }
   //! remote control mode has been changed to the given mode
   virtual void vOnVideoSourceError (tDiaResult errCode)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnVideoSourceError(errCode);
      }
   }
};

//lint +e665

#endif /* __INCLUDED_DIA_INTERFACE_VIDEO_SOURCE_CONTROL_LISTENER__ */
