/*****************************************************************************************
*
* \file    dia_IVDMMGRListener.h
*
* \brief   listener of dia_IVDMMGRListener
*
* The interface-class covers methods for sending requests and data to SAFeature.
* The reception and processing is replied with a tDiaResult value.
* For details about the available methods see the list below.
*
* \author shw2abt, fgl2hi (generated with ifGen.py tool)
*
*     !!!  THIS FILE IS GENERATED - DO NOT EDIT
*     !!!  MANUAL CHANGES WILL BE OVERWRITTEN BY BUILD-PROCESS
*     !!!  TO UPDATE THIS FILE EDIT dia_IVDMMGR.xml
*
* (c) 2019 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_VDMMGR_LISTENER__
#define __INCLUDED_DIA_INTERFACE_VDMMGR_LISTENER__

#ifndef __INCLUDED_DIA_INTERFACE_VDMMGR__
#include "dia_IVDMMGR.h"
#endif

#define IID_VDMMGR_LISTENER ((dia::IID) 0xb82976ae)
/**
 *
 *  \class dia_IVDMMGRListener
 *
 */

class dia_IVDMMGRListener :
   public virtual dia_Listener
{
public:
   static dia::IID getUID (void ) { return (dia::IID)IID_VDMMGR_LISTENER; }
public:
   //! result of the cd drive selftest start-operation
   virtual void vOnCDDriveSelftestStarted (tDiaResult result ) = 0;
   //! result of the cd drive selftest
   virtual void vOnCDDriveSelftest (tU8 duration, dia_tDriveTestResult& testResult ) = 0;
   //! information about the optical drive media type
   virtual void vOnOpticalDriveMediaType (dia_eOpticalDriveMediaType MediaType ) = 0;
   //! information about the optical drive loader status
   virtual void vOnOpticalDriveLoaderStatus (dia_eOpticalDriveLoaderStatus LoaderStatus ) = 0;
   //! information about the eject result
   virtual void vOnControlEject (tDiaResult eDiaResult ) = 0;
   //! information about the CD mode change result
   virtual void vOnCDModeChangeResultMMgr (tDiaResult eDiaResult ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_IVDMMGRListener( void ) {}
};
/**
 *
 *  \class dia_IVDMMGRListenerImpl
 *
 */

class dia_IVDMMGRListenerImpl
   : public dia_IVDMMGRListener
{
public:
   //! result of the cd drive selftest start-operation
   virtual void vOnCDDriveSelftestStarted (tDiaResult /*result*/ ) {}
   //! result of the cd drive selftest
   virtual void vOnCDDriveSelftest (tU8 /*duration*/, dia_tDriveTestResult& /*testResult*/ ) {}
   //! information about the optical drive media type
   virtual void vOnOpticalDriveMediaType (dia_eOpticalDriveMediaType /*MediaType*/ ) {}
   //! information about the optical drive loader status
   virtual void vOnOpticalDriveLoaderStatus (dia_eOpticalDriveLoaderStatus /*LoaderStatus*/ ) {}
   //! information about the eject result
   virtual void vOnControlEject (tDiaResult /*eDiaResult*/ ) {}
   //! information about the CD mode change result
   virtual void vOnCDModeChangeResultMMgr (tDiaResult /*eDiaResult*/ ) {}

protected:
   //! virtual base class destructor
   virtual ~dia_IVDMMGRListenerImpl( void ) {}
};
/**
 *
 *  \class dia_IVDMMGRNotifier
 *
 */

//lint -e665 review result: lint does not handle the macro properly 665:

class dia_IVDMMGRNotifier
   : public dia_IVDMMGRListener,
     public dia_Notifier<dia_IVDMMGRListener>
{
public:
   //! result of the cd drive selftest start-operation
   virtual void vOnCDDriveSelftestStarted (tDiaResult result)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnCDDriveSelftestStarted(result);
      }
   }
   //! result of the cd drive selftest
   virtual void vOnCDDriveSelftest (tU8 duration, dia_tDriveTestResult& testResult)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnCDDriveSelftest(duration, testResult);
      }
   }
   //! information about the optical drive media type
   virtual void vOnOpticalDriveMediaType (dia_eOpticalDriveMediaType MediaType)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnOpticalDriveMediaType(MediaType);
      }
   }
   //! information about the optical drive loader status
   virtual void vOnOpticalDriveLoaderStatus (dia_eOpticalDriveLoaderStatus LoaderStatus)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnOpticalDriveLoaderStatus(LoaderStatus);
      }
   }
   //! information about the eject result
   virtual void vOnControlEject (tDiaResult eDiaResult)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnControlEject(eDiaResult);
      }
   }
   //! information about the CD mode change result
   virtual void vOnCDModeChangeResultMMgr (tDiaResult eDiaResult)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnCDModeChangeResultMMgr(eDiaResult);
      }
   }
};

//lint +e665

#endif /* __INCLUDED_DIA_INTERFACE_VDMMGR_LISTENER__ */
