/*****************************************************************************************
*
* \file    dia_IVDMMGR.h
*
* \brief   interface of dia_IVDMMGR
*
* The interface-class covers methods for sending requests and data to SAFeature.
* The reception and processing is replied with a tDiaResult value.
* For details about the available methods see the list below.
*
* \author shw2abt, fgl2hi (generated with ifGen.py tool)
*
*     !!!  THIS FILE IS GENERATED - DO NOT EDIT
*     !!!  MANUAL CHANGES WILL BE OVERWRITTEN BY BUILD-PROCESS
*     !!!  TO UPDATE THIS FILE EDIT dia_IVDMMGR.xml
*
* (c) 2019 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_VDMMGR__
#define __INCLUDED_DIA_INTERFACE_VDMMGR__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif
#ifndef __INCLUDED_DIA_INTERFACES__
#include "common/interfaces/dia_interfaces.h"
#endif
#define IID_VDMMGR ((dia::IID) 0x3c7bf248)
//------------------------------------------------------------------------------
enum dia_eOpticalDriveMediaType
{
   DIA_EN_MMGR_CD_MEDIA_TYPE_UNKNOWN = 0,
   DIA_EN_MMGR_CD_MEDIA_TYPE_NO_MEDIA,
   DIA_EN_MMGR_CD_MEDIA_TYPE_AUDIO,
   DIA_EN_MMGR_CD_MEDIA_TYPE_DATA,
   DIA_EN_MMGR_CD_MEDIA_TYPE_INCORRECT,
   DIA_EN_MMGR_CD_MEDIA_TYPE_INSERTION,
   DIA_EN_MMGR_CD_MEDIA_TYPE_EJECTING,
   DIA_EN_MMGR_CD_MEDIA_TYPE_MEDIA_IN_SLOT,
   DIA_EN_MMGR_CD_MEDIA_TYPE_COUNT = 8
};
//------------------------------------------------------------------------------
enum dia_eOpticalDriveLoaderStatus
{
   DIA_EN_MMGR_CD_LOADER_STATUS_UNKNOWN = 0,
   DIA_EN_MMGR_CD_LOADER_STATUS_MEDIA_IN_SLOT,
   DIA_EN_MMGR_CD_LOADER_STATUS_NO_MEDIA_IN_DRIVE,
   DIA_EN_MMGR_CD_LOADER_STATUS_MEDIA_INSIDE,
   DIA_EN_MMGR_CD_LOADER_STATUS_EJECT_IN_PROGRESS,
   DIA_EN_MMGR_CD_LOADER_STATUS_COUNT = 5
};
//------------------------------------------------------------------------------
enum dia_eControlEjectResult
{
   DIA_EN_MMGR_CONTROL_EJECT_RESULT_UNKNOWN = 0,
   DIA_EN_MMGR_CONTROL_EJECT_RESULT_OK,
   DIA_EN_MMGR_CONTROL_EJECT_RESULT_FAILED,
   DIA_EN_MMGR_CONTROL_EJECT_RESULT_COUNT = 3
};
//------------------------------------------------------------------------------
enum dia_eMMgr_CDModeSwitch2
{
   DIA_EN_MMGR_CD_MODE_SWITCH_TO_UNKNOWN = 0,
   DIA_EN_MMGR_CD_MODE_SWITCH_TO_CDDA,
   DIA_EN_MMGR_CD_MODE_SWITCH_TO_CDROM,
   DIA_EN_MMGR_CD_MODE_SWITCH_TO_COUNT = 3
};
//------------------------------------------------------------------------------
enum dia_eDriveType
{
   DIA_EN_MMGR_DRIVE_TYPE_UNKNOWN = 0,
   DIA_EN_MMGR_DRIVE_TYPE_CD,
   DIA_EN_MMGR_DRIVE_TYPE_COUNT = 2
};
//------------------------------------------------------------------------------
enum dia_eDriveTestType
{
   DIA_EN_MMGR_DRIVE_TEST_TYPE_UNKNOWN = 0,
   DIA_EN_MMGR_DRIVE_TEST_TYPE_SHORT,
   DIA_EN_MMGR_DRIVE_TEST_TYPE_SHORT_TEF,
   DIA_EN_MMGR_DRIVE_TEST_TYPE_INTENSIVE,
   DIA_EN_MMGR_DRIVE_TEST_TYPE_COUNT = 4
};
struct dia_tDriveTestResult
{
public:
   //! default constructor
   dia_tDriveTestResult() :
      mType(DIA_EN_MMGR_DRIVE_TYPE_UNKNOWN),
      mTestType(DIA_EN_MMGR_DRIVE_TEST_TYPE_UNKNOWN),
      mReturnValue(DIA_FAILED),
      mSectorsRead(0),
      mReadAttemps(0),
      mErrorCount(0),
      mAverageReadTimePerSector(0),
      mTotalReadTime(0),
      mMaxReadTimePerSector(0),
      mMaxLBA(0),
      mCntDVDLayer(0)
   {}

   //! class constructor
   dia_tDriveTestResult(
      dia_eDriveType mType_,
      dia_eDriveTestType mTestType_,
      tDiaResult mReturnValue_,
      tU32 mSectorsRead_,
      tU16 mReadAttemps_,
      tU16 mErrorCount_,
      tU16 mAverageReadTimePerSector_,
      tU32 mTotalReadTime_,
      tU16 mMaxReadTimePerSector_,
      tU32 mMaxLBA_,
      tU8 mCntDVDLayer_
   ) :
      mType(mType_),
      mTestType(mTestType_),
      mReturnValue(mReturnValue_),
      mSectorsRead(mSectorsRead_),
      mReadAttemps(mReadAttemps_),
      mErrorCount(mErrorCount_),
      mAverageReadTimePerSector(mAverageReadTimePerSector_),
      mTotalReadTime(mTotalReadTime_),
      mMaxReadTimePerSector(mMaxReadTimePerSector_),
      mMaxLBA(mMaxLBA_),
      mCntDVDLayer(mCntDVDLayer_)
   {}
   dia_eDriveType mType; // type of drive media
   dia_eDriveTestType mTestType; // type of drive test
   tDiaResult mReturnValue; // drive test return code
   tU32 mSectorsRead; // number of sectors read
   tU16 mReadAttemps; // number of read attempts
   tU16 mErrorCount; // number of errors detected
   tU16 mAverageReadTimePerSector; // average read time per sector
   tU32 mTotalReadTime; // total read time
   tU16 mMaxReadTimePerSector; // maximum read time per sector
   tU32 mMaxLBA; // max LBA
   tU8 mCntDVDLayer; // count dvd layer
};
class dia_IVDMMGR
{
public:
   static dia::IID getUID (void ) { return (dia::IID)IID_VDMMGR; }
public:
   //! starts the CD drive selftest - full parameter
   virtual tDiaResult startCDDriveTest (const tU8 duration, const tU16 drive, const tU16 driveTestCmd, dia_eDriveTestType driveTestParam ) = 0;
   //! starts the CD drive selftest
   virtual tDiaResult startCDDriveTest (dia_eDriveTestType selftestType ) = 0;
   //! request the actual media type of the optical drive
   virtual tDiaResult getOpticalDriveMediaType ( ) = 0;
   //! request the actual drive loader status
   virtual tDiaResult getOpticalDriveLoaderStatus ( ) = 0;
   //! eject CD/DVD
   virtual tDiaResult ejectCD ( ) = 0;
   //! Switch between CD modes (CDDA / CDROM)
   virtual tDiaResult selectCDMode (dia_eMMgr_CDModeSwitch2 switch2CDMode ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_IVDMMGR( void ) {}
};

#endif /* __INCLUDED_DIA_INTERFACE_VDMMGR__ */
