/*****************************************************************************************
*
* \file    dia_ITunerMasterListener.h
*
* \brief   listener of dia_ITunerMasterListener
*
* The interface-class covers methods for sending requests and data to SAFeature.
* The reception and processing is replied with a tDiaResult value.
* For details about the available methods see the list below.
*
* \author shw2abt (generated with ifGen.py tool)
*
*     !!!  THIS FILE IS GENERATED - DO NOT EDIT
*     !!!  MANUAL CHANGES WILL BE OVERWRITTEN BY BUILD-PROCESS
*     !!!  TO UPDATE THIS FILE EDIT dia_ITunerMaster.xml
*
* (c) 2019 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_TUNER_MASTER_LISTENER__
#define __INCLUDED_DIA_INTERFACE_TUNER_MASTER_LISTENER__

#ifndef __INCLUDED_DIA_INTERFACE_TUNER_MASTER__
#include "dia_ITunerMaster.h"
#endif

#define IID_TUNER_MASTER_LISTENER ((dia::IID) 0x1606205b)
/**
 *
 *  \class dia_ITunerMasterListener
 *
 */

class dia_ITunerMasterListener :
   public virtual dia_Listener
{
public:
   static dia::IID getUID (void ) { return (dia::IID)IID_TUNER_MASTER_LISTENER; }
public:
   //! result on the selectActiveTuner_Get call
   virtual void vOnTunerAMFMActiveTuner_Get (dia_eTuner activeTuner ) = 0;
   //! result on the selectActiveTuner_Set call
   virtual void vOnTunerAMFMActiveTuner_Set (tDiaResult activateTuner ) = 0;
   //! result on the TunerBand_Set call
   virtual void vOnTunerAMFMTunerBand_Set (tDiaResult bandSetSuccessful ) = 0;
   //! result on the AMFM AntennaStatus_Get call
   virtual void vOnTunerAMFMAntennaStatus_Get (dia_eAntennaStatus antennaStatus ) = 0;
   //! result on the AMFM Antenna2Status call
   virtual void vOnTunerAMFMAntenna2Status_Get (dia_eAntennaStatus antennaStatus ) = 0;
   //! result on the AMFM Antenna1Current_Get call
   virtual void vOnTunerAMFMAntenna1Current_Get (tU16 antennaCurrent ) = 0;
   //! result on the AMFM Antenna2Current call
   virtual void vOnTunerAMFMAntenna2Current_Get (tU16 antennaCurrent ) = 0;
   //! result on the DAB AntennaStatus_Get call
   virtual void vOnTunerDABAntennaStatus_Get (dia_eAntennaStatus antennaStatus ) = 0;
   //! result on the Antenna1Current_Get call
   virtual void vOnTunerDABAntenna1Current_Get (tU16 antennaCurrent ) = 0;
   //! result on the tunerDAB_AntennaStatus_Get call
   virtual void vOnGetTunMstrRFAntennaTestInfo (dia_eAntennaStatus antennaStatus, tU8 connectionCurrent ) = 0;
   //! result on the tunerAMFM_AntennaStatus_Get call
   virtual void vOnGetTunerAerialRadio1Status (dia_eAntennaStatus antennaStatus, tU8 connectionCurrent ) = 0;
   //! result on the tunerAMFM_Antenna2Status call
   virtual void vOnGetTunerAerialRadio2Status (dia_eAntennaStatus antennaStatus, tU8 connectionCurrent ) = 0;
   //! result on the tuner_TrafficProgramStatus_Get call
   virtual void vOnGetTrafficprogramStatus (tBool tpState, dia_eTunerMasterSource tunMasterSource ) = 0;
   //! current gnss antenna current
   virtual void vOnGNSSAntennaCurrent (tU16 antennaCurrent ) = 0;
   //! current gnss antenna status
   virtual void vOnGNSSAntennaStatus (tU8 antennaStatus ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_ITunerMasterListener( void ) {}
};
/**
 *
 *  \class dia_ITunerMasterListenerImpl
 *
 */

class dia_ITunerMasterListenerImpl
   : public dia_ITunerMasterListener
{
public:
   //! result on the selectActiveTuner_Get call
   virtual void vOnTunerAMFMActiveTuner_Get (dia_eTuner /*activeTuner*/ ) {}
   //! result on the selectActiveTuner_Set call
   virtual void vOnTunerAMFMActiveTuner_Set (tDiaResult /*activateTuner*/ ) {}
   //! result on the TunerBand_Set call
   virtual void vOnTunerAMFMTunerBand_Set (tDiaResult /*bandSetSuccessful*/ ) {}
   //! result on the AMFM AntennaStatus_Get call
   virtual void vOnTunerAMFMAntennaStatus_Get (dia_eAntennaStatus /*antennaStatus*/ ) {}
   //! result on the AMFM Antenna2Status call
   virtual void vOnTunerAMFMAntenna2Status_Get (dia_eAntennaStatus /*antennaStatus*/ ) {}
   //! result on the AMFM Antenna1Current_Get call
   virtual void vOnTunerAMFMAntenna1Current_Get (tU16 /*antennaCurrent*/ ) {}
   //! result on the AMFM Antenna2Current call
   virtual void vOnTunerAMFMAntenna2Current_Get (tU16 /*antennaCurrent*/ ) {}
   //! result on the DAB AntennaStatus_Get call
   virtual void vOnTunerDABAntennaStatus_Get (dia_eAntennaStatus /*antennaStatus*/ ) {}
   //! result on the Antenna1Current_Get call
   virtual void vOnTunerDABAntenna1Current_Get (tU16 /*antennaCurrent*/ ) {}
   //! result on the tunerDAB_AntennaStatus_Get call
   virtual void vOnGetTunMstrRFAntennaTestInfo (dia_eAntennaStatus /*antennaStatus*/, tU8 /*connectionCurrent*/ ) {}
   //! result on the tunerAMFM_AntennaStatus_Get call
   virtual void vOnGetTunerAerialRadio1Status (dia_eAntennaStatus /*antennaStatus*/, tU8 /*connectionCurrent*/ ) {}
   //! result on the tunerAMFM_Antenna2Status call
   virtual void vOnGetTunerAerialRadio2Status (dia_eAntennaStatus /*antennaStatus*/, tU8 /*connectionCurrent*/ ) {}
   //! result on the tuner_TrafficProgramStatus_Get call
   virtual void vOnGetTrafficprogramStatus (tBool /*tpState*/, dia_eTunerMasterSource /*tunMasterSource*/ ) {}
   //! current gnss antenna current
   virtual void vOnGNSSAntennaCurrent (tU16 /*antennaCurrent*/ ) {}
   //! current gnss antenna status
   virtual void vOnGNSSAntennaStatus (tU8 /*antennaStatus*/ ) {}

protected:
   //! virtual base class destructor
   virtual ~dia_ITunerMasterListenerImpl( void ) {}
};
/**
 *
 *  \class dia_ITunerMasterNotifier
 *
 */

//lint -e665 review result: lint does not handle the macro properly 665:

class dia_ITunerMasterNotifier
   : public dia_ITunerMasterListener,
     public dia_Notifier<dia_ITunerMasterListener>
{
public:
   //! result on the selectActiveTuner_Get call
   virtual void vOnTunerAMFMActiveTuner_Get (dia_eTuner activeTuner)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnTunerAMFMActiveTuner_Get(activeTuner);
      }
   }
   //! result on the selectActiveTuner_Set call
   virtual void vOnTunerAMFMActiveTuner_Set (tDiaResult activateTuner)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnTunerAMFMActiveTuner_Set(activateTuner);
      }
   }
   //! result on the TunerBand_Set call
   virtual void vOnTunerAMFMTunerBand_Set (tDiaResult bandSetSuccessful)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnTunerAMFMTunerBand_Set(bandSetSuccessful);
      }
   }
   //! result on the AMFM AntennaStatus_Get call
   virtual void vOnTunerAMFMAntennaStatus_Get (dia_eAntennaStatus antennaStatus)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnTunerAMFMAntennaStatus_Get(antennaStatus);
      }
   }
   //! result on the AMFM Antenna2Status call
   virtual void vOnTunerAMFMAntenna2Status_Get (dia_eAntennaStatus antennaStatus)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnTunerAMFMAntenna2Status_Get(antennaStatus);
      }
   }
   //! result on the AMFM Antenna1Current_Get call
   virtual void vOnTunerAMFMAntenna1Current_Get (tU16 antennaCurrent)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnTunerAMFMAntenna1Current_Get(antennaCurrent);
      }
   }
   //! result on the AMFM Antenna2Current call
   virtual void vOnTunerAMFMAntenna2Current_Get (tU16 antennaCurrent)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnTunerAMFMAntenna2Current_Get(antennaCurrent);
      }
   }
   //! result on the DAB AntennaStatus_Get call
   virtual void vOnTunerDABAntennaStatus_Get (dia_eAntennaStatus antennaStatus)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnTunerDABAntennaStatus_Get(antennaStatus);
      }
   }
   //! result on the Antenna1Current_Get call
   virtual void vOnTunerDABAntenna1Current_Get (tU16 antennaCurrent)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnTunerDABAntenna1Current_Get(antennaCurrent);
      }
   }
   //! result on the tunerDAB_AntennaStatus_Get call
   virtual void vOnGetTunMstrRFAntennaTestInfo (dia_eAntennaStatus antennaStatus, tU8 connectionCurrent)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnGetTunMstrRFAntennaTestInfo(antennaStatus, connectionCurrent);
      }
   }
   //! result on the tunerAMFM_AntennaStatus_Get call
   virtual void vOnGetTunerAerialRadio1Status (dia_eAntennaStatus antennaStatus, tU8 connectionCurrent)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnGetTunerAerialRadio1Status(antennaStatus, connectionCurrent);
      }
   }
   //! result on the tunerAMFM_Antenna2Status call
   virtual void vOnGetTunerAerialRadio2Status (dia_eAntennaStatus antennaStatus, tU8 connectionCurrent)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnGetTunerAerialRadio2Status(antennaStatus, connectionCurrent);
      }
   }
   //! result on the tuner_TrafficProgramStatus_Get call
   virtual void vOnGetTrafficprogramStatus (tBool tpState, dia_eTunerMasterSource tunMasterSource)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnGetTrafficprogramStatus(tpState, tunMasterSource);
      }
   }
   //! current gnss antenna current
   virtual void vOnGNSSAntennaCurrent (tU16 antennaCurrent)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnGNSSAntennaCurrent(antennaCurrent);
      }
   }
   //! current gnss antenna status
   virtual void vOnGNSSAntennaStatus (tU8 antennaStatus)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnGNSSAntennaStatus(antennaStatus);
      }
   }
};

//lint +e665

#endif /* __INCLUDED_DIA_INTERFACE_TUNER_MASTER_LISTENER__ */
