/*****************************************************************************************
*
* \file    dia_ITunerAMFMListener.h
*
* \brief   listener of dia_ITunerAMFMListener
*
* The interface-class covers methods for sending requests and data to SAFeature.
* The reception and processing is replied with a tDiaResult value.
* For details about the available methods see the list below.
*
* \author shw2abt (generated with ifGen.py tool)
*
*     !!!  THIS FILE IS GENERATED - DO NOT EDIT
*     !!!  MANUAL CHANGES WILL BE OVERWRITTEN BY BUILD-PROCESS
*     !!!  TO UPDATE THIS FILE EDIT dia_ITunerAMFM.xml
*
* (c) 2019 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_TUNERAMFM_LISTENER__
#define __INCLUDED_DIA_INTERFACE_TUNERAMFM_LISTENER__

#ifndef __INCLUDED_DIA_INTERFACE_TUNERAMFM__
#include "dia_ITunerAMFM.h"
#endif

#define IID_TUNER_AMFM_LISTENER ((dia::IID) 0x57e350d0)
/**
 *
 *  \class dia_ITunerAMFMListener
 *
 */

class dia_ITunerAMFMListener :
   public virtual dia_Listener
{
public:
   static dia::IID getUID (void ) { return (dia::IID)IID_TUNER_AMFM_LISTENER; }
public:
   //! result on the selectActiveTuner_Get call
   virtual void vOnTunerAMFMFrequency_Get (tU32 frequency ) = 0;
   //! result on the selectActiveTuner_Set call
   virtual void vOnTunerAMFMFrequency_Set (tDiaResult setFrequency ) = 0;
   //! result on the TunerBand_Get call
   virtual void vOnTunerAMFMBand_Get (dia_eBandAMFM activeBand ) = 0;
   //! result on the TunerFMRDSProgramInformation_Get call
   virtual void vOnTunerFMRDSProgramInformation_Get (tU16 PICode ) = 0;
   //! result on the tunerAMFM_TunerFieldStrength_Get call
   virtual void vOnTunerAMFMFieldStrength_Get (tU8 strength ) = 0;
   //! result on the tunerAMFM_TunerFieldStrength_Get call
   virtual void vOnGetTunerAerialRadio2FieldStrength (tU8 receptionLevel ) = 0;
   //! result on the tunerAMFM_TunerFieldStrength_Get call
   virtual void vOnGetTunerAerialRadio1FieldStrength (tU8 receptionLevel ) = 0;
   //! result on the radioTuner1Status_Get call
   virtual void vOnGetRadioTuner1Status (dia_eBandAMFM e8Band, tU32 u32Frequency, tU8 fieldStrength ) = 0;
   //! notification that seek has been started
   virtual void vOnTunerAMFMFrequencySeekStarted (tDiaResult result ) = 0;
   //! notification that seek has been stopped
   virtual void vOnTunerAMFMFrequencySeekStopped (tDiaResult result ) = 0;
   //! notification that seek has been ended (with success or fail)
   virtual void vOnTunerAMFMFrequencySeekResult (tDiaResult result ) = 0;
   //! result on the tuner DRM freq get call
   virtual void vOnTunerDRMGetFrequency (tU32 frequency ) = 0;
   //! result on the tuner DRM service Id get call
   virtual void vOnTunerDRMGetServiceID (tU32 serviceID ) = 0;
   //! result on the tunerDRM_EnsembleFrequency_Set call.
   virtual void vOnTunerDRMEnsembleFrequency_Set (tDiaResult success ) = 0;
   //! result on the tunerDRM_ServiceID_Set call.
   virtual void vOnTunerDRMServiceID_Set (tDiaResult success ) = 0;
   //! result on the TunerSetTestmodeFeature call.
   virtual void vOnTunerSetTestmodeFeature (tDiaResult success ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_ITunerAMFMListener( void ) {}
};
/**
 *
 *  \class dia_ITunerAMFMListenerImpl
 *
 */

class dia_ITunerAMFMListenerImpl
   : public dia_ITunerAMFMListener
{
public:
   //! result on the selectActiveTuner_Get call
   virtual void vOnTunerAMFMFrequency_Get (tU32 /*frequency*/ ) {}
   //! result on the selectActiveTuner_Set call
   virtual void vOnTunerAMFMFrequency_Set (tDiaResult /*setFrequency*/ ) {}
   //! result on the TunerBand_Get call
   virtual void vOnTunerAMFMBand_Get (dia_eBandAMFM /*activeBand*/ ) {}
   //! result on the TunerFMRDSProgramInformation_Get call
   virtual void vOnTunerFMRDSProgramInformation_Get (tU16 /*PICode*/ ) {}
   //! result on the tunerAMFM_TunerFieldStrength_Get call
   virtual void vOnTunerAMFMFieldStrength_Get (tU8 /*strength*/ ) {}
   //! result on the tunerAMFM_TunerFieldStrength_Get call
   virtual void vOnGetTunerAerialRadio2FieldStrength (tU8 /*receptionLevel*/ ) {}
   //! result on the tunerAMFM_TunerFieldStrength_Get call
   virtual void vOnGetTunerAerialRadio1FieldStrength (tU8 /*receptionLevel*/ ) {}
   //! result on the radioTuner1Status_Get call
   virtual void vOnGetRadioTuner1Status (dia_eBandAMFM /*e8Band*/, tU32 /*u32Frequency*/, tU8 /*fieldStrength*/ ) {}
   //! notification that seek has been started
   virtual void vOnTunerAMFMFrequencySeekStarted (tDiaResult /*result*/ ) {}
   //! notification that seek has been stopped
   virtual void vOnTunerAMFMFrequencySeekStopped (tDiaResult /*result*/ ) {}
   //! notification that seek has been ended (with success or fail)
   virtual void vOnTunerAMFMFrequencySeekResult (tDiaResult /*result*/ ) {}
   //! result on the tuner DRM freq get call
   virtual void vOnTunerDRMGetFrequency (tU32 /*frequency*/ ) {}
   //! result on the tuner DRM service Id get call
   virtual void vOnTunerDRMGetServiceID (tU32 /*serviceID*/ ) {}
   //! result on the tunerDRM_EnsembleFrequency_Set call.
   virtual void vOnTunerDRMEnsembleFrequency_Set (tDiaResult /*success*/ ) {}
   //! result on the tunerDRM_ServiceID_Set call.
   virtual void vOnTunerDRMServiceID_Set (tDiaResult /*success*/ ) {}
   //! result on the TunerSetTestmodeFeature call.
   virtual void vOnTunerSetTestmodeFeature (tDiaResult /*success*/ ) {}

protected:
   //! virtual base class destructor
   virtual ~dia_ITunerAMFMListenerImpl( void ) {}
};
/**
 *
 *  \class dia_ITunerAMFMNotifier
 *
 */

//lint -e665 review result: lint does not handle the macro properly 665:

class dia_ITunerAMFMNotifier
   : public dia_ITunerAMFMListener,
     public dia_Notifier<dia_ITunerAMFMListener>
{
public:
   //! result on the selectActiveTuner_Get call
   virtual void vOnTunerAMFMFrequency_Get (tU32 frequency)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnTunerAMFMFrequency_Get(frequency);
      }
   }
   //! result on the selectActiveTuner_Set call
   virtual void vOnTunerAMFMFrequency_Set (tDiaResult setFrequency)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnTunerAMFMFrequency_Set(setFrequency);
      }
   }
   //! result on the TunerBand_Get call
   virtual void vOnTunerAMFMBand_Get (dia_eBandAMFM activeBand)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnTunerAMFMBand_Get(activeBand);
      }
   }
   //! result on the TunerFMRDSProgramInformation_Get call
   virtual void vOnTunerFMRDSProgramInformation_Get (tU16 PICode)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnTunerFMRDSProgramInformation_Get(PICode);
      }
   }
   //! result on the tunerAMFM_TunerFieldStrength_Get call
   virtual void vOnTunerAMFMFieldStrength_Get (tU8 strength)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnTunerAMFMFieldStrength_Get(strength);
      }
   }
   //! result on the tunerAMFM_TunerFieldStrength_Get call
   virtual void vOnGetTunerAerialRadio2FieldStrength (tU8 receptionLevel)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnGetTunerAerialRadio2FieldStrength(receptionLevel);
      }
   }
   //! result on the tunerAMFM_TunerFieldStrength_Get call
   virtual void vOnGetTunerAerialRadio1FieldStrength (tU8 receptionLevel)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnGetTunerAerialRadio1FieldStrength(receptionLevel);
      }
   }
   //! result on the radioTuner1Status_Get call
   virtual void vOnGetRadioTuner1Status (dia_eBandAMFM e8Band, tU32 u32Frequency, tU8 fieldStrength)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnGetRadioTuner1Status(e8Band, u32Frequency, fieldStrength);
      }
   }
   //! notification that seek has been started
   virtual void vOnTunerAMFMFrequencySeekStarted (tDiaResult result)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnTunerAMFMFrequencySeekStarted(result);
      }
   }
   //! notification that seek has been stopped
   virtual void vOnTunerAMFMFrequencySeekStopped (tDiaResult result)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnTunerAMFMFrequencySeekStopped(result);
      }
   }
   //! notification that seek has been ended (with success or fail)
   virtual void vOnTunerAMFMFrequencySeekResult (tDiaResult result)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnTunerAMFMFrequencySeekResult(result);
      }
   }
   //! result on the tuner DRM freq get call
   virtual void vOnTunerDRMGetFrequency (tU32 frequency)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnTunerDRMGetFrequency(frequency);
      }
   }
   //! result on the tuner DRM service Id get call
   virtual void vOnTunerDRMGetServiceID (tU32 serviceID)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnTunerDRMGetServiceID(serviceID);
      }
   }
   //! result on the tunerDRM_EnsembleFrequency_Set call.
   virtual void vOnTunerDRMEnsembleFrequency_Set (tDiaResult success)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnTunerDRMEnsembleFrequency_Set(success);
      }
   }
   //! result on the tunerDRM_ServiceID_Set call.
   virtual void vOnTunerDRMServiceID_Set (tDiaResult success)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnTunerDRMServiceID_Set(success);
      }
   }
   //! result on the TunerSetTestmodeFeature call.
   virtual void vOnTunerSetTestmodeFeature (tDiaResult success)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnTunerSetTestmodeFeature(success);
      }
   }
};

//lint +e665

#endif /* __INCLUDED_DIA_INTERFACE_TUNERAMFM_LISTENER__ */
