/*****************************************************************************************
*
* \file    dia_ITraceListener.h
*
* \brief   listener of dia_ITraceListener
*
* The interface-class covers methods for sending requests and data to SAFeature.
* The reception and processing is replied with a tDiaResult value.
* For details about the available methods see the list below.
*
* \author shw2abt (generated with ifGen.py tool)
*
*     !!!  THIS FILE IS GENERATED - DO NOT EDIT
*     !!!  MANUAL CHANGES WILL BE OVERWRITTEN BY BUILD-PROCESS
*     !!!  TO UPDATE THIS FILE EDIT dia_ITrace.xml
*
* (c) 2019 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_TRACE_LISTENER__
#define __INCLUDED_DIA_INTERFACE_TRACE_LISTENER__

#ifndef __INCLUDED_DIA_INTERFACE_TRACE__
#include "dia_ITrace.h"
#endif

#define IID_TRACE_LISTENER ((dia::IID) 0x6759b210)
/**
 *
 *  \class dia_ITraceListener
 *
 */

class dia_ITraceListener :
   public virtual dia_Listener
{
public:
   static dia::IID getUID (void ) { return (dia::IID)IID_TRACE_LISTENER; }
public:
   //! a new trace message has been arrived
   virtual void vOnTraceMessage (tU8* pMessage ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_ITraceListener( void ) {}
};
/**
 *
 *  \class dia_ITraceListenerImpl
 *
 */

class dia_ITraceListenerImpl
   : public dia_ITraceListener
{
public:
   //! a new trace message has been arrived
   virtual void vOnTraceMessage (tU8* /*pMessage*/ ) {}

protected:
   //! virtual base class destructor
   virtual ~dia_ITraceListenerImpl( void ) {}
};
/**
 *
 *  \class dia_ITraceNotifier
 *
 */

//lint -e665 review result: lint does not handle the macro properly 665:

class dia_ITraceNotifier
   : public dia_ITraceListener,
     public dia_Notifier<dia_ITraceListener>
{
public:
   //! a new trace message has been arrived
   virtual void vOnTraceMessage (tU8* pMessage)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnTraceMessage(pMessage);
      }
   }
};

//lint +e665

#endif /* __INCLUDED_DIA_INTERFACE_TRACE_LISTENER__ */
