/*****************************************************************************************
*
* \file    ITemperatureHistogram.h
*
* \brief   interface of ITemperatureHistogram
*
* The interface-class covers methods for sending requests and data to SAFeature.
* The reception and processing is replied with a tDiaResult value.
* For details about the available methods see the list below.
*
* \author hpe2hi (generated with ifGen.py tool)
*
*     !!!  THIS FILE IS GENERATED - DO NOT EDIT
*     !!!  MANUAL CHANGES WILL BE OVERWRITTEN BY BUILD-PROCESS
*     !!!  TO UPDATE THIS FILE EDIT dia_ITemperatureHistogram.xml
*
* (c) 2019 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_TEMPERATURE_HISTOGRAM__
#define __INCLUDED_DIA_INTERFACE_TEMPERATURE_HISTOGRAM__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif
#ifndef __INCLUDED_DIA_INTERFACES__
#include "common/interfaces/dia_interfaces.h"
#endif
#include "common/interfaces/dia_IHeatControl.h"
#include "array"
#define DIA_TEMPERATURE_HISTOGRAM_LENGTH (uint32_t)22
#define IID_TEMPERATURE_HISTOGRAM ((dia::IID) 0x7ee2866a)
namespace dia {
struct dia_tTemperatureHistogram
{
public:
   //! default constructor
   dia_tTemperatureHistogram() :
      mId(),
      mTemperatureMin(0),
      mTemperatureMax(0),
      mData()
   {}

   //! class constructor
   dia_tTemperatureHistogram(
      dia_eHeatCtrlTemperatureID mId_,
      tS16 mTemperatureMin_,
      tS16 mTemperatureMax_,
      std::array<uint32_t, DIA_TEMPERATURE_HISTOGRAM_LENGTH>const* mData_
   ) :
      mId(mId_),
      mTemperatureMin(mTemperatureMin_),
      mTemperatureMax(mTemperatureMax_),
      mData(mData_)
   {}
   dia_eHeatCtrlTemperatureID mId;
   tS16 mTemperatureMin;
   tS16 mTemperatureMax;
   std::array<uint32_t, DIA_TEMPERATURE_HISTOGRAM_LENGTH>const* mData;
};
class ITemperatureHistogram
{
public:
   static dia::IID getUID (void ) { return (dia::IID)IID_TEMPERATURE_HISTOGRAM; }
public:
   //! request histogram for specific source
   virtual tDiaResult getTemperatureHistogram (dia_eHeatCtrlTemperatureID id ) = 0;

protected:
   //! virtual base class destructor
   virtual ~ITemperatureHistogram( void ) {}
};
} /* namespace dia */


#endif /* __INCLUDED_DIA_INTERFACE_TEMPERATURE_HISTOGRAM__ */
