/*****************************************************************************************
*
* \file    dia_ISystemSettingsListener.h
*
* \brief   listener of dia_ISystemSettingsListener
*
* The interface-class covers methods for sending requests and data to SAFeature.
* The reception and processing is replied with a tDiaResult value.
* For details about the available methods see the list below.
*
* \author shw2abt (generated with ifGen.py tool)
*
*     !!!  THIS FILE IS GENERATED - DO NOT EDIT
*     !!!  MANUAL CHANGES WILL BE OVERWRITTEN BY BUILD-PROCESS
*     !!!  TO UPDATE THIS FILE EDIT dia_ISystemSettings.xml
*
* (c) 2019 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_SYSTEM_SETTINGS_LISTENER__
#define __INCLUDED_DIA_INTERFACE_SYSTEM_SETTINGS_LISTENER__

#ifndef __INCLUDED_DIA_INTERFACE_SYSTEM_SETTINGS__
#include "dia_ISystemSettings.h"
#endif

#define IID_SYSTEM_SETTINGS_LISTENER ((dia::IID) 0x7af9deb7)
/**
 *
 *  \class dia_ISystemSettingsListener
 *
 */

class dia_ISystemSettingsListener :
   public virtual dia_Listener
{
public:
   static dia::IID getUID (void ) { return (dia::IID)IID_SYSTEM_SETTINGS_LISTENER; }
public:
   virtual void onSetSystemSettingMode (dia_enSystemSettingMode /*mode*/, tDiaResult /*resultCode*/, tCookieType /*cookie*/ ) {}
   virtual void onSystemSettingProcessed (dia_UID typeID, const dia_SystemSettingExtendedData& extData, tDiaResult resultCode, tCookieType cookie ) = 0;
   virtual void onSystemSettingProcessed (dia_UID /*typeID*/, const dia_SystemSettingExtendedData& /*extData*/, const std::vector<dia_UID>& /*uids*/, tDiaResult /*resultCode*/, tCookieType /*cookie*/ ) {}
   virtual void onSystemSettingProcessed (dia_UID /*typeID*/, dia_enSystemSettingLevel /*level*/, const dia_SystemSettingExtendedData& /*extData*/, tDiaResult /*resultCode*/, tCookieType /*cookie*/ ) {}

protected:
   //! virtual base class destructor
   virtual ~dia_ISystemSettingsListener( void ) {}
};
/**
 *
 *  \class dia_ISystemSettingsListenerImpl
 *
 */

class dia_ISystemSettingsListenerImpl
   : public dia_ISystemSettingsListener
{
public:
   virtual void onSetSystemSettingMode (dia_enSystemSettingMode /*mode*/, tDiaResult /*resultCode*/, tCookieType /*cookie*/ ) {}
   virtual void onSystemSettingProcessed (dia_UID /*typeID*/, const dia_SystemSettingExtendedData& /*extData*/, tDiaResult /*resultCode*/, tCookieType /*cookie*/ ) {}
   virtual void onSystemSettingProcessed (dia_UID /*typeID*/, const dia_SystemSettingExtendedData& /*extData*/, const std::vector<dia_UID>& /*uids*/, tDiaResult /*resultCode*/, tCookieType /*cookie*/ ) {}
   virtual void onSystemSettingProcessed (dia_UID /*typeID*/, dia_enSystemSettingLevel /*level*/, const dia_SystemSettingExtendedData& /*extData*/, tDiaResult /*resultCode*/, tCookieType /*cookie*/ ) {}

protected:
   //! virtual base class destructor
   virtual ~dia_ISystemSettingsListenerImpl( void ) {}
};
/**
 *
 *  \class dia_ISystemSettingsNotifier
 *
 */

//lint -e665 review result: lint does not handle the macro properly 665:

class dia_ISystemSettingsNotifier
   : public dia_ISystemSettingsListener,
     public dia_Notifier<dia_ISystemSettingsListener>
{
public:
   virtual void onSetSystemSettingMode (dia_enSystemSettingMode mode, tDiaResult resultCode, tCookieType cookie)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->onSetSystemSettingMode(mode, resultCode, cookie);
      }
   }
   virtual void onSystemSettingProcessed (dia_UID typeID, const dia_SystemSettingExtendedData& extData, tDiaResult resultCode, tCookieType cookie)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->onSystemSettingProcessed(typeID, extData, resultCode, cookie);
      }
   }
   virtual void onSystemSettingProcessed (dia_UID typeID, const dia_SystemSettingExtendedData& extData, const std::vector<dia_UID>& uids, tDiaResult resultCode, tCookieType cookie)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->onSystemSettingProcessed(typeID, extData, uids, resultCode, cookie);
      }
   }
   virtual void onSystemSettingProcessed (dia_UID typeID, dia_enSystemSettingLevel level, const dia_SystemSettingExtendedData& extData, tDiaResult resultCode, tCookieType cookie)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->onSystemSettingProcessed(typeID, level, extData, resultCode, cookie);
      }
   }
};

//lint +e665

#endif /* __INCLUDED_DIA_INTERFACE_SYSTEM_SETTINGS_LISTENER__ */
