/*****************************************************************************************
*
* \file    dia_ISystemSettings.h
*
* \brief   interface of dia_ISystemSettings
*
* The interface-class covers methods for sending requests and data to SAFeature.
* The reception and processing is replied with a tDiaResult value.
* For details about the available methods see the list below.
*
* \author shw2abt (generated with ifGen.py tool)
*
*     !!!  THIS FILE IS GENERATED - DO NOT EDIT
*     !!!  MANUAL CHANGES WILL BE OVERWRITTEN BY BUILD-PROCESS
*     !!!  TO UPDATE THIS FILE EDIT dia_ISystemSettings.xml
*
* (c) 2019 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_SYSTEM_SETTINGS__
#define __INCLUDED_DIA_INTERFACE_SYSTEM_SETTINGS__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif
#ifndef __INCLUDED_DIA_INTERFACES__
#include "common/interfaces/dia_interfaces.h"
#endif
#include "common/framework/sysset/dia_common_sysset.h"
class dia_SystemSettingsModule;
class dia_SystemSettingsPlugin;
class dia_ISystemSettingsListener;
#define IID_SYSTEM_SETTINGS ((dia::IID) 0x10ed6151)
class dia_ISystemSettings
{
public:
   static dia::IID getUID (void ) { return (dia::IID)IID_SYSTEM_SETTINGS; }
public:
   //! set system setting framework to slave or master mode. in slave mode an external master will trigger the level requests
   virtual tDiaResult setSystemSettingMode (dia_enSystemSettingMode mode, dia_ISystemSettingsListener& requester, tCookieType cookie ) = 0;
   //! retrieve the current mode of the system setting framework. can be either in master or slave mode
   virtual dia_enSystemSettingMode getSystemSettingMode ( ) = 0;
   //! perform the requested type of system setting in master mode. that means all three levels (prepare, execute, finallize) will be carried out by the framework itself
   virtual tDiaResult processSystemSetting (dia_UID typeID, dia_ISystemSettingsListener& pRequester, tCookieType cookie ) = 0;
   //! perform the requested type of system setting in master mode. that means all three levels (prepare, execute, finallize) will be carried out by the framework itself
   virtual tDiaResult processSystemSetting (dia_UID typeID, const dia_SystemSettingExtendedData& extData, dia_ISystemSettingsListener& pRequester, tCookieType cookie ) = 0;
   //! perform the requested type of system setting in master mode. that means all three levels (prepare, execute, finallize) will be carried out by the framework itself
   virtual tDiaResult processSystemSetting (dia_UID typeID, const std::vector<dia_UID>& modules, dia_ISystemSettingsListener& pRequester, tCookieType cookie ) = 0;
   //! perform the requested type of system setting in master mode. that means all three levels (prepare, execute, finallize) will be carried out by the framework itself
   virtual tDiaResult processSystemSetting (dia_UID typeID, const dia_SystemSettingExtendedData& extData, const std::vector<dia_UID>& modules, dia_ISystemSettingsListener& pRequester, tCookieType cookie ) = 0;
   //! perform the requested type of system setting in slave mode. that means the level to be carried out (prepare, execute, finallize) is explicitly requested by the remote master
   virtual tDiaResult processSystemSetting (dia_UID typeID, dia_enSystemSettingLevel level, dia_ISystemSettingsListener& pRequester, tCookieType cookie ) = 0;
   //! perform the requested type of system setting in slave mode. that means the level to be carried out (prepare, execute, finallize) is explicitly requested by the remote master
   virtual tDiaResult processSystemSetting (dia_UID typeID, dia_enSystemSettingLevel level, const dia_SystemSettingExtendedData& extData, dia_ISystemSettingsListener& pRequester, tCookieType cookie ) = 0;
   //! install a signal handler
   virtual tDiaResult addSystemSettingsModule (dia_SystemSettingsModule& module ) = 0;
   //! install a signal handler
   virtual tDiaResult addSystemSettingsPlugin (dia_SystemSettingsPlugin& plugin ) = 0;
   virtual void onSystemSettingsModuleUpdate (dia_SystemSettingsModule& module, dia_UID sysSetTypeUID, dia_enSystemSettingLevel level, tDiaResult errCode ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_ISystemSettings( void ) {}
};

#endif /* __INCLUDED_DIA_INTERFACE_SYSTEM_SETTINGS__ */
