/*****************************************************************************************
*
* \file    dia_ISpmListener.h
*
* \brief   listener of dia_ISpmListener
*
* The interface-class covers methods for sending requests and data to SAFeature.
* The reception and processing is replied with a tDiaResult value.
* For details about the available methods see the list below.
*
* \author gib2hi (generated with ifGen.py tool)
*
*     !!!  THIS FILE IS GENERATED - DO NOT EDIT
*     !!!  MANUAL CHANGES WILL BE OVERWRITTEN BY BUILD-PROCESS
*     !!!  TO UPDATE THIS FILE EDIT dia_ISpm.xml
*
* (c) 2019 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_SPM_LISTENER__
#define __INCLUDED_DIA_INTERFACE_SPM_LISTENER__

#ifndef __INCLUDED_DIA_INTERFACE_SPM__
#include "dia_ISpm.h"
#endif

#define IID_SPM_LISTENER ((dia::IID) 0xbd6068f1)
/**
 *
 *  \class dia_ISpmListener
 *
 */

class dia_ISpmListener :
   public virtual dia_Listener
{
public:
   static dia::IID getUID (void ) { return (dia::IID)IID_SPM_LISTENER; }
public:
   //! notification about a system state status
   virtual void vOnSystemState (dia_eSpmSystemState state, dia_eSpmSystemState prevState ) = 0;
   //! notification about a Hmi state change
   virtual void vOnHmiStateChange (dia_eSpmHmiState state, dia_eSpmHmiState prevState ) = 0;
   //! notification about a critical voltage monitor event
   virtual void vOnCVMEvent (dia_eSpmCvmEvent event, dia_eSpmCvmState state ) = 0;
   //! current value of the battery voltage
   virtual void vOnBatteryVoltage (tU32 voltage ) = 0;
   //! number of system resets - This function can be removed in future as a new function vOnSystemResetInformation is implemented as per the new feature behavior
   virtual void vOnSystemResetStatus (const dia_tSpmResetStatus* status ) = 0;
   //! system reset information
   virtual void vOnSystemResetInformation (const dia_tSpmResetDate* date, const dia_tSpmResetCounterStatus* status ) = 0;
   //! Success of reset system resets status.
   virtual void vOnResetSystemResetStatus (tDiaResult success ) = 0;
   //! acknowledge that the watchdog test was initiated
   virtual void vOnAckWatchdogTest ( ) = 0;
   //! acknowledge that the system will restart
   virtual void vOnAckSystemRestart (dia_eSpmRestartMode mode ) = 0;
   //! acknowledge that the diagnosis activity substate was entered
   virtual void vOnSubstateAck ( ) = 0;
   //! response on sending restart command
   virtual void vOnSystemRestart (tDiaResult success ) = 0;
   //! response on sending fastShutdown command
   virtual void vOnSystemFastShutdown (tDiaResult success ) = 0;
   //! current reset history list of request getResetHistory
   virtual void vOnGetResetHistory (const std::vector<tU8>* resetElements ) = 0;
   //! current wakeup history list of request getWakeUpHistory
   virtual void vOnGetWakeUpHistory (const std::vector<tU8>* wakeupElements ) = 0;
   //! current state history list of request getStateHistory
   virtual void vOnGetStateHistory (const std::vector<tU8>* stateElements ) = 0;
   //! current error state history list of request getErrStateHistory
   virtual void vOnGetErrStateHistory (dia_eSpmErrState errState, const std::vector<tU8>* errStateElements ) = 0;
   //! current power save mode of the vehicle, of request getSystemPowerSaveMode
   virtual void vOnGetSystemPowerSaveMode (tU32 sysPwrSaveMode ) = 0;
   //! status for the requested voltage terminal value i.e. response on getVoltageSplyTerminalValue
   virtual void vOnGetVoltageSplyTerminalValue (tU16 voltage ) = 0;
   //! receive the current power supply status
   virtual void vOnGetPowerSupplyStatus (tU8 voltage ) = 0;
   //! receive the current power supply voltage
   virtual void vOnGetPowerSupply (tU16 voltage ) = 0;
   //! receive the current system restart value
   virtual void vOnGetSystemRestartValue (dia_eSpmRestartMode mode ) = 0;
   //! current startup origin of request getSwitchOnHistory
   virtual void vOnGetStartUpReason (dia_eSpmStartUpReason startUpOrigin ) = 0;
   //! Last startup origin of request getSwitchOnHistory
   virtual void vOnGetLastStartUpReason (dia_eSpmStartUpReason lastStartUpOrigin ) = 0;
   //! current wakeup origin of request getWakeUpHistory
   virtual void vOnGetWakeUpReason  (dia_eSpmWakeUpReason wakeUpOrigin ) = 0;
   //! Last wakeup origin of request getWakeUpHistory
   virtual void vOnGetLastWakeUpReason (dia_eSpmWakeUpReason lastWakeUpOrigin ) = 0;
   //! response on sending restart command for SW update
   virtual void vOnSystemRestartDone (tDiaResult result ) = 0;
   //! Response for sendOnOffTrigger request
   virtual void vOnAckOnOffTrigger (tDiaResult response ) = 0;
   //! Response for battery voltage
   virtual void vOnGetBatteryVoltage (tU16 voltage ) = 0;
   //! Response for system power state
   virtual void vOnPowerState (dia_eSpmSystemPowerState pwrState ) = 0;
   //! receive the current system startup state
   virtual void vOnStartupStatus (const std::vector<dia_tSpmStartupStatus>* startupStatus ) = 0;
   //! notification about a radio state status
   virtual void vOnRadioState (dia_eSpmSystemState state ) = 0;
   //! status for the requested Degraded Mode Counter i.e. response on getDegradedModeCounter
   virtual void vOnGetDegradedModeCounter (tU32 icounter ) = 0;
   //! status for the requested Degraded Mode Cumulated Duration i.e. response on getDegradedModeTime
   virtual void vOnGetDegradedModeTime (tU32 itime ) = 0;
   //! status for the requested time from engine stopped i.e. response on getEngineStoppedTime
   virtual void vOnGetEngineStoppedTime (tU32 itime ) = 0;
   //! status for the requested Vehicle Identifier Value i.e. response on getVehicleIdentifierValue
   virtual void vOnGetVehicleIdentifierValue (tU32 veh_id ) = 0;
   //! status for the requested counters i.e. response on getPowerSupplyVoltageEventCounters
   virtual void vOnGetPowerSupplyVoltageEventCounters (dia_tPowerSupplyVoltageEventCounters counters ) = 0;
   //! status for the requested counters i.e. response on vOnGetPowerSupplyVoltageHistogram
   virtual void vOnGetPowerSupplyVoltageHistogram (const std::vector<dia_tSpmVoltageHistogramElement>* histogram ) = 0;
   //! status for the requested statistics i.e. response on vOnGetCpuUsageStatistics
   virtual void vOnGetCpuUsageStatistics (dia_tSpmStatisticData statistics ) = 0;
   //! status for the requested statistics i.e. response on vOnGetRamUsageStatistics
   virtual void vOnGetRamUsageStatistics (dia_tSpmStatisticData statistics ) = 0;
   //! status for the requested statistics i.e. response on vOnGetStartupTimeStatistics
   virtual void vOnGetStartupTimeStatistics (dia_tSpmStatisticData statistics ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_ISpmListener( void ) {}
};
/**
 *
 *  \class dia_ISpmListenerImpl
 *
 */

class dia_ISpmListenerImpl
   : public dia_ISpmListener
{
public:
   //! notification about a system state status
   virtual void vOnSystemState (dia_eSpmSystemState /*state*/, dia_eSpmSystemState /*prevState*/ ) {}
   //! notification about a Hmi state change
   virtual void vOnHmiStateChange (dia_eSpmHmiState /*state*/, dia_eSpmHmiState /*prevState*/ ) {}
   //! notification about a critical voltage monitor event
   virtual void vOnCVMEvent (dia_eSpmCvmEvent /*event*/, dia_eSpmCvmState /*state*/ ) {}
   //! current value of the battery voltage
   virtual void vOnBatteryVoltage (tU32 /*voltage*/ ) {}
   //! number of system resets - This function can be removed in future as a new function vOnSystemResetInformation is implemented as per the new feature behavior
   virtual void vOnSystemResetStatus (const dia_tSpmResetStatus* /*status*/ ) {}
   //! system reset information
   virtual void vOnSystemResetInformation (const dia_tSpmResetDate* /*date*/, const dia_tSpmResetCounterStatus* /*status*/ ) {}
   //! Success of reset system resets status.
   virtual void vOnResetSystemResetStatus (tDiaResult /*success*/ ) {}
   //! acknowledge that the watchdog test was initiated
   virtual void vOnAckWatchdogTest ( ) {}
   //! acknowledge that the system will restart
   virtual void vOnAckSystemRestart (dia_eSpmRestartMode /*mode*/ ) {}
   //! acknowledge that the diagnosis activity substate was entered
   virtual void vOnSubstateAck ( ) {}
   //! response on sending restart command
   virtual void vOnSystemRestart (tDiaResult /*success*/ ) {}
   //! response on sending fastShutdown command
   virtual void vOnSystemFastShutdown (tDiaResult /*success*/ ) {}
   //! current reset history list of request getResetHistory
   virtual void vOnGetResetHistory (const std::vector<tU8>* /*resetElements*/ ) {}
   //! current wakeup history list of request getWakeUpHistory
   virtual void vOnGetWakeUpHistory (const std::vector<tU8>* /*wakeupElements*/ ) {}
   //! current state history list of request getStateHistory
   virtual void vOnGetStateHistory (const std::vector<tU8>* /*stateElements*/ ) {}
   //! current error state history list of request getErrStateHistory
   virtual void vOnGetErrStateHistory (dia_eSpmErrState /*errState*/, const std::vector<tU8>* /*errStateElements*/ ) {}
   //! current power save mode of the vehicle, of request getSystemPowerSaveMode
   virtual void vOnGetSystemPowerSaveMode (tU32 /*sysPwrSaveMode*/ ) {}
   //! status for the requested voltage terminal value i.e. response on getVoltageSplyTerminalValue
   virtual void vOnGetVoltageSplyTerminalValue (tU16 /*voltage*/ ) {}
   //! receive the current power supply status
   virtual void vOnGetPowerSupplyStatus (tU8 /*voltage*/ ) {}
   //! receive the current power supply voltage
   virtual void vOnGetPowerSupply (tU16 /*voltage*/ ) {}
   //! receive the current system restart value
   virtual void vOnGetSystemRestartValue (dia_eSpmRestartMode /*mode*/ ) {}
   //! current startup origin of request getSwitchOnHistory
   virtual void vOnGetStartUpReason (dia_eSpmStartUpReason /*startUpOrigin*/ ) {}
   //! Last startup origin of request getSwitchOnHistory
   virtual void vOnGetLastStartUpReason (dia_eSpmStartUpReason /*lastStartUpOrigin*/ ) {}
   //! current wakeup origin of request getWakeUpHistory
   virtual void vOnGetWakeUpReason  (dia_eSpmWakeUpReason /*wakeUpOrigin*/ ) {}
   //! Last wakeup origin of request getWakeUpHistory
   virtual void vOnGetLastWakeUpReason (dia_eSpmWakeUpReason /*lastWakeUpOrigin*/ ) {}
   //! response on sending restart command for SW update
   virtual void vOnSystemRestartDone (tDiaResult /*result*/ ) {}
   //! Response for sendOnOffTrigger request
   virtual void vOnAckOnOffTrigger (tDiaResult /*response*/ ) {}
   //! Response for battery voltage
   virtual void vOnGetBatteryVoltage (tU16 /*voltage*/ ) {}
   //! Response for system power state
   virtual void vOnPowerState (dia_eSpmSystemPowerState /*pwrState*/ ) {}
   //! receive the current system startup state
   virtual void vOnStartupStatus (const std::vector<dia_tSpmStartupStatus>* /*startupStatus*/ ) {}
   //! notification about a radio state status
   virtual void vOnRadioState (dia_eSpmSystemState /*state*/ ) {}
   //! status for the requested Degraded Mode Counter i.e. response on getDegradedModeCounter
   virtual void vOnGetDegradedModeCounter (tU32 /*icounter*/ ) {}
   //! status for the requested Degraded Mode Cumulated Duration i.e. response on getDegradedModeTime
   virtual void vOnGetDegradedModeTime (tU32 /*itime*/ ) {}
   //! status for the requested time from engine stopped i.e. response on getEngineStoppedTime
   virtual void vOnGetEngineStoppedTime (tU32 /*itime*/ ) {}
   //! status for the requested Vehicle Identifier Value i.e. response on getVehicleIdentifierValue
   virtual void vOnGetVehicleIdentifierValue (tU32 /*veh_id*/ ) {}
   //! status for the requested counters i.e. response on getPowerSupplyVoltageEventCounters
   virtual void vOnGetPowerSupplyVoltageEventCounters (dia_tPowerSupplyVoltageEventCounters /*counters*/ ) {}
   //! status for the requested counters i.e. response on vOnGetPowerSupplyVoltageHistogram
   virtual void vOnGetPowerSupplyVoltageHistogram (const std::vector<dia_tSpmVoltageHistogramElement>* /*histogram*/ ) {}
   //! status for the requested statistics i.e. response on vOnGetCpuUsageStatistics
   virtual void vOnGetCpuUsageStatistics (dia_tSpmStatisticData /*statistics*/ ) {}
   //! status for the requested statistics i.e. response on vOnGetRamUsageStatistics
   virtual void vOnGetRamUsageStatistics (dia_tSpmStatisticData /*statistics*/ ) {}
   //! status for the requested statistics i.e. response on vOnGetStartupTimeStatistics
   virtual void vOnGetStartupTimeStatistics (dia_tSpmStatisticData /*statistics*/ ) {}

protected:
   //! virtual base class destructor
   virtual ~dia_ISpmListenerImpl( void ) {}
};
/**
 *
 *  \class dia_ISpmNotifier
 *
 */

//lint -e665 review result: lint does not handle the macro properly 665:

class dia_ISpmNotifier
   : public dia_ISpmListener,
     public dia_Notifier<dia_ISpmListener>
{
public:
   //! notification about a system state status
   virtual void vOnSystemState (dia_eSpmSystemState state, dia_eSpmSystemState prevState)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnSystemState(state, prevState);
      }
   }
   //! notification about a Hmi state change
   virtual void vOnHmiStateChange (dia_eSpmHmiState state, dia_eSpmHmiState prevState)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnHmiStateChange(state, prevState);
      }
   }
   //! notification about a critical voltage monitor event
   virtual void vOnCVMEvent (dia_eSpmCvmEvent event, dia_eSpmCvmState state)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnCVMEvent(event, state);
      }
   }
   //! current value of the battery voltage
   virtual void vOnBatteryVoltage (tU32 voltage)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnBatteryVoltage(voltage);
      }
   }
   //! number of system resets - This function can be removed in future as a new function vOnSystemResetInformation is implemented as per the new feature behavior
   virtual void vOnSystemResetStatus (const dia_tSpmResetStatus* status)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnSystemResetStatus(status);
      }
   }
   //! system reset information
   virtual void vOnSystemResetInformation (const dia_tSpmResetDate* date, const dia_tSpmResetCounterStatus* status)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnSystemResetInformation(date, status);
      }
   }
   //! Success of reset system resets status.
   virtual void vOnResetSystemResetStatus (tDiaResult success)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnResetSystemResetStatus(success);
      }
   }
   //! acknowledge that the watchdog test was initiated
   virtual void vOnAckWatchdogTest ()
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnAckWatchdogTest();
      }
   }
   //! acknowledge that the system will restart
   virtual void vOnAckSystemRestart (dia_eSpmRestartMode mode)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnAckSystemRestart(mode);
      }
   }
   //! acknowledge that the diagnosis activity substate was entered
   virtual void vOnSubstateAck ()
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnSubstateAck();
      }
   }
   //! response on sending restart command
   virtual void vOnSystemRestart (tDiaResult success)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnSystemRestart(success);
      }
   }
   //! response on sending fastShutdown command
   virtual void vOnSystemFastShutdown (tDiaResult success)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnSystemFastShutdown(success);
      }
   }
   //! current reset history list of request getResetHistory
   virtual void vOnGetResetHistory (const std::vector<tU8>* resetElements)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnGetResetHistory(resetElements);
      }
   }
   //! current wakeup history list of request getWakeUpHistory
   virtual void vOnGetWakeUpHistory (const std::vector<tU8>* wakeupElements)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnGetWakeUpHistory(wakeupElements);
      }
   }
   //! current state history list of request getStateHistory
   virtual void vOnGetStateHistory (const std::vector<tU8>* stateElements)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnGetStateHistory(stateElements);
      }
   }
   //! current error state history list of request getErrStateHistory
   virtual void vOnGetErrStateHistory (dia_eSpmErrState errState, const std::vector<tU8>* errStateElements)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnGetErrStateHistory(errState, errStateElements);
      }
   }
   //! current power save mode of the vehicle, of request getSystemPowerSaveMode
   virtual void vOnGetSystemPowerSaveMode (tU32 sysPwrSaveMode)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnGetSystemPowerSaveMode(sysPwrSaveMode);
      }
   }
   //! status for the requested voltage terminal value i.e. response on getVoltageSplyTerminalValue
   virtual void vOnGetVoltageSplyTerminalValue (tU16 voltage)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnGetVoltageSplyTerminalValue(voltage);
      }
   }
   //! receive the current power supply status
   virtual void vOnGetPowerSupplyStatus (tU8 voltage)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnGetPowerSupplyStatus(voltage);
      }
   }
   //! receive the current power supply voltage
   virtual void vOnGetPowerSupply (tU16 voltage)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnGetPowerSupply(voltage);
      }
   }
   //! receive the current system restart value
   virtual void vOnGetSystemRestartValue (dia_eSpmRestartMode mode)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnGetSystemRestartValue(mode);
      }
   }
   //! current startup origin of request getSwitchOnHistory
   virtual void vOnGetStartUpReason (dia_eSpmStartUpReason startUpOrigin)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnGetStartUpReason(startUpOrigin);
      }
   }
   //! Last startup origin of request getSwitchOnHistory
   virtual void vOnGetLastStartUpReason (dia_eSpmStartUpReason lastStartUpOrigin)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnGetLastStartUpReason(lastStartUpOrigin);
      }
   }
   //! current wakeup origin of request getWakeUpHistory
   virtual void vOnGetWakeUpReason  (dia_eSpmWakeUpReason wakeUpOrigin)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnGetWakeUpReason (wakeUpOrigin);
      }
   }
   //! Last wakeup origin of request getWakeUpHistory
   virtual void vOnGetLastWakeUpReason (dia_eSpmWakeUpReason lastWakeUpOrigin)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnGetLastWakeUpReason(lastWakeUpOrigin);
      }
   }
   //! response on sending restart command for SW update
   virtual void vOnSystemRestartDone (tDiaResult result)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnSystemRestartDone(result);
      }
   }
   //! Response for sendOnOffTrigger request
   virtual void vOnAckOnOffTrigger (tDiaResult response)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnAckOnOffTrigger(response);
      }
   }
   //! Response for battery voltage
   virtual void vOnGetBatteryVoltage (tU16 voltage)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnGetBatteryVoltage(voltage);
      }
   }
   //! Response for system power state
   virtual void vOnPowerState (dia_eSpmSystemPowerState pwrState)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnPowerState(pwrState);
      }
   }
   //! receive the current system startup state
   virtual void vOnStartupStatus (const std::vector<dia_tSpmStartupStatus>* startupStatus)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnStartupStatus(startupStatus);
      }
   }
   //! notification about a radio state status
   virtual void vOnRadioState (dia_eSpmSystemState state)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnRadioState(state);
      }
   }
   //! status for the requested Degraded Mode Counter i.e. response on getDegradedModeCounter
   virtual void vOnGetDegradedModeCounter (tU32 icounter)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnGetDegradedModeCounter(icounter);
      }
   }
   //! status for the requested Degraded Mode Cumulated Duration i.e. response on getDegradedModeTime
   virtual void vOnGetDegradedModeTime (tU32 itime)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnGetDegradedModeTime(itime);
      }
   }
   //! status for the requested time from engine stopped i.e. response on getEngineStoppedTime
   virtual void vOnGetEngineStoppedTime (tU32 itime)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnGetEngineStoppedTime(itime);
      }
   }
   //! status for the requested Vehicle Identifier Value i.e. response on getVehicleIdentifierValue
   virtual void vOnGetVehicleIdentifierValue (tU32 veh_id)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnGetVehicleIdentifierValue(veh_id);
      }
   }
   //! status for the requested counters i.e. response on getPowerSupplyVoltageEventCounters
   virtual void vOnGetPowerSupplyVoltageEventCounters (dia_tPowerSupplyVoltageEventCounters counters)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnGetPowerSupplyVoltageEventCounters(counters);
      }
   }
   //! status for the requested counters i.e. response on vOnGetPowerSupplyVoltageHistogram
   virtual void vOnGetPowerSupplyVoltageHistogram (const std::vector<dia_tSpmVoltageHistogramElement>* histogram)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnGetPowerSupplyVoltageHistogram(histogram);
      }
   }
   //! status for the requested statistics i.e. response on vOnGetCpuUsageStatistics
   virtual void vOnGetCpuUsageStatistics (dia_tSpmStatisticData statistics)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnGetCpuUsageStatistics(statistics);
      }
   }
   //! status for the requested statistics i.e. response on vOnGetRamUsageStatistics
   virtual void vOnGetRamUsageStatistics (dia_tSpmStatisticData statistics)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnGetRamUsageStatistics(statistics);
      }
   }
   //! status for the requested statistics i.e. response on vOnGetStartupTimeStatistics
   virtual void vOnGetStartupTimeStatistics (dia_tSpmStatisticData statistics)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnGetStartupTimeStatistics(statistics);
      }
   }
};

//lint +e665

#endif /* __INCLUDED_DIA_INTERFACE_SPM_LISTENER__ */
