/*****************************************************************************************
*
* \file    dia_ISpm.h
*
* \brief   interface of dia_ISpm
*
* The interface-class covers methods for sending requests and data to SAFeature.
* The reception and processing is replied with a tDiaResult value.
* For details about the available methods see the list below.
*
* \author gib2hi (generated with ifGen.py tool)
*
*     !!!  THIS FILE IS GENERATED - DO NOT EDIT
*     !!!  MANUAL CHANGES WILL BE OVERWRITTEN BY BUILD-PROCESS
*     !!!  TO UPDATE THIS FILE EDIT dia_ISpm.xml
*
* (c) 2019 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_SPM__
#define __INCLUDED_DIA_INTERFACE_SPM__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif
#ifndef __INCLUDED_DIA_INTERFACES__
#include "common/interfaces/dia_interfaces.h"
#endif
#define IID_SPM ((dia::IID) 0x4132518b)
//------------------------------------------------------------------------------
enum dia_eSpmSubState
{
   DIA_EN_SPM_SUBSTATE_UNKNOWN = 0xFFFFFFFF,
   DIA_EN_SPM_SUBSTATE_DIAGNOSIS_ACTIVITY = 5,
   DIA_EN_SPM_SUBSTATE_FAST_SHUTDOWN = 2,
   DIA_EN_SPM_SUBSTATE_DIAGNOSIS_MODE = 6,
   DIA_EN_SPM_SUBSTATE_IGNITION = 9,
   DIA_EN_SPM_SUBSTATE_ACCESSORY = 8,
   DIA_EN_SPM_SUBSTATE_ON_TIPPER = 20,
   DIA_EN_SPM_SUBSTATE_DIAGNOSIS_REQUEST = 27,
   DIA_EN_SPM_SUBSTATE_COUNT = 9
};
//------------------------------------------------------------------------------
enum dia_eSpmStartUpReason
{
   DIA_EN_SPM_STARTUP_REASON_UNKNOWN = 0,
   DIA_EN_SPM_STARTUP_REASON_S_CONTACT,
   DIA_EN_SPM_STARTUP_REASON_PHONE,
   DIA_EN_SPM_STARTUP_REASON_DOWNLOAD,
   DIA_EN_SPM_STARTUP_REASON_ON_TIPPER,
   DIA_EN_SPM_STARTUP_REASON_COUNT = 5
};
//------------------------------------------------------------------------------
enum dia_eSpmResetReason_full
{
   DIA_EN_SPM_FULL_RESET_REASON_UNKNOWN = 0,
   DIA_EN_SPM_FULL_RESET_REASON_HMI_COPRO_NO_REASON,
   DIA_EN_SPM_FULL_RESET_REASON_HMI_COPRO_SPI_ERROR,
   DIA_EN_SPM_FULL_RESET_REASON_HMI_COPRO_WATCHDOG_TIMEOUT,
   DIA_EN_SPM_FULL_RESET_REASON_HMI_COPRO_SMACK_TIMEOUT,
   DIA_EN_SPM_FULL_RESET_REASON_HMI_COPRO_RSTOUT_INACTIVE,
   DIA_EN_SPM_FULL_RESET_REASON_HMI_COPRO_RSTOUT_ACTIVE_TIMEOUT,
   DIA_EN_SPM_FULL_RESET_REASON_HMI_COPRO_RSTOUT_INACTIVE_TIMEOUT,
   DIA_EN_SPM_FULL_RESET_REASON_HMI_COPRO_WAKEUP_MSG_TIMEOUT,
   DIA_EN_SPM_FULL_RESET_REASON_HMI_COPRO_NO_MODE_TIMEOUT,
   DIA_EN_SPM_FULL_RESET_REASON_HMI_APP_NOT_INITIALIZED,
   DIA_EN_SPM_FULL_RESET_REASON_HMI_APP_NOT_ACK,
   DIA_EN_SPM_FULL_RESET_REASON_HMI_APP_END_WANTED,
   DIA_EN_SPM_FULL_RESET_REASON_HMI_APP_WDT_ERROR,
   DIA_EN_SPM_FULL_RESET_REASON_HMI_APP_NOTIFY_ERROR,
   DIA_EN_SPM_FULL_RESET_REASON_HMI_APP_DOWNLOAD_ERROR,
   DIA_EN_SPM_FULL_RESET_REASON_HMI_APP_DOWNLOAD,
   DIA_EN_SPM_FULL_RESET_REASON_HMI_WDT,
   DIA_EN_SPM_FULL_RESET_REASON_HMI_MPU_WDT,
   DIA_EN_SPM_FULL_RESET_REASON_HMI_DSP_WDT,
   DIA_EN_SPM_FULL_RESET_REASON_HMI_SOFTWARE,
   DIA_EN_SPM_FULL_RESET_REASON_HMI_MPU,
   DIA_EN_SPM_FULL_RESET_REASON_HMI_UNKNOWN,
   DIA_EN_SPM_FULL_RESET_REASON_HMI_EXTERN,
   DIA_EN_SPM_FULL_RESET_REASON_HMI_USER,
   DIA_EN_SPM_FULL_RESET_REASON_RU_UNKNOWN,
   DIA_EN_SPM_FULL_RESET_REASON_RU_UNDERVOLTAGE,
   DIA_EN_SPM_FULL_RESET_REASON_RU_HMI,
   DIA_EN_SPM_FULL_RESET_REASON_FGS_HMI,
   DIA_EN_SPM_FULL_RESET_REASON_FGS_FGS,
   DIA_EN_SPM_FULL_RESET_REASON_HMI_OVERTEMPERATURE,
   DIA_EN_SPM_FULL_RESET_REASON_HMI_SLV_SUPERVISION,
   DIA_EN_SPM_FULL_RESET_REASON_HMI_ECU,
   DIA_EN_SPM_FULL_RESET_REASON_HMI_ECU_FAST,
   DIA_EN_SPM_FULL_RESET_REASON_HMI_APP_WDT_HEARTBEAT_ERROR,
   DIA_EN_SPM_FULL_RESET_REASON_HMI_SLV_PROCESS_SUPERVISION,
   DIA_EN_SPM_FULL_RESET_REASON_HMI_SLV_REQUESTED_RESET,
   DIA_EN_SPM_FULL_RESET_REASON_HMI_POWER_ON_RESET,
   DIA_EN_SPM_FULL_RESET_REASON_COUNT = 38
};
//------------------------------------------------------------------------------
enum dia_eSpmWakeUpReason
{
   DIA_EN_SPM_WAKEUP_REASON_UNKNOWN = 0,
   DIA_EN_SPM_WAKEUP_REASON_INVALID = 0,
   DIA_EN_SPM_WAKEUP_REASON_CAN = 1,
   DIA_EN_SPM_WAKEUP_REASON_EJECT = 2,
   DIA_EN_SPM_WAKEUP_REASON_INSERT = 3,
   DIA_EN_SPM_WAKEUP_REASON_IGNITION = 4,
   DIA_EN_SPM_WAKEUP_REASON_RTC = 5,
   DIA_EN_SPM_WAKEUP_REASON_POWER_ON = 6,
   DIA_EN_SPM_WAKEUP_REASON_ON_TIPPER = 7,
   DIA_EN_SPM_WAKEUP_REASON_COPRO_REQ = 8,
   DIA_EN_SPM_WAKEUP_REASON_MAUS_BUS = 9,
   DIA_EN_SPM_WAKEUP_REASON_DOOR_OPEN = 0x0A,
   DIA_EN_SPM_WAKEUP_REASON_SDCARD_INSERT = 0x0B,
   DIA_EN_SPM_WAKEUP_REASON_PHONE_MUTE = 0x0C,
   DIA_EN_SPM_WAKEUP_REASON_ACCESSORY = 0xD,
   DIA_EN_SPM_WAKEUP_REASON_MOST = 0xF,
   DIA_EN_SPM_WAKEUP_REASON_RESET = 0xFF,
   DIA_EN_SPM_WAKEUP_REASON_RESTART = 0xFFFFFFFFUL,
   DIA_EN_SPM_WAKEUP_REASON_COUNT = 18
};
//------------------------------------------------------------------------------
enum dia_eSpmStateEntry
{
   DIA_EN_SPM_STATE_ENTRY_UNKNOWN = 0,
   DIA_EN_SPM_STATE_ENTRY_WAKEUP,
   DIA_EN_SPM_STATE_ENTRY_SUBSTATE,
   DIA_EN_SPM_STATE_ENTRY_RESET,
   DIA_EN_SPM_STATE_ENTRY_COUNT = 4
};
//------------------------------------------------------------------------------
enum dia_eSpmShutdownMode
{
   DIA_EN_SPM_SHUTDOWN_MODE_UNKNOWN = 0,
   DIA_EN_SPM_SHUTDOWN_MODE_FAST,
   DIA_EN_SPM_SHUTDOWN_MODE_OFF_LASTSTATE,
   DIA_EN_SPM_SHUTDOWN_MODE_COUNT = 3
};
//------------------------------------------------------------------------------
enum dia_eSpmRestartMode
{
   DIA_EN_SPM_RESTART_MODE_UNKNOWN = 0,
   DIA_EN_SPM_RESTART_MODE_ECU,
   DIA_EN_SPM_RESTART_MODE_WDT,
   DIA_EN_SPM_RESTART_MODE_ECU_FAST,
   DIA_EN_SPM_RESTART_MODE_DOWNLOAD_ERROR,
   DIA_EN_SPM_RESTART_MODE_DOWNLOAD_FINSIHED,
   DIA_EN_SPM_RESTART_MODE_ECU_WITH_SYNC,
   DIA_EN_SPM_RESTART_MODE_DOWNLOAD_ABORTED,
   DIA_EN_SPM_RESTART_MODE_ECU_ALTSW_TESTMANAGER,
   DIA_EN_SPM_RESTART_MODE_ECU_ALTSW_NAC_TESTSOFTWARE,
   DIA_EN_SPM_RESTART_MODE_COUNT = 10
};
//------------------------------------------------------------------------------
enum dia_eSpmCoreRestartMode
{
   DIA_EN_SPM_CORE_RESTART_MODE_UNKNOWN = 0,
   DIA_EN_SPM_CORE_RESTART_MODE_ECU,
   DIA_EN_SPM_CORE_RESTART_MODE_WDT,
   DIA_EN_SPM_CORE_RESTART_MODE_ECU_FAST,
   DIA_EN_SPM_CORE_RESTART_MODE_DOWNLOAD_ERROR,
   DIA_EN_SPM_CORE_RESTART_MODE_DOWNLOAD_FINSIHED,
   DIA_EN_SPM_CORE_RESTART_MODE_ECU_WITH_SYNC,
   DIA_EN_SPM_CORE_RESTART_MODE_DOWNLOAD_ABORTED,
   DIA_EN_SPM_CORE_RESTART_MODE_ECU_ALTSW_TESTMANAGER,
   DIA_EN_SPM_CORE_RESTART_MODE_ECU_SYNC_WITHOUT_RESTART,
   DIA_EN_SPM_CORE_RESTART_MODE_ECU_ALTSW_NAC_TESTSOFTWARE,
   DIA_EN_SPM_CORE_RESTART_MODE_COUNT = 11
};
//------------------------------------------------------------------------------
enum dia_eSpmDiagActivityMode
{
   DIA_EN_SPM_DIA_ACTIVITY_MODE_UNKNOWN = 0,
   DIA_EN_SPM_DIA_ACTIVITY_MODE_ON,
   DIA_EN_SPM_DIA_ACTIVITY_MODE_OFF,
   DIA_EN_SPM_DIA_ACTIVITY_MODE_COUNT = 3
};
//------------------------------------------------------------------------------
enum dia_eSpmSystemState
{
   DIA_EN_SPM_SYSTEM_STATE_UNKNOWN = 0xFFFFFFFFUL,
   DIA_EN_SPM_SYSTEM_STATE_SUSPEND = 0,
   DIA_EN_SPM_SYSTEM_STATE_STANDBY = 1,
   DIA_EN_SPM_SYSTEM_STATE_OFF = 2,
   DIA_EN_SPM_SYSTEM_STATE_DOWNLOAD = 3,
   DIA_EN_SPM_SYSTEM_STATE_ON = 4,
   DIA_EN_SPM_SYSTEM_STATE_BACKGROUND = 5,
   DIA_EN_SPM_SYSTEM_STATE_DOOR_OPEN = 6,
   DIA_EN_SPM_SYSTEM_STATE_IGNITION = 7,
   DIA_EN_SPM_SYSTEM_STATE_DIAGNOSIS = 8,
   DIA_EN_SPM_SYSTEM_STATE_PROFILE = 9,
   DIA_EN_SPM_SYSTEM_STATE_PREPARE_SHUTDOWN = 16,
   DIA_EN_SPM_SYSTEM_STATE_SHUTDOWN = 17,
   DIA_EN_SPM_SYSTEM_STATE_MMI_STANDBY_PWR_SAVE_1 = 32,
   DIA_EN_SPM_SYSTEM_STATE_MMI_STANDBY_PWR_SAVE_2 = 33,
   DIA_EN_SPM_SYSTEM_STATE_MMI_STANDBY = 34,
   DIA_EN_SPM_SYSTEM_STATE_MMI_ON = 35,
   DIA_EN_SPM_SYSTEM_STATE_MMI_STANDBY_RESTRICTED = 36,
   DIA_EN_SPM_SYSTEM_STATE_MMI_ON_DIAG = 37,
   DIA_EN_SPM_SYSTEM_STATE_MMI_ON_TEL = 38,
   DIA_EN_SPM_SYSTEM_STATE_MMI_ON_SWDL = 39,
   DIA_EN_SPM_SYSTEM_STATE_MMI_STANDBY_CUSTOMER_SWDL = 40,
   DIA_EN_SPM_SYSTEM_STATE_MMI_STANDBY_PWR_SAVE = 41,
   DIA_EN_SPM_SYSTEM_STATE_OVERTEMP = 42,
   DIA_EN_SPM_SYSTEM_STATE_SAFE = 43,
   DIA_EN_SPM_SYSTEM_STATE_STATE_MAX = 44,
   DIA_EN_SPM_SYSTEM_STATE_COUNT = 27
};
//------------------------------------------------------------------------------
enum dia_eSpmHmiState
{
   DIA_EN_SPM_HMI_STATE_UNKNOWN = 0,
   DIA_EN_SPM_HMI_STATE_SHOW_OFF,
   DIA_EN_SPM_HMI_STATE_SHOW_HMI,
   DIA_EN_SPM_HMI_STATE_COUNT = 3
};
//------------------------------------------------------------------------------
enum dia_eSpmCvmState
{
   DIA_EN_SPM_CVM_STATE_VOLTAGE_UNKNOWN = 0,
   DIA_EN_SPM_CVM_STATE_VOLTAGE_NORMAL,
   DIA_EN_SPM_CVM_STATE_VOLTAGE_LOW,
   DIA_EN_SPM_CVM_STATE_VOLTAGE_LOW_CRITICAL,
   DIA_EN_SPM_CVM_STATE_VOLTAGE_HIGH,
   DIA_EN_SPM_CVM_STATE_VOLTAGE_HIGH_CRITICAL,
   DIA_EN_SPM_CVM_STATE_VOLTAGE_COUNT = 6
};
//------------------------------------------------------------------------------
enum dia_eSpmCvmEvent
{
   DIA_EN_SPM_CVM_EVENT_UNKNOWN = 0,
   DIA_EN_SPM_CVM_EVENT_CRITICAL_LOW_VOLTAGE_START,
   DIA_EN_SPM_CVM_EVENT_CRITICAL_LOW_VOLTAGE_END,
   DIA_EN_SPM_CVM_EVENT_LOW_VOLTAGE_START,
   DIA_EN_SPM_CVM_EVENT_LOW_VOLTAGE_END,
   DIA_EN_SPM_CVM_EVENT_HIGH_VOLTAGE_START,
   DIA_EN_SPM_CVM_EVENT_HIGH_VOLTAGE_END,
   DIA_EN_SPM_CVM_EVENT_CRITICAL_HIGH_VOLTAGE_START,
   DIA_EN_SPM_CVM_EVENT_CRITICAL_HIGH_VOLTAGE_END,
   DIA_EN_SPM_CVM_EVENT_COUNT = 9
};
//------------------------------------------------------------------------------
enum dia_eSpmErrState
{
   DIA_EN_SPM_ERR_STATE_UNKNOWN = 0,
   DIA_EN_SPM_ERR_STATE_01,
   DIA_EN_SPM_ERR_STATE_02,
   DIA_EN_SPM_ERR_STATE_03,
   DIA_EN_SPM_ERR_STATE_04,
   DIA_EN_SPM_ERR_STATE_05,
   DIA_EN_SPM_ERR_STATE_COUNT = 6
};
//------------------------------------------------------------------------------
enum dia_eSpmSystemPowerState
{
   DIA_EN_SYS_PWR_STATE_UNKNOWN = 0,
   DIA_EN_SYS_PWR_STATE_OFF/* Means input lines are both off (Ignition+ACC) */,
   DIA_EN_SYS_PWR_STATE_RUN/* Means input lines Ignition+ACC */,
   DIA_EN_SYS_PWR_STATE_ACCESSORY/* ACC */,
   DIA_EN_SYS_PWR_STATE_COUNT = 4
};
//------------------------------------------------------------------------------
enum dia_eSpmProcessState
{
   DIA_EN_SPM_PROCESS_STATE_UNKNOWN = 0,
   DIA_EN_SPM_PROCESS_STATE_TO_START,
   DIA_EN_SPM_PROCESS_STATE_RUNNING,
   DIA_EN_SPM_PROCESS_STATE_DOWN,
   DIA_EN_SPM_PROCESS_STATE_COUNT = 4
};
struct dia_tSpmResetStatus
{
public:
   //! default constructor
   dia_tSpmResetStatus() :
      mLastResetReason(0),
      mDateHour(0),
      mDateMinute(0),
      mDateDay(0),
      mDateMonth(0),
      mDateYear(0),
      mCoproResetByHmi(0),
      mCoproResetByUndervoltage(0),
      mHmiResetByCoproStartup(0),
      mHmiResetByCoproRun(0),
      mHmiResetByCoproShutdown(0),
      mHmiResetByHmiWdg(0),
      mHmiResetByHmiApp(0),
      mHmiResetByHmiException(0),
      mHmiResetByHmiExtern(0),
      mHmiResetByHmiDownload(0),
      mHmiResetByHmiDiag(0),
      mFgsResetByHmi(0)
   {}

   //! class constructor
   dia_tSpmResetStatus(
      tU8 mLastResetReason_,
      tU8 mDateHour_,
      tU8 mDateMinute_,
      tU8 mDateDay_,
      tU8 mDateMonth_,
      tU16 mDateYear_,
      tU8 mCoproResetByHmi_,
      tU8 mCoproResetByUndervoltage_,
      tU8 mHmiResetByCoproStartup_,
      tU8 mHmiResetByCoproRun_,
      tU8 mHmiResetByCoproShutdown_,
      tU8 mHmiResetByHmiWdg_,
      tU8 mHmiResetByHmiApp_,
      tU8 mHmiResetByHmiException_,
      tU8 mHmiResetByHmiExtern_,
      tU8 mHmiResetByHmiDownload_,
      tU8 mHmiResetByHmiDiag_,
      tU8 mFgsResetByHmi_
   ) :
      mLastResetReason(mLastResetReason_),
      mDateHour(mDateHour_),
      mDateMinute(mDateMinute_),
      mDateDay(mDateDay_),
      mDateMonth(mDateMonth_),
      mDateYear(mDateYear_),
      mCoproResetByHmi(mCoproResetByHmi_),
      mCoproResetByUndervoltage(mCoproResetByUndervoltage_),
      mHmiResetByCoproStartup(mHmiResetByCoproStartup_),
      mHmiResetByCoproRun(mHmiResetByCoproRun_),
      mHmiResetByCoproShutdown(mHmiResetByCoproShutdown_),
      mHmiResetByHmiWdg(mHmiResetByHmiWdg_),
      mHmiResetByHmiApp(mHmiResetByHmiApp_),
      mHmiResetByHmiException(mHmiResetByHmiException_),
      mHmiResetByHmiExtern(mHmiResetByHmiExtern_),
      mHmiResetByHmiDownload(mHmiResetByHmiDownload_),
      mHmiResetByHmiDiag(mHmiResetByHmiDiag_),
      mFgsResetByHmi(mFgsResetByHmi_)
   {}
   tU8 mLastResetReason;
   tU8 mDateHour;
   tU8 mDateMinute;
   tU8 mDateDay;
   tU8 mDateMonth;
   tU16 mDateYear;
   tU8 mCoproResetByHmi;
   tU8 mCoproResetByUndervoltage;
   tU8 mHmiResetByCoproStartup;
   tU8 mHmiResetByCoproRun;
   tU8 mHmiResetByCoproShutdown;
   tU8 mHmiResetByHmiWdg;
   tU8 mHmiResetByHmiApp;
   tU8 mHmiResetByHmiException;
   tU8 mHmiResetByHmiExtern;
   tU8 mHmiResetByHmiDownload;
   tU8 mHmiResetByHmiDiag;
   tU8 mFgsResetByHmi;
};
struct dia_tSpmResetDate
{
public:
   //! default constructor
   dia_tSpmResetDate() :
      mDateYear(0),
      mDateMonth(0),
      mDateDay(0),
      mDateHour(0),
      mDateMinute(0),
      mDateSecond(0)
   {}

   //! class constructor
   dia_tSpmResetDate(
      tU16 mDateYear_,
      tU8 mDateMonth_,
      tU8 mDateDay_,
      tU8 mDateHour_,
      tU8 mDateMinute_,
      tU8 mDateSecond_
   ) :
      mDateYear(mDateYear_),
      mDateMonth(mDateMonth_),
      mDateDay(mDateDay_),
      mDateHour(mDateHour_),
      mDateMinute(mDateMinute_),
      mDateSecond(mDateSecond_)
   {}
   tU16 mDateYear;
   tU8 mDateMonth;
   tU8 mDateDay;
   tU8 mDateHour;
   tU8 mDateMinute;
   tU8 mDateSecond;
};
struct dia_tSpmTimeDate
{
public:
   //! default constructor
   dia_tSpmTimeDate() :
      mYear(0),
      mMonth(0),
      mDay(0),
      mHour(0),
      mMinute(0),
      mSecond(0)
   {}

   //! class constructor
   dia_tSpmTimeDate(
      int16_t mYear_,
      uint8_t mMonth_,
      uint8_t mDay_,
      uint8_t mHour_,
      uint8_t mMinute_,
      uint8_t mSecond_
   ) :
      mYear(mYear_),
      mMonth(mMonth_),
      mDay(mDay_),
      mHour(mHour_),
      mMinute(mMinute_),
      mSecond(mSecond_)
   {}
   int16_t mYear;
   uint8_t mMonth;
   uint8_t mDay;
   uint8_t mHour;
   uint8_t mMinute;
   uint8_t mSecond;
};
struct dia_tSpmResetCounterStatus
{
public:
   //! default constructor
   dia_tSpmResetCounterStatus() :
      mLastResetReason(0),
      mApApplicationError(0),
      mApSoftware(0),
      mApEcuReset(0),
      mApDownload(0),
      mApDownloadError(0),
      mApOvertemperature(0),
      mApUser(0),
      mApLcmIntern(0),
      mApWarmstartCount(0),
      mApPowerOnCount(0),
      mApPowerLossCount(0),
      mApPowerOffCount(0),
      mApSccCount(0),
      mApUnknownCount(0),
      mSccHwWdtCount(0),
      mSccPowerOnCount(0),
      mSccColdstartCount(0),
      mSccAppmodeChangeCount(0),
      mSccDuringLpwCount(0),
      mSccDuringPllOszCount(0),
      mSccDuringSWCount(0),
      mSccWarmstartCount(0)
   {}

   //! class constructor
   dia_tSpmResetCounterStatus(
      tU8 mLastResetReason_,
      tU32 mApApplicationError_,
      tU32 mApSoftware_,
      tU32 mApEcuReset_,
      tU32 mApDownload_,
      tU32 mApDownloadError_,
      tU32 mApOvertemperature_,
      tU32 mApUser_,
      tU32 mApLcmIntern_,
      tU32 mApWarmstartCount_,
      tU32 mApPowerOnCount_,
      tU32 mApPowerLossCount_,
      tU32 mApPowerOffCount_,
      tU32 mApSccCount_,
      tU32 mApUnknownCount_,
      tU32 mSccHwWdtCount_,
      tU32 mSccPowerOnCount_,
      tU32 mSccColdstartCount_,
      tU32 mSccAppmodeChangeCount_,
      tU32 mSccDuringLpwCount_,
      tU32 mSccDuringPllOszCount_,
      tU32 mSccDuringSWCount_,
      tU32 mSccWarmstartCount_
   ) :
      mLastResetReason(mLastResetReason_),
      mApApplicationError(mApApplicationError_),
      mApSoftware(mApSoftware_),
      mApEcuReset(mApEcuReset_),
      mApDownload(mApDownload_),
      mApDownloadError(mApDownloadError_),
      mApOvertemperature(mApOvertemperature_),
      mApUser(mApUser_),
      mApLcmIntern(mApLcmIntern_),
      mApWarmstartCount(mApWarmstartCount_),
      mApPowerOnCount(mApPowerOnCount_),
      mApPowerLossCount(mApPowerLossCount_),
      mApPowerOffCount(mApPowerOffCount_),
      mApSccCount(mApSccCount_),
      mApUnknownCount(mApUnknownCount_),
      mSccHwWdtCount(mSccHwWdtCount_),
      mSccPowerOnCount(mSccPowerOnCount_),
      mSccColdstartCount(mSccColdstartCount_),
      mSccAppmodeChangeCount(mSccAppmodeChangeCount_),
      mSccDuringLpwCount(mSccDuringLpwCount_),
      mSccDuringPllOszCount(mSccDuringPllOszCount_),
      mSccDuringSWCount(mSccDuringSWCount_),
      mSccWarmstartCount(mSccWarmstartCount_)
   {}
   tU8 mLastResetReason;
   tU32 mApApplicationError;
   tU32 mApSoftware;
   tU32 mApEcuReset;
   tU32 mApDownload;
   tU32 mApDownloadError;
   tU32 mApOvertemperature;
   tU32 mApUser;
   tU32 mApLcmIntern;
   tU32 mApWarmstartCount;
   tU32 mApPowerOnCount;
   tU32 mApPowerLossCount;
   tU32 mApPowerOffCount;
   tU32 mApSccCount;
   tU32 mApUnknownCount;
   tU32 mSccHwWdtCount;
   tU32 mSccPowerOnCount;
   tU32 mSccColdstartCount;
   tU32 mSccAppmodeChangeCount;
   tU32 mSccDuringLpwCount;
   tU32 mSccDuringPllOszCount;
   tU32 mSccDuringSWCount;
   tU32 mSccWarmstartCount;
};
struct dia_tSpmStartupStatus
{
public:
   //! default constructor
   dia_tSpmStartupStatus() :
      mProcessName(),
      mProcessState(0),
      mStartTimeSinceStart(0),
      mSwitchOnDateYear(0),
      mSwitchOnDateMonth(0),
      mSwitchOnDateDay(0),
      mSwitchOnDateHour(0),
      mSwitchOnDateMinute(0),
      mSwitchOnDateSecond(0)
   {}

   //! class constructor
   dia_tSpmStartupStatus(
      std::string mProcessName_,
      tU8 mProcessState_,
      tU32 mStartTimeSinceStart_,
      tS16 mSwitchOnDateYear_,
      tU8 mSwitchOnDateMonth_,
      tU8 mSwitchOnDateDay_,
      tU8 mSwitchOnDateHour_,
      tU8 mSwitchOnDateMinute_,
      tU8 mSwitchOnDateSecond_
   ) :
      mProcessName(mProcessName_),
      mProcessState(mProcessState_),
      mStartTimeSinceStart(mStartTimeSinceStart_),
      mSwitchOnDateYear(mSwitchOnDateYear_),
      mSwitchOnDateMonth(mSwitchOnDateMonth_),
      mSwitchOnDateDay(mSwitchOnDateDay_),
      mSwitchOnDateHour(mSwitchOnDateHour_),
      mSwitchOnDateMinute(mSwitchOnDateMinute_),
      mSwitchOnDateSecond(mSwitchOnDateSecond_)
   {}
   std::string mProcessName;
   tU8 mProcessState;
   tU32 mStartTimeSinceStart;
   tS16 mSwitchOnDateYear;
   tU8 mSwitchOnDateMonth;
   tU8 mSwitchOnDateDay;
   tU8 mSwitchOnDateHour;
   tU8 mSwitchOnDateMinute;
   tU8 mSwitchOnDateSecond;
};
struct dia_tPowerSupplyVoltageEventCounters
{
public:
   //! default constructor
   dia_tPowerSupplyVoltageEventCounters() :
      mLowVoltageCount(0),
      mCrLowVoltageCount(0),
      mHighVoltageCount(0),
      mCrHighVoltageCount(0)
   {}

   //! class constructor
   dia_tPowerSupplyVoltageEventCounters(
      tU32 mLowVoltageCount_,
      tU32 mCrLowVoltageCount_,
      tU32 mHighVoltageCount_,
      tU32 mCrHighVoltageCount_
   ) :
      mLowVoltageCount(mLowVoltageCount_),
      mCrLowVoltageCount(mCrLowVoltageCount_),
      mHighVoltageCount(mHighVoltageCount_),
      mCrHighVoltageCount(mCrHighVoltageCount_)
   {}
   tU32 mLowVoltageCount;
   tU32 mCrLowVoltageCount;
   tU32 mHighVoltageCount;
   tU32 mCrHighVoltageCount;
};
struct dia_tSpmVoltageHistogramElement
{
public:
   //! default constructor
   dia_tSpmVoltageHistogramElement() :
      aVoltageMV(0),
      mOperationTimeSeconds(0)
   {}

   //! class constructor
   dia_tSpmVoltageHistogramElement(
      tU32 aVoltageMV_,
      tU32 mOperationTimeSeconds_
   ) :
      aVoltageMV(aVoltageMV_),
      mOperationTimeSeconds(mOperationTimeSeconds_)
   {}
   tU32 aVoltageMV;
   tU32 mOperationTimeSeconds;
};
struct dia_tSpmStatisticData
{
public:
   //! default constructor
   dia_tSpmStatisticData() :
      mMaxValue(0),
      mAvgValue(0),
      mMinValue(0)
   {}

   //! class constructor
   dia_tSpmStatisticData(
      tU32 mMaxValue_,
      tU32 mAvgValue_,
      tU32 mMinValue_
   ) :
      mMaxValue(mMaxValue_),
      mAvgValue(mAvgValue_),
      mMinValue(mMinValue_)
   {}
   tU32 mMaxValue;
   tU32 mAvgValue;
   tU32 mMinValue;
};
class dia_ISpm
{
public:
   static dia::IID getUID (void ) { return (dia::IID)IID_SPM; }
public:
   //! synchronous method used to retrieve the current system state
   virtual tDiaResult getSystemState (dia_eSpmSystemState& state ) = 0;
   //! synchronous method used to retrieve the radio state
   virtual tDiaResult getRadioState ( ) { return DIA_E_NOT_IMPLEMENTED; }
   //! synchronous method used to retrieve the current HMI state
   virtual tDiaResult getHmiState (dia_eSpmHmiState& state ) = 0;
   //! synchronous method used to retrieve the current CVM state
   virtual tDiaResult getCVMState (dia_eSpmCvmState& state ) = 0;
   //! synchronous method used to retrieve the last CVM event
   virtual tDiaResult getCVMLastEvent (dia_eSpmCvmEvent& state ) = 0;
   //! request the current value of the battery voltage
   virtual tDiaResult getBatteryVoltage ( ) = 0;
   //! request property which informs about the powermode the vehicle is currently in (key position).
   virtual tDiaResult getSystemPowerMode ( ) = 0;
   //! request the number of system resets
   virtual tDiaResult getSystemResetCounter ( ) = 0;
   //! request the system reset information
   virtual tDiaResult getSystemResetInformation ( ) = 0;
   //! reset system reset counter
   virtual tDiaResult resetSystemResetCounter ( ) = 0;
   //! reset system reset information
   virtual tDiaResult resetSystemResetInformation ( ) = 0;
   //! initiate a system shutdown
   virtual tDiaResult signalSystemShutdown (dia_eSpmShutdownMode mode ) = 0;
   //! initiate a system restart
   virtual tDiaResult signalSystemRestart (dia_eSpmRestartMode mode ) = 0;
   //! initiate a system restart
   virtual tDiaResult lcmSystemRestart (dia_eSpmRestartMode mode ) = 0;
   //! initiate a system reset
   virtual tDiaResult signalSystemReset (dia_eSpmCoreRestartMode mode ) = 0;
   //! initiate a system watchdog shutdown
   virtual tDiaResult signalWatchdog ( ) = 0;
   //! set a substate of the SPM to the given value
   virtual tDiaResult setSubState (dia_eSpmSubState substate, tBool mode ) = 0;
   //! request the reset history
   virtual tDiaResult getResetHistory ( ) = 0;
   //! request the wake up history
   virtual tDiaResult getWakeUpHistory ( ) = 0;
   //! request the state history
   virtual tDiaResult getStateHistory ( ) = 0;
   //! request the error state history of the given parameter
   virtual tDiaResult getErrStateHistory (dia_eSpmErrState errState ) = 0;
   //! request the switch on history
   virtual tDiaResult getSwitchOnHistory ( ) = 0;
   //! request the current power save mode of the vehicle
   virtual tDiaResult getSystemPowerSaveMode ( ) = 0;
   //! request the voltage terminal value
   virtual tDiaResult getVoltageSplyTerminalValue ( ) = 0;
   //! request the Power Supply Status
   virtual tDiaResult getPowerSupplyStatus ( ) { return DIA_E_NOT_IMPLEMENTED; }
   //! Set a new OnOff reason
   virtual tDiaResult sendOnOffTrigger (dia_eSpmSubState /*substate*/, tBool /*mode*/ ) { return DIA_E_NOT_IMPLEMENTED; }
   //! request the Startup Status process based
   virtual tDiaResult getStartupStatus ( ) { return DIA_E_NOT_IMPLEMENTED; }
   //! request the Degraded Mode Counter
   virtual tDiaResult getDegradedModeCounter ( ) { return DIA_E_NOT_IMPLEMENTED; }
   //! request the Degraded Mode Cumulated Duration
   virtual tDiaResult getDegradedModeTime ( ) { return DIA_E_NOT_IMPLEMENTED; }
   //! request the Time From Engine Stopped
   virtual tDiaResult getEngineStoppedTime ( ) { return DIA_E_NOT_IMPLEMENTED; }
   //! request the Vehicle Identifier Value
   virtual tDiaResult getVehicleIdentifierValue ( ) { return DIA_E_NOT_IMPLEMENTED; }
   //! request counters of voltage events
   virtual tDiaResult getPowerSupplyVoltageEventCounters ( ) { return DIA_E_NOT_IMPLEMENTED; }
   //! request supply voltage histogram
   virtual tDiaResult getPowerSupplyVoltageHistogram ( ) { return DIA_E_NOT_IMPLEMENTED; }
   //! request statistics for CPU usage
   virtual tDiaResult getCpuUsageStatistics ( ) { return DIA_E_NOT_IMPLEMENTED; }
   //! request statistics for RAM usage
   virtual tDiaResult getRamUsageStatistics ( ) { return DIA_E_NOT_IMPLEMENTED; }
   //! request statistics for startup times
   virtual tDiaResult getStartupTimeStatistics ( ) { return DIA_E_NOT_IMPLEMENTED; }

protected:
   //! virtual base class destructor
   virtual ~dia_ISpm( void ) {}
};

#endif /* __INCLUDED_DIA_INTERFACE_SPM__ */
