/*****************************************************************************************
*
* \file    dia_IServiceListener.h
*
* \brief   listener of dia_IServiceListener
*
* The interface-class covers methods for sending requests and data to SAFeature.
* The reception and processing is replied with a tDiaResult value.
* For details about the available methods see the list below.
*
* \author shw2abt (generated with ifGen.py tool)
*
*     !!!  THIS FILE IS GENERATED - DO NOT EDIT
*     !!!  MANUAL CHANGES WILL BE OVERWRITTEN BY BUILD-PROCESS
*     !!!  TO UPDATE THIS FILE EDIT dia_IService.xml
*
* (c) 2019 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_SERVICE_LISTENER__
#define __INCLUDED_DIA_INTERFACE_SERVICE_LISTENER__

#ifndef __INCLUDED_DIA_INTERFACE_SERVICE__
#include "dia_IService.h"
#endif

#define IID_SERVICE_LISTENER ((dia::IID) 0x5b248392)
/**
 *
 *  \class dia_IServiceListener
 *
 */

class dia_IServiceListener :
   public virtual dia_Listener
{
public:
   static dia::IID getUID (void ) { return (dia::IID)IID_SERVICE_LISTENER; }
public:
   virtual void vOnServiceRegistration (tU16 serviceID, tU16 serverID, tU16 regID ) = 0;
   virtual void vOnServiceState (tU16 serviceID, tU16 serverID, tBool availability ) = 0;
   virtual void vOnServiceStateChange (tU16 serviceID, tU16 oldState, tU16 newState ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_IServiceListener( void ) {}
};
/**
 *
 *  \class dia_IServiceListenerImpl
 *
 */

class dia_IServiceListenerImpl
   : public dia_IServiceListener
{
public:
   virtual void vOnServiceRegistration (tU16 /*serviceID*/, tU16 /*serverID*/, tU16 /*regID*/ ) {}
   virtual void vOnServiceState (tU16 /*serviceID*/, tU16 /*serverID*/, tBool /*availability*/ ) {}
   virtual void vOnServiceStateChange (tU16 /*serviceID*/, tU16 /*oldState*/, tU16 /*newState*/ ) {}

protected:
   //! virtual base class destructor
   virtual ~dia_IServiceListenerImpl( void ) {}
};
/**
 *
 *  \class dia_IServiceNotifier
 *
 */

//lint -e665 review result: lint does not handle the macro properly 665:

class dia_IServiceNotifier
   : public dia_IServiceListener,
     public dia_Notifier<dia_IServiceListener>
{
public:
   virtual void vOnServiceRegistration (tU16 serviceID, tU16 serverID, tU16 regID)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnServiceRegistration(serviceID, serverID, regID);
      }
   }
   virtual void vOnServiceState (tU16 serviceID, tU16 serverID, tBool availability)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnServiceState(serviceID, serverID, availability);
      }
   }
   virtual void vOnServiceStateChange (tU16 serviceID, tU16 oldState, tU16 newState)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnServiceStateChange(serviceID, oldState, newState);
      }
   }
};

//lint +e665

#endif /* __INCLUDED_DIA_INTERFACE_SERVICE_LISTENER__ */
