/*****************************************************************************************
*
* \file    dia_ISensor.h
*
* \brief   interface of dia_ISensor
*
* The interface-class covers methods for sending requests and data to SAFeature.
* The reception and processing is replied with a tDiaResult value.
* For details about the available methods see the list below.
*
* \author shw2abt (generated with ifGen.py tool)
*
*     !!!  THIS FILE IS GENERATED - DO NOT EDIT
*     !!!  MANUAL CHANGES WILL BE OVERWRITTEN BY BUILD-PROCESS
*     !!!  TO UPDATE THIS FILE EDIT dia_ISensor.xml
*
* (c) 2019 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_SENSOR__
#define __INCLUDED_DIA_INTERFACE_SENSOR__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif
#ifndef __INCLUDED_DIA_INTERFACES__
#include "common/interfaces/dia_interfaces.h"
#endif
#define IID_SENSOR ((dia::IID) 0x37e46075)
//------------------------------------------------------------------------------
/**
 * Enumeration type defining the status code associated with a gyro value
   */
enum dia_eGyroStatus
{
   DIA_EN_GYRO_STATUS_UNKNOWN = 0,
   DIA_EN_GYRO_STATUS_CONNECTED_NORMAL,
   DIA_EN_GYRO_STATUS_OUT_OF_ORDER,
   DIA_EN_GYRO_STATUS_OVERHEAT,
   DIA_EN_GYRO_STATUS_SENSOR_NOT_PRESENT,
   DIA_EN_GYRO_STATUS_CONNECTED_DATA_INVALID,
   DIA_EN_GYRO_STATUS_CONNECTED_INTERNALERROR,
   DIA_EN_GYRO_STATUS_COUNT = 7
};
//------------------------------------------------------------------------------
/**
 * Enumeration type defining the status code associated with a acc value
   */
enum dia_eAccStatus
{
   DIA_EN_ACC_STATUS_UNKNOWN = 0,
   DIA_EN_ACC_STATUS_CONNECTED_NORMAL,
   DIA_EN_ACC_STATUS_OUT_OF_ORDER,
   DIA_EN_ACC_STATUS_OVERHEAT,
   DIA_EN_ACC_STATUS_SENSOR_NOT_PRESENT,
   DIA_EN_ACC_STATUS_CONNECTED_DATA_INVALID,
   DIA_EN_ACC_STATUS_CONNECTED_INTERNALERROR,
   DIA_EN_ACC_STATUS_COUNT = 7
};
class dia_ISensor
{
public:
   static dia::IID getUID (void ) { return (dia::IID)IID_SENSOR; }
public:
   //! get the current speed
   virtual tDiaResult getSensorSpeed ( ) = 0;
   //! get the current OdometerCount
   virtual tDiaResult getOdometerCount ( ) = 0;
   //! get the current value of the 3D Gyro-sensor
   virtual tDiaResult bGetSensor3dGyroValue ( ) = 0;
   //! get the current value of 3D Acceleration sensor
   virtual tDiaResult bGetSensor3dAccValue ( ) = 0;
   //! start gyro sensor selftest process
   virtual tDiaResult vGyroSelfTest ( ) = 0;
   //! start gyro sensor selftest process
   virtual tDiaResult vAccSelfTest ( ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_ISensor( void ) {}
};

#endif /* __INCLUDED_DIA_INTERFACE_SENSOR__ */
