/*****************************************************************************************
*
* \file    ISCCListener.h
*
* \brief   listener of ISCCListener
*
* The interface-class covers methods for sending requests and data to SAFeature.
* The reception and processing is replied with a tDiaResult value.
* For details about the available methods see the list below.
*
* \author shw2abt (generated with ifGen.py tool)
*
*     !!!  THIS FILE IS GENERATED - DO NOT EDIT
*     !!!  MANUAL CHANGES WILL BE OVERWRITTEN BY BUILD-PROCESS
*     !!!  TO UPDATE THIS FILE EDIT dia_ISCC.xml
*
* (c) 2019 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_SCC_LISTENER__
#define __INCLUDED_DIA_INTERFACE_SCC_LISTENER__

#ifndef __INCLUDED_DIA_INTERFACE_SCC__
#include "dia_ISCC.h"
#endif

#define IID_SCC_LISTENER ((dia::IID) 0xe148748d)
namespace dia {
/**
 *
 *  \class ISCCListener
 *
 */

class ISCCListener :
   public virtual dia_Listener
{
public:
   static dia::IID getUID (void ) { return (dia::IID)IID_SCC_LISTENER; }
public:
   //! received notification that connection to SCC was established
   virtual void onSccConnected ( ) = 0;
   //! received notification that connection to SCC was terminated
   virtual void onSccDisconnected ( ) = 0;
   //! received notification about the current component status
   virtual void onSccStatusUpdate (enSccComponentStatus status ) = 0;

protected:
   //! virtual base class destructor
   virtual ~ISCCListener( void ) {}
};
/**
 *
 *  \class ISCCListenerImpl
 *
 */

class ISCCListenerImpl
   : public ISCCListener
{
public:
   //! received notification that connection to SCC was established
   virtual void onSccConnected ( ) {}
   //! received notification that connection to SCC was terminated
   virtual void onSccDisconnected ( ) {}
   //! received notification about the current component status
   virtual void onSccStatusUpdate (enSccComponentStatus /*status*/ ) {}

protected:
   //! virtual base class destructor
   virtual ~ISCCListenerImpl( void ) {}
};
/**
 *
 *  \class ISCCNotifier
 *
 */

//lint -e665 review result: lint does not handle the macro properly 665:

class ISCCNotifier
   : public ISCCListener,
     public dia_Notifier<ISCCListener>
{
public:
   //! received notification that connection to SCC was established
   virtual void onSccConnected ()
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->onSccConnected();
      }
   }
   //! received notification that connection to SCC was terminated
   virtual void onSccDisconnected ()
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->onSccDisconnected();
      }
   }
   //! received notification about the current component status
   virtual void onSccStatusUpdate (enSccComponentStatus status)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->onSccStatusUpdate(status);
      }
   }
};

//lint +e665
} /* namespace dia */


#endif /* __INCLUDED_DIA_INTERFACE_SCC_LISTENER__ */
