/*****************************************************************************************
*
* \file    dia_IRunLevelListener.h
*
* \brief   listener of dia_IRunLevelListener
*
* The interface-class covers methods for sending requests and data to SAFeature.
* The reception and processing is replied with a tDiaResult value.
* For details about the available methods see the list below.
*
* \author shw2abt (generated with ifGen.py tool)
*
*     !!!  THIS FILE IS GENERATED - DO NOT EDIT
*     !!!  MANUAL CHANGES WILL BE OVERWRITTEN BY BUILD-PROCESS
*     !!!  TO UPDATE THIS FILE EDIT dia_IRunLevel.xml
*
* (c) 2019 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_RUN_LEVEL_LISTENER__
#define __INCLUDED_DIA_INTERFACE_RUN_LEVEL_LISTENER__

#ifndef __INCLUDED_DIA_INTERFACE_RUN_LEVEL__
#include "dia_IRunLevel.h"
#endif

#define IID_RUNLEVEL_LISTENER ((dia::IID) 0xe07a544e)
/**
 *
 *  \class dia_IRunLevelListener
 *
 */

class dia_IRunLevelListener :
   public virtual dia_Listener
{
public:
   static dia::IID getUID (void ) { return (dia::IID)IID_RUNLEVEL_LISTENER; }
public:
   //! overloaded method from dia_IServiceListener
   virtual void vOnRunLevelChanged (dia_enRunlevel newLevel, dia_enRunlevel oldLevel ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_IRunLevelListener( void ) {}
};
/**
 *
 *  \class dia_IRunLevelListenerImpl
 *
 */

class dia_IRunLevelListenerImpl
   : public dia_IRunLevelListener
{
public:
   //! overloaded method from dia_IServiceListener
   virtual void vOnRunLevelChanged (dia_enRunlevel /*newLevel*/, dia_enRunlevel /*oldLevel*/ ) {}

protected:
   //! virtual base class destructor
   virtual ~dia_IRunLevelListenerImpl( void ) {}
};
/**
 *
 *  \class dia_IRunLevelNotifier
 *
 */

//lint -e665 review result: lint does not handle the macro properly 665:

class dia_IRunLevelNotifier
   : public dia_IRunLevelListener,
     public dia_Notifier<dia_IRunLevelListener>
{
public:
   //! overloaded method from dia_IServiceListener
   virtual void vOnRunLevelChanged (dia_enRunlevel newLevel, dia_enRunlevel oldLevel)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnRunLevelChanged(newLevel, oldLevel);
      }
   }
};

//lint +e665

#endif /* __INCLUDED_DIA_INTERFACE_RUN_LEVEL_LISTENER__ */
