/*****************************************************************************************
*
* \file    dia_IRoutineControlListener.h
*
* \brief   listener of dia_IRoutineControlListener
*
* The interface-class covers methods for sending requests and data to SAFeature.
* The reception and processing is replied with a tDiaResult value.
* For details about the available methods see the list below.
*
* \author shw2abt (generated with ifGen.py tool)
*
*     !!!  THIS FILE IS GENERATED - DO NOT EDIT
*     !!!  MANUAL CHANGES WILL BE OVERWRITTEN BY BUILD-PROCESS
*     !!!  TO UPDATE THIS FILE EDIT dia_IRoutineControl.xml
*
* (c) 2019 Robert Bosch Car Multimedia GmbH
*
****************************************************************************************/

#ifndef __INCLUDED_DIA_INTERFACE_ROUTINE_CONTROL_LISTENER__
#define __INCLUDED_DIA_INTERFACE_ROUTINE_CONTROL_LISTENER__

#ifndef __INCLUDED_DIA_INTERFACE_ROUTINE_CONTROL__
#include "dia_IRoutineControl.h"
#endif

#define IID_ROUTINE_CONTROL_LISTENER ((dia::IID) 0x9e69988)
/**
 *
 *  \class dia_IRoutineControlListener
 *
 */

class dia_IRoutineControlListener :
   public virtual dia_Listener
{
public:
   static dia::IID getUID (void ) { return (dia::IID)IID_ROUTINE_CONTROL_LISTENER; }
public:
   //! there was an update of the given routine
   virtual void vOnRoutineUpdate (dia_Routine& routine ) = 0;

protected:
   //! virtual base class destructor
   virtual ~dia_IRoutineControlListener( void ) {}
};
/**
 *
 *  \class dia_IRoutineControlListenerImpl
 *
 */

class dia_IRoutineControlListenerImpl
   : public dia_IRoutineControlListener
{
public:
   //! there was an update of the given routine
   virtual void vOnRoutineUpdate (dia_Routine& /*routine*/ ) {}

protected:
   //! virtual base class destructor
   virtual ~dia_IRoutineControlListenerImpl( void ) {}
};
/**
 *
 *  \class dia_IRoutineControlNotifier
 *
 */

//lint -e665 review result: lint does not handle the macro properly 665:

class dia_IRoutineControlNotifier
   : public dia_IRoutineControlListener,
     public dia_Notifier<dia_IRoutineControlListener>
{
public:
   //! there was an update of the given routine
   virtual void vOnRoutineUpdate (dia_Routine& routine)
   {
      std::list<void*> listenerRep = mListenerRep;
      for ( std::list<void*>::iterator it = listenerRep.begin(); it != listenerRep.end(); ++it )
      {
         if ( *it ) convertListenerType(*it)->vOnRoutineUpdate(routine);
      }
   }
};

//lint +e665

#endif /* __INCLUDED_DIA_INTERFACE_ROUTINE_CONTROL_LISTENER__ */
